<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('smart_discounts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('beauty_salon_id');
            $table->string('name');
            $table->text('description')->nullable();
            $table->json('days_of_week'); // ['monday', 'tuesday', ...]
            $table->decimal('discount_percentage', 5, 2); // %10, %20, etc.
            $table->json('service_ids')->nullable(); // Hangi hizmetlere uygulanacak (null = tüm hizmetler)
            $table->time('start_time')->nullable(); // Başlangıç saati (opsiyonel)
            $table->time('end_time')->nullable(); // Bitiş saati (opsiyonel)
            $table->date('start_date')->nullable(); // Kampanya başlangıç tarihi
            $table->date('end_date')->nullable(); // Kampanya bitiş tarihi
            $table->boolean('is_active')->default(true);
            $table->boolean('auto_apply')->default(true); // Otomatik uygula
            $table->timestamps();
            
            $table->foreign('beauty_salon_id')->references('id')->on('users')->onDelete('cascade');
            $table->index(['beauty_salon_id', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('smart_discounts');
    }
};
