<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('smart_discounts', function (Blueprint $table) {
            // Kampanya tipi (indirim veya kampanya)
            $table->enum('campaign_type', ['discount', 'campaign'])->default('discount')->after('description');
            
            // Kampanya özellikleri
            $table->enum('status', ['draft', 'active', 'paused', 'completed', 'cancelled'])->default('active')->after('is_active');
            $table->decimal('budget', 10, 2)->nullable()->after('end_date');
            $table->decimal('budget_used', 10, 2)->default(0)->after('budget');
            $table->integer('max_redemptions')->nullable()->after('budget_used');
            $table->integer('redemptions_count')->default(0)->after('max_redemptions');
            $table->decimal('discount_amount', 10, 2)->nullable()->after('discount_percentage');
            $table->json('target_segments')->nullable()->after('service_ids');
            $table->boolean('auto_stop_on_loss')->default(false)->after('auto_apply');
            $table->decimal('min_roi', 5, 2)->nullable()->after('auto_stop_on_loss');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('smart_discounts', function (Blueprint $table) {
            $table->dropColumn([
                'campaign_type',
                'status',
                'budget',
                'budget_used',
                'max_redemptions',
                'redemptions_count',
                'discount_amount',
                'target_segments',
                'auto_stop_on_loss',
                'min_roi',
            ]);
        });
    }
};
