<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            if (!Schema::hasColumn('accounts', 'beauty_salon_id')) {
                $table->unsignedBigInteger('beauty_salon_id')->nullable()->after('is_active');
                $table->foreign('beauty_salon_id')->references('id')->on('users')->onDelete('cascade');
                $table->index('beauty_salon_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('accounts', function (Blueprint $table) {
            if (Schema::hasColumn('accounts', 'beauty_salon_id')) {
                $table->dropForeign(['beauty_salon_id']);
                $table->dropIndex(['beauty_salon_id']);
                $table->dropColumn('beauty_salon_id');
            }
        });
    }
};
