<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('invoice_type', 20)->nullable()->after('package_id'); // bireysel, kurumsal
            $table->string('invoice_name')->nullable(); // Ünvan veya ad soyad
            $table->string('invoice_tax_number', 20)->nullable(); // VKN veya TC
            $table->string('invoice_tax_office')->nullable(); // Vergi dairesi
            $table->text('invoice_address')->nullable(); // Fatura adresi
            $table->string('invoice_city')->nullable();
            $table->string('invoice_district')->nullable();
            $table->string('invoice_postal_code', 10)->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'invoice_type', 'invoice_name', 'invoice_tax_number',
                'invoice_tax_office', 'invoice_address', 'invoice_city',
                'invoice_district', 'invoice_postal_code'
            ]);
        });
    }
};
