<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->timestamp('free_access_ends_at')->nullable()->after('trial_ends_at');
            $table->timestamp('kvkk_approved_at')->nullable()->after('free_access_ends_at');
            $table->timestamp('privacy_approved_at')->nullable()->after('kvkk_approved_at');
            $table->timestamp('terms_approved_at')->nullable()->after('privacy_approved_at');
            $table->timestamp('pricing_notice_approved_at')->nullable()->after('terms_approved_at');
            $table->string('consent_ip_address', 45)->nullable()->after('pricing_notice_approved_at');
            $table->text('consent_user_agent')->nullable()->after('consent_ip_address');
        });

        $campaignEndsAt = now()->addMonthsNoOverflow(6);

        // One-time backfill: existing beauty salon accounts were given extended access at migration time.
        // New signups now use 14-day trial only; free_access_ends_at is used for coupon-granted periods.
        DB::table('users')
            ->where('role', 'güzellik_salonu')
            ->where(function ($query) {
                $query->whereNull('free_access_ends_at')
                    ->orWhere('free_access_ends_at', '<', now());
            })
            ->update([
                'free_access_ends_at' => $campaignEndsAt,
            ]);

        // Keep trial/license aligned so package blocking does not occur during campaign.
        DB::table('users')
            ->where('role', 'güzellik_salonu')
            ->where(function ($query) use ($campaignEndsAt) {
                $query->whereNull('trial_ends_at')
                    ->orWhere('trial_ends_at', '<', $campaignEndsAt);
            })
            ->update([
                'trial_ends_at' => $campaignEndsAt,
            ]);

        DB::table('users')
            ->where('role', 'güzellik_salonu')
            ->where(function ($query) use ($campaignEndsAt) {
                $query->whereNull('license_expires_at')
                    ->orWhere('license_expires_at', '<', $campaignEndsAt);
            })
            ->update([
                'license_expires_at' => $campaignEndsAt,
            ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'free_access_ends_at',
                'kvkk_approved_at',
                'privacy_approved_at',
                'terms_approved_at',
                'pricing_notice_approved_at',
                'consent_ip_address',
                'consent_user_agent',
            ]);
        });
    }
};
