<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('personel_leaves', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('beauty_salon_id');
            $table->unsignedBigInteger('personel_id');
            $table->date('leave_date');
            $table->string('note', 500)->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('transfer_to_personel_id')->nullable();
            $table->timestamps();

            $table->index(['beauty_salon_id', 'leave_date']);
            $table->unique(['personel_id', 'leave_date']);

            $table->foreign('beauty_salon_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('personel_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->nullOnDelete();
            $table->foreign('transfer_to_personel_id')->references('id')->on('users')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('personel_leaves');
    }
};

