<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Company;
use App\Models\Salon;
use App\Models\Customer;
use App\Models\Menu;
use App\Models\Extra;
use App\Models\Reservation;
use App\Models\Appointment;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class DemoDataSeeder extends Seeder
{
    public function run(): void
    {
        
        $company = Company::create([
            'name' => 'Örnek Düğün Salonu',
            'phone' => '02121234567',
            'email' => 'info@ornekdugun.local',
            'address' => 'İstanbul',
            'tax_number' => '1234567890',
            'is_active' => true,
        ]);

        $salon1 = Salon::create([
            'name' => 'Ana Salon',
            'capacity' => 500,
            'description' => 'Ana düğün salonu',
            'is_active' => true,
        ]);

        $salon2 = Salon::create([
            'name' => 'Küçük Salon',
            'capacity' => 200,
            'description' => 'Küçük etkinlikler için',
            'is_active' => true,
        ]);

        $menu1 = Menu::create([
            'name' => 'Standart Menü',
            'description' => 'Standart düğün menüsü',
            'price' => 5000.00,
            'is_active' => true,
        ]);

        $menu2 = Menu::create([
            'name' => 'Lüks Menü',
            'description' => 'Lüks düğün menüsü',
            'price' => 8000.00,
            'is_active' => true,
        ]);

        $extra1 = Extra::create([
            'name' => 'Fotoğrafçı',
            'description' => 'Profesyonel fotoğrafçı hizmeti',
            'price' => 2000.00,
            'is_active' => true,
        ]);

        $extra2 = Extra::create([
            'name' => 'DJ',
            'description' => 'DJ hizmeti',
            'price' => 1500.00,
            'is_active' => true,
        ]);

        $customer1 = Customer::create([
            'name' => 'Ahmet Yılmaz',
            'phone' => '05551234567',
            'email' => 'ahmet@example.com',
            'address' => 'İstanbul',
        ]);

        $customer2 = Customer::create([
            'name' => 'Ayşe Demir',
            'phone' => '05559876543',
            'email' => 'ayse@example.com',
            'address' => 'Ankara',
        ]);

        $reservation1 = Reservation::create([
            'customer_id' => $customer1->id,
            'company_id' => $company->id,
            'salon_id' => $salon1->id,
            'menu_id' => $menu1->id,
            'date' => now()->addDays(30),
            'start_time' => '18:00:00',
            'end_time' => '23:00:00',
            'guest_count' => 300,
            'total_price' => 5000.00,
            'deposit_paid' => 2000.00,
            'remaining_amount' => 3000.00,
            'status' => 'open',
            'notes' => 'Örnek rezervasyon notu',
        ]);

        $reservation1->extras()->attach($extra1->id, [
            'quantity' => 1,
            'price' => $extra1->price,
        ]);

        $reservation2 = Reservation::create([
            'code' => 'REZ-' . strtoupper(uniqid()),
            'customer_id' => $customer2->id,
            'company_id' => $company->id,
            'salon_id' => $salon2->id,
            'menu_id' => $menu2->id,
            'date' => now()->addDays(45),
            'start_time' => '19:00:00',
            'end_time' => '00:00:00',
            'guest_count' => 150,
            'total_price' => 8000.00,
            'deposit_paid' => 4000.00,
            'remaining_amount' => 4000.00,
            'status' => 'confirmed',
        ]);

        Appointment::create([
            'customer_id' => $customer1->id,
            'date' => now()->addDays(7),
            'start_time' => '14:00:00',
            'end_time' => '15:00:00',
            'subject' => 'Menü Seçimi',
            'notes' => 'Menü seçimi için randevu',
            'status' => 'pending',
        ]);
    }
}

