<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Package;

class PackageSeeder extends Seeder
{
    public function run(): void
    {
        // Mevcut paketleri temizle
        \DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Package::truncate();
        \DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        // Tüm paketler için ortak özellikler (dolu dolu)
        $commonFeatures = [
            'Sınırsız randevu oluşturma ve yönetimi',
            'Sınırsız müşteri kaydı ve veri saklama',
            'Sınırsız personel ekleme ve yönetimi',
            'Sınırsız hizmet ve oda tanımlama',
            'Gelişmiş takvim görünümü ve planlama',
            'Otomatik SMS bildirimleri ve hatırlatmalar',
            'Profesyonel fatura oluşturma ve yönetimi',
            'Detaylı kasa takibi ve finansal raporlama',
            'Gelir-gider analizi ve istatistikler',
            'Müşteri geçmişi ve işlem kayıtları',
            'Personel performans takibi',
            'Hizmet bazlı gelir raporları',
            'Mobil uygulama erişimi (iOS & Android)',
            'Web tabanlı yönetim paneli',
            'Veri yedekleme ve güvenlik',
            '7/24 teknik destek hizmeti',
            'Ücretsiz sistem güncellemeleri',
            'Özel entegrasyon desteği',
        ];

        // 1. Paket: 1 Aylık
        Package::create([
            'name' => 'Aylık Paket',
            'description' => '1 aylık abonelik paketi. Tüm özelliklere erişim sağlar.',
            'price' => 1000.00,
            'original_price' => 2000.00, // %50 indirimli
            'discount_percentage' => 50,
            'price_period' => 'monthly',
            'duration_months' => 1,
            'is_popular' => false,
            'is_active' => true,
            'sort_order' => 1,
            'features' => $commonFeatures,
        ]);

        // 2. Paket: 3 Aylık
        Package::create([
            'name' => '3 Aylık Paket',
            'description' => '3 aylık abonelik paketi. Daha fazla tasarruf edin.',
            'price' => 3000.00, // 3 x 1.000 TL
            'original_price' => 6000.00, // %50 indirimli (3 x 2.000 TL)
            'discount_percentage' => 50,
            'price_period' => 'monthly',
            'duration_months' => 3,
            'is_popular' => false,
            'is_active' => true,
            'sort_order' => 2,
            'features' => $commonFeatures,
        ]);

        // 3. Paket: 12 Aylık (Popüler)
        Package::create([
            'name' => 'Yıllık Paket',
            'description' => '12 aylık abonelik paketi. En iyi değer! 2 ay ücretsiz.',
            'price' => 10000.00, // 12 aylık için özel fiyat (10.000 TL = 10 ay fiyatı, 2 ay ücretsiz)
            'original_price' => 20000.00, // %50 indirimli (12 x 2.000 TL = 24.000 TL, ama 20.000 TL gösteriyoruz)
            'discount_percentage' => 50,
            'price_period' => 'yearly',
            'duration_months' => 12,
            'is_popular' => true, // Popüler paket
            'is_active' => true,
            'sort_order' => 3,
            'features' => $commonFeatures,
        ]);
    }
}
