<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PermissionSeeder extends Seeder
{
    public function run(): void
    {
        $permissions = [
            
            ['module' => 'appointments', 'action' => 'view', 'description' => 'Randevuları görüntüleme'],
            ['module' => 'appointments', 'action' => 'create', 'description' => 'Randevu oluşturma'],
            ['module' => 'appointments', 'action' => 'edit', 'description' => 'Randevu düzenleme'],
            ['module' => 'appointments', 'action' => 'delete', 'description' => 'Randevu silme'],
            ['module' => 'appointments', 'action' => 'approve', 'description' => 'Randevu onaylama'],
            ['module' => 'appointments', 'action' => 'cancel', 'description' => 'Randevu iptal etme'],
            ['module' => 'appointments', 'action' => 'complete', 'description' => 'Randevu tamamlama'],

            ['module' => 'customers', 'action' => 'view', 'description' => 'Müşterileri görüntüleme'],
            ['module' => 'customers', 'action' => 'create', 'description' => 'Müşteri oluşturma'],
            ['module' => 'customers', 'action' => 'edit', 'description' => 'Müşteri düzenleme'],
            ['module' => 'customers', 'action' => 'delete', 'description' => 'Müşteri silme'],

            ['module' => 'services', 'action' => 'view', 'description' => 'Hizmetleri görüntüleme'],
            ['module' => 'services', 'action' => 'create', 'description' => 'Hizmet oluşturma'],
            ['module' => 'services', 'action' => 'edit', 'description' => 'Hizmet düzenleme'],
            ['module' => 'services', 'action' => 'delete', 'description' => 'Hizmet silme'],

            ['module' => 'staff', 'action' => 'view', 'description' => 'Personeli görüntüleme'],
            ['module' => 'staff', 'action' => 'create', 'description' => 'Personel oluşturma'],
            ['module' => 'staff', 'action' => 'edit', 'description' => 'Personel düzenleme'],
            ['module' => 'staff', 'action' => 'delete', 'description' => 'Personel silme'],

            ['module' => 'rooms', 'action' => 'view', 'description' => 'Odaları görüntüleme'],
            ['module' => 'rooms', 'action' => 'create', 'description' => 'Oda oluşturma'],
            ['module' => 'rooms', 'action' => 'edit', 'description' => 'Oda düzenleme'],
            ['module' => 'rooms', 'action' => 'delete', 'description' => 'Oda silme'],

            ['module' => 'invoices', 'action' => 'view', 'description' => 'Faturaları görüntüleme'],
            ['module' => 'invoices', 'action' => 'create', 'description' => 'Fatura oluşturma'],
            ['module' => 'invoices', 'action' => 'edit', 'description' => 'Fatura düzenleme'],
            ['module' => 'invoices', 'action' => 'send', 'description' => 'Fatura gönderme'],

            ['module' => 'accounting', 'action' => 'view', 'description' => 'Muhasebe görüntüleme'],
            ['module' => 'accounting', 'action' => 'create', 'description' => 'Muhasebe kaydı oluşturma'],
            ['module' => 'accounting', 'action' => 'edit', 'description' => 'Muhasebe kaydı düzenleme'],

            ['module' => 'reports', 'action' => 'view', 'description' => 'Raporları görüntüleme'],
            ['module' => 'reports', 'action' => 'export', 'description' => 'Rapor dışa aktarma'],

            ['module' => 'dashboard', 'action' => 'view', 'description' => 'Dashboard görüntüleme'],

            ['module' => 'settings', 'action' => 'view', 'description' => 'Ayarları görüntüleme'],
            ['module' => 'settings', 'action' => 'edit', 'description' => 'Ayarları düzenleme'],

            ['module' => 'users', 'action' => 'view', 'description' => 'Kullanıcıları görüntüleme'],
            ['module' => 'users', 'action' => 'create', 'description' => 'Kullanıcı oluşturma'],
            ['module' => 'users', 'action' => 'edit', 'description' => 'Kullanıcı düzenleme'],
            ['module' => 'users', 'action' => 'delete', 'description' => 'Kullanıcı silme'],
            ['module' => 'companies', 'action' => 'view', 'description' => 'Firmaları görüntüleme'],
            ['module' => 'companies', 'action' => 'manage', 'description' => 'Firma yönetimi'],
        ];

        foreach ($permissions as $permission) {
            DB::table('permissions')->insertOrIgnore([
                'module' => $permission['module'],
                'action' => $permission['action'],
                'description' => $permission['description'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $this->assignRolePermissions();
    }

    private function assignRolePermissions(): void
    {
        
        $superAdminPermissions = DB::table('permissions')->pluck('id')->toArray();
        foreach ($superAdminPermissions as $permissionId) {
            DB::table('role_permission')->insertOrIgnore([
                'role' => 'super_admin',
                'permission_id' => $permissionId,
                'restrictions' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $randevucuModules = ['appointments', 'customers', 'invoices', 'accounting', 'reports', 'dashboard', 'settings'];
        $randevucuPermissions = DB::table('permissions')
            ->whereIn('module', $randevucuModules)
            ->pluck('id')
            ->toArray();
        foreach ($randevucuPermissions as $permissionId) {
            DB::table('role_permission')->insertOrIgnore([
                'role' => 'randevucu',
                'permission_id' => $permissionId,
                'restrictions' => json_encode(['scope' => 'own_company']),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $salonModules = ['appointments', 'customers', 'services', 'staff', 'rooms', 'invoices', 'accounting', 'reports', 'dashboard', 'settings'];
        $salonPermissions = DB::table('permissions')
            ->whereIn('module', $salonModules)
            ->pluck('id')
            ->toArray();
        foreach ($salonPermissions as $permissionId) {
            DB::table('role_permission')->insertOrIgnore([
                'role' => 'beauty_salon',
                'permission_id' => $permissionId,
                'restrictions' => json_encode(['scope' => 'own_salon']),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $personelPermissions = DB::table('permissions')
            ->whereIn('module', ['appointments', 'customers', 'dashboard'])
            ->whereIn('action', ['view'])
            ->pluck('id')
            ->toArray();
        foreach ($personelPermissions as $permissionId) {
            DB::table('role_permission')->insertOrIgnore([
                'role' => 'personel',
                'permission_id' => $permissionId,
                'restrictions' => json_encode(['scope' => 'own', 'can_delete' => false, 'can_edit' => false]),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}

