<?php
/**
 * Laravel Final Kontrol Scripti
 * Bu dosyayı tarayıcıda açın: https://muham.com.tr/final_check.php
 * KURULUM SONRASI BU DOSYAYI SİLİN!
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo '<!DOCTYPE html>
<html>
<head>
    <title>Laravel Final Kontrol</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 900px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { color: #2563EB; }
        h2 { color: #1E40AF; margin-top: 30px; }
        .success { background: #d4edda; color: #155724; padding: 12px; margin: 10px 0; border-radius: 4px; border-left: 4px solid #28a745; }
        .error { background: #f8d7da; color: #721c24; padding: 12px; margin: 10px 0; border-radius: 4px; border-left: 4px solid #dc3545; }
        .info { background: #d1ecf1; color: #0c5460; padding: 12px; margin: 10px 0; border-radius: 4px; border-left: 4px solid #17a2b8; }
        .warning { background: #fff3cd; color: #856404; padding: 12px; margin: 10px 0; border-radius: 4px; border-left: 4px solid #ffc107; }
        code { background: #f4f4f4; padding: 3px 8px; border-radius: 3px; font-family: monospace; }
    </style>
</head>
<body>
<div class="container">
<h1>✅ Laravel Final Kontrol</h1>';

$basePath = dirname(__DIR__);
$allGood = true;

// 1. .env kontrolü
echo '<h2>1. Yapılandırma (.env)</h2>';

$envPath = $basePath . '/.env';
if (file_exists($envPath)) {
    echo '<div class="success">✓ .env dosyası mevcut</div>';
    
    $envContent = file_get_contents($envPath);
    
    // APP_KEY kontrolü
    if (preg_match('/APP_KEY=(.+)/', $envContent, $matches)) {
        $appKey = trim($matches[1]);
        if (!empty($appKey) && strpos($appKey, 'base64:') !== false) {
            echo '<div class="success">✓ APP_KEY tanımlı</div>';
        } else {
            echo '<div class="error">✗ APP_KEY eksik veya boş</div>';
            $allGood = false;
        }
    } else {
        echo '<div class="error">✗ APP_KEY bulunamadı</div>';
        $allGood = false;
    }
    
    // SESSION_DRIVER kontrolü
    if (preg_match('/SESSION_DRIVER=(.+)/', $envContent, $matches)) {
        $sessionDriver = trim($matches[1]);
        echo '<div class="info">→ SESSION_DRIVER: <code>' . htmlspecialchars($sessionDriver) . '</code></div>';
        
        if ($sessionDriver === 'file') {
            $sessionsPath = $basePath . '/storage/framework/sessions';
            if (is_dir($sessionsPath) && is_writable($sessionsPath)) {
                echo '<div class="success">✓ Sessions klasörü hazır</div>';
            } else {
                echo '<div class="error">✗ Sessions klasörü yazılamıyor!</div>';
                $allGood = false;
            }
        } elseif ($sessionDriver === 'database') {
            echo '<div class="info">→ Database session kullanılıyor</div>';
        }
    } else {
        echo '<div class="warning">⚠ SESSION_DRIVER tanımlı değil (varsayılan: database)</div>';
    }
    
    // Veritabanı kontrolü
    if (preg_match('/DB_HOST=(.+)/', $envContent, $dbHost) &&
        preg_match('/DB_DATABASE=(.+)/', $envContent, $dbName) &&
        preg_match('/DB_USERNAME=(.+)/', $envContent, $dbUser)) {
        
        $host = trim($dbHost[1]);
        $database = trim($dbName[1]);
        $username = trim($dbUser[1]);
        preg_match('/DB_PASSWORD=(.+)/', $envContent, $dbPass);
        $password = !empty($dbPass[1]) ? trim($dbPass[1]) : '';
        
        try {
            $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            echo '<div class="success">✓ Veritabanı bağlantısı başarılı</div>';
            
            // Tabloları kontrol et
            $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
            echo '<div class="info">→ ' . count($tables) . ' tablo bulundu</div>';
            
            $requiredTables = ['users', 'customers', 'reservations', 'accounts', 'transactions'];
            $missingTables = [];
            foreach ($requiredTables as $table) {
                if (!in_array($table, $tables)) {
                    $missingTables[] = $table;
                }
            }
            
            if (empty($missingTables)) {
                echo '<div class="success">✓ Tüm gerekli tablolar mevcut</div>';
            } else {
                echo '<div class="error">✗ Eksik tablolar: ' . implode(', ', $missingTables) . '</div>';
                echo '<div class="info">→ <a href="run_all_migrations.php" target="_blank">run_all_migrations.php</a> scriptini çalıştırın</div>';
                $allGood = false;
            }
            
        } catch (PDOException $e) {
            echo '<div class="error">✗ Veritabanı bağlantı hatası: ' . htmlspecialchars($e->getMessage()) . '</div>';
            $allGood = false;
        }
    } else {
        echo '<div class="error">✗ Veritabanı bilgileri eksik</div>';
        $allGood = false;
    }
} else {
    echo '<div class="error">✗ .env dosyası bulunamadı!</div>';
    $allGood = false;
}

// 2. Storage klasörleri kontrolü
echo '<h2>2. Storage Klasörleri</h2>';

$storageDirs = [
    'storage/framework/sessions',
    'storage/logs',
    'bootstrap/cache',
];

foreach ($storageDirs as $dir) {
    $fullPath = $basePath . '/' . $dir;
    if (is_dir($fullPath)) {
        if (is_writable($fullPath)) {
            $perms = substr(sprintf('%o', fileperms($fullPath)), -4);
            echo '<div class="success">✓ ' . $dir . ' → Yazılabilir (İzin: ' . $perms . ')</div>';
        } else {
            echo '<div class="error">✗ ' . $dir . ' → Yazılamıyor!</div>';
            $allGood = false;
        }
    } else {
        echo '<div class="error">✗ ' . $dir . ' → Klasör bulunamadı!</div>';
        $allGood = false;
    }
}

// 3. Cache temizleme önerisi
echo '<h2>3. Cache Durumu</h2>';

$cacheFiles = [
    'bootstrap/cache/config.php',
    'bootstrap/cache/routes.php',
    'bootstrap/cache/services.php',
];

$hasCache = false;
foreach ($cacheFiles as $file) {
    $fullPath = $basePath . '/' . $file;
    if (file_exists($fullPath)) {
        $hasCache = true;
        echo '<div class="info">→ ' . $file . ' mevcut</div>';
    }
}

if ($hasCache) {
    echo '<div class="info">→ Cache dosyaları mevcut (normal)</div>';
} else {
    echo '<div class="warning">⚠ Cache dosyaları henüz oluşturulmamış</div>';
}

// 4. Sonuç ve öneriler
echo '<hr><h2>📋 Sonuç</h2>';

if ($allGood) {
    echo '<div class="success"><strong>✅ Tüm kontroller başarılı! Site çalışmaya hazır.</strong></div>';
    echo '<div class="info">';
    echo '<p><strong>Sonraki adımlar:</strong></p>';
    echo '<ol>';
    echo '<li><strong>Siteyi test edin:</strong> <a href="https://muham.com.tr" target="_blank">https://muham.com.tr</a></li>';
    echo '<li><strong>Login sayfasını test edin:</strong> <a href="https://muham.com.tr/login" target="_blank">https://muham.com.tr/login</a></li>';
    echo '<li>Eğer hala hata alıyorsanız, <code>storage/logs/laravel.log</code> dosyasını kontrol edin</li>';
    echo '<li><strong>BU DOSYAYI SİLİN: <code>final_check.php</code></strong></li>';
    echo '</ol>';
    echo '</div>';
} else {
    echo '<div class="warning"><strong>⚠ Bazı sorunlar tespit edildi.</strong></div>';
    echo '<div class="info">';
    echo '<p><strong>Yapılacaklar:</strong></p>';
    echo '<ol>';
    echo '<li>Yukarıdaki hataları düzeltin</li>';
    echo '<li>Eksik tablolar varsa: <a href="run_all_migrations.php" target="_blank">run_all_migrations.php</a></li>';
    echo '<li>Storage sorunları varsa: <a href="fix_sessions.php" target="_blank">fix_sessions.php</a></li>';
    echo '<li>Tekrar kontrol edin</li>';
    echo '</ol>';
    echo '</div>';
}

echo '<hr><div class="warning"><strong>⚠ GÜVENLİK:</strong> Bu dosyayı kurulum sonrası mutlaka SİLİN!</div>';
echo '</div></body></html>';
?>

