@extends('layouts.admin')

@section('title', 'Hesap Yönetimi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Hesap Yönetimi</li>
@endsection

@section('content')
<style>
    @media (max-width: 1024px) {
        .account-page-header {
            display: none !important;
        }
        
        .card {
            border-radius: 16px !important;
            margin-bottom: 15px !important;
        }
        
        .card-header {
            padding: 15px !important;
            font-size: 16px !important;
        }
        
        .card-body {
            padding: 15px !important;
        }
        
        .form-control, .form-select {
            padding: 12px 15px !important;
            font-size: 16px !important;
            min-height: 44px !important;
            border-radius: 12px !important;
        }
        
        .form-label {
            font-size: 14px !important;
            font-weight: 600 !important;
            margin-bottom: 8px !important;
        }
        
        .btn {
            padding: 12px 20px !important;
            font-size: 15px !important;
            min-height: 44px !important;
            border-radius: 12px !important;
            width: 100% !important;
            margin-bottom: 10px !important;
        }
        
        .input-group .btn {
            width: auto !important;
            margin-bottom: 0 !important;
        }
        
        .row .col-md-6 {
            margin-bottom: 15px !important;
        }
        
        .alert {
            padding: 15px !important;
            border-radius: 12px !important;
            font-size: 14px !important;
        }
        
        .modal-dialog {
            margin: 10px !important;
            max-width: calc(100% - 20px) !important;
        }
        
        .modal-content {
            border-radius: 20px !important;
        }
        
        .modal-body {
            padding: 20px !important;
            max-height: calc(100vh - 200px) !important;
            overflow-y: auto !important;
        }
    }
</style>

    <div class="account-page-header d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0 p-3 rounded" style="color: #000;">
            <i class="bi bi-person-circle"></i> Hesap Yönetimi
        </h2>
    </div>
    
    <div class="mb-4" style="display: none;" id="mobileHeader">
        <h2 class="mb-3 p-3 rounded" style="color: #000; text-align: center;">
            <i class="bi bi-person-circle"></i> Hesap Yönetimi
        </h2>
    </div>
    
    <div class="card">
        <div class="card-header bg-white border-0">
            <h5 class="mb-0" style="color: #000;"><i class="bi bi-person"></i> Üyelik Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.account.update') }}">
                @csrf
                @method('PUT')
                
                <div class="row mb-3">
                    <div class="col-md-6 mb-3 mb-md-0">
                        <label class="form-label">Ad Soyad *</label>
                        <input type="text" name="name" class="form-control" value="{{ $user->name }}" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">E-posta *</label>
                        <input type="email" name="email" class="form-control" value="{{ $user->email }}" required>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-6 mb-3 mb-md-0">
                        <label class="form-label">Telefon Numarası</label>
                        <input type="tel" class="form-control" value="{{ $user->phone }}" readonly>
                        <small class="text-muted">Telefon numarasını değiştirmek için aşağıdaki "Telefon Numarası Değiştir" bölümünü kullanın.</small>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Rol</label>
                        <input type="text" class="form-control" value="{{ $user->role === 'super_admin' ? 'Süper Admin' : ($user->role === 'admin' ? 'Randevucu' : ucfirst($user->role)) }}" readonly>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary w-100 w-md-auto">Güncelle</button>
            </form>
        </div>
    </div>
    
    <!-- Şifre Değiştirme Bölümü -->
    <div class="card mt-4 border-warning">
        <div class="card-header bg-warning text-dark">
            <h5 class="mb-0"><i class="bi bi-key"></i> Şifre Değiştir</h5>
        </div>
        <div class="card-body">
            <div class="alert alert-info">
                <i class="bi bi-info-circle"></i> Şifrenizi değiştirmek için telefon numaranıza doğrulama kodu gönderilecektir.
            </div>
            
            <form method="POST" action="{{ route('admin.account.change-password') }}" id="changePasswordForm">
                @csrf
                
                <div class="mb-3">
                    <label class="form-label">Telefon Numarası</label>
                    <div class="input-group">
                        <input type="tel" class="form-control" value="{{ $user->phone }}" readonly>
                        <button type="button" class="btn btn-outline-warning" id="sendPasswordOtpBtn" onclick="sendPasswordOtp()">
                            <i class="bi bi-send"></i> Kod Gönder
                        </button>
                    </div>
                    <small class="text-muted" id="passwordOtpStatus"></small>
                </div>
                
                <div class="mb-3" id="passwordOtpField">
                    <label for="password_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="password_otp_code" name="otp_code" maxlength="6" placeholder="Önce 'Kod Gönder' butonuna tıklayın" required readonly>
                    <small class="text-muted">Telefonunuza gönderilen 6 haneli kodu giriniz.</small>
                    @error('otp_code')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>
                
                        <div class="row mb-3">
                            <div class="col-md-6 mb-3 mb-md-0">
                                <label for="new_password" class="form-label">Yeni Şifre <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="new_password" name="password" minlength="8" required>
                                <small class="text-muted">En az 8 karakter olmalıdır.</small>
                            </div>
                            <div class="col-md-6">
                                <label for="new_password_confirmation" class="form-label">Yeni Şifre (Tekrar) <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="new_password_confirmation" name="password_confirmation" minlength="8" required>
                            </div>
                        </div>
                
                <button type="submit" class="btn btn-warning">
                    <i class="bi bi-key"></i> Şifreyi Değiştir
                </button>
            </form>
        </div>
    </div>
    
    <!-- Telefon Numarası Değiştirme Bölümü -->
    <div class="card mt-4 border-info">
        <div class="card-header bg-light">
            <h5 class="mb-0 text-dark"><i class="bi bi-telephone"></i> Telefon Numarası Değiştir</h5>
        </div>
        <div class="card-body">
            <div class="alert alert-info">
                <i class="bi bi-info-circle"></i> Telefon numaranızı değiştirmek için yeni telefon numaranıza doğrulama kodu gönderilecek ve mevcut şifreniz istenecektir.
            </div>
            
            <form method="POST" action="{{ route('admin.account.change-phone') }}" id="changePhoneForm">
                @csrf
                
                <div class="mb-3">
                    <label for="current_phone" class="form-label">Mevcut Telefon Numarası</label>
                    <input type="tel" class="form-control" value="{{ $user->phone }}" readonly>
                </div>
                
                <div class="mb-3">
                    <label for="new_phone" class="form-label">Yeni Telefon Numarası <span class="text-danger">*</span></label>
                    <div class="input-group">
                        <input type="tel" class="form-control" id="new_phone" name="new_phone" placeholder="05XX XXX XX XX" required>
                        <button type="button" class="btn btn-outline-info" id="sendPhoneOtpBtn" onclick="sendPhoneOtp()">
                            <i class="bi bi-send"></i> Kod Gönder
                        </button>
                    </div>
                    <small class="text-muted" id="phoneOtpStatus"></small>
                </div>
                
                <div class="mb-3" id="phoneOtpField">
                    <label for="phone_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="phone_otp_code" name="otp_code" maxlength="6" placeholder="Önce 'Kod Gönder' butonuna tıklayın" required readonly>
                    <small class="text-muted">Yeni telefon numaranıza gönderilen 6 haneli kodu giriniz.</small>
                    @error('otp_code')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="mb-3">
                    <label for="phone_change_password" class="form-label">Mevcut Şifre <span class="text-danger">*</span></label>
                    <input type="password" class="form-control" id="phone_change_password" name="password" required placeholder="Hesap şifrenizi giriniz">
                    @error('password')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>
                
                <button type="submit" class="btn btn-info">
                    <i class="bi bi-telephone"></i> Telefon Numarasını Değiştir
                </button>
            </form>
        </div>
    </div>
    
    <!-- Hesap Silme Bölümü -->
    <div class="card mt-4 border-danger">
        <div class="card-header bg-light">
            <h5 class="mb-0 text-dark"><i class="bi bi-exclamation-triangle"></i> Hesabı Sil</h5>
        </div>
        <div class="card-body">
            @error('error')
                <div class="alert alert-danger alert-dismissible fade show">
                    <i class="bi bi-exclamation-circle"></i> {{ $message }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @enderror
            <div class="alert alert-warning">
                <i class="bi bi-info-circle"></i> <strong>Dikkat!</strong> Bu işlem geri alınamaz. Hesabınız ve tüm verileriniz kalıcı olarak silinecektir.
            </div>
            
            <form method="POST" action="{{ route('admin.account.destroy') }}" id="deleteAccountForm">
                @csrf
                
                <div class="mb-3">
                    <label for="delete_password" class="form-label">Şifre Doğrulama <span class="text-danger">*</span></label>
                    <input type="password" class="form-control" id="delete_password" name="password" required placeholder="Hesap şifrenizi giriniz">
                </div>
                
                <div class="mb-3">
                    <label for="delete_phone" class="form-label">Telefon Numarası</label>
                    <div class="input-group">
                        <input type="tel" class="form-control" id="delete_phone" value="{{ $user->phone }}" readonly>
                        <button type="button" class="btn btn-outline-danger" id="sendDeleteOtpBtn" onclick="sendDeleteOtp()">
                            <i class="bi bi-send"></i> Kod Gönder
                        </button>
                    </div>
                    <small class="text-muted" id="deleteOtpStatus"></small>
                </div>
                
                <div class="mb-3" id="deleteOtpField">
                    <label for="delete_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="delete_otp_code" name="otp_code" maxlength="6" placeholder="Önce 'Kod Gönder' butonuna tıklayın" required readonly>
                    <small class="text-muted">Telefonunuza gönderilen 6 haneli kodu giriniz.</small>
                    @error('otp_code')
                        <div class="text-danger small">{{ $message }}</div>
                    @enderror
                </div>
                
                <button type="button" class="btn btn-danger" onclick="confirmDelete()">
                    <i class="bi bi-trash"></i> Hesabı Kalıcı Olarak Sil
                </button>
            </form>
        </div>
    </div>
    
    <!-- Silme Onay Modalı -->
    <div class="modal fade" id="confirmDeleteModal" tabindex="-1" aria-labelledby="confirmDeleteModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="confirmDeleteModalLabel">
                        <i class="bi bi-exclamation-triangle"></i> Son Onay
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p class="mb-3">
                        <strong>Hesabınızı silmek istediğinize emin misiniz?</strong>
                    </p>
                    <div class="alert alert-danger mb-0">
                        <i class="bi bi-info-circle"></i> Bu işlem geri alınamaz! Tüm verileriniz kalıcı olarak silinecektir.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x"></i> İptal
                    </button>
                    <button type="button" class="btn btn-danger" onclick="submitDeleteForm()">
                        <i class="bi bi-trash"></i> Evet, Hesabı Sil
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Şifre Değiştirme Modal -->
    <div class="modal fade" id="changePasswordModal" tabindex="-1" aria-labelledby="changePasswordModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-warning text-dark">
                    <h5 class="modal-title" id="changePasswordModalLabel">
                        <i class="bi bi-key"></i> Şifre Değiştir
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle"></i> Şifrenizi değiştirmek için telefon numaranıza doğrulama kodu gönderilecektir.
                    </div>
                    
                    <form method="POST" action="{{ route('admin.account.change-password') }}" id="modalChangePasswordForm">
                        @csrf
                        
                        <div class="mb-3">
                            <label class="form-label">Telefon Numarası</label>
                            <div class="input-group">
                                <input type="tel" class="form-control" value="{{ $user->phone }}" readonly>
                                <button type="button" class="btn btn-outline-warning" id="modalSendPasswordOtpBtn" onclick="sendPasswordOtpModal()">
                                    <i class="bi bi-send"></i> Kod Gönder
                                </button>
                            </div>
                            <small class="text-muted" id="modalPasswordOtpStatus"></small>
                        </div>
                        
                        <div class="mb-3" id="modalPasswordOtpField">
                            <label for="modal_password_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="modal_password_otp_code" name="otp_code" maxlength="6" placeholder="Önce 'Kod Gönder' butonuna tıklayın" required readonly>
                            <small class="text-muted">Telefonunuza gönderilen 6 haneli kodu giriniz.</small>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6 mb-3 mb-md-0">
                                <label for="modal_new_password" class="form-label">Yeni Şifre <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="modal_new_password" name="password" minlength="8" required>
                                <small class="text-muted">En az 8 karakter olmalıdır.</small>
                            </div>
                            <div class="col-md-6">
                                <label for="modal_new_password_confirmation" class="form-label">Yeni Şifre (Tekrar) <span class="text-danger">*</span></label>
                                <input type="password" class="form-control" id="modal_new_password_confirmation" name="password_confirmation" minlength="8" required>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-warning" onclick="submitChangePasswordModal()">
                        <i class="bi bi-key"></i> Şifreyi Değiştir
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Telefon Değiştirme Modal -->
    <div class="modal fade" id="changePhoneModal" tabindex="-1" aria-labelledby="changePhoneModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h5 class="modal-title text-dark" id="changePhoneModalLabel">
                        <i class="bi bi-telephone"></i> Telefon Numarası Değiştir
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle"></i> Telefon numaranızı değiştirmek için yeni telefon numaranıza doğrulama kodu gönderilecek ve mevcut şifreniz istenecektir.
                    </div>
                    
                    <form method="POST" action="{{ route('admin.account.change-phone') }}" id="modalChangePhoneForm">
                        @csrf
                        
                        <div class="mb-3">
                            <label class="form-label">Mevcut Telefon Numarası</label>
                            <input type="tel" class="form-control" value="{{ $user->phone }}" readonly>
                        </div>
                        
                        <div class="mb-3">
                            <label for="modal_new_phone" class="form-label">Yeni Telefon Numarası <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="tel" class="form-control" id="modal_new_phone" name="new_phone" placeholder="05XX XXX XX XX" required>
                                <button type="button" class="btn btn-outline-info" id="modalSendPhoneOtpBtn" onclick="sendPhoneOtpModal()">
                                    <i class="bi bi-send"></i> Kod Gönder
                                </button>
                            </div>
                            <small class="text-muted" id="modalPhoneOtpStatus"></small>
                        </div>
                        
                        <div class="mb-3" id="modalPhoneOtpField">
                            <label for="modal_phone_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="modal_phone_otp_code" name="otp_code" maxlength="6" placeholder="Önce 'Kod Gönder' butonuna tıklayın" required readonly>
                            <small class="text-muted">Yeni telefon numaranıza gönderilen 6 haneli kodu giriniz.</small>
                        </div>
                        
                        <div class="mb-3">
                            <label for="modal_phone_change_password" class="form-label">Mevcut Şifre <span class="text-danger">*</span></label>
                            <input type="password" class="form-control" id="modal_phone_change_password" name="password" required placeholder="Hesap şifrenizi giriniz">
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-info" onclick="submitChangePhoneModal()">
                        <i class="bi bi-telephone"></i> Telefon Numarasını Değiştir
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Hesap Silme Modal -->
    <div class="modal fade" id="deleteAccountModal" tabindex="-1" aria-labelledby="deleteAccountModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h5 class="modal-title text-dark" id="deleteAccountModalLabel">
                        <i class="bi bi-exclamation-triangle"></i> Hesabı Sil
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="bi bi-info-circle"></i> <strong>Dikkat!</strong> Bu işlem geri alınamaz. Hesabınız ve tüm verileriniz kalıcı olarak silinecektir.
                    </div>
                    
                    <form method="POST" action="{{ route('admin.account.destroy') }}" id="modalDeleteAccountForm">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="modal_delete_password" class="form-label">Şifre Doğrulama <span class="text-danger">*</span></label>
                            <input type="password" class="form-control" id="modal_delete_password" name="password" required placeholder="Hesap şifrenizi giriniz">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Telefon Numarası</label>
                            <div class="input-group">
                                <input type="tel" class="form-control" value="{{ $user->phone }}" readonly>
                                <button type="button" class="btn btn-outline-danger" id="modalSendDeleteOtpBtn" onclick="sendDeleteOtpModal()">
                                    <i class="bi bi-send"></i> Kod Gönder
                                </button>
                            </div>
                            <small class="text-muted" id="modalDeleteOtpStatus"></small>
                        </div>
                        
                        <div class="mb-3" id="modalDeleteOtpField">
                            <label for="modal_delete_otp_code" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="modal_delete_otp_code" name="otp_code" maxlength="6" placeholder="Önce 'Kod Gönder' butonuna tıklayın" required readonly>
                            <small class="text-muted">Telefonunuza gönderilen 6 haneli kodu giriniz.</small>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-danger" onclick="submitDeleteAccountModal()">
                        <i class="bi bi-trash"></i> Hesabı Kalıcı Olarak Sil
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
    // Modal açma fonksiyonları
    function openChangePasswordModal() {
        const modalElement = document.getElementById('changePasswordModal');
        if (modalElement) {
            const modal = new bootstrap.Modal(modalElement);
            modal.show();
        } else {
            console.error('changePasswordModal bulunamadı');
        }
    }
    
    function openChangePhoneModal() {
        const modalElement = document.getElementById('changePhoneModal');
        if (modalElement) {
            const modal = new bootstrap.Modal(modalElement);
            modal.show();
        } else {
            console.error('changePhoneModal bulunamadı');
        }
    }
    
    function openDeleteAccountModal() {
        const modalElement = document.getElementById('deleteAccountModal');
        if (modalElement) {
            const modal = new bootstrap.Modal(modalElement);
            modal.show();
        } else {
            console.error('deleteAccountModal bulunamadı');
        }
    }
    
    // Modal içindeki OTP gönderme fonksiyonları
    function sendPasswordOtpModal() {
        const sendBtn = document.getElementById('modalSendPasswordOtpBtn');
        const otpStatus = document.getElementById('modalPasswordOtpStatus');
        const otpField = document.getElementById('modalPasswordOtpField');
        
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        otpStatus.textContent = '';
        
        fetch('{{ route("admin.account.send-password-change-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                otpStatus.className = 'text-success';
                const otpInput = document.getElementById('modal_password_otp_code');
                otpInput.removeAttribute('readonly');
                otpInput.placeholder = '6 haneli kod';
                otpInput.focus();
                
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    function sendPhoneOtpModal() {
        const newPhone = document.getElementById('modal_new_phone').value.trim();
        if (!newPhone) {
            alert('Lütfen yeni telefon numarasını giriniz.');
            return;
        }
        
        const sendBtn = document.getElementById('modalSendPhoneOtpBtn');
        const otpStatus = document.getElementById('modalPhoneOtpStatus');
        const otpField = document.getElementById('modalPhoneOtpField');
        
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        otpStatus.textContent = '';
        
        fetch('{{ route("admin.account.send-phone-change-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ new_phone: newPhone })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu yeni telefon numaranıza gönderildi. Lütfen kontrol edin.';
                otpStatus.className = 'text-success';
                const otpInput = document.getElementById('modal_phone_otp_code');
                otpInput.removeAttribute('readonly');
                otpInput.placeholder = '6 haneli kod';
                otpInput.focus();
                
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    function sendDeleteOtpModal() {
        const sendBtn = document.getElementById('modalSendDeleteOtpBtn');
        const otpStatus = document.getElementById('modalDeleteOtpStatus');
        const otpField = document.getElementById('modalDeleteOtpField');
        
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        otpStatus.textContent = '';
        
        fetch('{{ route("admin.account.send-delete-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                otpStatus.className = 'text-success';
                const otpInput = document.getElementById('modal_delete_otp_code');
                otpInput.removeAttribute('readonly');
                otpInput.placeholder = '6 haneli kod';
                otpInput.focus();
                
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    // Form gönderme fonksiyonları
    function submitChangePasswordModal() {
        const form = document.getElementById('modalChangePasswordForm');
        const otpCode = document.getElementById('modal_password_otp_code').value;
        const password = document.getElementById('modal_new_password').value;
        const passwordConfirmation = document.getElementById('modal_new_password_confirmation').value;
        
        if (!otpCode || otpCode.length !== 6) {
            alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
            return;
        }
        
        if (!password || password.length < 8) {
            alert('Şifre en az 8 karakter olmalıdır.');
            return;
        }
        
        if (password !== passwordConfirmation) {
            alert('Şifreler eşleşmiyor.');
            return;
        }
        
        form.submit();
    }
    
    function submitChangePhoneModal() {
        const form = document.getElementById('modalChangePhoneForm');
        const newPhone = document.getElementById('modal_new_phone').value.trim();
        const otpCode = document.getElementById('modal_phone_otp_code').value;
        const password = document.getElementById('modal_phone_change_password').value;
        
        if (!newPhone) {
            alert('Lütfen yeni telefon numarasını giriniz.');
            return;
        }
        
        if (!otpCode || otpCode.length !== 6) {
            alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
            return;
        }
        
        if (!password) {
            alert('Lütfen mevcut şifrenizi giriniz.');
            return;
        }
        
        form.submit();
    }
    
    function submitDeleteAccountModal() {
        const form = document.getElementById('modalDeleteAccountForm');
        const password = document.getElementById('modal_delete_password').value;
        const otpCode = document.getElementById('modal_delete_otp_code').value;
        
        if (!password) {
            alert('Lütfen şifrenizi giriniz.');
            return;
        }
        
        if (!otpCode || otpCode.length !== 6) {
            alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
            return;
        }
        
        if (confirm('Hesabınızı silmek istediğinize emin misiniz? Bu işlem geri alınamaz!')) {
            form.submit();
        }
    }
    
    // OTP kodları sadece rakam girişi
    document.getElementById('modal_password_otp_code')?.addEventListener('input', function(e) {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
    
    document.getElementById('modal_phone_otp_code')?.addEventListener('input', function(e) {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
    
    document.getElementById('modal_delete_otp_code')?.addEventListener('input', function(e) {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
    
    // Şifre değiştirme OTP gönderme
    function sendPasswordOtp() {
        const sendBtn = document.getElementById('sendPasswordOtpBtn');
        const otpStatus = document.getElementById('passwordOtpStatus');
        const otpField = document.getElementById('passwordOtpField');
        
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        otpStatus.textContent = '';
        
        fetch('{{ route("admin.account.send-password-change-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                otpStatus.className = 'text-success';
                const otpInput = document.getElementById('password_otp_code');
                otpInput.removeAttribute('readonly');
                otpInput.placeholder = '6 haneli kod';
                otpInput.focus();
                
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    // Telefon değiştirme OTP gönderme
    function sendPhoneOtp() {
        const newPhone = document.getElementById('new_phone').value.trim();
        if (!newPhone) {
            alert('Lütfen yeni telefon numarasını giriniz.');
            return;
        }
        
        const sendBtn = document.getElementById('sendPhoneOtpBtn');
        const otpStatus = document.getElementById('phoneOtpStatus');
        const otpField = document.getElementById('phoneOtpField');
        
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        otpStatus.textContent = '';
        
        fetch('{{ route("admin.account.send-phone-change-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ new_phone: newPhone })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu yeni telefon numaranıza gönderildi. Lütfen kontrol edin.';
                otpStatus.className = 'text-success';
                const otpInput = document.getElementById('phone_otp_code');
                otpInput.removeAttribute('readonly');
                otpInput.placeholder = '6 haneli kod';
                otpInput.focus();
                
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    // OTP kodları sadece rakam girişi
    document.getElementById('password_otp_code')?.addEventListener('input', function(e) {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
    
    document.getElementById('phone_otp_code')?.addEventListener('input', function(e) {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
    
    // Hesap silme OTP gönderme fonksiyonu
    function sendDeleteOtp() {
        const sendBtn = document.getElementById('sendDeleteOtpBtn');
        const otpStatus = document.getElementById('deleteOtpStatus');
        const otpField = document.getElementById('deleteOtpField');
        
        
        sendBtn.disabled = true;
        sendBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Gönderiliyor...';
        otpStatus.textContent = '';
        
        // AJAX isteği
        fetch('{{ route("admin.account.send-delete-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                otpStatus.textContent = 'Doğrulama kodu gönderildi. Lütfen telefonunuzu kontrol edin.';
                otpStatus.className = 'text-success';
                const otpInput = document.getElementById('delete_otp_code');
                otpInput.removeAttribute('readonly');
                otpInput.placeholder = '6 haneli kod';
                otpInput.focus();
                
                // 60 saniye geri sayım
                let countdown = 60;
                const interval = setInterval(() => {
                    countdown--;
                    sendBtn.innerHTML = `<i class="bi bi-clock"></i> Tekrar Gönder (${countdown}s)`;
                    if (countdown <= 0) {
                        clearInterval(interval);
                        sendBtn.disabled = false;
                        sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
                    }
                }, 1000);
            } else {
                otpStatus.textContent = data.message || 'OTP gönderilemedi.';
                otpStatus.className = 'text-danger';
                sendBtn.disabled = false;
                sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            otpStatus.textContent = 'Bir hata oluştu.';
            otpStatus.className = 'text-danger';
            sendBtn.disabled = false;
            sendBtn.innerHTML = '<i class="bi bi-send"></i> Kod Gönder';
        });
    }
    
    // OTP kodu sadece rakam girişi
    document.getElementById('delete_otp_code')?.addEventListener('input', function(e) {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
    
    // Mobile header göster/gizle
    if (window.innerWidth <= 1024) {
        document.getElementById('mobileHeader').style.display = 'block';
    }
    
    window.addEventListener('resize', function() {
        if (window.innerWidth <= 1024) {
            document.getElementById('mobileHeader').style.display = 'block';
        } else {
            document.getElementById('mobileHeader').style.display = 'none';
        }
    });
    
    // Silme onayı
    function confirmDelete() {
        const form = document.getElementById('deleteAccountForm');
        const password = document.getElementById('delete_password').value;
        const otpCode = document.getElementById('delete_otp_code').value;
        
        if (!password) {
            alert('Lütfen şifrenizi giriniz.');
            return;
        }
        
        if (!otpCode || otpCode.length !== 6) {
            alert('Lütfen 6 haneli doğrulama kodunu giriniz.');
            return;
        }
        
        const modal = new bootstrap.Modal(document.getElementById('confirmDeleteModal'));
        modal.show();
    }
    
    // Form gönderme
    function submitDeleteForm() {
        document.getElementById('deleteAccountForm').submit();
    }
</script>
@endsection

