@extends('layouts.admin')

@section('title', 'Randevu Gelirleri')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Randevu Gelirleri</li>
@endsection

@section('content')
    <h2 class="mb-4">Randevu Gelirleri</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-success text-white">
            <h5 class="mb-0"><i class="bi bi-cash-coin"></i> Randevu Gelirleri</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Randevu Kodu</th>
                            <th>Müşteri</th>
                            <th>Tarih</th>
                            <th>Salon</th>
                            <th>Toplam Tutar</th>
                            <th>Ödenen</th>
                            <th>Kalan</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($appointments as $reservation)
                            <tr>
                                <td>{{ $reservation->code }}</td>
                                <td>{{ $reservation->customer->name }}</td>
                                <td>{{ $reservation->date->format('d.m.Y') }}</td>
                                <td>{{ $reservation->salon->name }}</td>
                                <td><strong>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</strong></td>
                                <td class="text-success">{{ number_format($reservation->deposit_paid, 2, ',', '.') }} ₺</td>
                                <td class="text-danger">{{ number_format($reservation->remaining_amount, 2, ',', '.') }} ₺</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">Randevu bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $appointments->links() }}
            </div>
        </div>
    </div>
@endsection

