@extends('layouts.admin')

@section('title', 'KASA')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">KASA</li>
@endsection

@section('content')
<style>
    /* Desktop görünümde de üstten boşluk */
    @media (min-width: 1025px) {
        .main-content {
            padding-top: 20px !important;
        }
    }
    
    @media (max-width: 1024px) {
        .main-content {
            padding-top: 20px !important;
        }
        /* Kasa kartlarının background'larını koru - inline style'ları override etme */
        .row.mb-4.g-3 .card[style*="background"] {
            border-radius: 16px !important;
            margin-bottom: 15px !important;
        }
        
        .row.mb-4.g-3 .card[style*="background"] .card-body {
            background: transparent !important;
        }
        
        /* Text renklerini siyah yap - desktop mobil görünümde */
        .row.mb-4.g-3 .card[style*="background"] .text-white,
        .row.mb-4.g-3 .card[style*="background"] .text-white-50,
        .row.mb-4.g-3 .card[style*="background"] h3,
        .row.mb-4.g-3 .card[style*="background"] h6,
        .row.mb-4.g-3 .card[style*="background"] small,
        .row.mb-4.g-3 .card[style*="background"] .text-white-50,
        .row.mb-4.g-3 .card[style*="background"] i {
            color: #000000 !important;
        }
        
        /* Kasa Bakiyesi - Mavi kutu */
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(1) .card[style*="background"] {
            background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%) !important;
        }
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(1) .card[style*="background"] .text-white,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(1) .card[style*="background"] .text-white-50,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(1) .card[style*="background"] h3,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(1) .card[style*="background"] h6,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(1) .card[style*="background"] small,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(1) .card[style*="background"] i {
            color: #ffffff !important;
        }
        
        /* Toplam Gelir - Yeşil kutu */
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(2) .card[style*="background"] {
            background: linear-gradient(135deg, #be185d 0%, #ec4899 100%) !important;
        }
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(2) .card[style*="background"] .text-white,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(2) .card[style*="background"] .text-white-50,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(2) .card[style*="background"] h3,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(2) .card[style*="background"] h6,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(2) .card[style*="background"] small,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(2) .card[style*="background"] i {
            color: #ffffff !important;
        }
        
        /* Toplam Gider - Kırmızı kutu */
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(3) .card[style*="background"] {
            background: linear-gradient(135deg, #dc2626 0%, #ef4444 100%) !important;
        }
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(3) .card[style*="background"] .text-white,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(3) .card[style*="background"] .text-white-50,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(3) .card[style*="background"] h3,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(3) .card[style*="background"] h6,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(3) .card[style*="background"] small,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(3) .card[style*="background"] i {
            color: #ffffff !important;
        }
        
        /* Bu Ay Net - Mavi kutu */
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(4) .card[style*="background"] {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
        }
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(4) .card[style*="background"] .text-white,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(4) .card[style*="background"] .text-white-50,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(4) .card[style*="background"] h3,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(4) .card[style*="background"] h6,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(4) .card[style*="background"] small,
        .row.mb-4.g-3 .col-md-6.col-lg-3:nth-child(4) .card[style*="background"] i {
            color: #ffffff !important;
        }
        
        .card {
            border-radius: 16px !important;
            margin-bottom: 15px !important;
        }
        
        .card-header {
            padding: 15px !important;
            font-size: 16px !important;
        }
        
        .card-body {
            padding: 15px !important;
        }
        
        .form-control, .form-select {
            padding: 12px 15px !important;
            font-size: 16px !important;
            min-height: 44px !important;
            border-radius: 12px !important;
        }
        
        .form-label {
            font-size: 14px !important;
            font-weight: 600 !important;
            margin-bottom: 8px !important;
        }
        
        .btn {
            padding: 12px 20px !important;
            font-size: 15px !important;
            min-height: 44px !important;
            border-radius: 12px !important;
            width: 100% !important;
            margin-bottom: 10px !important;
        }
        
        .row .col-md-6, .row .col-lg-3 {
            margin-bottom: 15px !important;
        }
        
        .table-responsive {
            border-radius: 12px !important;
            overflow-x: auto !important;
            -webkit-overflow-scrolling: touch;
        }
        
        .table {
            font-size: 14px !important;
        }
        
        .table th, .table td {
            padding: 12px 8px !important;
            white-space: nowrap;
            color: #000000 !important;
        }
        
        .table th {
            color: #000000 !important;
        }
        
        .table td {
            color: #000000 !important;
        }
        
        .table .text-muted {
            color: #6b7280 !important;
        }
        
        .table .text-primary {
            color: #ec4899 !important;
        }
        
        .table .text-success {
            color: #ec4899 !important;
        }
        
        .table .text-danger {
            color: #ef4444 !important;
        }
        
        .badge {
            font-size: 11px !important;
            padding: 4px 8px !important;
        }
        
        .alert {
            padding: 15px !important;
            border-radius: 12px !important;
            font-size: 14px !important;
        }
        
        .modal-dialog {
            margin: 10px !important;
            max-width: calc(100% - 20px) !important;
        }
        
        .modal-content {
            border-radius: 20px !important;
        }
        
        .modal-body {
            padding: 20px !important;
            max-height: calc(100vh - 200px) !important;
            overflow-y: auto !important;
        }
    }
    
    .date-filter-input {
        max-width: 150px;
    }
    @media (max-width: 768px) {
        .date-filter-input {
            max-width: 100%;
            width: 100%;
            margin-bottom: 0.5rem;
        }
        .card-header .d-flex {
            flex-direction: column;
            align-items: stretch !important;
        }
        .card-header .d-flex.gap-2 {
            width: 100%;
        }
    }
    input[type="date"]::before {
        content: attr(placeholder);
        color: #999;
        width: 100%;
    }
    input[type="date"]:focus::before,
    input[type="date"]:valid::before {
        display: none;
    }
</style>
    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="bi bi-exclamation-circle"></i> {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(isset($error))
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="bi bi-exclamation-circle"></i> {{ $error }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-2" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                KASA
            </h2>
        </div>
        <div class="d-flex gap-2">
            <button type="button" class="btn btn-success" onclick="openIncomeModal()">
                <i class="bi bi-plus-circle"></i> Gelir Ekle
            </button>
            <button type="button" class="btn btn-danger" onclick="openExpenseModal()">
                <i class="bi bi-dash-circle"></i> Gider Ekle
            </button>
        </div>
    </div>
    
    <!-- Özet Kartları -->
    <div class="row mb-4 g-3">
        <!-- Toplam Kasa Bakiyesi -->
        <div class="col-md-6 col-lg-3">
            <div class="card shadow-lg border-0 h-100" style="background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%); border-radius: 15px; overflow: hidden;">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-white-50 mb-2" style="font-size: 12px; text-transform: uppercase; letter-spacing: 1px;">
                                <i class="bi bi-wallet2 me-1"></i>Kasa Bakiyesi
                            </h6>
                            <h3 class="text-white mb-0 fw-bold">{{ number_format($totalBalance, 2, ',', '.') }} ₺</h3>
                        </div>
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle bg-white bg-opacity-25" style="width: 50px; height: 50px;">
                            <i class="bi bi-cash-stack text-white" style="font-size: 24px;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Toplam Gelir -->
        <div class="col-md-6 col-lg-3 d-none d-md-block">
            <div class="card shadow-lg border-0 h-100" style="background: linear-gradient(135deg, #be185d 0%, #ec4899 100%); border-radius: 15px; overflow: hidden;">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-white-50 mb-2" style="font-size: 12px; text-transform: uppercase; letter-spacing: 1px;">
                                <i class="bi bi-arrow-down-circle me-1"></i>Toplam Gelir
                            </h6>
                            <h3 class="text-white mb-0 fw-bold">{{ number_format($totalIncome ?? 0, 2, ',', '.') }} ₺</h3>
                            <small class="text-white-50">Bugün: {{ number_format($todayIncome ?? 0, 2, ',', '.') }} ₺</small>
                        </div>
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle bg-white bg-opacity-25" style="width: 50px; height: 50px;">
                            <i class="bi bi-graph-up-arrow text-white" style="font-size: 24px;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Toplam Gider -->
        <div class="col-md-6 col-lg-3">
            <div class="card shadow-lg border-0 h-100" style="background: linear-gradient(135deg, #dc2626 0%, #ef4444 100%); border-radius: 15px; overflow: hidden;">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-white-50 mb-2" style="font-size: 12px; text-transform: uppercase; letter-spacing: 1px;">
                                <i class="bi bi-arrow-up-circle me-1"></i>Toplam Gider
                            </h6>
                            <h3 class="text-white mb-0 fw-bold">{{ number_format($totalExpense ?? 0, 2, ',', '.') }} ₺</h3>
                            <small class="text-white-50">Bugün: {{ number_format($todayExpense ?? 0, 2, ',', '.') }} ₺</small>
                        </div>
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle bg-white bg-opacity-25" style="width: 50px; height: 50px;">
                            <i class="bi bi-graph-down-arrow text-white" style="font-size: 24px;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Bu Ay Özet -->
        <div class="col-md-6 col-lg-3">
            <div class="card shadow-lg border-0 h-100" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 15px; overflow: hidden;">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-white-50 mb-2" style="font-size: 12px; text-transform: uppercase; letter-spacing: 1px;">
                                <i class="bi bi-calendar-month me-1"></i>Bu Ay Net
                            </h6>
                            @php $monthlyNet = ($monthlyIncome ?? 0) - ($monthlyExpense ?? 0); @endphp
                            <h3 class="text-white mb-0 fw-bold">{{ number_format($monthlyNet, 2, ',', '.') }} ₺</h3>
                            <small class="text-white-50">
                                <i class="bi bi-arrow-up text-success-emphasis"></i> {{ number_format($monthlyIncome ?? 0, 0, ',', '.') }} 
                                <i class="bi bi-arrow-down text-danger-emphasis ms-2"></i> {{ number_format($monthlyExpense ?? 0, 0, ',', '.') }}
                            </small>
                        </div>
                        <div class="d-inline-flex align-items-center justify-content-center rounded-circle bg-white bg-opacity-25" style="width: 50px; height: 50px;">
                            <i class="bi bi-pie-chart text-white" style="font-size: 24px;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card shadow-sm border-0">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #f472b6 0%, #ec4899 100%);">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0 text-white"><i class="bi bi-list-ul me-2"></i> Gelirler - Giderler</h5>
                <div class="d-flex gap-2 flex-wrap">
                    <input type="text" class="form-control form-control-sm date-filter-input" id="dateFromFilter" value="{{ $filters['date_from'] ?? '' }}" placeholder="gg.aa.yyyy" onfocus="this.type='date'; if(!this.value && this.placeholder) this.placeholder='';" onblur="if(!this.value) { this.type='text'; this.placeholder='gg.aa.yyyy'; }">
                    <input type="text" class="form-control form-control-sm date-filter-input" id="dateToFilter" value="{{ $filters['date_to'] ?? '' }}" placeholder="gg.aa.yyyy" onfocus="this.type='date'; if(!this.value && this.placeholder) this.placeholder='';" onblur="if(!this.value) { this.type='text'; this.placeholder='gg.aa.yyyy'; }">
                    <select class="form-select form-select-sm" id="typeFilter" style="max-width: 120px;">
                        <option value="">Tümü</option>
                        <option value="income" {{ ($filters['type'] ?? '') == 'income' ? 'selected' : '' }}>Gelir</option>
                        <option value="expense" {{ ($filters['type'] ?? '') == 'expense' ? 'selected' : '' }}>Gider</option>
                    </select>
                    @if($filters['date_from'] || $filters['date_to'] || $filters['type'])
                        <a href="{{ route('admin.accounting.cashbox') }}" class="btn btn-sm btn-outline-secondary">
                            <i class="bi bi-x-circle"></i> Temizle
                        </a>
                    @endif
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive d-none d-md-block">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th style="width: 10%;" class="ps-4">Tarih</th>
                            <th style="width: 12%;">Tip</th>
                            <th style="width: 12%;">Hesap</th>
                            <th style="width: 12%;">Randevu</th>
                            <th style="width: 15%;">Ödeme Yapan</th>
                            <th style="width: 20%;">Açıklama</th>
                            <th style="width: 12%;" class="text-end">Tutar</th>
                            <th style="width: 7%;" class="text-center">İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $transaction)
                            <tr class="transaction-row" data-type="{{ $transaction->type ?? 'unknown' }}">
                                <td class="ps-4">
                                    @if($transaction->date)
                                        <span class="fw-bold">{{ $transaction->date->format('d.m.Y') }}</span>
                                    @elseif($transaction->created_at)
                                        <span class="fw-bold">{{ $transaction->created_at->format('d.m.Y') }}</span>
                                    @else
                                        <span class="fw-bold">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($transaction->type === 'income')
                                        <span class="badge bg-success-subtle text-success border border-success">
                                            <i class="bi bi-arrow-down-circle me-1"></i> Gelir
                                        </span>
                                    @else
                                        <span class="badge bg-danger-subtle text-danger border border-danger">
                                            <i class="bi bi-arrow-up-circle me-1"></i> Gider
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <span class="text-muted">{{ ($transaction->account && $transaction->account->name) ? $transaction->account->name : '-' }}</span>
                                </td>
                                <td>
                                    @if($transaction->reservation && $transaction->reservation_id)
                                        <a href="{{ route('admin.appointments.show', $transaction->reservation_id) }}" class="text-primary text-decoration-none">
                                            <i class="bi bi-calendar-check me-1"></i>#{{ $transaction->reservation_id }}
                                        </a>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($transaction->customer && $transaction->customer_id)
                                        <a href="{{ route('admin.customers.show', $transaction->customer_id) }}" class="text-primary text-decoration-none">
                                            <i class="bi bi-person me-1"></i>{{ $transaction->customer->name ?? '-' }}
                                        </a>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="text-muted">{{ Str::limit($transaction->description ?? '-', 40) }}</span>
                                </td>
                                <td class="text-end">
                                    @if(($transaction->type ?? '') === 'income')
                                        <strong class="text-success" style="font-size: 16px;">
                                            <i class="bi bi-plus-circle me-1"></i>+{{ number_format($transaction->amount ?? 0, 2, ',', '.') }} ₺
                                        </strong>
                                    @else
                                        <strong class="text-danger" style="font-size: 16px;">
                                            <i class="bi bi-dash-circle me-1"></i>-{{ number_format($transaction->amount ?? 0, 2, ',', '.') }} ₺
                                        </strong>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if(isset($transaction->id))
                                        <div class="btn-group btn-group-sm" role="group">
                                            <button type="button" class="btn btn-outline-primary" onclick="showInvoiceForTransaction({{ $transaction->id }})" title="Faturayı Görüntüle">
                                                <i class="bi bi-receipt"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-danger" onclick="deleteTransaction({{ $transaction->id }})" title="Sil">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="bi bi-inbox" style="font-size: 48px;"></i>
                                        <p class="mt-3 mb-0">Henüz işlem bulunmamaktadır.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <!-- Mobile Cards -->
            <div class="d-md-none">
                @forelse($transactions as $transaction)
                    <div class="card mb-3 mx-3 mt-3 border-start border-4" style="border-left-color: {{ ($transaction->type ?? '') === 'income' ? '#ec4899' : '#ef4444' }};">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div>
                                    @if($transaction->date)
                                        <h6 class="mb-1 fw-bold">{{ $transaction->date->format('d.m.Y') }}</h6>
                                    @elseif($transaction->created_at)
                                        <h6 class="mb-1 fw-bold">{{ $transaction->created_at->format('d.m.Y') }}</h6>
                                    @else
                                        <h6 class="mb-1 fw-bold">-</h6>
                                    @endif
                                    <small class="text-muted">{{ $transaction->created_at->format('H:i') ?? '' }}</small>
                                </div>
                                <div>
                                    @if($transaction->type === 'income')
                                        <span class="badge bg-success">
                                            <i class="bi bi-arrow-down-circle"></i> Gelir
                                        </span>
                                    @else
                                        <span class="badge bg-danger">
                                            <i class="bi bi-arrow-up-circle"></i> Gider
                                        </span>
                                    @endif
                                </div>
                            </div>
                            
                            @if($transaction->account)
                                <div class="mb-2">
                                    <small class="text-muted d-block">Hesap:</small>
                                    <strong>{{ $transaction->account->name ?? '-' }}</strong>
                                </div>
                            @endif
                            
                            @if($transaction->reservation)
                                <div class="mb-2">
                                    <small class="text-muted d-block">Randevu:</small>
                                    <a href="{{ route('admin.appointments.show', $transaction->reservation_id) }}" class="text-primary text-decoration-none">
                                        <i class="bi bi-calendar-check"></i> #{{ $transaction->reservation_id }}
                                    </a>
                                </div>
                            @endif
                            
                            @if($transaction->customer)
                                <div class="mb-2">
                                    <small class="text-muted d-block">Ödeme Yapan:</small>
                                    <a href="{{ route('admin.customers.show', $transaction->customer_id) }}" class="text-primary text-decoration-none">
                                        <i class="bi bi-person"></i> {{ $transaction->customer->name ?? '-' }}
                                    </a>
                                </div>
                            @endif
                            
                            @if($transaction->description)
                                <div class="mb-2">
                                    <small class="text-muted d-block">Açıklama:</small>
                                    <span>{{ Str::limit($transaction->description, 50) }}</span>
                                </div>
                            @endif
                            
                            <div class="row g-2 mb-2">
                                <div class="col-12">
                                    <small class="text-muted d-block">Tutar</small>
                                    @if(($transaction->type ?? '') === 'income')
                                        <strong class="text-success" style="font-size: 18px;">
                                            <i class="bi bi-plus-circle"></i> +{{ number_format($transaction->amount ?? 0, 2, ',', '.') }} ₺
                                        </strong>
                                    @else
                                        <strong class="text-danger" style="font-size: 18px;">
                                            <i class="bi bi-dash-circle"></i> -{{ number_format($transaction->amount ?? 0, 2, ',', '.') }} ₺
                                        </strong>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="d-flex flex-wrap gap-1 mt-2">
                                @if(isset($transaction->id))
                                    <button type="button" class="btn btn-sm btn-outline-primary flex-fill" onclick="showInvoiceForTransaction({{ $transaction->id }})">
                                        <i class="bi bi-receipt"></i> Fatura
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="deleteTransaction({{ $transaction->id }})">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                @endif
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="text-center py-5 px-3">
                        <i class="bi bi-inbox display-4 text-muted"></i>
                        <p class="text-muted mt-2">Henüz işlem bulunmamaktadır.</p>
                    </div>
                @endforelse
            </div>
            
            <div class="card-footer bg-light border-top">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <small class="text-muted">Toplam {{ $transactions->total() }} işlem</small>
                    </div>
                    <div>
                        {{ $transactions->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
<style>
    .transaction-row {
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        border-left: 4px solid transparent;
    }
    
    .transaction-row:hover {
        background: linear-gradient(90deg, rgba(248, 249, 250, 0.8) 0%, rgba(255, 255, 255, 1) 100%);
        transform: translateX(4px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    }
    
    .transaction-row[data-type="income"] {
        border-left-color: #28a745;
        background-color: rgba(40, 167, 69, 0.02);
    }
    
    .transaction-row[data-type="income"]:hover {
        background: linear-gradient(90deg, rgba(40, 167, 69, 0.05) 0%, rgba(255, 255, 255, 1) 100%);
    }
    
    .transaction-row[data-type="expense"] {
        border-left-color: #dc3545;
        background-color: rgba(220, 53, 69, 0.02);
    }
    
    .transaction-row[data-type="expense"]:hover {
        background: linear-gradient(90deg, rgba(220, 53, 69, 0.05) 0%, rgba(255, 255, 255, 1) 100%);
    }
    
    .table thead th {
        font-weight: 600;
        font-size: 12px;
        text-transform: uppercase;
        letter-spacing: 0.8px;
        color: #64748b;
        border-bottom: 2px solid #e2e8f0;
        background-color: #f8f9fa;
        padding: 1rem 1.5rem;
    }
    
    .table tbody td {
        vertical-align: middle;
        padding: 1.25rem 1.5rem;
        border-bottom: 1px solid #f1f5f9;
    }
    
    .badge {
        padding: 0.5em 0.9em;
        font-weight: 500;
        font-size: 12px;
        border-radius: 6px;
    }
    
    .card-header {
        padding: 1.25rem 1.5rem;
        background-color: #f8f9fa;
        border-bottom: 1px solid #e2e8f0;
    }
    
    .card-footer {
        padding: 1rem 1.5rem;
        background-color: #f8f9fa;
        border-top: 1px solid #e2e8f0;
    }
    
    .table {
        margin-bottom: 0;
    }
    
    .btn-outline-danger:hover {
        transform: scale(1.1);
        transition: transform 0.2s ease;
    }
</style>
@endpush

<!-- Gelir Ekleme Modal -->
<div class="modal fade" id="incomeModal" tabindex="-1" aria-labelledby="incomeModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-light">
                <h5 class="modal-title text-dark" id="incomeModalLabel">
                    <i class="bi bi-plus-circle"></i> Gelir Ekle
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="incomeForm" method="POST" action="{{ route('admin.accounting.cashbox.income.store') }}">
                    @csrf
                    
                    <div class="mb-3">
                        <label class="form-label">Tutar <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="amount" class="form-control" required min="0">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Tarih <span class="text-danger">*</span></label>
                        <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Müşteri</label>
                        <select name="customer_id" class="form-select" id="incomeCustomerSelect">
                            <option value="">Seçiniz (Opsiyonel)</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Randevu</label>
                        <select name="reservation_id" class="form-select" id="incomeReservationSelect">
                            <option value="">Önce müşteri seçin</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Ödeme Yapan Kişi <small class="text-muted">(Opsiyonel)</small></label>
                        <input type="text" name="payer_name" class="form-control" placeholder="Örn: Ahmet Yılmaz">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Açıklama</label>
                        <textarea name="description" class="form-control" rows="3"></textarea>
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                        <button type="submit" class="btn btn-success">Kaydet</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- İşlem Düzenleme Modal -->
<div class="modal fade" id="editTransactionModal" tabindex="-1" aria-labelledby="editTransactionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-light">
                <h5 class="modal-title text-dark" id="editTransactionModalLabel">
                    <i class="bi bi-pencil"></i> İşlem Düzenle
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editTransactionForm" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label class="form-label">Tutar <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="amount" id="editAmount" class="form-control" required min="0">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Tarih <span class="text-danger">*</span></label>
                        <input type="date" name="date" id="editDate" class="form-control" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Müşteri</label>
                        <select name="customer_id" class="form-select" id="editCustomerSelect">
                            <option value="">Seçiniz (Opsiyonel)</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Açıklama</label>
                        <textarea name="description" id="editDescription" class="form-control" rows="3"></textarea>
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                        <button type="submit" class="btn btn-primary">Güncelle</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Gider Ekleme Modal -->
<div class="modal fade" id="expenseModal" tabindex="-1" aria-labelledby="expenseModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-light">
                <h5 class="modal-title text-dark" id="expenseModalLabel">
                    <i class="bi bi-dash-circle"></i> Gider Ekle
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="expenseForm" method="POST" action="{{ route('admin.accounting.cashbox.expense.store') }}">
                    @csrf
                    
                    <div class="mb-3">
                        <label class="form-label">Tutar <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="amount" class="form-control" required min="0">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Tarih <span class="text-danger">*</span></label>
                        <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Müşteri</label>
                        <select name="customer_id" class="form-select" id="expenseCustomerSelect">
                            <option value="">Seçiniz (Opsiyonel)</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Randevu</label>
                        <select name="reservation_id" class="form-select" id="expenseReservationSelect">
                            <option value="">Önce müşteri seçin</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Açıklama</label>
                        <textarea name="description" class="form-control" rows="3"></textarea>
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                        <button type="submit" class="btn btn-danger">Kaydet</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function openIncomeModal() {
    // Formu sıfırla
    const form = document.getElementById('incomeForm');
    if (form) {
        form.reset();
        form.querySelector('input[name="date"]').value = '{{ date("Y-m-d") }}';
        const submitBtn = form.querySelector('button[type="submit"]');
        if (submitBtn) {
            submitBtn.disabled = false;
            submitBtn.innerHTML = 'Kaydet';
        }
        // Randevu listesini sıfırla
        const reservationSelect = document.getElementById('incomeReservationSelect');
        if (reservationSelect) {
            reservationSelect.innerHTML = '<option value="">Önce müşteri seçin</option>';
        }
    }
    const modal = new bootstrap.Modal(document.getElementById('incomeModal'));
    modal.show();
}

function openExpenseModal() {
    // Formu sıfırla
    const form = document.getElementById('expenseForm');
    if (form) {
        form.reset();
        form.querySelector('input[name="date"]').value = '{{ date("Y-m-d") }}';
        const submitBtn = form.querySelector('button[type="submit"]');
        if (submitBtn) {
            submitBtn.disabled = false;
            submitBtn.innerHTML = 'Kaydet';
        }
        // Randevu listesini sıfırla
        const reservationSelect = document.getElementById('expenseReservationSelect');
        if (reservationSelect) {
            reservationSelect.innerHTML = '<option value="">Önce müşteri seçin</option>';
        }
    }
    const modal = new bootstrap.Modal(document.getElementById('expenseModal'));
    modal.show();
}

// Tüm randevuları JSON formatında al
@php
    $appointmentsJson = $appointments->map(function($r) {
        return [
            'id' => $r->id,
            'customer_id' => $r->customer_id,
            'customer' => $r->customer ? ['name' => $r->customer->name] : null,
            'date' => $r->date ? $r->date->format('d.m.Y') : ($r->created_at ? $r->created_at->format('d.m.Y') : '')
        ];
    })->values()->all();
@endphp
const allAppointments = @json($appointmentsJson ?? []);

// Sonsuz döngüyü önlemek için flag
let isUpdatingReservation = false;

// Müşteri seçildiğinde randevuları filtrele
document.getElementById('incomeCustomerSelect')?.addEventListener('change', function() {
    if (isUpdatingReservation) return;
    
    const customerId = this.value;
    const reservationSelect = document.getElementById('incomeReservationSelect');
    
    if (!reservationSelect) return;
    
    // Mevcut seçili randevuu koru
    const currentReservationId = reservationSelect.value;
    
    // Müşteri seçildiyse sadece o müşterinin randevularını göster
    if (customerId) {
        const filteredAppointments = allAppointments.filter(r => r.customer_id == customerId);
        reservationSelect.innerHTML = '<option value="">Seçiniz (Opsiyonel)</option>';
        filteredAppointments.forEach(reservation => {
            const option = document.createElement('option');
            option.value = reservation.id;
            option.dataset.customerId = reservation.customer_id;
            const customerName = reservation.customer?.name || 'Müşteri Yok';
            option.textContent = `#${reservation.id} - ${customerName} (${reservation.date})`;
            reservationSelect.appendChild(option);
        });
        
        // Eğer seçili randevu bu müşteriye aitse, seçimini koru
        if (currentReservationId && filteredAppointments.find(r => r.id == currentReservationId)) {
            reservationSelect.value = currentReservationId;
        }
    } else {
        // Müşteri seçilmediyse tüm randevuları göster
        reservationSelect.innerHTML = '<option value="">Seçiniz (Opsiyonel)</option>';
        allAppointments.forEach(reservation => {
            const option = document.createElement('option');
            option.value = reservation.id;
            option.dataset.customerId = reservation.customer_id;
            const customerName = reservation.customer?.name || 'Müşteri Yok';
            option.textContent = `#${reservation.id} - ${customerName} (${reservation.date})`;
            reservationSelect.appendChild(option);
        });
        
        // Eğer seçili randevu varsa, seçimini koru
        if (currentReservationId) {
            reservationSelect.value = currentReservationId;
        }
    }
});

// Randevu seçildiğinde müşteriyi otomatik doldur
document.getElementById('incomeReservationSelect')?.addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    if (!selectedOption) return;
    
    const customerId = selectedOption.dataset.customerId;
    const reservationId = this.value;
    
    if (customerId && reservationId) {
        isUpdatingReservation = true;
        const customerSelect = document.getElementById('incomeCustomerSelect');
        const currentCustomerId = customerSelect.value;
        
        // Müşteri değişecekse güncelle
        if (currentCustomerId != customerId) {
            customerSelect.value = customerId;
            // Müşteri değiştiği için randevu listesini güncelle ama seçimi koru
            customerSelect.dispatchEvent(new Event('change'));
        }
        
        // Randevu seçimini koru
        setTimeout(() => {
            const reservationSelect = document.getElementById('incomeReservationSelect');
            if (reservationSelect) {
                reservationSelect.value = reservationId;
            }
            isUpdatingReservation = false;
        }, 50);
    }
});

// Müşteri seçildiğinde randevuları filtrele (Gider için)
document.getElementById('expenseCustomerSelect')?.addEventListener('change', function() {
    if (isUpdatingReservation) return;
    
    const customerId = this.value;
    const reservationSelect = document.getElementById('expenseReservationSelect');
    
    if (!reservationSelect) return;
    
    // Mevcut seçili randevuu koru
    const currentReservationId = reservationSelect.value;
    
    // Müşteri seçildiyse sadece o müşterinin randevularını göster
    if (customerId) {
        const filteredAppointments = allAppointments.filter(r => r.customer_id == customerId);
        reservationSelect.innerHTML = '<option value="">Seçiniz (Opsiyonel)</option>';
        filteredAppointments.forEach(reservation => {
            const option = document.createElement('option');
            option.value = reservation.id;
            option.dataset.customerId = reservation.customer_id;
            const customerName = reservation.customer?.name || 'Müşteri Yok';
            option.textContent = `#${reservation.id} - ${customerName} (${reservation.date})`;
            reservationSelect.appendChild(option);
        });
        
        // Eğer seçili randevu bu müşteriye aitse, seçimini koru
        if (currentReservationId && filteredAppointments.find(r => r.id == currentReservationId)) {
            reservationSelect.value = currentReservationId;
        }
    } else {
        // Müşteri seçilmediyse tüm randevuları göster
        reservationSelect.innerHTML = '<option value="">Seçiniz (Opsiyonel)</option>';
        allAppointments.forEach(reservation => {
            const option = document.createElement('option');
            option.value = reservation.id;
            option.dataset.customerId = reservation.customer_id;
            const customerName = reservation.customer?.name || 'Müşteri Yok';
            option.textContent = `#${reservation.id} - ${customerName} (${reservation.date})`;
            reservationSelect.appendChild(option);
        });
        
        // Eğer seçili randevu varsa, seçimini koru
        if (currentReservationId) {
            reservationSelect.value = currentReservationId;
        }
    }
});

document.getElementById('expenseReservationSelect')?.addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];
    if (!selectedOption) return;
    
    const customerId = selectedOption.dataset.customerId;
    const reservationId = this.value;
    
    if (customerId && reservationId) {
        isUpdatingReservation = true;
        const customerSelect = document.getElementById('expenseCustomerSelect');
        const currentCustomerId = customerSelect.value;
        
        // Müşteri değişecekse güncelle
        if (currentCustomerId != customerId) {
            customerSelect.value = customerId;
            // Müşteri değiştiği için randevu listesini güncelle ama seçimi koru
            customerSelect.dispatchEvent(new Event('change'));
        }
        
        // Randevu seçimini koru
        setTimeout(() => {
            const reservationSelect = document.getElementById('expenseReservationSelect');
            if (reservationSelect) {
                reservationSelect.value = reservationId;
            }
            isUpdatingReservation = false;
        }, 50);
    }
});

// Form submit - AJAX (çift kayıt önleme)
document.getElementById('incomeForm')?.addEventListener('submit', function(e) {
    e.preventDefault();
    const form = this;
    const submitBtn = form.querySelector('button[type="submit"]');
    
    // Çift tıklama önleme
    if (submitBtn.disabled) return;
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;"> Kaydediliyor...';
    
    const formData = new FormData(form);
    
    fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
        }
    })
    .then(response => {
        if (response.ok) {
            return response.json().catch(() => ({ success: true }));
        }
        return response.json().then(data => { throw new Error(data.message || 'Hata oluştu'); });
    })
    .then(data => {
        bootstrap.Modal.getInstance(document.getElementById('incomeModal')).hide();
        window.location.reload();
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Gelir eklenirken bir hata oluştu: ' + error.message);
        submitBtn.disabled = false;
        submitBtn.innerHTML = 'Kaydet';
    });
});

document.getElementById('expenseForm')?.addEventListener('submit', function(e) {
    e.preventDefault();
    const form = this;
    const submitBtn = form.querySelector('button[type="submit"]');
    
    // Çift tıklama önleme
    if (submitBtn.disabled) return;
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;"> Kaydediliyor...';
    
    const formData = new FormData(form);
    
    fetch(form.action, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
        }
    })
    .then(response => {
        if (response.ok) {
            return response.json().catch(() => ({ success: true }));
        }
        return response.json().then(data => { throw new Error(data.message || 'Hata oluştu'); });
    })
    .then(data => {
        bootstrap.Modal.getInstance(document.getElementById('expenseModal')).hide();
        window.location.reload();
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Gider eklenirken bir hata oluştu: ' + error.message);
        submitBtn.disabled = false;
        submitBtn.innerHTML = 'Kaydet';
    });
});

// İşlem düzenleme
async function editTransaction(transactionId) {
    try {
        const response = await fetch(`{{ url('admin/muhasebe/kasa') }}/${transactionId}`, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        });
        
        if (!response.ok) {
            throw new Error('İşlem bulunamadı');
        }
        
        const data = await response.json();
        if (!data.success) {
            alert(data.message || 'İşlem bulunamadı.');
            return;
        }
        
        const transaction = data.transaction;
        
        // Modal'ı doldur
        document.getElementById('editAmount').value = transaction.amount || '';
        document.getElementById('editDate').value = transaction.date || '';
        document.getElementById('editCustomerSelect').value = transaction.customer_id || '';
        document.getElementById('editDescription').value = transaction.description || '';
        document.getElementById('editTransactionForm').action = `{{ url('admin/muhasebe/kasa') }}/${transactionId}`;
        
        const modal = new bootstrap.Modal(document.getElementById('editTransactionModal'));
        modal.show();
    } catch (error) {
        console.error('Error:', error);
        alert('İşlem bilgileri yüklenirken bir hata oluştu.');
    }
}

// Transaction için faturayı göster
async function showInvoiceForTransaction(transactionId) {
    try {
        // Route helper kullan
        const routeTemplate = '{{ route("admin.accounting.cashbox.invoice", ["id" => "XXX"]) }}';
        const url = routeTemplate.replace('XXX', transactionId);
        
        const response = await fetch(url, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Accept': 'application/json'
            }
        });
        
        if (!response.ok) {
            throw new Error('Fatura bulunamadı (HTTP ' + response.status + ')');
        }
        
        const data = await response.json();
        
        if (data.success && data.invoice) {
            // Faturayı yeni sekmede aç
            window.open(data.invoice.public_url, '_blank');
        } else {
            const errorMsg = data.message || 'Fatura bulunamadı.';
            if (typeof showToast === 'function') {
                showToast('error', errorMsg);
            } else if (typeof showPopup === 'function') {
                showPopup('error', errorMsg);
            } else {
                alert(errorMsg);
            }
        }
    } catch (error) {
        console.error('Error:', error);
        const errorMsg = 'Fatura yüklenirken bir hata oluştu: ' + error.message;
        if (typeof showToast === 'function') {
            showToast('error', errorMsg);
        } else if (typeof showPopup === 'function') {
            showPopup('error', errorMsg);
        } else {
            alert(errorMsg);
        }
    }
}

// İşlem silme
async function deleteTransaction(transactionId) {
    const confirmed = await customConfirm('Bu işlemi silmek istediğinize emin misiniz? Bu işlem geri alınamaz ve bakiyeler güncellenecektir.');
    if (!confirmed) {
        return;
    }
    
    fetch(`{{ url('admin/muhasebe/kasa') }}/${transactionId}`, {
        method: 'DELETE',
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            if (typeof showToast === 'function') {
                showToast('success', 'İşlem başarıyla silindi.');
            } else {
                showPopup('success', 'İşlem başarıyla silindi.');
            }
            // Onay verildikten sonra sayfayı hemen yenile
            setTimeout(() => window.location.reload(), 1000);
        } else {
            if (typeof showToast === 'function') {
                showToast('error', data.message || 'Bir hata oluştu.');
            } else {
                showPopup('error', data.message || 'Bir hata oluştu.');
            }
        }
    })
    .catch(error => {
        console.error('Error:', error);
        if (typeof showToast === 'function') {
            showToast('error', 'İşlem silinirken bir hata oluştu.');
        } else {
            showPopup('error', 'İşlem silinirken bir hata oluştu.');
        }
    });
}


// Filtreleme
document.getElementById('dateFromFilter')?.addEventListener('change', function() {
    applyFilters();
});

document.getElementById('dateToFilter')?.addEventListener('change', function() {
    applyFilters();
});

document.getElementById('typeFilter')?.addEventListener('change', function() {
    applyFilters();
});

function applyFilters() {
    const dateFrom = document.getElementById('dateFromFilter')?.value || '';
    const dateTo = document.getElementById('dateToFilter')?.value || '';
    const type = document.getElementById('typeFilter')?.value || '';
    
    const params = new URLSearchParams();
    if (dateFrom) params.append('date_from', dateFrom);
    if (dateTo) params.append('date_to', dateTo);
    if (type) params.append('type', type);
    
    window.location.href = `{{ route('admin.accounting.cashbox') }}?${params.toString()}`;
}

// Düzenleme formu submit (çift kayıt önleme)
document.getElementById('editTransactionForm')?.addEventListener('submit', function(e) {
    e.preventDefault();
    const form = this;
    const submitBtn = form.querySelector('button[type="submit"]');
    
    // Çift tıklama önleme
    if (submitBtn.disabled) return;
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;"> Güncelleniyor...';
    
    const formData = new FormData(form);
    
    fetch(form.action, {
        method: 'PUT',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content
        }
    })
    .then(response => {
        if (response.ok) {
            return response.json().catch(() => ({ success: true }));
        }
        return response.json().then(data => { throw new Error(data.message || 'Hata oluştu'); });
    })
    .then(data => {
        bootstrap.Modal.getInstance(document.getElementById('editTransactionModal')).hide();
        window.location.reload();
    })
    .catch(error => {
        console.error('Error:', error);
        alert('İşlem güncellenirken bir hata oluştu: ' + error.message);
        submitBtn.disabled = false;
        submitBtn.innerHTML = 'Güncelle';
    });
});
</script>
@endpush
