@extends('layouts.admin')

@section('title', 'Cari Hesap Detayı')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.accounting.customers') }}">Cariler</a></li>
    <li class="breadcrumb-item active">Detay</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Cari Hesap Detayı - {{ $customer->name }}</h2>
        <a href="{{ route('admin.accounting.customers') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">Toplam Tutar</h5>
                </div>
                <div class="card-body">
                    <h3 class="text-primary">{{ number_format($totalAmount, 2, ',', '.') }} ₺</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">Ödenen</h5>
                </div>
                <div class="card-body">
                    <h3 class="text-success">{{ number_format($totalPaid, 2, ',', '.') }} ₺</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0">Kalan</h5>
                </div>
                <div class="card-body">
                    <h3 class="text-danger">{{ number_format($totalRemaining, 2, ',', '.') }} ₺</h3>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0"><i class="bi bi-list-ul"></i> Randevular</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Randevu Kodu</th>
                            <th>Tarih</th>
                            <th>Toplam</th>
                            <th>Ödenen</th>
                            <th>Kalan</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($appointments as $reservation)
                            <tr>
                                <td>{{ $reservation->code }}</td>
                                <td>{{ $reservation->date->format('d.m.Y') }}</td>
                                <td>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</td>
                                <td class="text-success">{{ number_format($reservation->deposit_paid, 2, ',', '.') }} ₺</td>
                                <td class="text-danger">{{ number_format($reservation->remaining_amount, 2, ',', '.') }} ₺</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">Randevu bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

