@extends('layouts.admin')

@section('title', 'Gelecek Kaporalar')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Gelecek Kaporalar</li>
@endsection

@section('content')
    <h2 class="mb-4">Gelecek Kaporalar</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-warning text-white">
            <h5 class="mb-0"><i class="bi bi-calendar-check"></i> Gelecek Kaporalar</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Randevu Kodu</th>
                            <th>Müşteri</th>
                            <th>Kapora Tutarı</th>
                            <th>Vade Tarihi</th>
                            <th>Durum</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($deposits as $deposit)
                            <tr>
                                <td>{{ $deposit->reservation->code }}</td>
                                <td>{{ $deposit->reservation->customer->name }}</td>
                                <td><strong>{{ number_format($deposit->amount, 2, ',', '.') }} ₺</strong></td>
                                <td>{{ $deposit->due_date->format('d.m.Y') }}</td>
                                <td>
                                    @if($deposit->is_paid)
                                        <span class="badge bg-success">Ödendi</span>
                                    @else
                                        <span class="badge bg-warning">Beklemede</span>
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">Kapora kaydı bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $deposits->links() }}
            </div>
        </div>
    </div>
@endsection

