@extends('layouts.admin')

@section('title', 'Randevu Talepleri')
@section('page-title', 'Randevu Talepleri')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-calendar-check me-2"></i>Bekleyen Randevu Talepleri
                    </h5>
                </div>
                <div class="card-body">
                    @if($pendingRequests->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Müşteri</th>
                                        <th>Telefon</th>
                                        <th>Hizmet</th>
                                        <th>Tarih</th>
                                        <th>Durum</th>
                                        <th>İşlemler</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($pendingRequests as $request)
                                        <tr>
                                            <td>
                                                {{ $request->name }}
                                                @if($request->surname)
                                                    {{ $request->surname }}
                                                @endif
                                            </td>
                                            <td>{{ $request->phone }}</td>
                                            <td>
                                                @if($request->service)
                                                    <span class="badge bg-primary">{{ $request->service->name }}</span>
                                                    <br>
                                                    <small class="text-muted">{{ number_format($request->service->price, 2, ',', '.') }} ₺</small>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                <small>{{ $request->created_at->format('d.m.Y H:i') }}</small>
                                            </td>
                                            <td>
                                                <span class="badge bg-warning">Bekliyor</span>
                                            </td>
                                            <td>
                                                <a href="{{ route('admin.beauty-salon.appointment-requests.show', $request->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="bi bi-eye me-1"></i>İncele
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>Henüz bekleyen randevu talebi bulunmamaktadır.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-12">
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                <strong>Bilgi:</strong> Onaylanan randevu talepleri otomatik olarak <a href="{{ route('admin.appointments.index') }}" class="alert-link">Randevu Yönetimi</a> sayfasına aktarılır.
            </div>
        </div>
    </div>
</div>
@endsection
