@if(!request()->ajax())
@extends('layouts.admin')

@section('title', 'Randevu Talebi Detayı')
@section('page-title', 'Randevu Talebi Detayı')

@section('content')
<div class="container-fluid">
@else
<div class="container-fluid">
@endif
    <div class="row g-3" style="margin: 0;">
        <!-- Sol Taraf: Müşteri Bilgileri ve Portföyü -->
        <div class="col-lg-6 col-md-12" style="padding: 0 0.75rem;">
            <!-- Müşteri Bilgileri - Minimalist -->
            <div class="card shadow-sm mb-3" style="border-radius: 12px; border: none;">
                <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">
                    <h6 class="mb-0 text-white fw-bold" style="font-size: 0.95rem;">
                        <i class="bi bi-person-circle me-2"></i>Müşteri Bilgileri
                    </h6>
                </div>
                <div class="card-body p-3">
                    <!-- Kompakt Bilgi Listesi -->
                    <div class="mb-2">
                        <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Ad Soyad</small>
                        <p class="mb-2 fw-bold" style="font-size: 0.9rem; color: #1f2937;">{{ $appointmentRequest->name }} {{ $appointmentRequest->surname ?? '' }}</p>
                    </div>
                    
                    <div class="mb-2">
                        <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Telefon</small>
                        <p class="mb-2" style="font-size: 0.9rem;">
                            <a href="tel:{{ $appointmentRequest->phone }}" class="text-decoration-none" style="color: #ec4899;">{{ $appointmentRequest->phone }}</a>
                        </p>
                    </div>
                    
                    @if($appointmentRequest->age)
                    <div class="mb-2">
                        <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Yaş</small>
                        <p class="mb-2" style="font-size: 0.9rem; color: #1f2937;">{{ $appointmentRequest->age }}</p>
                    </div>
                    @endif
                    
                    <div class="mb-2">
                        <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Durum</small>
                        <p class="mb-2">
                            @if($appointmentRequest->status === 'pending')
                                <span class="badge bg-warning px-2 py-1" style="font-size: 0.75rem;">Bekliyor</span>
                            @elseif($appointmentRequest->status === 'approved')
                                <span class="badge bg-success px-2 py-1" style="font-size: 0.75rem;">Onaylandı</span>
                            @elseif($appointmentRequest->status === 'rejected')
                                <span class="badge bg-danger px-2 py-1" style="font-size: 0.75rem;">Reddedildi</span>
                            @else
                                <span class="badge bg-secondary px-2 py-1" style="font-size: 0.75rem;">{{ $appointmentRequest->status }}</span>
                            @endif
                        </p>
                    </div>
                    
                    <hr class="my-2" style="border-color: #e5e7eb;">
                    
                    <!-- Hizmet Bilgisi - Kompakt -->
                    <div class="mb-2">
                        <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Hizmet</small>
                        @if($appointmentRequest->service)
                            <div class="d-flex align-items-center gap-2 flex-wrap">
                                <span class="badge bg-primary px-2 py-1" style="font-size: 0.8rem;">{{ $appointmentRequest->service->name }}</span>
                                <span class="text-success fw-bold" style="font-size: 0.85rem;">{{ number_format($appointmentRequest->service->price, 2, ',', '.') }} ₺</span>
                                @if($appointmentRequest->service->duration)
                                    <span class="text-muted" style="font-size: 0.8rem;">
                                        <i class="bi bi-clock me-1"></i>{{ $appointmentRequest->service->duration }} dk
                                    </span>
                                @endif
                            </div>
                        @else
                            <p class="text-muted mb-0" style="font-size: 0.85rem;">Hizmet seçilmemiş</p>
                        @endif
                    </div>
                    
                    <!-- Tarih Bilgileri - Kompakt -->
                    <div class="mb-2">
                        <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Talep Tarihi</small>
                        <p class="mb-0" style="font-size: 0.85rem; color: #1f2937;">{{ $appointmentRequest->created_at->format('d.m.Y H:i') }}</p>
                    </div>
                    
                    @if($appointmentRequest->appointment_date)
                    <div class="mb-2">
                        <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Randevu Tarihi</small>
                        <p class="mb-0" style="font-size: 0.85rem; color: #1f2937;">
                            {{ \Carbon\Carbon::parse($appointmentRequest->appointment_date)->format('d.m.Y') }}
                            @if($appointmentRequest->appointment_time)
                                <span class="text-muted">- {{ $appointmentRequest->appointment_time }}</span>
                            @endif
                        </p>
                    </div>
                    @endif
                    
                    @if($appointmentRequest->recurring_data)
                    <div class="mb-2">
                        <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Tekrarlama Periyotu</small>
                        <div class="alert alert-warning mb-0 p-2" style="border-radius: 8px; font-size: 0.85rem; background: #fef3c7; border: 1px solid #fbbf24;">
                            <i class="bi bi-calendar-repeat me-2 text-warning"></i>
                            <strong>Bu randevu tekrarlanacak!</strong>
                            <div class="mt-1" style="font-size: 0.8rem;">
                                @php
                                    $recurring = $appointmentRequest->recurring_data;
                                    $type = $recurring['recurring_type'] ?? null;
                                    $count = $recurring['recurring_count'] ?? 1;
                                @endphp
                                @if($type === 'weekly')
                                    <i class="bi bi-calendar-week me-1"></i>
                                    <strong>Haftalık:</strong> Her hafta 
                                    @php
                                        $days = ['', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi', 'Pazar'];
                                        $dayOfWeek = $recurring['day_of_week'] ?? 1;
                                    @endphp
                                    <strong>{{ $days[$dayOfWeek] ?? 'Pazartesi' }}</strong>
                                @elseif($type === 'monthly')
                                    <i class="bi bi-calendar-month me-1"></i>
                                    <strong>Aylık:</strong> Her ayın 
                                    <strong>{{ $recurring['day_of_month'] ?? 1 }}. günü</strong>
                                @endif
                                <br>
                                <i class="bi bi-arrow-repeat me-1"></i>
                                <strong>Toplam {{ $count }} kez</strong> tekrarlanacak
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            
            <!-- Müşteri Portföyü - Kompakt -->
            <div class="card shadow-sm" style="border-radius: 12px; border: none;">
                <div class="card-header" style="background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">
                    <h6 class="mb-0 text-white fw-bold" style="font-size: 0.95rem;">
                        <i class="bi bi-person-badge me-2"></i>Müşteri Portföyü
                    </h6>
                </div>
                <div class="card-body p-3">
                    @if($customer)
                        <!-- Müşteri Bilgileri - Kompakt -->
                        <div class="mb-3">
                            <div class="d-flex align-items-center mb-2">
                                <div class="customer-avatar me-2" style="width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 16px;">
                                    {{ strtoupper(mb_substr($customer->name ?? 'M', 0, 1)) }}
                                </div>
                                <div>
                                    <p class="mb-0 fw-bold" style="font-size: 0.9rem;">{{ $customer->name }} {{ $customer->surname ?? '' }}</p>
                                    <small class="text-muted" style="font-size: 0.75rem;">
                                        @if($customer->age)
                                            <i class="bi bi-calendar3 me-1"></i>{{ $customer->age }} yaş
                                        @endif
                                        @if($customer->phone)
                                            <span class="ms-2"><i class="bi bi-telephone me-1"></i>{{ $customer->phone }}</span>
                                        @endif
                                    </small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Geçmiş Randevular - Kompakt -->
                        <div>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <small class="text-muted" style="font-size: 0.75rem; font-weight: 600;">
                                    <i class="bi bi-clock-history me-1"></i>Geçmiş Randevular ({{ $customerReservations->count() }})
                                </small>
                                @if($customer && $customerReservations->count() > 0)
                                    <button type="button" 
                                            class="btn btn-sm" 
                                            onclick="showCustomerPortfolio({{ $customer->id }})"
                                            style="font-size: 0.7rem; color: #ec4899; background: rgba(236, 72, 153, 0.1); border: 1px solid rgba(236, 72, 153, 0.3); border-radius: 6px; padding: 2px 8px; font-weight: 600; transition: all 0.2s;"
                                            onmouseover="this.style.background='rgba(236, 72, 153, 0.2)'; this.style.borderColor='#ec4899';"
                                            onmouseout="this.style.background='rgba(236, 72, 153, 0.1)'; this.style.borderColor='rgba(236, 72, 153, 0.3)';">
                                        <i class="bi bi-arrow-right-circle me-1"></i>Daha Fazla
                                    </button>
                                @endif
                            </div>
                            @if($customerReservations->count() > 0)
                                <div class="reservation-history" style="max-height: 200px; overflow-y: auto;">
                                    @foreach($customerReservations->take(3) as $reservation)
                                        <div class="reservation-item mb-2 p-2 rounded" style="background: #f8fafc; border-left: 3px solid #ec4899;">
                                            <div class="d-flex justify-content-between align-items-start">
                                                <div style="flex: 1;">
                                                    <strong class="d-block" style="font-size: 0.85rem;">{{ \Carbon\Carbon::parse($reservation->date)->format('d.m.Y') }} {{ $reservation->start_time }}</strong>
                                                    <small class="text-muted" style="font-size: 0.75rem;">
                                                        @if($reservation->personel)
                                                            <i class="bi bi-person me-1"></i>{{ $reservation->personel->name }}
                                                        @endif
                                                        @if($reservation->appointmentRequest && $reservation->appointmentRequest->service)
                                                            <span class="ms-2"><i class="bi bi-scissors me-1"></i>{{ $reservation->appointmentRequest->service->name }}</span>
                                                        @endif
                                                    </small>
                                                </div>
                                                <div class="text-end">
                                                    <span class="badge 
                                                        @if($reservation->status === 'completed') bg-success
                                                        @elseif($reservation->status === 'confirmed') bg-primary
                                                        @elseif($reservation->status === 'cancelled') bg-danger
                                                        @elseif($reservation->status === 'pending' || $reservation->status === 'open') bg-warning
                                                        @else bg-secondary
                                                        @endif
                                                    " style="font-size: 0.7rem;">
                                                        @if($reservation->status === 'completed')
                                                            Tamamlandı
                                                        @elseif($reservation->status === 'confirmed')
                                                            Onaylandı
                                                        @elseif($reservation->status === 'cancelled')
                                                            İptal Edildi
                                                        @elseif($reservation->status === 'pending' || $reservation->status === 'open')
                                                            Beklemede
                                                        @else
                                                            {{ $reservation->status }}
                                                        @endif
                                                    </span>
                                                    <div class="mt-1">
                                                        <small class="text-success fw-bold" style="font-size: 0.75rem;">{{ number_format($reservation->total_price ?? 0, 2, ',', '.') }} ₺</small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <p class="text-muted text-center py-2 mb-0" style="font-size: 0.8rem;">
                                    <i class="bi bi-info-circle me-1"></i>Henüz randevu geçmişi yok
                                </p>
                            @endif
                        </div>
                    @else
                        <div class="text-center py-3">
                            <i class="bi bi-person-x" style="font-size: 32px; color: #cbd5e1;"></i>
                            <p class="text-muted mt-2 mb-0" style="font-size: 0.85rem;">Bu müşteri daha önce kayıt olmamış</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        
            <!-- Sağ Taraf: Randevu Onaylama Formu -->
            <div class="col-lg-6 col-md-12" style="padding: 0 0.75rem;">
            @if($appointmentRequest->status === 'pending')
                <!-- Onay Formu -->
                <div class="card shadow-sm mb-3" style="border-radius: 12px; border: none;">
                    <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">
                        <h6 class="mb-0 text-white fw-bold" style="font-size: 0.95rem;">
                            <i class="bi bi-check-circle me-2"></i>Randevu Onayla
                        </h6>
                    </div>
                    <div class="card-body p-3">
                        <form action="{{ route('admin.beauty-salon.appointment-requests.approve', $appointmentRequest->id) }}" method="POST" id="approveRequestForm">
                            @csrf
                            
                            <!-- Tarih ve Saat Bilgisi (Sadece Gösterim) -->
                            <div class="mb-3">
                                <label class="form-label fw-bold" style="font-size: 0.85rem;">
                                    <i class="bi bi-calendar3 me-1"></i>Randevu Tarihi ve Saati
                                </label>
                                <div class="alert alert-info mb-2" style="border-radius: 8px; padding: 10px; font-size: 0.9rem;">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <strong>{{ $appointmentRequest->appointment_date ? \Carbon\Carbon::parse($appointmentRequest->appointment_date)->format('d.m.Y') : 'Tarih seçilmemiş' }}</strong>
                                    @if($appointmentRequest->appointment_time)
                                        <span class="ms-2"><strong>{{ $appointmentRequest->appointment_time }}</strong></span>
                                    @endif
                                </div>
                                
                                @if($appointmentRequest->recurring_data)
                                <div class="alert alert-warning mb-2" style="border-radius: 8px; padding: 12px; font-size: 0.85rem; background: #fef3c7; border: 2px solid #fbbf24;">
                                    <i class="bi bi-calendar-repeat me-2 text-warning"></i>
                                    <strong class="d-block mb-2">⚠️ TEKRARLANAN SEANS UYARISI</strong>
                                    @php
                                        $recurring = $appointmentRequest->recurring_data;
                                        $type = $recurring['recurring_type'] ?? null;
                                        $count = $recurring['recurring_count'] ?? 1;
                                    @endphp
                                    <div style="font-size: 0.8rem; line-height: 1.6;">
                                        @if($type === 'weekly')
                                            <i class="bi bi-calendar-week me-1"></i>
                                            <strong>Periyot:</strong> Haftalık - Her hafta 
                                            @php
                                                $days = ['', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi', 'Pazar'];
                                                $dayOfWeek = $recurring['day_of_week'] ?? 1;
                                            @endphp
                                            <strong>{{ $days[$dayOfWeek] ?? 'Pazartesi' }}</strong>
                                        @elseif($type === 'monthly')
                                            <i class="bi bi-calendar-month me-1"></i>
                                            <strong>Periyot:</strong> Aylık - Her ayın 
                                            <strong>{{ $recurring['day_of_month'] ?? 1 }}. günü</strong>
                                        @endif
                                        <br>
                                        <i class="bi bi-arrow-repeat me-1"></i>
                                        <strong>Tekrarlama Sayısı:</strong> {{ $count }} kez
                                        <br>
                                        <i class="bi bi-exclamation-triangle me-1"></i>
                                        <strong>Önemli:</strong> Bu randevuyu onayladığınızda, toplam <strong>{{ $count }} adet</strong> randevu otomatik olarak oluşturulacaktır!
                                    </div>
                                </div>
                                @endif
                                
                                <input type="hidden" name="appointment_date" value="{{ $appointmentRequest->appointment_date }}">
                                <input type="hidden" name="appointment_time" value="{{ $appointmentRequest->appointment_time ? (is_string($appointmentRequest->appointment_time) ? substr($appointmentRequest->appointment_time, 0, 5) : \Carbon\Carbon::parse($appointmentRequest->appointment_time)->format('H:i')) : '' }}">
                            </div>
                            
                            <!-- Fiyat Düzenleme -->
                            <div class="mb-3">
                                <label for="total_price" class="form-label fw-bold" style="font-size: 0.85rem;">
                                    <i class="bi bi-currency-exchange me-1"></i>Fiyat <span class="text-danger">*</span>
                                </label>
                                <div class="input-group">
                                    <input type="number" 
                                           class="form-control" 
                                           id="total_price" 
                                           name="total_price" 
                                           step="0.01"
                                           min="0"
                                           value="{{ $appointmentRequest->service ? $appointmentRequest->service->price : 0 }}"
                                           data-service-price="{{ $appointmentRequest->service ? $appointmentRequest->service->price : 0 }}"
                                           required
                                           style="border-radius: 8px 0 0 8px; border: 1px solid #e5e7eb; padding: 8px; font-size: 0.9rem;">
                                    <span class="input-group-text" style="border-radius: 0 8px 8px 0; border: 1px solid #e5e7eb; background: #f8f9fa; font-weight: 600;">₺</span>
                                </div>
                                <small class="text-muted" style="font-size: 0.75rem;">
                                    <i class="bi bi-info-circle me-1"></i>Hizmet fiyatı: <strong>{{ $appointmentRequest->service ? number_format($appointmentRequest->service->price, 2, ',', '.') : '0,00' }} ₺</strong> - Fiyatı manuel olarak düzenleyebilirsiniz.
                                </small>
                            </div>
                            
                            <!-- Personel Seçimi -->
                            <div class="mb-3">
                                <label for="personel_id" class="form-label fw-bold" style="font-size: 0.85rem;">
                                    <i class="bi bi-person-badge me-1"></i>Personel <span class="text-danger">*</span>
                                </label>
                                <select class="form-select" 
                                        id="personel_id" 
                                        name="personel_id" 
                                        required
                                        style="border-radius: 8px; border: 1px solid #e5e7eb; padding: 8px; font-size: 0.9rem;">
                                    <option value="">Seçiniz...</option>
                                    @foreach($personels as $personel)
                                        <option value="{{ $personel->id }}" {{ $appointmentRequest->personel_id == $personel->id ? 'selected' : '' }}>{{ $personel->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <!-- Oda Seçimi -->
                            <div class="mb-3">
                                <label for="room_id" class="form-label fw-bold" style="font-size: 0.85rem;">
                                    <i class="bi bi-door-open me-1"></i>Oda <span class="text-muted">(Opsiyonel)</span>
                                </label>
                                <select class="form-select" 
                                        id="room_id" 
                                        name="room_id"
                                        style="border-radius: 8px; border: 1px solid #e5e7eb; padding: 8px; font-size: 0.9rem;">
                                    <option value="">Seçiniz...</option>
                                    @foreach($rooms as $room)
                                        <option value="{{ $room->id }}" {{ $appointmentRequest->room_id == $room->id ? 'selected' : '' }}>{{ $room->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <!-- Not Kısmı -->
                            <div class="mb-3">
                                <label for="notes" class="form-label fw-bold" style="font-size: 0.85rem;">
                                    <i class="bi bi-sticky me-1"></i>Not <span class="text-muted">(Opsiyonel)</span>
                                </label>
                                <textarea class="form-control" 
                                          id="notes" 
                                          name="notes" 
                                          rows="3"
                                          placeholder="Randevu ile ilgili notlar..."
                                          style="border-radius: 8px; border: 1px solid #e5e7eb; padding: 8px; font-size: 0.9rem;">{{ $appointmentRequest->notes }}</textarea>
                            </div>
                            
                            <!-- Butonlar -->
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn fw-bold" 
                                        id="approveBtn"
                                        style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border: none; border-radius: 8px; padding: 10px; font-size: 0.9rem;">
                                    <i class="bi bi-check-circle me-2"></i>Randevuyu Onayla
                                </button>
                            </div>
                        </form>
                        
                        <!-- Reddet Butonu -->
                        <form action="{{ route('admin.beauty-salon.appointment-requests.reject', $appointmentRequest->id) }}" 
                              method="POST" 
                              class="mt-2"
                              id="rejectRequestForm">
                            @csrf
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-danger fw-bold" 
                                        style="border-radius: 8px; padding: 10px; font-size: 0.9rem;">
                                    <i class="bi bi-x-circle me-2"></i>Randevu Talebini Reddet
                                </button>
                                <button type="button" class="btn btn-light fw-bold" 
                                        data-bs-dismiss="modal"
                                        style="border-radius: 8px; padding: 10px; font-size: 0.9rem;">
                                    <i class="bi bi-arrow-left me-2"></i>Kapat
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            @else
                <!-- Onaylanmış/Reddedilmiş Durum -->
                <div class="card shadow-sm" style="border-radius: 12px; border: none;">
                    <div class="card-header" style="background: linear-gradient(135deg, 
                        @if($appointmentRequest->status === 'approved') #ec4899 0%, #be185d 100%
                        @else #ef4444 0%, #dc2626 100%
                        @endif
                    ); border-radius: 12px 12px 0 0; padding: 12px 16px;">
                        <h6 class="mb-0 text-white fw-bold" style="font-size: 0.95rem;">
                            <i class="bi bi-{{ $appointmentRequest->status === 'approved' ? 'check-circle' : 'x-circle' }} me-2"></i>
                            {{ $appointmentRequest->status === 'approved' ? 'Onaylanmış Randevu' : 'Reddedilmiş Talep' }}
                        </h6>
                    </div>
                    <div class="card-body p-3">
                        @if($appointmentRequest->reservation)
                            <div class="mb-2">
                                <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Randevu Kodu</small>
                                <p class="mb-2 fw-bold" style="font-size: 0.9rem;">{{ $appointmentRequest->reservation->code }}</p>
                            </div>
                            
                            <div class="mb-3">
                                <small class="text-muted d-block mb-1" style="font-size: 0.75rem; font-weight: 600;">Durum</small>
                                <p class="mb-0">
                                    @if($appointmentRequest->reservation->status === 'confirmed')
                                        <span class="badge bg-success px-2 py-1" style="font-size: 0.75rem;">Onaylandı</span>
                                    @elseif($appointmentRequest->reservation->status === 'completed')
                                        <span class="badge bg-info px-2 py-1" style="font-size: 0.75rem;">Tamamlandı</span>
                                    @elseif($appointmentRequest->reservation->status === 'cancelled')
                                        <span class="badge bg-danger px-2 py-1" style="font-size: 0.75rem;">İptal Edildi</span>
                                    @elseif($appointmentRequest->reservation->status === 'pending' || $appointmentRequest->reservation->status === 'open')
                                        <span class="badge bg-warning px-2 py-1" style="font-size: 0.75rem;">Beklemede</span>
                                    @else
                                        <span class="badge bg-secondary px-2 py-1" style="font-size: 0.75rem;">{{ $appointmentRequest->reservation->status }}</span>
                                    @endif
                                </p>
                            </div>
                            
                            <a href="{{ route('admin.appointments.show', $appointmentRequest->reservation->id) }}" 
                               class="btn btn-primary w-100 fw-bold"
                               style="border-radius: 8px; padding: 10px; font-size: 0.9rem;">
                                <i class="bi bi-calendar-event me-2"></i>Randevu Detayına Git
                            </a>
                        @endif
                        
                        <button type="button" 
                                class="btn btn-light w-100 mt-2 fw-bold" 
                                data-bs-dismiss="modal"
                                style="border-radius: 8px; padding: 10px; font-size: 0.9rem;">
                            <i class="bi bi-arrow-left me-2"></i>Kapat
                        </button>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

@push('styles')
<style>
    /* Form Control Focus */
    .form-control:focus,
    .form-select:focus {
        border-color: #ec4899;
        box-shadow: 0 0 0 2px rgba(236, 72, 153, 0.1);
    }
    
    /* Scrollbar Stilleri */
    .reservation-history::-webkit-scrollbar {
        width: 6px;
    }
    
    .reservation-history::-webkit-scrollbar-track {
        background: #f1f5f9;
        border-radius: 3px;
    }
    
    .reservation-history::-webkit-scrollbar-thumb {
        background: #ec4899;
        border-radius: 3px;
    }
    
    .reservation-history::-webkit-scrollbar-thumb:hover {
        background: #be185d;
    }
    
    /* Responsive Styles */
    @media (max-width: 768px) {
        .modal-dialog {
            margin: 10px;
            max-width: calc(100% - 20px);
        }
        
        .modal-content {
            border-radius: 12px;
        }
        
        .modal-body {
            padding: 1rem !important;
        }
        
        .row.g-3 {
            margin: 0 !important;
        }
        
        .row.g-3 > div {
            padding: 0 0.5rem !important;
            margin-bottom: 1rem;
        }
        
        .card {
            margin-bottom: 1rem;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1) !important;
            border: none !important;
        }
        
        /* Card Header Renklendirme - Mobile */
        .card-header {
            padding: 14px 16px !important;
            border-radius: 12px 12px 0 0 !important;
        }
        
        .card-header[style*="background: linear-gradient(135deg, #ec4899"] {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
            box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3) !important;
        }
        
        .card-header[style*="background: linear-gradient(135deg, #8b5cf6"] {
            background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%) !important;
            box-shadow: 0 2px 8px rgba(139, 92, 246, 0.3) !important;
        }
        
        /* Card Header içindeki text-white'ı koru */
        .card-header .text-white,
        .card-header h6.text-white,
        .card-header .text-white * {
            color: #ffffff !important;
        }
        
        .card-header h6 {
            font-size: 1rem !important;
            font-weight: 700 !important;
            color: #ffffff !important;
        }
        
        .card-body {
            padding: 1.25rem !important;
            background: #ffffff !important;
            color: #111827 !important;
        }
        
        /* Card-body içindeki text-white'ı siyaha çevir - ÇOK SPESİFİK */
        .card .card-body .text-white,
        .card .card-body .text-white *,
        .card-body .text-white,
        .card-body .text-white *,
        .card-body p.text-white,
        .card-body span.text-white,
        .card-body div.text-white,
        .card-body a.text-white {
            color: #111827 !important;
        }
        
        /* Card-body içindeki tüm text renklerini düzelt */
        .card-body p:not(.text-white):not(.text-success):not(.text-danger):not(.text-primary):not(.text-info):not(.text-warning),
        .card-body small:not(.text-white):not(.text-success):not(.text-danger):not(.text-primary):not(.text-info):not(.text-warning),
        .card-body span:not(.text-white):not(.text-success):not(.text-danger):not(.text-primary):not(.text-info):not(.text-warning):not(.badge),
        .card-body div:not(.text-white):not(.text-success):not(.text-danger):not(.text-primary):not(.text-info):not(.text-warning) {
            color: #111827 !important;
        }
        
        .card-body .text-muted {
            color: #6b7280 !important;
        }
        
        /* Card-body içindeki link renklerini koru */
        .card-body a[style*="color: #ec4899"] {
            color: #ec4899 !important;
        }
        
        .card-body .text-success {
            color: #10b981 !important;
        }
        
        /* İkon renklerini düzelt */
        .card-body i {
            color: inherit !important;
        }
        
        /* Badge Renklendirme - Mobile */
        .badge.bg-warning {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%) !important;
            color: white !important;
            padding: 6px 12px !important;
            font-weight: 600 !important;
            box-shadow: 0 2px 4px rgba(245, 158, 11, 0.3) !important;
        }
        
        .badge.bg-success {
            background: linear-gradient(135deg, #10b981 0%, #047857 100%) !important;
            color: white !important;
            padding: 6px 12px !important;
            font-weight: 600 !important;
            box-shadow: 0 2px 4px rgba(16, 185, 129, 0.3) !important;
        }
        
        .badge.bg-danger {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%) !important;
            color: white !important;
            padding: 6px 12px !important;
            font-weight: 600 !important;
            box-shadow: 0 2px 4px rgba(239, 68, 68, 0.3) !important;
        }
        
        .badge.bg-primary {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%) !important;
            color: white !important;
            padding: 6px 12px !important;
            font-weight: 600 !important;
            box-shadow: 0 2px 4px rgba(59, 130, 246, 0.3) !important;
        }
        
        .badge.bg-info {
            background: linear-gradient(135deg, #06b6d4 0%, #0891b2 100%) !important;
            color: white !important;
            padding: 6px 12px !important;
            font-weight: 600 !important;
            box-shadow: 0 2px 4px rgba(6, 182, 212, 0.3) !important;
        }
        
        /* Butonlar - Mobile */
        .btn {
            width: 100%;
            margin-bottom: 0.75rem;
            padding: 12px 20px !important;
            font-weight: 600 !important;
            border-radius: 10px !important;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1) !important;
            transition: all 0.2s !important;
        }
        
        .btn:active {
            transform: scale(0.98);
            box-shadow: 0 2px 4px rgba(0,0,0,0.15) !important;
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%) !important;
            border: none !important;
            box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3) !important;
        }
        
        .btn-light {
            background: #f9fafb !important;
            border: 1px solid #e5e7eb !important;
            color: #6b7280 !important;
        }
        
        /* Form Elements - Mobile */
        .form-control,
        .form-select {
            border-radius: 10px !important;
            border: 2px solid #e5e7eb !important;
            padding: 12px 16px !important;
            font-size: 16px !important;
            transition: all 0.2s !important;
        }
        
        .form-control:focus,
        .form-select:focus {
            border-color: #ec4899 !important;
            box-shadow: 0 0 0 4px rgba(236, 72, 153, 0.1) !important;
        }
        
        .form-label {
            font-weight: 600 !important;
            color: #111827 !important;
            margin-bottom: 8px !important;
        }
        
        /* Text Renklendirme - Mobile */
        a[style*="color: #ec4899"] {
            color: #ec4899 !important;
            font-weight: 600 !important;
        }
        
        .text-success {
            color: #10b981 !important;
            font-weight: 600 !important;
        }
        
        /* Reservation Item - Mobile */
        .reservation-item {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%) !important;
            border-left: 4px solid #ec4899 !important;
            border-radius: 10px !important;
            padding: 14px !important;
            margin-bottom: 12px !important;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08) !important;
        }
        
        /* Customer Avatar - Mobile */
        .customer-avatar {
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.25) !important;
        }
        
        .btn-group {
            flex-direction: column;
            width: 100%;
        }
        
        .btn-group .btn {
            width: 100%;
            border-radius: 10px !important;
        }
    }
    
    @media (max-width: 480px) {
        .modal-body {
            padding: 1rem !important;
        }
        
        .card-header {
            padding: 12px 14px !important;
            font-size: 0.95rem !important;
        }
        
        .card-body {
            padding: 1rem !important;
        }
        
        .form-control,
        .form-select {
            font-size: 16px !important;
            padding: 14px 16px !important;
        }
        
        .btn {
            padding: 14px 20px !important;
            font-size: 15px !important;
        }
    }
</style>
@endpush


@push('scripts')
<script>
// Fiyat düzenleme - Hizmet seçildiğinde otomatik fiyatı yaz
(function() {
    'use strict';
    
    // Sayfa yüklendiğinde veya modal açıldığında
    function initPriceField() {
        const priceInput = document.getElementById('total_price');
        if (!priceInput) return;
        
        // Hizmet fiyatını göster (sadece bilgi amaçlı)
        const servicePrice = parseFloat(priceInput.getAttribute('data-service-price')) || parseFloat(priceInput.value) || 0;
        
        // Fiyat değiştiğinde renklendirme
        priceInput.addEventListener('input', function() {
            const currentPrice = parseFloat(this.value) || 0;
            if (currentPrice > servicePrice) {
                this.style.borderColor = '#10b981';
                this.style.boxShadow = '0 0 0 2px rgba(16, 185, 129, 0.1)';
            } else if (currentPrice < servicePrice) {
                this.style.borderColor = '#f59e0b';
                this.style.boxShadow = '0 0 0 2px rgba(245, 158, 11, 0.1)';
            } else {
                this.style.borderColor = '#e5e7eb';
                this.style.boxShadow = 'none';
            }
        });
    }
    
    // İlk kurulum
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(initPriceField, 100);
        });
    } else {
        setTimeout(initPriceField, 100);
    }
    
    // Modal açıldığında
    const modal = document.getElementById('requestDetailModal');
    if (modal) {
        modal.addEventListener('shown.bs.modal', function() {
            setTimeout(initPriceField, 300);
        });
    }
    
    // Form submit kontrolü
    const approveForm = document.getElementById('approveRequestForm');
    if (approveForm) {
        approveForm.addEventListener('submit', function(e) {
            const priceInput = document.getElementById('total_price');
            if (!priceInput || !priceInput.value || parseFloat(priceInput.value) <= 0) {
                e.preventDefault();
                alert('Lütfen geçerli bir fiyat giriniz.');
                return false;
            }
        });
    }
})();
</script>
@endpush

@if(!request()->ajax())
@endsection
@endif

@push('scripts')

<script>
// Global müşteri portföyü fonksiyonu
if (typeof showCustomerPortfolio === 'undefined') {
    window.showCustomerPortfolio = function(customerId) {
        // Modal oluştur veya bul
        let portfolioModal = document.getElementById('customerPortfolioModal');
        if (!portfolioModal) {
            // Modal yoksa oluştur
            const modalHTML = `
                <div class="modal fade" id="customerPortfolioModal" tabindex="-1" aria-labelledby="customerPortfolioModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content" style="border-radius: 16px; border: none;">
                            <div class="modal-header" style="background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); border-radius: 16px 16px 0 0;">
                                <h5 class="modal-title text-white fw-bold" id="customerPortfolioModalLabel">
                                    <i class="bi bi-person-circle me-2"></i>Müşteri Portföyü
                                </h5>
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body" style="padding: 1.5rem; max-height: 80vh; overflow-y: auto;" id="customerPortfolioContent">
                                <div class="text-center py-5">
                                    <div class="spinner-border text-primary" role="status"></div>
                                    <p class="mt-3">Yükleniyor...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
            document.body.insertAdjacentHTML('beforeend', modalHTML);
            portfolioModal = document.getElementById('customerPortfolioModal');
        }
        
        const content = document.getElementById('customerPortfolioContent');
        if (content) {
            content.innerHTML = '<div class="text-center py-5"><div class="spinner-border text-primary" role="status"></div><p class="mt-3">Yükleniyor...</p></div>';
        }
        
        // Modal'ı aç
        const modal = new bootstrap.Modal(portfolioModal);
        modal.show();
        
        // Detayları yükle
        const portfolioUrlBase = '{{ route("admin.beauty-salon.appointment-requests.customer-portfolio", ["customerId" => ":customerId"]) }}';
        const portfolioUrl = portfolioUrlBase.replace(':customerId', customerId);
        
        fetch(portfolioUrl, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(async response => {
            if (!response.ok) {
                const errorText = await response.text();
                console.error('HTTP Error:', response.status, errorText);
                throw new Error('HTTP ' + response.status);
            }
            const contentType = response.headers.get('content-type');
            if (contentType && contentType.includes('application/json')) {
                return response.json();
            } else {
                const text = await response.text();
                throw new Error('Beklenmeyen response formatı');
            }
        })
            .then(data => {
                // Müşteri bilgileri
                let customerInfo = `
                    <div class="card shadow-sm mb-4" style="border-radius: 12px; border: none;">
                        <div class="card-header" style="background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); border-radius: 12px 12px 0 0; padding: 16px;">
                            <div class="d-flex align-items-center">
                                <div class="customer-avatar me-3" style="width: 50px; height: 50px; border-radius: 50%; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 20px;">
                                    ${data.customer.name ? data.customer.name.charAt(0).toUpperCase() : 'M'}
                                </div>
                                <div>
                                    <h5 class="mb-0 text-white fw-bold">${data.customer.name} ${data.customer.surname || ''}</h5>
                                    <small class="text-white opacity-75">
                                        ${data.customer.phone ? '<i class="bi bi-telephone me-1"></i>' + data.customer.phone : ''}
                                        ${data.customer.age ? '<span class="ms-2"><i class="bi bi-calendar3 me-1"></i>' + data.customer.age + ' yaş</span>' : ''}
                                    </small>
                                </div>
                            </div>
                        </div>
                        <div class="card-body p-3">
                            <div class="row text-center">
                                <div class="col-4">
                                    <div class="mb-2">
                                        <small class="text-muted d-block" style="font-size: 0.75rem;">Toplam Randevu</small>
                                        <strong style="font-size: 1.2rem; color: #8b5cf6;">${data.statistics.total}</strong>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="mb-2">
                                        <small class="text-muted d-block" style="font-size: 0.75rem;">Tamamlanan</small>
                                        <strong style="font-size: 1.2rem; color: #10b981;">${data.statistics.completed}</strong>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="mb-2">
                                        <small class="text-muted d-block" style="font-size: 0.75rem;">Toplam Harcama</small>
                                        <strong style="font-size: 1.2rem; color: #ec4899;">${parseFloat(data.statistics.total_spent).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2})} ₺</strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
                
                // Randevu listesi
                let reservationsList = '';
                if (data.reservations && data.reservations.length > 0) {
                    reservationsList = `
                        <div class="card shadow-sm" style="border-radius: 12px; border: none;">
                            <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">
                                <h6 class="mb-0 text-white fw-bold" style="font-size: 0.95rem;">
                                    <i class="bi bi-clock-history me-2"></i>Tüm Randevular (${data.reservations.length})
                                </h6>
                            </div>
                            <div class="card-body p-3">
                                <div style="max-height: 400px; overflow-y: auto;">
                                    ${data.reservations.map(reservation => {
                                        const date = new Date(reservation.date);
                                        const formattedDate = date.toLocaleDateString('tr-TR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                                        
                                        let statusBadge = '';
                                        if (reservation.status === 'completed') {
                                            statusBadge = '<span class="badge bg-success" style="font-size: 0.7rem;">Tamamlandı</span>';
                                        } else if (reservation.status === 'confirmed') {
                                            statusBadge = '<span class="badge bg-primary" style="font-size: 0.7rem;">Onaylandı</span>';
                                        } else if (reservation.status === 'cancelled') {
                                            statusBadge = '<span class="badge bg-danger" style="font-size: 0.7rem;">İptal Edildi</span>';
                                        } else if (reservation.status === 'pending' || reservation.status === 'open') {
                                            statusBadge = '<span class="badge bg-warning" style="font-size: 0.7rem;">Beklemede</span>';
                                        } else {
                                            statusBadge = '<span class="badge bg-secondary" style="font-size: 0.7rem;">' + reservation.status + '</span>';
                                        }
                                        
                                        return `
                                            <div class="reservation-item mb-3 p-3 rounded" style="background: #f8fafc; border-left: 4px solid #ec4899;">
                                                <div class="d-flex justify-content-between align-items-start mb-2">
                                                    <div style="flex: 1;">
                                                        <strong class="d-block" style="font-size: 0.9rem;">${formattedDate} ${reservation.start_time}</strong>
                                                        <small class="text-muted d-block mt-1" style="font-size: 0.8rem;">
                                                            ${reservation.personel_name ? '<i class="bi bi-person me-1"></i>' + reservation.personel_name : ''}
                                                            ${reservation.service_name ? '<span class="ms-2"><i class="bi bi-scissors me-1"></i>' + reservation.service_name + '</span>' : ''}
                                                            ${reservation.room_name ? '<span class="ms-2"><i class="bi bi-door-open me-1"></i>' + reservation.room_name + '</span>' : ''}
                                                        </small>
                                                    </div>
                                                    <div class="text-end">
                                                        ${statusBadge}
                                                        <div class="mt-2">
                                                            <strong class="text-success" style="font-size: 0.85rem;">${parseFloat(reservation.total_price || 0).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2})} ₺</strong>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        `;
                                    }).join('')}
                                </div>
                            </div>
                        </div>
                    `;
                } else {
                    reservationsList = `
                        <div class="card shadow-sm" style="border-radius: 12px; border: none;">
                            <div class="card-body text-center py-5">
                                <i class="bi bi-info-circle" style="font-size: 48px; color: #cbd5e1;"></i>
                                <p class="text-muted mt-3 mb-0">Henüz randevu geçmişi yok</p>
                            </div>
                        </div>
                    `;
                }
                
                const content = document.getElementById('customerPortfolioContent');
                if (content) {
                    content.innerHTML = customerInfo + reservationsList;
                }
            })
            .catch(error => {
                console.error('Hata:', error);
                const content = document.getElementById('customerPortfolioContent');
                if (content) {
                    content.innerHTML = `
                        <div class="alert alert-danger">
                            <i class="bi bi-exclamation-triangle me-2"></i>Müşteri portföyü yüklenirken bir hata oluştu: ${error.message}
                        </div>
                    `;
                }
            });
        } else {
            console.error('customerPortfolioModal bulunamadı');
        }
    };
}

// Reddet formu için confirm ekle
(function() {
    'use strict';
    
    const rejectForm = document.querySelector('#rejectRequestForm');
    if (rejectForm && typeof customConfirm !== 'undefined') {
        rejectForm.addEventListener('submit', function(e) {
            e.preventDefault();
            customConfirm('Bu randevu talebini reddetmek istediğinize emin misiniz?').then(confirmed => {
                if (confirmed) {
                    rejectForm.submit();
                }
            });
            return false;
        });
    }
})();
</script>
@endpush
