@extends('layouts.admin')

@section('title', 'Randevu Düzenle')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.appointments.index') }}">Randevu Yönetimi</a></li>
    <li class="breadcrumb-item active">Düzenle</li>
@endsection

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Randevu Düzenle</h2>
        <a href="{{ route('admin.appointments.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Geri
        </a>
    </div>
    
    <div class="card shadow-sm">
        <div class="card-header text-white" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 12px 12px 0 0;">
            <h5 class="mb-0 fw-bold"><i class="bi bi-pencil-square me-2"></i> Randevu Bilgileri</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.appointments.update', $reservation->id) }}">
                @csrf
                @method('PUT')
                
                <div class="row mb-3">
                    <div class="col-md-12">
                        <label class="form-label fw-bold">Müşteri *</label>
                        <select name="customer_id" class="form-select form-select-lg" required>
                            <option value="">Seçiniz</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ old('customer_id', $reservation->customer_id) == $customer->id ? 'selected' : '' }}>
                                    {{ $customer->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                @if(Auth::user()->role === 'güzellik_salonu')
                    {{-- Güzellik Salonu Formu --}}
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Hizmet</label>
                            <select name="service_id" class="form-select form-select-lg">
                                <option value="">Seçiniz</option>
                                @foreach($services ?? [] as $service)
                                    <option value="{{ $service->id }}" {{ old('service_id', $reservation->appointmentRequest && $reservation->appointmentRequest->service ? $reservation->appointmentRequest->service->id : '') == $service->id ? 'selected' : '' }}>
                                        {{ $service->name }} ({{ number_format($service->price, 2, ',', '.') }} ₺)
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Personel</label>
                            <select name="personel_id" class="form-select form-select-lg">
                                <option value="">Seçiniz</option>
                                @foreach($personels ?? [] as $personel)
                                    <option value="{{ $personel->id }}" {{ old('personel_id', $reservation->personel_id) == $personel->id ? 'selected' : '' }}>
                                        {{ $personel->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Oda</label>
                            <select name="room_id" class="form-select form-select-lg">
                                <option value="">Seçiniz</option>
                                @foreach($rooms ?? [] as $room)
                                    <option value="{{ $room->id }}" {{ old('room_id', $reservation->room_id) == $room->id ? 'selected' : '' }}>
                                        {{ $room->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Tarih *</label>
                            <input type="date" name="date" class="form-control form-control-lg" value="{{ old('date', $reservation->date ? (is_string($reservation->date) ? $reservation->date : $reservation->date->format('Y-m-d')) : '') }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Başlangıç Saati *</label>
                            <input type="time" name="start_time" class="form-control form-control-lg" value="{{ old('start_time', $reservation->start_time) }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Bitiş Saati</label>
                            <input type="time" name="end_time" class="form-control form-control-lg" value="{{ old('end_time', $reservation->end_time) }}">
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Toplam Fiyat</label>
                            <input type="number" step="0.01" name="total_price" class="form-control form-control-lg" value="{{ old('total_price', $reservation->total_price) }}">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Kapora</label>
                            <input type="number" step="0.01" name="deposit_paid" class="form-control form-control-lg" value="{{ old('deposit_paid', $reservation->deposit_paid ?? 0) }}">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Durum *</label>
                            <select name="status" class="form-select form-select-lg" required>
                                <option value="open" {{ old('status', $reservation->status) == 'open' ? 'selected' : '' }}>Açık</option>
                                <option value="confirmed" {{ old('status', $reservation->status) == 'confirmed' ? 'selected' : '' }}>Onaylandı</option>
                                <option value="cancelled" {{ old('status', $reservation->status) == 'cancelled' ? 'selected' : '' }}>İptal</option>
                                <option value="completed" {{ old('status', $reservation->status) == 'completed' ? 'selected' : '' }}>Tamamlandı</option>
                            </select>
                        </div>
                    </div>
                @else
                    {{-- Eski Sistem Formu (Randevucu/Admin) --}}
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Salon *</label>
                            <select name="salon_id" class="form-select form-select-lg" required>
                                <option value="">Seçiniz</option>
                                @foreach($salons ?? [] as $salon)
                                    <option value="{{ $salon->id }}" {{ old('salon_id', $reservation->salon_id) == $salon->id ? 'selected' : '' }}>
                                        {{ $salon->name }} (Kapasite: {{ $salon->capacity }})
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Misafir Sayısı *</label>
                            <input type="number" name="guest_count" class="form-control form-control-lg" value="{{ old('guest_count', $reservation->guest_count ?? 1) }}" min="1" required>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Tarih *</label>
                            <input type="date" name="date" class="form-control form-control-lg" value="{{ old('date', $reservation->date ? (is_string($reservation->date) ? $reservation->date : $reservation->date->format('Y-m-d')) : '') }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Başlangıç Saati *</label>
                            <input type="time" name="start_time" class="form-control form-control-lg" value="{{ old('start_time', $reservation->start_time) }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Bitiş Saati *</label>
                            <input type="time" name="end_time" class="form-control form-control-lg" value="{{ old('end_time', $reservation->end_time) }}" required>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Toplam Fiyat *</label>
                            <input type="number" step="0.01" name="total_price" class="form-control form-control-lg" value="{{ old('total_price', $reservation->total_price) }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Kapora</label>
                            <input type="number" step="0.01" name="deposit_paid" class="form-control form-control-lg" value="{{ old('deposit_paid', $reservation->deposit_paid ?? 0) }}">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label fw-bold">Durum *</label>
                            <select name="status" class="form-select form-select-lg" required>
                                <option value="open" {{ old('status', $reservation->status) == 'open' ? 'selected' : '' }}>Açık</option>
                                <option value="confirmed" {{ old('status', $reservation->status) == 'confirmed' ? 'selected' : '' }}>Onaylandı</option>
                                <option value="cancelled" {{ old('status', $reservation->status) == 'cancelled' ? 'selected' : '' }}>İptal</option>
                                <option value="completed" {{ old('status', $reservation->status) == 'completed' ? 'selected' : '' }}>Tamamlandı</option>
                            </select>
                        </div>
                    </div>
                @endif
                
                <div class="mb-3">
                    <label class="form-label fw-bold">Notlar</label>
                    <textarea name="notes" class="form-control" rows="4">{{ old('notes', $reservation->notes) }}</textarea>
                </div>
                
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.appointments.index') }}" class="btn btn-lg btn-secondary">
                        <i class="bi bi-x-circle"></i> İptal
                    </a>
                    <button type="submit" class="btn btn-lg btn-primary">
                        <i class="bi bi-check-circle"></i> Güncelle
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
