@extends('layouts.admin')

@section('title', 'Randevu Takvimi')

@section('content')
<style>
    body {
        padding-top: var(--header-height) !important;
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    }
    .main-content {
        padding: 0 !important;
        margin: 0 !important;
    }
    
    /* Mobil görünümde header padding düzeltmesi */
    @media (max-width: 1024px) {
        body {
            padding-top: 108px !important;
        }
        
        .main-content {
            padding-top: 20px !important;
        }
        
        /* Takvime üstte boşluk ekle */
        .desktop-calendar-wrapper {
            padding-top: 20px !important;
        }
        
        .mobile-calendar-wrapper {
            padding-top: 20px !important;
        }
    }
    
    .calendar-container {
        background: white;
        border-radius: 0;
        box-shadow: none;
        overflow: hidden;
        margin: 0;
        width: 100%;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
    }
    
    .calendar-header {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        padding: 18px 24px;
        color: white;
    }
    
    .calendar-header h2 {
        color: white;
        font-weight: 700;
        font-size: 28px;
        margin: 0 0 12px 0;
        text-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .calendar-controls {
        display: flex;
        gap: 10px;
        margin-top: 12px;
        flex-wrap: wrap;
    }
    
    .view-btn {
        padding: 10px 20px;
        border: 2px solid rgba(255,255,255,0.3);
        background: rgba(255,255,255,0.15);
        color: white;
        border-radius: 25px !important;
        font-weight: 600;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
    }
    
    .view-btn:hover {
        background: rgba(255,255,255,0.25);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .view-btn.active {
        background: white;
        color: #ec4899;
        border-color: white;
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .salon-filter-wrapper {
        position: relative;
        min-width: 280px;
    }
    
    .salon-filter-input {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid rgba(255,255,255,0.3);
        background: rgba(255,255,255,0.15);
        color: white;
        border-radius: 12px;
        font-size: 14px;
        backdrop-filter: blur(10px);
        transition: all 0.3s ease;
    }
    
    .salon-filter-input::placeholder {
        color: rgba(255,255,255,0.7);
    }
    
    .salon-filter-input:focus {
        outline: none;
        border-color: white;
        background: rgba(255,255,255,0.25);
        box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    }
    
    .new-reservation-btn {
        padding: 12px 24px;
        background: white;
        color: #ec4899;
        border: none;
        border-radius: 12px;
        font-weight: 700;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }
    
    .new-reservation-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0,0,0,0.25);
    }
    
    .events-sidebar {
        background: white;
        border-radius: 24px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
        overflow: hidden;
        height: fit-content;
    }
    
    .events-sidebar-header {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        padding: 20px 24px;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .events-sidebar-header h5 {
        color: #1e293b;
        font-weight: 700;
        font-size: 18px;
        margin: 0;
    }
    
    .event-category-card {
        background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
        border: 2px solid #e2e8f0;
        border-radius: 16px;
        padding: 20px;
        margin-bottom: 16px;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }
    
    .event-category-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        transform: scaleY(0);
        transition: transform 0.3s ease;
    }
    
    .event-category-card:hover {
        transform: translateX(8px);
        border-color: #ec4899;
        box-shadow: 0 8px 24px rgba(236, 72, 153, 0.15);
    }
    
    .event-category-card:hover::before {
        transform: scaleY(1);
    }
    
    .event-icon {
        width: 50px;
        height: 50px;
        border-radius: 14px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    }
    
    .upcoming-event-card {
        background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
        border: 2px solid #e2e8f0;
        border-radius: 16px;
        padding: 18px;
        margin-bottom: 12px;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
    }
    
    .upcoming-event-card:hover {
        transform: translateY(-4px);
        border-color: #ec4899;
        box-shadow: 0 8px 24px rgba(236, 72, 153, 0.2);
    }
    
    .event-status-badge {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        display: inline-block;
        margin-right: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }
    
    .fc {
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
    }
    
    .fc-toolbar {
        padding: 20px 32px !important;
        background: white;
        border-bottom: 2px solid #e2e8f0;
    }
    
    .fc-toolbar-title {
        font-size: 26px !important;
        font-weight: 700 !important;
        color: #1e293b !important;
        letter-spacing: -0.5px;
    }
    
    .fc-button {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
        border: none !important;
        color: white !important;
        padding: 10px 20px !important;
        font-size: 14px !important;
        border-radius: 12px !important;
        font-weight: 600 !important;
        transition: all 0.3s ease !important;
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.2) !important;
    }
    
    .fc-button:hover {
        background: linear-gradient(135deg, #be185d 0%, #1e3a8a 100%) !important;
        transform: translateY(-2px) !important;
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3) !important;
    }
    
    .fc-button:active {
        transform: translateY(0) !important;
    }
    
    .fc-button-group {
        gap: 8px !important;
    }
    
    .fc-col-header-cell {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%) !important;
        padding: 16px 8px !important;
        border-color: #e2e8f0 !important;
        font-weight: 700 !important;
        color: #475569 !important;
        font-size: 13px !important;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .fc-daygrid-day {
        background: white !important;
        border-color: #e2e8f0 !important;
        min-height: 140px !important;
        transition: all 0.2s ease;
        position: relative;
    }
    
    .fc-daygrid-day:hover {
        background: #f8fafc !important;
    }
    
    .fc-day-today {
        background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%) !important;
        position: relative;
    }
    
    .fc-day-today::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
    }
    
    .fc-daygrid-day-number {
        padding: 0 !important;
        font-weight: 600 !important;
        color: #1e293b !important;
        font-size: 14px !important;
        width: 32px !important;
        height: 32px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        border-radius: 50% !important;
        background: transparent !important;
        margin: 6px auto !important;
        text-decoration: none !important;
        border: none !important;
    }
    
    .fc-day-today .fc-daygrid-day-number {
        color: white !important;
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
        font-weight: 700 !important;
        box-shadow: 0 2px 8px rgba(236, 72, 153, 0.3) !important;
    }
    
    .fc-daygrid-day-number:hover {
        background: #f1f5f9 !important;
        color: #ec4899 !important;
    }
    
    .fc-day-today .fc-daygrid-day-number:hover {
        background: linear-gradient(135deg, #be185d 0%, #1e3a8a 100%) !important;
        color: white !important;
    }
    
    .fc-event {
        border: none !important;
        padding: 12px 16px !important;
        border-radius: 14px !important;
        cursor: pointer !important;
        font-size: 13px !important;
        margin: 6px 4px !important;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12) !important;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1) !important;
        font-weight: 600 !important;
        border-left: 5px solid rgba(255,255,255,0.8) !important;
        position: relative !important;
        overflow: hidden !important;
        backdrop-filter: blur(10px) !important;
    }
    
    .fc-event::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, rgba(255,255,255,0.05) 100%);
        opacity: 0;
        transition: opacity 0.3s ease;
    }
    
    .fc-event:hover {
        transform: translateY(-4px) scale(1.03) !important;
        box-shadow: 0 12px 28px rgba(0, 0, 0, 0.2) !important;
        z-index: 10 !important;
        border-left-width: 6px !important;
    }
    
    .fc-event:hover::before {
        opacity: 1;
    }
    
    /* Status'a göre event renkleri */
    .fc-event[data-status="confirmed"] {
        background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%) !important;
        color: white !important;
    }
    
    .fc-event[data-status="open"] {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%) !important;
        color: white !important;
    }
    
    .fc-event[data-status="completed"] {
        background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%) !important;
        color: white !important;
    }
    
    .fc-event[data-status="cancelled"] {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%) !important;
        color: white !important;
    }
    
    .fc-event-title {
        font-weight: 600 !important;
    }
    
    .fc-daygrid-event {
        white-space: nowrap !important;
        overflow: hidden !important;
        text-overflow: ellipsis !important;
    }
    
    .fc-scrollgrid {
        border: 2px solid #e2e8f0 !important;
        border-radius: 16px !important;
        overflow: hidden !important;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06) !important;
    }
    
    .fc-scrollgrid-section > * {
        border-radius: 0 !important;
    }
    
    .fc-scrollgrid-section:first-child > * > .fc-col-header-cell:first-child {
        border-top-left-radius: 14px !important;
    }
    
    .fc-scrollgrid-section:first-child > * > .fc-col-header-cell:last-child {
        border-top-right-radius: 14px !important;
    }
    
    .fc-view-harness {
        padding: 0 32px 32px 32px !important;
        flex: 1;
        overflow: auto;
    }
    
    #calendar {
        flex: 1;
        min-height: 0;
    }
    
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        color: #64748b;
    }
    
    .empty-state-icon {
        font-size: 64px;
        color: #cbd5e1;
        margin-bottom: 16px;
    }
    
    .calendar-footer {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border-top: 2px solid #e2e8f0;
        padding: 24px;
        margin-top: 0;
    }
    
    .info-box {
        background: white;
        border: none;
        border-radius: 24px;
        padding: 28px;
        margin-bottom: 24px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }
    
    .info-box::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #ec4899 0%, #be185d 100%);
        transform: scaleX(0);
        transition: transform 0.3s ease;
    }
    
    .info-box:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 30px rgba(236, 72, 153, 0.15);
    }
    
    .info-box:hover::before {
        transform: scaleX(1);
    }
    
    .info-box-title {
        font-size: 20px;
        font-weight: 700;
        color: #1e293b;
        margin-bottom: 24px;
        display: flex;
        align-items: center;
        gap: 12px;
        padding-bottom: 16px;
        border-bottom: 2px solid #f1f5f9;
    }
    
    .info-box-title i {
        font-size: 24px;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 12px;
        background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%);
    }
    
    .info-box-title i.text-warning {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    }
    
    .info-box-title i.text-primary {
        background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%);
    }
    
    /* Mobil takvim wrapper - varsayılan olarak gizli */
    .mobile-calendar-wrapper {
        display: none;
    }
    
    @media (max-width: 1024px) {
        /* Desktop takvimini mobil görünümde gizle */
        .desktop-calendar-wrapper {
            display: none !important;
        }
        
        /* Mobil takvimi göster */
        .mobile-calendar-wrapper {
            display: block !important;
            padding-top: 20px !important;
        }
        
        /* Desktop takvime üstte boşluk ekle */
        .desktop-calendar-wrapper {
            padding-top: 20px !important;
        }
        
        body {
            padding-top: 0 !important;
            margin-top: 0 !important;
            background: #f5f5f5 !important;
        }
        
        .main-content {
            padding: 0 !important;
            margin: 0 !important;
        }
    }
</style>

<!-- Mobil Takvim (sadece mobil görünümde görünür) -->
<div class="mobile-calendar-wrapper" style="padding-top: 20px;">
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css" rel="stylesheet">
    <style>
        .mobile-calendar-wrapper .calendar-page {
            padding: 20px;
            padding-bottom: 100px;
        }
        
        .mobile-calendar-wrapper .calendar-header {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            color: white;
            padding: 18px 24px;
            border-radius: 16px;
            margin-bottom: 20px;
        }
        
        .mobile-calendar-wrapper .calendar-header h1 {
            font-size: 24px;
            font-weight: 700;
            margin: 0 0 12px 0;
        }
        
        .mobile-calendar-wrapper .calendar-controls {
            display: flex;
            gap: 10px;
            margin-top: 12px;
            flex-wrap: wrap;
        }
        
        .mobile-calendar-wrapper .view-btn {
            padding: 10px 16px;
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 8px;
            font-size: 13px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .mobile-calendar-wrapper .view-btn:active {
            background: rgba(255, 255, 255, 0.3);
            transform: scale(0.95);
        }
        
        .mobile-calendar-wrapper .view-btn.active {
            background: white;
            color: #ec4899;
            border-color: white;
        }
        
        .mobile-calendar-wrapper .salon-filter {
            width: 100%;
            padding: 12px 16px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            background: rgba(255, 255, 255, 0.15);
            color: white;
            border-radius: 8px;
            font-size: 14px;
            margin-top: 12px;
            -webkit-appearance: none;
        }
        
        .mobile-calendar-wrapper .salon-filter option {
            color: #111827;
        }
        
        .mobile-calendar-wrapper .calendar-container {
            background: white;
            border-radius: 16px;
            padding: 18px 24px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            border: 1px solid #e5e7eb;
            margin-bottom: 20px;
        }
        
        .mobile-calendar-wrapper .stats-summary {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 12px;
            margin-bottom: 20px;
        }
        
        .mobile-calendar-wrapper .stat-mini {
            background: white;
            border-radius: 12px;
            padding: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            border: 1px solid #e5e7eb;
            text-align: center;
        }
        
        .mobile-calendar-wrapper .stat-mini-value {
            font-size: 20px;
            font-weight: 700;
            color: #111827;
            margin-bottom: 4px;
        }
        
        .mobile-calendar-wrapper .stat-mini-label {
            font-size: 11px;
            color: #6b7280;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .mobile-calendar-wrapper .list-view-container {
            display: none;
            background: white;
            border-radius: 16px;
            padding: 18px 24px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.08);
            border: 1px solid #e5e7eb;
            margin-bottom: 20px;
        }
        
        .mobile-calendar-wrapper .list-view-container.active {
            display: block;
        }
        
        .mobile-calendar-wrapper .new-reservation-btn {
            position: fixed;
            bottom: 80px;
            right: 16px;
            width: 56px;
            height: 56px;
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
            color: white;
            border: none;
            border-radius: 50%;
            font-size: 24px;
            box-shadow: 0 4px 12px rgba(236, 72, 153, 0.4);
            cursor: pointer;
            transition: all 0.2s;
            z-index: 999;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .mobile-calendar-wrapper .new-reservation-btn:active {
            transform: scale(0.9);
    }
</style>

    <div class="calendar-page" style="padding: 20px;">
        <div class="calendar-header">
            <h1>Randevu Takvimi</h1>
            <div class="calendar-controls">
                <button class="view-btn active" onclick="mobileChangeView('dayGridMonth', this)">Ay</button>
                <button class="view-btn" onclick="mobileChangeView('timeGridWeek', this)">Hafta</button>
                <button class="view-btn" onclick="mobileChangeView('timeGridDay', this)">Gün</button>
                <button class="view-btn" onclick="mobileToggleListView(this)">Liste</button>
            </div>
            <select id="mobileSalonFilter" class="salon-filter" onchange="mobileFilterBySalon()">
                <option value="">Tüm Salonlar</option>
                @foreach($salons ?? [] as $salon)
                    <option value="{{ $salon->id }}">{{ $salon->name }}</option>
                @endforeach
            </select>
            @if(isset($personels) && $personels->count() > 0)
            <select id="mobilePersonelFilter" class="salon-filter" onchange="mobileFilterByPersonel()" style="margin-top: 10px;">
                <option value="">Tüm Personeller</option>
                @foreach($personels as $personel)
                    <option value="{{ $personel->id }}">{{ $personel->name }}</option>
                @endforeach
            </select>
            @endif
        </div>
        
        <div class="stats-summary">
            <div class="stat-mini">
                <div class="stat-mini-value" id="mobileTodayCount">0</div>
                <div class="stat-mini-label">Bugün</div>
            </div>
            <div class="stat-mini">
                <div class="stat-mini-value" id="mobileWeekCount">0</div>
                <div class="stat-mini-label">Bu Hafta</div>
            </div>
        </div>
        
        <div class="list-view-container" id="mobileListViewContainer">
            <div id="mobileListViewContent"></div>
        </div>
        
        <div class="calendar-container" id="mobileCalendarContainer">
            <div id="mobileCalendar"></div>
        </div>
        
        <a href="javascript:void(0)" onclick="mobileOpenNewReservation()" class="new-reservation-btn">
            <i class="bi bi-plus"></i>
        </a>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/locales/tr.js"></script>
    <script>
        let mobileCalendar;
        let mobileCurrentView = 'dayGridMonth';
        let mobileSelectedSalonId = '';
        let mobileIsListView = false;
        let mobileAllEvents = [];
        
        document.addEventListener('DOMContentLoaded', function() {
            const calendarEl = document.getElementById('mobileCalendar');
            if (!calendarEl) return;
            
            mobileCalendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                locale: 'tr',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: ''
                },
                height: 'auto',
                events: function(fetchInfo, successCallback, failureCallback) {
                    const start = fetchInfo.startStr;
                    const end = fetchInfo.endStr;
                    const salonId = mobileSelectedSalonId || '';
                    const feedRoute = '{{ route('admin.reservations.calendar.feed') }}';
                    
                    fetch(`${feedRoute}?start=${start}&end=${end}&salon_id=${salonId}`, {
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                        },
                        credentials: 'same-origin'
                    })
                    .then(response => response.json())
                    .then(data => {
                        mobileAllEvents = data;
                        successCallback(data);
                        mobileUpdateStats(data);
                        if (mobileIsListView) {
                            mobileRenderListView();
                        }
                    })
                    .catch(error => {
                        console.error('Calendar feed error:', error);
                        failureCallback(error);
                    });
                },
                eventDidMount: function(info) {
                    // Event'e status attribute'u ekle
                    const status = info.event.extendedProps?.status || 'open';
                    info.el.setAttribute('data-status', status);
                    
                    // Event'e tooltip ekle
                    const props = info.event.extendedProps || {};
                    const personel = props.personel || 'Personel Yok';
                    const service = props.service || 'Hizmet';
                    const customer = props.customer || 'Müşteri';
                    const time = props.start_time ? props.start_time.substring(0, 5) : '';
                    const price = props.total_price ? parseFloat(props.total_price).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2}) + ' ₺' : '';
                    
                    info.el.setAttribute('title', `${personel} - ${service}\n${customer}\n${time} - ${price}`);
                    info.el.setAttribute('data-bs-toggle', 'tooltip');
                    info.el.setAttribute('data-bs-placement', 'top');
                },
                eventClick: function(info) {
                    info.jsEvent.preventDefault();
                    // Randevu ID'sini al
                    const reservationId = info.event.extendedProps?.reservation_id || info.event.id;
                    
                    if (reservationId) {
                        // Popup aç
                        if (typeof window.showReservationDetail === 'function') {
                            window.showReservationDetail(reservationId);
                        } else if (typeof showReservationDetail === 'function') {
                            showReservationDetail(reservationId);
                        } else {
                            console.warn('showReservationDetail fonksiyonu bulunamadı, sayfaya yönlendiriliyor');
                            // Fallback: direkt sayfaya git
                            if (info.event.url) {
                                window.location.href = info.event.url;
                            }
                        }
                    } else if (info.event.url) {
                        window.location.href = info.event.url;
                    }
                },
                dateClick: function(info) {
                    
                },
                dayMaxEvents: 3,
                moreLinkClick: 'popover',
                eventDisplay: 'block',
                eventTimeFormat: {
                    hour: '2-digit',
                    minute: '2-digit',
                    hour12: false
                }
            });
            
            mobileCalendar.render();
        });
        
        function mobileChangeView(view, buttonElement) {
            if (mobileIsListView) {
                mobileIsListView = false;
                document.getElementById('mobileListViewContainer').classList.remove('active');
                document.getElementById('mobileCalendarContainer').style.display = 'block';
            }
            
            mobileCurrentView = view;
            mobileCalendar.changeView(view);
            
            document.querySelectorAll('.mobile-calendar-wrapper .view-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            if (buttonElement) {
                buttonElement.classList.add('active');
            }
        }
        
        function mobileFilterBySalon() {
            mobileSelectedSalonId = document.getElementById('mobileSalonFilter').value;
            mobileCalendar.refetchEvents();
        }
        
        function mobileUpdateStats(events) {
            const today = new Date().toISOString().split('T')[0];
            const todayEvents = events.filter(e => e.start.startsWith(today));
            
            const weekStart = new Date();
            weekStart.setDate(weekStart.getDate() - weekStart.getDay());
            const weekEnd = new Date(weekStart);
            weekEnd.setDate(weekStart.getDate() + 6);
            
            const weekEvents = events.filter(e => {
                const eventDate = new Date(e.start);
                return eventDate >= weekStart && eventDate <= weekEnd;
            });
            
            document.getElementById('mobileTodayCount').textContent = todayEvents.length;
            document.getElementById('mobileWeekCount').textContent = weekEvents.length;
        }
        
        function mobileToggleListView(buttonElement) {
            mobileIsListView = !mobileIsListView;
            
            if (mobileIsListView) {
                document.getElementById('mobileListViewContainer').classList.add('active');
                document.getElementById('mobileCalendarContainer').style.display = 'none';
                buttonElement.classList.add('active');
                mobileRenderListView();
            } else {
                document.getElementById('mobileListViewContainer').classList.remove('active');
                document.getElementById('mobileCalendarContainer').style.display = 'block';
                buttonElement.classList.remove('active');
            }
        }
        
        function mobileRenderListView() {
            const listViewContent = document.getElementById('mobileListViewContent');
            
            if (!mobileAllEvents || mobileAllEvents.length === 0) {
                listViewContent.innerHTML = '<div style="text-align: center; padding: 40px; color: #9ca3af;"><i class="bi bi-calendar-x" style="font-size: 48px; opacity: 0.5; margin-bottom: 16px;"></i><div style="font-size: 16px; font-weight: 600;">Henüz randevu yok</div></div>';
                return;
            }
            
            const sortedEvents = [...mobileAllEvents].sort((a, b) => {
                return new Date(a.start) - new Date(b.start);
            });
            
            let html = '';
            sortedEvents.forEach(event => {
                const startDate = new Date(event.start);
                const dateStr = startDate.toLocaleDateString('tr-TR', { 
                    day: 'numeric', 
                    month: 'long', 
                    year: 'numeric',
                    weekday: 'long'
                });
                
                let timeStr = '';
                if (event.extendedProps?.time) {
                    timeStr = event.extendedProps.time;
                } else if (event.start) {
                    const time = new Date(event.start);
                    timeStr = time.toLocaleTimeString('tr-TR', { 
                        hour: '2-digit', 
                        minute: '2-digit',
                        hour12: false
                    });
                }
                
                html += `
                    <div class="list-view-item" ${event.extendedProps?.reservation_id ? `onclick="if(typeof showReservationDetail === 'function') { showReservationDetail(${event.extendedProps.reservation_id}); } else { window.location.href='${event.url || '#'}'; }" style="cursor: pointer;"` : event.url ? `onclick="window.location.href='${event.url}'" style="cursor: pointer;"` : ''}>
                        <div class="list-view-item-header">
                            <div>
                                <div class="list-view-item-title">${event.title || 'Randevu'}</div>
                                <div class="list-view-item-date">
                                    <i class="bi bi-calendar3"></i> ${dateStr}
                                </div>
                            </div>
                            ${timeStr ? `
                            <div class="list-view-item-time">
                                <i class="bi bi-clock"></i> ${timeStr}
                            </div>
                            ` : ''}
                        </div>
                        ${event.extendedProps?.customer ? `
                            <div class="list-view-item-details">
                                <span><i class="bi bi-person"></i> ${event.extendedProps.customer}</span>
                            </div>
                        ` : ''}
                        ${event.extendedProps?.salon ? `
                            <div class="list-view-item-details">
                                <span><i class="bi bi-building"></i> ${event.extendedProps.salon}</span>
                            </div>
                        ` : ''}
                    </div>
                `;
            });
            
            listViewContent.innerHTML = html;
        }
        
        function mobileOpenNewReservation() {
            // Mobil için sayfa yönlendirmesi
                window.location.href = '{{ route("mobile.appointments.create") }}';
        }
    </script>
</div>

<!-- Desktop Takvim (sadece desktop görünümde görünür) -->
<div class="container-fluid px-0 desktop-calendar-wrapper" style="padding-top: 20px;">
    <div class="row g-0 mx-0">
        <!-- Tam Sayfa Takvim -->
        <div class="col-12 px-0">
            <div class="calendar-container">
                <div class="calendar-header">
                    <h2 class="mb-3"><i class="bi bi-calendar-heart me-2"></i> Randevu Takvimi</h2>
                    <div class="calendar-controls">
                        @if(isset($personels) && $personels->count() > 0)
                        <div class="salon-filter-wrapper">
                            <input type="text" id="personelFilterInput" class="salon-filter-input" placeholder="🔍 Personel ara..." autocomplete="off">
                            <select id="personelFilterHidden" class="form-select" style="display: none;">
                                <option value="">Tüm Personeller</option>
                                @foreach($personels as $personel)
                                    <option value="{{ $personel->id }}" data-name="{{ strtolower($personel->name) }}">{{ $personel->name }}</option>
                                @endforeach
                            </select>
                            <div id="personelFilterDropdown" class="position-absolute w-100" style="display: none; top: 100%; left: 0; z-index: 1000; background: white; border: 2px solid #ec4899; border-radius: 12px; box-shadow: 0 8px 25px rgba(0,0,0,0.15); max-height: 300px; overflow-y: auto; margin-top: 8px;">
                            </div>
                        </div>
                        @endif
                        @if(isset($personels) && $personels->count() > 0)
                        <div class="salon-filter-wrapper">
                            <select id="personelFilter" class="salon-filter-input" style="appearance: auto; padding-right: 40px;">
                                <option value="">👤 Tüm Personeller</option>
                                @foreach($personels as $personel)
                                    <option value="{{ $personel->id }}">{{ $personel->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        @endif
                        <!-- Yeni Randevu butonu kaldırıldı -->
                        <div class="d-flex gap-2">
                            <button type="button" class="view-btn active" id="viewMonth" onclick="changeCalendarView('dayGridMonth')">
                                <i class="bi bi-calendar-month me-1"></i> Ay
                            </button>
                            <button type="button" class="view-btn" id="viewWeek" onclick="changeCalendarView('timeGridWeek')">
                                <i class="bi bi-calendar-week me-1"></i> Hafta
                            </button>
                            <button type="button" class="view-btn" id="viewDay" onclick="changeCalendarView('timeGridDay')">
                                <i class="bi bi-calendar-day me-1"></i> Gün
                            </button>
                            <button type="button" class="view-btn" id="viewList" onclick="changeCalendarView('listWeek')">
                                <i class="bi bi-list-ul me-1"></i> Liste
                            </button>
                        </div>
                    </div>
                </div>
                <div id="calendar"></div>
                
                <!-- Alt Kısım - Güzel Kutular İçinde -->
                <div class="calendar-footer">
                    <div class="container-fluid px-0">
                        <div class="row g-3">
                            <!-- Bugünkü Randevular Kutusu -->
                            <div class="col-12">
                                <div class="card shadow-sm border-0" style="background: #ffffff; border-left: 4px solid #ec4899 !important;">
                                    <div class="card-header bg-transparent border-bottom border-light py-3">
                                        <div class="d-flex align-items-center gap-2">
                                            <i class="bi bi-calendar-day text-primary" style="font-size: 20px;"></i>
                                            <h5 class="mb-0 fw-bold text-dark">Bugünkü Randevular</h5>
                                        </div>
                                    </div>
                                    <div class="card-body p-4">
                                        <div id="todayAppointments" class="row g-3">
                                            <div class="col-12 text-center text-muted py-4">
                                                <i class="bi bi-hourglass-split" style="font-size: 32px; opacity: 0.5;"></i>
                                                <p class="mt-2 mb-0">Yükleniyor...</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- İstatistikler Kutusu -->
                            <div class="col-lg-8">
                                <div class="info-box" style="background: linear-gradient(135deg, #ffffff 0%, #fce7f3 100%); border-left: 5px solid #ec4899;">
                                    <div class="info-box-title">
                                        <i class="bi bi-bar-chart-fill text-primary"></i>
                                        <span>Bu Ay İstatistikleri</span>
                                    </div>
                                    <div class="row g-3">
                                        <div class="col-md-4 col-sm-6">
                                            <div class="stat-card" style="background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%); border-radius: 20px; padding: 24px; text-align: center; border: none; box-shadow: 0 4px 12px rgba(236, 72, 153, 0.15);">
                                                <div class="stat-icon mb-3" style="font-size: 36px; color: #ec4899;">
                                                    <i class="bi bi-calendar-check"></i>
                                                </div>
                                                <div class="stat-value fw-bold" style="font-size: 28px; color: #1e293b; margin-bottom: 8px;" id="statTotalAppointments">0</div>
                                                <div class="stat-label text-muted" style="font-size: 13px; font-weight: 500;">Toplam Randevu</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6">
                                            <div class="stat-card" style="background: linear-gradient(135deg, #dcfce7 0%, #bbf7d0 100%); border-radius: 20px; padding: 24px; text-align: center; border: none; box-shadow: 0 4px 12px rgba(22, 163, 74, 0.15);">
                                                <div class="stat-icon mb-3" style="font-size: 36px; color: #16a34a;">
                                                    <i class="bi bi-check-circle"></i>
                                                </div>
                                                <div class="stat-value fw-bold" style="font-size: 28px; color: #1e293b; margin-bottom: 8px;" id="statConfirmed">0</div>
                                                <div class="stat-label text-muted" style="font-size: 13px; font-weight: 500;">Onaylanan</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 col-sm-6">
                                            <div class="stat-card" style="background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%); border-radius: 20px; padding: 24px; text-align: center; border: none; box-shadow: 0 4px 12px rgba(220, 38, 38, 0.15);">
                                                <div class="stat-icon mb-3" style="font-size: 36px; color: #dc2626;">
                                                    <i class="bi bi-x-circle"></i>
                                                </div>
                                                <div class="stat-value fw-bold" style="font-size: 28px; color: #1e293b; margin-bottom: 8px;" id="statCancelled">0</div>
                                                <div class="stat-label text-muted" style="font-size: 13px; font-weight: 500;">İptal</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Hızlı Erişim Kutusu -->
                            <div class="col-lg-4">
                                <div class="info-box">
                                    <div class="info-box-title">
                                        <i class="bi bi-lightning-fill text-warning"></i>
                                        <span>Hızlı Erişim</span>
                                    </div>
                                    <div class="d-flex flex-column gap-2">
                                        <a href="{{ route('admin.appointments.index') }}" class="quick-action-btn" style="display: flex; align-items: center; gap: 12px; padding: 14px 18px; background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); border: 2px solid #e2e8f0; border-radius: 12px; text-decoration: none; color: #1e293b; font-weight: 600; transition: all 0.3s ease;">
                                            <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 18px;">
                                                <i class="bi bi-list-ul"></i>
                                            </div>
                                            <span>Randevu Listesi</span>
                                            <i class="bi bi-arrow-right ms-auto"></i>
                                        </a>
                                        <!-- Yeni Randevu butonu kaldırıldı -->
                                        <a href="{{ route('admin.customers.index') }}" class="quick-action-btn" style="display: flex; align-items: center; gap: 12px; padding: 14px 18px; background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); border: 2px solid #e2e8f0; border-radius: 12px; text-decoration: none; color: #1e293b; font-weight: 600; transition: all 0.3s ease;">
                                            <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 18px;">
                                                <i class="bi bi-people"></i>
                                            </div>
                                            <span>Müşteriler</span>
                                            <i class="bi bi-arrow-right ms-auto"></i>
                                        </a>
                                        <a href="{{ route('admin.settings.salons.index') }}" class="quick-action-btn" style="display: flex; align-items: center; gap: 12px; padding: 14px 18px; background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%); border: 2px solid #e2e8f0; border-radius: 12px; text-decoration: none; color: #1e293b; font-weight: 600; transition: all 0.3s ease;">
                                            <div style="width: 40px; height: 40px; border-radius: 10px; background: linear-gradient(135deg, #d97706 0%, #b45309 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 18px;">
                                                <i class="bi bi-building"></i>
                                            </div>
                                            <span>Salonlar</span>
                                            <i class="bi bi-arrow-right ms-auto"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Yeni randevu modal'ı kaldırıldı - artık sayfa yönlendirmesi kullanılıyor --}}

<style>
    .quick-action-btn:hover {
        transform: translateX(6px) translateY(-2px);
        border-color: #ec4899 !important;
        box-shadow: 0 8px 24px rgba(236, 72, 153, 0.2) !important;
        background: linear-gradient(135deg, #fce7f3 0%, #fbcfe8 100%) !important;
    }
    
    .stat-card {
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        cursor: pointer;
    }
    
    .stat-card:hover {
        transform: translateY(-6px) scale(1.02);
        box-shadow: 0 12px 32px rgba(0, 0, 0, 0.15) !important;
    }
    
    .today-reservation-card {
        border-radius: 12px !important;
        transition: none !important;
        animation: none !important;
    }
    
    .today-reservation-card:hover {
        border-radius: 12px !important;
        transform: none !important;
    }
    
    @media (max-width: 768px) {
        .calendar-footer {
            padding: 16px 20px !important;
        }
    }
</style>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css" rel="stylesheet">
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/locales/tr.js"></script>
<script>
let calendar;
let currentView = 'dayGridMonth';

document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('calendar');
    if (!calendarEl) return;
    
    calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        locale: 'tr',
        firstDay: 1,
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: ''
        },
        height: 'auto',
        contentHeight: 'auto',
        aspectRatio: 1.8,
        themeSystem: 'standard',
        events: function(info, successCallback, failureCallback) {
            const start = info.startStr;
            const end = info.endStr;
            let url = `{{ route('admin.reservations.calendar.feed') }}?start=${start}&end=${end}`;
            
            const personelFilter = document.getElementById('personelFilter');
            if (personelFilter && personelFilter.value) {
                url += `&personel_id=${personelFilter.value}`;
            }
            
            const personelFilterHidden = document.getElementById('personelFilterHidden');
            if (personelFilterHidden && personelFilterHidden.value) {
                url += `&personel_id=${personelFilterHidden.value}`;
            }
            
            fetch(url)
                .then(response => response.json())
                .then(data => {
                    successCallback(data);
                    loadUpcomingEvents(data);
                    updateStatistics(data);
                    loadTodayAppointments(data);
                })
                .catch(error => {
                    console.error('Takvim yükleme hatası:', error);
                    failureCallback(error);
                });
        },
        eventDidMount: function(info) {
            // Event'e status attribute'u ekle
            const status = info.event.extendedProps?.status || 'open';
            info.el.setAttribute('data-status', status);
            
            // Event'e tooltip ekle
            const props = info.event.extendedProps || {};
            const personel = props.personel || 'Personel Yok';
            const service = props.service || 'Hizmet';
            const customer = props.customer || 'Müşteri';
            const time = props.start_time ? props.start_time.substring(0, 5) : '';
            const price = props.total_price ? parseFloat(props.total_price).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2}) + ' ₺' : '';
            
            info.el.setAttribute('title', `${personel} - ${service}\n${customer}\n${time} - ${price}`);
            info.el.setAttribute('data-bs-toggle', 'tooltip');
            info.el.setAttribute('data-bs-placement', 'top');
        },
        eventClick: function(info) {
            info.jsEvent.preventDefault();
            // Randevu ID'sini al
            const reservationId = info.event.extendedProps?.reservation_id || info.event.id;
            
            if (reservationId) {
                // Popup aç
                if (typeof window.showReservationDetail === 'function') {
                    window.showReservationDetail(reservationId);
                } else if (typeof showReservationDetail === 'function') {
                    showReservationDetail(reservationId);
                } else {
                    console.warn('showReservationDetail fonksiyonu bulunamadı, sayfaya yönlendiriliyor');
                    // Fallback: direkt sayfaya git
                    if (info.event.url) {
                        window.location.href = info.event.url;
                    }
                }
            } else if (info.event.url) {
                window.location.href = info.event.url;
            }
        },
        dateClick: function(info) {
            // FullCalendar'dan gelen tarih zaten YYYY-MM-DD formatında
            const selectedDate = info.dateStr;
            
            // Mobile için sayfa aç, desktop için modal
            const userAgent = navigator.userAgent || navigator.vendor || window.opera;
            if (userAgent === 'SalonayMobileApp' || userAgent === 'SalonayAndroidApp/1.0' || /android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i.test(userAgent.toLowerCase())) {
                window.location.href = '{{ route("mobile.appointments.create") }}?date=' + selectedDate;
            } else {
                
            }
        },
        eventDisplay: 'block',
        eventTimeFormat: {
            hour: '2-digit',
            minute: '2-digit',
            hour12: false
        },
        dayMaxEvents: 3,
        moreLinkClick: 'popover'
    });
    
    calendar.render();
    
    // Personel filtresi autocomplete
    const personelFilterInput = document.getElementById('personelFilterInput');
    const personelFilterDropdown = document.getElementById('personelFilterDropdown');
    const personelFilterHidden = document.getElementById('personelFilterHidden');
    let allPersonels = [];
    
    if (personelFilterHidden) {
        Array.from(personelFilterHidden.options).forEach(option => {
            if (option.value) {
                allPersonels.push({
                    id: option.value,
                    name: option.textContent.trim(),
                    searchName: option.dataset.name || option.textContent.trim().toLowerCase()
                });
            }
        });
    }
    
    function showAllPersonelsOption() {
        if (!personelFilterDropdown) return;
        personelFilterDropdown.innerHTML = '';
        const allOption = document.createElement('div');
        allOption.style.cssText = 'padding: 12px 16px; cursor: pointer; border-bottom: 1px solid #e2e8f0; transition: background-color 0.2s; border-radius: 12px 12px 0 0;';
        allOption.innerHTML = '<strong style="color: #ec4899; font-size: 14px;">✨ Tüm Personeller</strong>';
        allOption.addEventListener('click', function() {
            if (personelFilterHidden) personelFilterHidden.value = '';
            const personelFilter = document.getElementById('personelFilter');
            if (personelFilter) personelFilter.value = '';
            if (personelFilterInput) personelFilterInput.value = '';
            personelFilterDropdown.style.display = 'none';
            calendar.refetchEvents();
        });
        allOption.addEventListener('mouseenter', function() {
            this.style.backgroundColor = '#fce7f3';
        });
        allOption.addEventListener('mouseleave', function() {
            this.style.backgroundColor = '';
        });
        personelFilterDropdown.appendChild(allOption);
    }
    
    if (personelFilterInput && personelFilterDropdown) {
        personelFilterInput.addEventListener('input', function(e) {
            const query = e.target.value.toLowerCase().trim();
            
            if (query.length === 0) {
                showAllPersonelsOption();
                personelFilterDropdown.style.display = 'block';
                return;
            }
            
            const filtered = allPersonels.filter(personel => 
                personel.searchName.includes(query) || 
                personel.name.toLowerCase().includes(query)
            );
            
            personelFilterDropdown.innerHTML = '';
            
            if (filtered.length === 0) {
                const noResult = document.createElement('div');
                noResult.style.cssText = 'padding: 20px; text-align: center; color: #64748b;';
                noResult.innerHTML = '<i class="bi bi-search" style="font-size: 24px; display: block; margin-bottom: 8px; opacity: 0.5;"></i><span>Personel bulunamadı</span>';
                personelFilterDropdown.appendChild(noResult);
            } else {
                filtered.forEach(personel => {
                    const item = document.createElement('div');
                    item.style.cssText = 'padding: 12px 16px; cursor: pointer; border-bottom: 1px solid #e2e8f0; transition: background-color 0.2s;';
                    item.innerHTML = `<span style="color: #1e293b; font-size: 14px;">${personel.name}</span>`;
                    item.addEventListener('click', function() {
                        if (personelFilterHidden) personelFilterHidden.value = personel.id;
                        const personelFilter = document.getElementById('personelFilter');
                        if (personelFilter) personelFilter.value = personel.id;
                        personelFilterInput.value = personel.name;
                        personelFilterDropdown.style.display = 'none';
                        calendar.refetchEvents();
                    });
                    item.addEventListener('mouseenter', function() {
                        this.style.backgroundColor = '#fce7f3';
                    });
                    item.addEventListener('mouseleave', function() {
                        this.style.backgroundColor = '';
                    });
                    personelFilterDropdown.appendChild(item);
                });
            }
            
            personelFilterDropdown.style.display = 'block';
        });
        
        personelFilterInput.addEventListener('focus', function() {
            if (personelFilterInput.value.trim() === '') {
                showAllPersonelsOption();
                personelFilterDropdown.style.display = 'block';
            }
        });
        
        document.addEventListener('click', function(e) {
            if (personelFilterInput && personelFilterDropdown && 
                !personelFilterInput.contains(e.target) && 
                !personelFilterDropdown.contains(e.target)) {
                personelFilterDropdown.style.display = 'none';
            }
        });
    }
    
    // Personel filtresi değiştiğinde
    const personelFilter = document.getElementById('personelFilter');
    if (personelFilter) {
        personelFilter.addEventListener('change', function() {
            calendar.refetchEvents();
        });
    }
});

function changeCalendarView(viewName) {
    currentView = viewName;
    calendar.changeView(viewName);
    
    // Buton stillerini güncelle
    document.querySelectorAll('.view-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    
    const viewMap = {
        'dayGridMonth': 'viewMonth',
        'timeGridWeek': 'viewWeek',
        'timeGridDay': 'viewDay',
        'listWeek': 'viewList'
    };
    
    const activeBtn = document.getElementById(viewMap[viewName]);
    if (activeBtn) {
        activeBtn.classList.add('active');
    }
}

function filterByCategory(category) {
    // Kategori filtreleme fonksiyonu (ileride eklenebilir)
    console.log('Kategori filtrelendi:', category);
}

function loadUpcomingEvents(events) {
    const now = new Date();
    const upcoming = events
        .filter(event => {
            const eventDate = new Date(event.start);
            return eventDate >= now;
        })
        .sort((a, b) => new Date(a.start) - new Date(b.start))
        .slice(0, 5);
    
    const container = document.getElementById('upcomingEventsList');
    if (!container) return;
    
    if (upcoming.length === 0) {
        container.innerHTML = `
            <div class="empty-state">
                <div class="empty-state-icon">
                    <i class="bi bi-calendar-x"></i>
                </div>
                <p class="text-muted mb-0" style="font-size: 14px;">Yaklaşan randevu bulunmamaktadır.</p>
            </div>
        `;
        return;
    }
    
    container.innerHTML = upcoming.map(event => {
        const date = new Date(event.start);
        const months = ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz', 'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'];
        const day = date.getDate();
        const month = months[date.getMonth()];
        const year = date.getFullYear();
        const dateStr = `${day} ${month} ${year}`;
        const timeStr = date.toLocaleTimeString('tr-TR', { hour: '2-digit', minute: '2-digit' });
        const title = event.title.split(' - ')[0];
        
        return `
            <div class="upcoming-event-card" onclick="${event.extendedProps?.reservation_id ? `if(typeof showReservationDetail === 'function') { showReservationDetail(${event.extendedProps.reservation_id}); } else { window.location.href='${event.url || '#'}'; }` : `window.location.href='${event.url || '#'}'`}">
                <div class="d-flex align-items-start gap-3">
                    <span class="event-status-badge" style="background: ${event.color}; margin-top: 6px;"></span>
                    <div class="flex-grow-1">
                        <h6 class="text-dark mb-1 fw-bold" style="font-size: 15px;">${title}</h6>
                        <div class="d-flex align-items-center gap-2 mb-1">
                            <i class="bi bi-calendar3 text-muted" style="font-size: 12px;"></i>
                            <small class="text-muted" style="font-size: 12px;">${dateStr}</small>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <i class="bi bi-clock text-muted" style="font-size: 12px;"></i>
                            <small class="text-muted" style="font-size: 12px;">${timeStr}</small>
                        </div>
                    </div>
                    <i class="bi bi-chevron-right text-muted"></i>
                </div>
            </div>
        `;
    }).join('');
}

function updateStatistics(events) {
    const now = new Date();
    const currentMonth = now.getMonth();
    const currentYear = now.getFullYear();
    
    // Bu ayın randevularını filtrele
    const thisMonthEvents = events.filter(event => {
        const eventDate = new Date(event.start);
        return eventDate.getMonth() === currentMonth && eventDate.getFullYear() === currentYear;
    });
    
    // İstatistikleri hesapla
    const total = thisMonthEvents.length;
    const confirmed = thisMonthEvents.filter(e => e.extendedProps?.status === 'confirmed').length;
    const cancelled = thisMonthEvents.filter(e => e.extendedProps?.status === 'cancelled').length;
    
    // DOM'a yaz
    const totalEl = document.getElementById('statTotalAppointments');
    const confirmedEl = document.getElementById('statConfirmed');
    const cancelledEl = document.getElementById('statCancelled');
    
    if (totalEl) totalEl.textContent = total;
    if (confirmedEl) confirmedEl.textContent = confirmed;
    if (cancelledEl) cancelledEl.textContent = cancelled;
}

function loadTodayAppointments(events) {
    const today = new Date();
    today.setHours(0, 0, 0, 0);
    const tomorrow = new Date(today);
    tomorrow.setDate(tomorrow.getDate() + 1);
    
    // Bugünkü randevuları filtrele
    const todayEvents = events.filter(event => {
        const eventDate = new Date(event.start);
        eventDate.setHours(0, 0, 0, 0);
        return eventDate.getTime() === today.getTime();
    }).sort((a, b) => {
        const timeA = new Date(a.start).getTime();
        const timeB = new Date(b.start).getTime();
        return timeA - timeB;
    });
    
    const container = document.getElementById('todayAppointments');
    if (!container) return;
    
    if (todayEvents.length === 0) {
        container.innerHTML = `
            <div class="col-12">
                <div class="text-center py-5" style="background: #f8fafc; border-radius: 12px; border: 1px solid #e2e8f0;">
                    <i class="bi bi-calendar-x" style="font-size: 48px; color: #cbd5e1; margin-bottom: 12px;"></i>
                    <p class="text-muted mb-0" style="font-size: 14px;">Bugün için randevu bulunmamaktadır.</p>
                </div>
            </div>
        `;
        return;
    }
    
    container.innerHTML = todayEvents.map(event => {
        const startDate = new Date(event.start);
        const endDate = new Date(event.end);
        const timeStr = startDate.toLocaleTimeString('tr-TR', { hour: '2-digit', minute: '2-digit' });
        const title = event.title.split(' - ')[0];
        const salon = event.title.split(' - ')[1] || '';
        
        // Durum badge rengi
        let statusBadge = '';
        let statusText = '';
        switch(event.extendedProps?.status) {
            case 'confirmed':
                statusBadge = 'bg-success';
                statusText = 'Onaylandı';
                break;
            case 'open':
                statusBadge = 'bg-warning';
                statusText = 'Açık';
                break;
            case 'completed':
                statusBadge = 'bg-info';
                statusText = 'Tamamlandı';
                break;
            default:
                statusBadge = 'bg-secondary';
                statusText = event.extendedProps?.status || 'Bilinmiyor';
        }
        
        return `
            <div class="col-md-6 col-lg-4">
                <div class="today-reservation-card" onclick="window.location.href='${event.url || '#'}'" style="background: white; border: 1px solid #e2e8f0; border-radius: 12px; padding: 16px; cursor: pointer; height: 100%; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
                    <div class="d-flex align-items-start justify-content-between mb-2">
                        <div class="d-flex align-items-center gap-2" style="flex: 1;">
                            <div style="width: 6px; height: 6px; border-radius: 50%; background: ${event.color}; flex-shrink: 0; margin-top: 6px;"></div>
                            <div style="flex: 1; min-width: 0;">
                                <h6 class="mb-0 fw-bold text-dark" style="font-size: 15px; line-height: 1.4;">${title}</h6>
                                ${salon ? `<small class="text-muted d-block mt-1" style="font-size: 12px;">${salon}</small>` : ''}
                            </div>
                        </div>
                        <span class="badge ${statusBadge} ms-2" style="font-size: 11px; flex-shrink: 0;">${statusText}</span>
                    </div>
                    <div class="d-flex align-items-center gap-3 mt-3 pt-2 border-top border-light">
                        <div class="d-flex align-items-center gap-1 text-muted" style="font-size: 13px;">
                            <i class="bi bi-clock"></i>
                            <span>${timeStr}</span>
                        </div>
                    </div>
                </div>
            </div>
        `;
    }).join('');
    
    // Hover efektleri için event listener ekle (sadece border rengi değişsin, animasyon yok)
    container.querySelectorAll('.today-reservation-card').forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.borderColor = '#ec4899';
            this.style.boxShadow = '0 2px 6px rgba(236, 72, 153, 0.2)';
        });
        card.addEventListener('mouseleave', function() {
            this.style.borderColor = '#e2e8f0';
            this.style.boxShadow = '0 1px 3px rgba(0,0,0,0.1)';
        });
    });
    
    // Yeni randevu aç (mobilde sayfa, desktop'ta sayfa yönlendirmesi)
    
    function openNewReservation() {
        return; 
        const userAgent = navigator.userAgent || navigator.vendor || window.opera;
        if (userAgent === 'SalonayMobileApp' || userAgent === 'SalonayAndroidApp/1.0' || /android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i.test(userAgent.toLowerCase())) {
            window.location.href = '{{ route("mobile.appointments.create") }}';
        } else {
            
        }
    }
}
</script>
@endpush
