@extends('layouts.admin')

@section('title', 'Tüm Randevular')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Tüm Randevular</li>
@endsection

@section('content')
<style>
    /* Şimşek düğmesi dropdown menüsü için yüksek z-index */
    .btn-group .dropdown-menu {
        z-index: 10001 !important;
    }
    
    /* Desktop görünümde de üstten boşluk */
    @media (min-width: 1025px) {
        .main-content {
            padding-top: 20px !important;
        }
    }
    
    @media (max-width: 1024px) {
        .main-content {
            padding-top: 20px !important;
        }
        .card {
            border-radius: 16px !important;
            margin-bottom: 15px !important;
        }
        
        .card-header {
            padding: 15px !important;
            font-size: 16px !important;
        }
        
        .card-body {
            padding: 15px !important;
        }
        
        .form-control, .form-select {
            padding: 12px 15px !important;
            font-size: 16px !important;
            min-height: 44px !important;
            border-radius: 12px !important;
        }
        
        .form-label {
            font-size: 14px !important;
            font-weight: 600 !important;
            margin-bottom: 8px !important;
        }
        
        .btn {
            padding: 12px 20px !important;
            font-size: 15px !important;
            min-height: 44px !important;
            border-radius: 12px !important;
        }
        
        .row .col-md-3, .row .col-md-4 {
            margin-bottom: 15px !important;
        }
        
        .table-responsive {
            border-radius: 12px !important;
            overflow-x: auto !important;
            -webkit-overflow-scrolling: touch;
        }
        
        .table {
            font-size: 14px !important;
        }
        
        .table th, .table td {
            padding: 12px 8px !important;
            white-space: nowrap;
        }
        
        .badge {
            font-size: 11px !important;
            padding: 4px 8px !important;
        }
        
        .btn-group {
            flex-direction: column !important;
            gap: 5px !important;
        }
        
        .btn-group .btn {
            width: 100% !important;
        }
    }
    
    .date-filter-input {
        max-width: 200px;
    }
    @media (max-width: 768px) {
        .date-filter-input {
            max-width: 100%;
            width: 100%;
        }
    }
    input[type="date"]::before {
        content: attr(placeholder);
        color: #999;
        width: 100%;
    }
    input[type="date"]:focus::before,
    input[type="date"]:valid::before {
        display: none;
    }
    
    /* Performans optimizasyonları - CSS sınıfları */
    .customer-avatar {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: bold;
        font-size: 11px;
        flex-shrink: 0;
    }
    
    .customer-avatar-lg {
        width: 40px;
        height: 40px;
        font-size: 12px;
    }
    
    /* Mobil görünümde randevu talepleri modal düzeltmeleri */
    @media (max-width: 768px) {
        /* Pending Requests Modal - Ortada ve düzgün görünsün */
        #pendingRequestsModal {
            z-index: 10060 !important;
        }
        
        #pendingRequestsModal .modal-dialog {
            margin: 0.5rem auto !important;
            max-width: calc(100% - 20px) !important;
            max-height: calc(100vh - 20px) !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            min-height: auto !important;
            height: auto !important;
            position: relative !important;
        }
        
        #pendingRequestsModal .modal-content {
            max-height: calc(100vh - 20px) !important;
            margin: auto !important;
            width: 100% !important;
            border-radius: 16px !important;
            border: none !important;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3) !important;
        }
        
        /* Modal Header - Gradient Background ve Text Renkleri */
        #pendingRequestsModal .modal-header {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%) !important;
            border-radius: 16px 16px 0 0 !important;
            padding: 16px 20px !important;
            flex-shrink: 0 !important;
            border-bottom: none !important;
        }
        
        #pendingRequestsModal .modal-header .modal-title,
        #pendingRequestsModal .modal-header .text-white,
        #pendingRequestsModal .modal-header h5,
        #pendingRequestsModal .modal-header * {
            color: #ffffff !important;
        }
        
        #pendingRequestsModal .modal-header .btn-close-white {
            filter: brightness(0) invert(1) !important;
            opacity: 1 !important;
        }
        
        #pendingRequestsModal .modal-body {
            padding: 1rem !important;
            background: #ffffff !important;
            color: #111827 !important;
        }
        
        #pendingRequestsModal .table {
            font-size: 13px !important;
        }
        
        #pendingRequestsModal .table th,
        #pendingRequestsModal .table td {
            color: #212529 !important;
            background-color: transparent !important;
            padding: 10px 8px !important;
        }
        
        #pendingRequestsModal .table thead th {
            background-color: #f8f9fa !important;
            color: #212529 !important;
            font-weight: 600 !important;
        }
        
        #pendingRequestsModal .table tbody td {
            color: #212529 !important;
        }
        
        #pendingRequestsModal .text-muted {
            color: #6c757d !important;
        }
        
        #pendingRequestsModal .btn-group {
            flex-direction: column;
            gap: 5px;
        }
        
        #pendingRequestsModal .btn-group .btn {
            width: 100%;
            font-size: 13px;
            padding: 8px 12px;
        }
        
        /* Request Detail Modal - Ortada ve düzgün görünsün */
        #requestDetailModal {
            z-index: 10060 !important;
        }
        
        #requestDetailModal .modal-dialog {
            margin: 0.5rem auto !important;
            max-width: calc(100% - 20px) !important;
            max-height: calc(100vh - 20px) !important;
            display: flex !important;
            align-items: center !important;
            justify-content: center !important;
            min-height: auto !important;
            height: auto !important;
            position: relative !important;
        }
        
        #requestDetailModal .modal-content {
            max-height: calc(100vh - 20px) !important;
            margin: auto !important;
            width: 100% !important;
            border-radius: 16px !important;
            border: none !important;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3) !important;
        }
        
        /* Modal Header - Gradient Background ve Text Renkleri */
        #requestDetailModal .modal-header {
            background: linear-gradient(135deg, #ec4899 0%, #be185d 100%) !important;
            border-radius: 16px 16px 0 0 !important;
            padding: 16px 20px !important;
            flex-shrink: 0 !important;
            border-bottom: none !important;
        }
        
        #requestDetailModal .modal-header .modal-title,
        #requestDetailModal .modal-header .text-white,
        #requestDetailModal .modal-header h5,
        #requestDetailModal .modal-header .btn-close,
        #requestDetailModal .modal-header * {
            color: #ffffff !important;
        }
        
        #requestDetailModal .modal-header .btn-close-white {
            filter: brightness(0) invert(1) !important;
            opacity: 1 !important;
        }
        
        /* Modal Body - Text Renkleri */
        #requestDetailModal .modal-body {
            padding: 1rem !important;
            background: #ffffff !important;
            color: #111827 !important;
            overflow-y: auto !important;
        }
        
        /* Modal body içindeki text renklerini düzelt */
        #requestDetailModal .modal-body .text-white,
        #requestDetailModal .modal-body .text-white *,
        #requestDetailModal .modal-body p:not(.text-success):not(.text-danger):not(.text-primary):not(.text-info):not(.text-warning),
        #requestDetailModal .modal-body span:not(.badge):not(.text-success):not(.text-danger):not(.text-primary):not(.text-info):not(.text-warning),
        #requestDetailModal .modal-body div:not(.text-white):not(.text-success):not(.text-danger):not(.text-primary):not(.text-info):not(.text-warning),
        #requestDetailModal .modal-body small:not(.text-muted):not(.text-white) {
            color: #111827 !important;
        }
        
        #requestDetailModal .modal-body .text-muted {
            color: #6b7280 !important;
        }
        
        /* Card header renklerini koru */
        #requestDetailModal .modal-body .card-header[style*="background: linear-gradient"] {
            background: inherit !important;
        }
        
        #requestDetailModal .modal-body .card-header .text-white {
            color: #ffffff !important;
        }
        
        /* Card body text renkleri */
        #requestDetailModal .modal-body .card-body {
            color: #111827 !important;
            background: #ffffff !important;
        }
        
        #requestDetailModal .modal-body .card-body .text-white {
            color: #111827 !important;
        }
        
        /* Mobil kart optimizasyonu */
        .reservation-card-mobile {
            will-change: transform;
            transform: translateZ(0);
            -webkit-transform: translateZ(0);
        }
    }
    </style>
    
    @if(session('sms_warning'))
        <!-- SMS Bakiye Bildirimi Modal -->
        <div class="modal fade" id="smsBalanceModal" tabindex="-1" aria-labelledby="smsBalanceModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-warning text-dark">
                        <h5 class="modal-title" id="smsBalanceModalLabel">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i>SMS Bakiyesi Tükenmiş
                        </h5>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-warning mb-3">
                            <i class="bi bi-info-circle-fill me-2"></i>
                            <strong>SMS bakiyeniz tükenmiştir.</strong> SMS gönderilemedi.
                        </div>
                        <p class="mb-0">SMS gönderebilmek için SMS paketi satın almanız gerekmektedir.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" onclick="closeSmsBalanceModal()">
                            <i class="bi bi-clock"></i> Daha Sonra
                        </button>
                        <a href="{{ route('sms-packages.index') }}" class="btn btn-primary">
                            <i class="bi bi-cart-plus"></i> SMS Al
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @endif
    
    <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-3">
        <div>
            <h2 class="fw-bold mb-2" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                Randevu Yönetimi
            </h2>
            <small class="text-muted">
                <i class="bi bi-keyboard me-1"></i>Kısayollar: <kbd>Ctrl+N</kbd> Yeni Randevu, <kbd>Ctrl+F</kbd> Arama, <kbd>Ctrl+R</kbd> Yenile
            </small>
        </div>
        <div class="d-flex gap-2 flex-wrap">
            @if(auth()->user()->isBeautySalon())
                <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#pendingRequestsModal" style="border-radius: 12px; padding: 10px 20px; font-weight: 600;">
                    <i class="bi bi-bell-fill me-2"></i>Bekleyen Talepler
                    @php
                        $pendingCount = \App\Models\AppointmentRequest::where('beauty_salon_id', auth()->id())
                            ->where('status', 'pending')
                            ->count();
                    @endphp
                    @if($pendingCount > 0)
                        <span class="badge bg-danger ms-2">{{ $pendingCount }}</span>
                    @endif
                </button>
            @endif
            <button type="button" class="btn btn-success" onclick="quickCreateReservation()" style="border-radius: 12px; padding: 10px 20px; font-weight: 600;" title="Hızlı Randevu Oluştur (Ctrl+N)">
                <i class="bi bi-lightning-fill me-2"></i>Hızlı Randevu
            </button>
        </div>
    </div>
    
    
    <div class="card mb-4">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-funnel me-2"></i>Filtreler</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.appointments.index') }}" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Tarih</label>
                    <input type="text" name="date" class="form-control date-filter-input" value="{{ request('date') }}" placeholder="gg.aa.yyyy" onfocus="this.type='date'; if(!this.value && this.placeholder) this.placeholder='';" onblur="if(!this.value) { this.type='text'; this.placeholder='gg.aa.yyyy'; }">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Salon</label>
                    <select name="salon_id" class="form-select">
                        <option value="">Tümü</option>
                        @foreach($salons as $salon)
                            <option value="{{ $salon->id }}" {{ request('salon_id') == $salon->id ? 'selected' : '' }}>
                                {{ $salon->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3" style="position: relative;">
                    <label class="form-label">Müşteri Adı / Telefon</label>
                    <input type="text" name="customer_name" id="customerSearchInput" class="form-control" value="{{ request('customer_name') }}" placeholder="İsim veya telefon ile ara..." autocomplete="off">
                    <div id="customerSearchResults" class="position-absolute bg-white border rounded shadow-lg mt-1" style="display: none; max-height: 300px; overflow-y: auto; z-index: 1000; width: calc(100% - 30px);"></div>
                </div>
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">Filtrele</button>
                    <a href="{{ route('admin.appointments.index') }}" class="btn btn-secondary">Temizle</a>
                    <button type="button" class="btn btn-info" onclick="exportAppointments()" title="Randevuları Excel'e Aktar">
                        <i class="bi bi-file-earmark-excel me-1"></i>Excel'e Aktar
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header border-0 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
            <h5 class="mb-0 text-white"><i class="bi bi-list-ul me-2"></i>Randevu Listesi</h5>
            <form method="GET" action="{{ route('admin.appointments.index') }}" class="d-inline-flex align-items-center gap-2">
                @foreach(request()->except('sort', 'page') as $key => $value)
                    <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                @endforeach
                <label class="form-label mb-0 small text-white-50">Sırala:</label>
                <select name="sort" class="form-select form-select-sm" style="width: auto; min-width: 150px; background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white;" onchange="this.form.submit()">
                    <option value="date_asc" {{ request('sort', 'date_asc') == 'date_asc' ? 'selected' : '' }} style="background: #ec4899; color: white;">En Yakın Tarih</option>
                    <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }} style="background: #ec4899; color: white;">A-Z (Müşteri)</option>
                    <option value="date_desc" {{ request('sort') == 'date_desc' ? 'selected' : '' }} style="background: #ec4899; color: white;">Yeniden Eskiye</option>
                </select>
            </form>
        </div>
        <div class="card-body">
            <div class="table-responsive d-none d-md-block">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Müşteri Adı</th>
                            <th>Tarih/Saat</th>
                            <th>Salon</th>
                            <th>Durum</th>
                            <th>Toplam Tutar</th>
                            <th>Kalan Bakiye</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($appointments as $index => $reservation)
                            @php
                                $itemsData = json_decode($reservation->items_data ?? '{}', true);
                                
                            @endphp
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center gap-2">
                                        <div class="customer-avatar" style="background: {{ $reservation->customer->avatar_color ?? '#ec4899' }};">
                                            {{ $reservation->customer->initials ?? '??' }}
                                        </div>
                                        <div>
                                            <div>{{ $reservation->customer->name }}</div>
                                            <!-- Gelin/damat bilgisi kaldırıldı -->
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    @if($reservation->date)
                                        {{ $reservation->date->format('d.m.Y') }} {{ $reservation->start_time }}
                                    @else
                                        <span class="text-muted">Tarih belirlenecek</span>
                                    @endif
                                </td>
                                <td>{{ $reservation->salon->name }}</td>
                                <td>
                                    @if($reservation->status == 'bekleyen')
                                        @if($reservation->appointmentRequest)
                                            <span class="badge bg-warning text-dark" style="position: relative;">
                                                <i class="bi bi-bell-fill"></i> Randevu Talebi
                                                <span class="badge bg-danger" style="position: absolute; top: -5px; right: -5px; font-size: 8px; padding: 2px 4px;">YENİ</span>
                                            </span>
                                        @else
                                            <span class="badge bg-warning text-dark"><i class="bi bi-clock-history"></i> Bekleyen</span>
                                        @endif
                                    @elseif($reservation->status == 'confirmed')
                                        <span class="badge bg-info"><i class="bi bi-check-circle"></i> Onaylandı</span>
                                    @elseif($reservation->status == 'open')
                                        <span class="badge bg-primary"><i class="bi bi-clock"></i> Açık</span>
                                    @elseif($reservation->status == 'cancelled')
                                        <span class="badge bg-danger"><i class="bi bi-x-circle"></i> İptal</span>
                                    @elseif($reservation->status == 'completed')
                                        <span class="badge bg-success"><i class="bi bi-check-circle"></i> Tamamlandı</span>
                                    @else
                                        <span class="badge bg-secondary">{{ $reservation->status }}</span>
                                    @endif
                                </td>
                                <td>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</td>
                                <td>
                                    @php
                                        $remaining = $reservation->total_price - ($reservation->deposit_paid ?? 0);
                                    @endphp
                                    @if($remaining > 0)
                                        <span class="text-danger fw-bold">{{ number_format($remaining, 2, ',', '.') }} ₺</span>
                                    @elseif($remaining < 0)
                                        <span class="text-success fw-bold">{{ number_format($remaining, 2, ',', '.') }} ₺</span>
                                        <br><small class="text-muted">(İade edilecek)</small>
                                    @else
                                        <span class="text-success"><i class="bi bi-check-circle"></i> 0,00 ₺</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="d-flex gap-1 flex-wrap">
                                        <button type="button" onclick="openReservationDetailModal({{ $reservation->id }})" class="btn btn-action btn-action-info" title="Detay">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                        <a href="{{ route('admin.appointments.edit', $reservation->id) }}" class="btn btn-action btn-action-warning" title="Düzenle">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        @if($reservation->status !== 'completed' && $reservation->status !== 'cancelled')
                                            <button type="button" class="btn btn-action btn-action-success" onclick="showQuickActionsModal({{ $reservation->id }}, {{ $reservation->total_price }}, {{ $reservation->deposit_paid ?? 0 }}, '{{ $reservation->status }}', '{{ $reservation->customer->phone ?? '' }}')" title="Hızlı İşlemler">
                                                <i class="bi bi-lightning-fill"></i>
                                            </button>
                                        @endif
                                        <form action="{{ route('admin.appointments.destroy', $reservation->id) }}" method="POST" class="d-inline delete-form" data-message="Bu randevuu silmek istediğinize emin misiniz?">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-action btn-action-danger" title="Sil">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center">Randevu bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <!-- Mobile Cards -->
            <div class="d-md-none">
                @forelse($appointments as $reservation)
                    @php
                        $itemsData = json_decode($reservation->items_data ?? '{}', true);
                        
                        $remaining = $reservation->total_price - ($reservation->deposit_paid ?? 0);
                    @endphp
                    @php
                        $borderColor = $reservation->status == 'confirmed' ? '#ec4899' : ($reservation->status == 'bekleyen' ? ($reservation->appointmentRequest ? '#f59e0b' : '#f59e0b') : ($reservation->status == 'open' ? '#ec4899' : ($reservation->status == 'cancelled' ? '#ef4444' : '#f472b6')));
                        $borderStyle = $reservation->appointmentRequest ? 'border-left-width: 6px; box-shadow: 0 0 10px rgba(245, 158, 11, 0.3);' : '';
                    @endphp
                    <div class="card mb-3 mx-3 mt-3 border-start border-4 reservation-card-mobile" style="border-left-color: {{ $borderColor }}; {{ $borderStyle }}">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div class="d-flex align-items-center gap-2">
                                    <div class="customer-avatar customer-avatar-lg" style="background: {{ $reservation->customer->avatar_color ?? '#ec4899' }};">
                                        {{ $reservation->customer->initials ?? '??' }}
                                    </div>
                                    <div>
                                        <h6 class="mb-1 fw-bold">{{ $reservation->customer->name }}</h6>
                                        <!-- Gelin/damat bilgisi kaldırıldı -->
                                    </div>
                                </div>
                                <div>
                                    @if($reservation->status == 'bekleyen')
                                        @if($reservation->appointmentRequest)
                                            <span class="badge bg-warning text-dark" style="position: relative;">
                                                <i class="bi bi-bell-fill"></i> Randevu Talebi
                                                <span class="badge bg-danger" style="position: absolute; top: -5px; right: -5px; font-size: 8px; padding: 2px 4px;">YENİ</span>
                                            </span>
                                        @else
                                            <span class="badge bg-warning text-dark"><i class="bi bi-clock-history"></i> Bekleyen</span>
                                        @endif
                                    @elseif($reservation->status == 'confirmed')
                                        <span class="badge bg-info"><i class="bi bi-check-circle"></i> Onaylandı</span>
                                    @elseif($reservation->status == 'open')
                                        <span class="badge bg-primary"><i class="bi bi-clock"></i> Açık</span>
                                    @elseif($reservation->status == 'cancelled')
                                        <span class="badge bg-danger"><i class="bi bi-x-circle"></i> İptal</span>
                                    @elseif($reservation->status == 'completed')
                                        <span class="badge bg-success"><i class="bi bi-check-circle"></i> Tamamlandı</span>
                                    @else
                                        <span class="badge bg-secondary">{{ $reservation->status }}</span>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="mb-2">
                                <small class="text-muted d-block">Tarih/Saat:</small>
                                <strong>
                                    @if($reservation->date)
                                        {{ $reservation->date->format('d.m.Y') }} {{ $reservation->start_time }}
                                    @else
                                        <span class="text-muted">Tarih belirlenecek</span>
                                    @endif
                                </strong>
                            </div>
                            
                            <div class="mb-2">
                                <small class="text-muted d-block">Salon:</small>
                                <strong>{{ $reservation->salon->name }}</strong>
                            </div>
                            
                            <div class="row g-2 mb-2">
                                <div class="col-6">
                                    <small class="text-muted d-block">Toplam Tutar</small>
                                    <strong>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</strong>
                                </div>
                                <div class="col-6">
                                    <small class="text-muted d-block">Kalan Bakiye</small>
                                    @if($remaining > 0)
                                        <strong class="text-danger">{{ number_format($remaining, 2, ',', '.') }} ₺</strong>
                                    @elseif($remaining < 0)
                                        <strong class="text-success">{{ number_format($remaining, 2, ',', '.') }} ₺</strong>
                                        <br><small class="text-muted">(İade)</small>
                                    @else
                                        <span class="text-success"><i class="bi bi-check-circle"></i> 0,00 ₺</span>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="d-flex flex-wrap gap-1 mt-2">
                                <button type="button" onclick="openReservationDetailModal({{ $reservation->id }})" class="btn btn-action btn-action-info flex-fill">
                                    <i class="bi bi-eye me-1"></i> Detay
                                </button>
                                <a href="{{ route('admin.appointments.edit', $reservation->id) }}" class="btn btn-action btn-action-warning">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                @if($reservation->status !== 'completed' && $reservation->status !== 'cancelled')
                                    <button type="button" class="btn btn-action btn-action-success" onclick="showQuickActionsModal({{ $reservation->id }}, {{ $reservation->total_price }}, {{ $reservation->deposit_paid ?? 0 }}, '{{ $reservation->status }}', '{{ $reservation->customer->phone ?? '' }}')" title="Hızlı İşlemler">
                                        <i class="bi bi-lightning-fill"></i>
                                    </button>
                                @endif
                                @if($reservation->customer && $reservation->customer->phone)
                                    <a href="tel:{{ $reservation->customer->phone }}" class="btn btn-action btn-action-info" title="Ara">
                                        <i class="bi bi-telephone"></i>
                                    </a>
                                    <a href="https://wa.me/{{ str_replace([' ', '(', ')', '-'], '', $reservation->customer->phone) }}" target="_blank" class="btn btn-action" style="background: linear-gradient(135deg, #25D366 0%, #128C7E 100%); color: white;" title="WhatsApp">
                                        <i class="bi bi-whatsapp"></i>
                                    </a>
                                @endif
                                <form action="{{ route('admin.appointments.destroy', $reservation->id) }}" method="POST" class="d-inline delete-form" data-message="Bu randevuu silmek istediğinize emin misiniz?">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-action btn-action-danger" title="Sil">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="text-center py-5 px-3">
                        <i class="bi bi-calendar-x display-4 text-muted"></i>
                        <p class="text-muted mt-2">Randevu bulunamadı.</p>
                    </div>
                @endforelse
            </div>
            
            <div class="mt-3">
                {{ $appointments->links() }}
            </div>
        </div>
    </div>

    <!-- YENİ RANDEVU MODAL -->
    @include('admin.appointments.reservations.partials.new-reservation-modal')
    
    <!-- Bekleyen Talepler Modal -->
    <div class="modal fade" id="pendingRequestsModal" tabindex="-1" aria-labelledby="pendingRequestsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content" style="border-radius: 16px; border: none;">
                <div class="modal-header" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="modal-title text-white fw-bold" id="pendingRequestsModalLabel">
                        <i class="bi bi-bell-fill me-2"></i>Bekleyen Randevu Talepleri
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="padding: 1.5rem;">
                    <div id="pendingRequestsList" class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Müşteri</th>
                                    <th>Telefon</th>
                                    <th>Hizmet</th>
                                    <th>Tarih</th>
                                    <th>İşlemler</th>
                                </tr>
                            </thead>
                            <tbody id="pendingRequestsTableBody">
                                <tr>
                                    <td colspan="5" class="text-center py-4">
                                        <div class="spinner-border text-warning" role="status">
                                            <span class="visually-hidden">Yükleniyor...</span>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Randevu Talebi Detay Modal -->
    <div class="modal fade" id="requestDetailModal" tabindex="-1" aria-labelledby="requestDetailModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl" style="max-width: 90%;">
            <div class="modal-content" style="border-radius: 16px; border: none; max-height: 90vh; display: flex; flex-direction: column;">
                <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; flex-shrink: 0;">
                    <h5 class="modal-title text-white fw-bold" id="requestDetailModalLabel">
                        <i class="bi bi-eye me-2"></i>Randevu Talebi Detayı
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="padding: 1.5rem; overflow-y: auto; flex: 1;" id="requestDetailContent">
                    <!-- İçerik JavaScript ile doldurulacak -->
                </div>
            </div>
        </div>
    </div>
    
    <!-- Müşteri Portföyü Detay Modal -->
    <div class="modal fade" id="customerPortfolioModal" tabindex="-1" aria-labelledby="customerPortfolioModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content" style="border-radius: 16px; border: none; max-height: 90vh; display: flex; flex-direction: column;">
                <div class="modal-header" style="background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); border-radius: 16px 16px 0 0; flex-shrink: 0;">
                    <h5 class="modal-title text-white fw-bold" id="customerPortfolioModalLabel">
                        <i class="bi bi-person-badge me-2"></i>Müşteri Portföyü Detayı
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="padding: 1.5rem; overflow-y: auto; flex: 1;" id="customerPortfolioContent">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status"></div>
                        <p class="mt-3">Yükleniyor...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- RANDEVU DETAY MODAL -->
    <div class="modal fade" id="reservationDetailModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header" style="background: linear-gradient(135deg, #f472b6 0%, #db2777 100%);">
                    <h5 class="modal-title text-white fw-bold"><i class="bi bi-eye me-2"></i>Randevu Detayı</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="reservationDetailContent">
                    <div class="text-center py-5">
                        <img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 40px; height: 40px; display: block; margin: 0 auto;">
                    </div>
                </div>
                <div class="modal-footer flex-wrap gap-2" style="background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);">
                    <input type="hidden" id="currentReservationId" value="">
                    <input type="hidden" id="currentRemainingAmount" value="0">
                    <input type="hidden" id="currentReservationStatus" value="">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-circle me-1"></i>Kapat
                    </button>
                    <button type="button" id="btnCancelReservation" class="btn btn-danger" onclick="cancelReservation()">
                        <i class="bi bi-x-octagon me-1"></i>İptal Edildi
                    </button>
                    <button type="button" id="btnCompleteReservation" class="btn btn-success btn-lg" onclick="completeReservation()">
                        <i class="bi bi-check-circle me-1"></i>Onayla ve Bitir
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Hızlı İşlemler Modal -->
    <div class="modal fade" id="quickActionsModal" tabindex="-1" aria-labelledby="quickActionsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius: 16px; border: none;">
                <div class="modal-header" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="modal-title text-white fw-bold" id="quickActionsModalLabel">
                        <i class="bi bi-lightning-fill me-2"></i>Hızlı İşlemler
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4" id="quickActionsContent">
                    <!-- İçerik JavaScript ile doldurulacak -->
                </div>
            </div>
        </div>
    </div>

    <!-- Yeni Randevu Oluştur Modal -->
    <div class="modal fade" id="newReservationModal" tabindex="-1" aria-labelledby="newReservationModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content" style="border-radius: 16px; border: none;">
                <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="modal-title text-white fw-bold" id="newReservationModalLabel">
                        <i class="bi bi-calendar-plus me-2"></i>Yeni Randevu Oluştur
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                    <div id="newReservationLoading" class="text-center py-4">
                        <div class="spinner-border text-primary" role="status"></div>
                        <p class="mt-2">Yükleniyor...</p>
                    </div>
                    <form id="newReservationForm" method="POST" action="{{ route('admin.appointments.store') }}" style="display: none;">
                        @csrf
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Müşteri <span class="text-danger">*</span></label>
                                <select name="customer_id" id="modal_customer_id" class="form-select" required>
                                    <option value="">Seçiniz</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label fw-bold">Durum <span class="text-danger">*</span></label>
                                <select name="status" class="form-select" required>
                                    <option value="pending">Beklemede</option>
                                    <option value="approved" selected>Onaylandı</option>
                                    <option value="open">Açık</option>
                                </select>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Tarih <span class="text-danger">*</span></label>
                                <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Başlangıç Saati <span class="text-danger">*</span></label>
                                <input type="time" name="start_time" class="form-control" required>
                            </div>
                            <div class="col-md-4">
                                <label class="form-label fw-bold">Bitiş Saati <span class="text-danger">*</span></label>
                                <input type="time" name="end_time" class="form-control" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Konu <span class="text-danger">*</span></label>
                            <input type="text" name="subject" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Notlar</label>
                            <textarea name="notes" class="form-control" rows="3"></textarea>
                        </div>
                        <div class="d-flex justify-content-end gap-2">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle me-2"></i>Kaydet
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
// Global fiyat formatlama fonksiyonu (binlik ayırıcı nokta, ondalık virgül)
function formatPrice(amount) {
    const parts = parseFloat(amount || 0).toFixed(2).split('.');
    const integerPart = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    return integerPart + ',' + parts[1];
}

// Yeni randevu aç (mobilde sayfa, desktop'ta modal)
window.openNewReservation = function() {
    const userAgent = navigator.userAgent || navigator.vendor || window.opera;
    const isMobile = /android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i.test(userAgent.toLowerCase());
    
    // User-Agent kontrolü (Flutter app)
    if (userAgent === 'SalonayMobileApp' || userAgent === 'SalonayAndroidApp/1.0' || isMobile) {
        window.location.href = '{{ route("mobile.appointments.create") }}';
        return;
    }
    
    
};

// Detay modal
function openReservationDetailModal(id) {
    document.getElementById('currentReservationId').value = id;
    const modal = new bootstrap.Modal(document.getElementById('reservationDetailModal'));
    const loadingGif = '{{ asset("splashlogo.gif") }}';
    document.getElementById('reservationDetailContent').innerHTML = '<div class="text-center py-5"><img src="' + loadingGif + '" alt="Yükleniyor" style="width: 40px; height: 40px; display: block; margin: 0 auto;"></div>';
    modal.show();
    
    const urlBase = '{{ route("admin.appointments.show", ["id" => ":id"]) }}';
    const url = urlBase.replace(':id', id);
    fetch(url, { 
        headers: { 
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || ''
        } 
    })
    .then(r => {
        if (!r.ok) {
            throw new Error('HTTP ' + r.status);
        }
        return r.json();
    })
    .then(data => {
        if (!data || !data.reservation) {
            throw new Error('Randevu verisi alınamadı');
        }
        let items = '';
        if (data.items?.length) {
            items = '<table class="table table-sm"><thead><tr><th>Kalem</th><th>Miktar</th><th>Fiyat</th><th>Toplam</th></tr></thead><tbody>' +
                data.items.map(i => `<tr><td>${i.name}</td><td>${i.quantity}</td><td>${formatPrice(i.price)} ₺</td><td>${formatPrice(i.total)} ₺</td></tr>`).join('') +
                '</tbody></table>';
        }
        
        let statusBadge = '';
        if (data.reservation.status === 'completed') {
            statusBadge = '<span class="badge bg-success"><i class="bi bi-check-circle"></i> Tamamlandı</span>';
        } else if (data.reservation.status === 'cancelled') {
            statusBadge = '<span class="badge bg-danger"><i class="bi bi-x-circle"></i> İptal Edildi</span>';
        } else if (data.reservation.status === 'bekleyen') {
            statusBadge = '<span class="badge bg-warning text-dark"><i class="bi bi-clock-history"></i> Bekleyen</span>';
        } else if (data.reservation.status === 'confirmed') {
            statusBadge = '<span class="badge bg-info"><i class="bi bi-check-circle"></i> Onaylandı</span>';
        } else if (data.reservation.status === 'open') {
            statusBadge = '<span class="badge bg-primary"><i class="bi bi-clock"></i> Açık</span>';
        } else {
            statusBadge = '<span class="badge bg-secondary">' + data.reservation.status + '</span>';
        }
        
        const reservationDate = data.reservation.date ? new Date(data.reservation.date).toLocaleDateString('tr-TR') : '-';
        const createdDate = data.reservation.created_at ? new Date(data.reservation.created_at).toLocaleDateString('tr-TR') : '-';
        const createdTime = data.reservation.created_at ? new Date(data.reservation.created_at).toLocaleTimeString('tr-TR', {hour: '2-digit', minute: '2-digit'}) : '-';
        const remainingAmountDetail = parseFloat(data.total_price) - parseFloat(data.deposit_paid || 0);
        
        document.getElementById('reservationDetailContent').innerHTML = `
            <div class="mb-3 text-center">${statusBadge}</div>
            <div class="row g-3">
                <!-- Müşteri -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #f472b6 0%, #ec4899 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-person-fill" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Müşteri</h6>
                            </div>
                            <div class="fw-bold">${data.customer?.name || '-'}</div>
                            ${data.customer?.phone ? `<small class="opacity-75"><i class="bi bi-telephone"></i> ${data.customer.phone}</small>` : ''}
                        </div>
                    </div>
                </div>
                
                <!-- Gelin/damat bilgisi kaldırıldı -->
                
                <!-- Salon -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #ec4899 0%, #db2777 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-building" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Salon</h6>
                            </div>
                            <div class="fw-bold fs-5">${data.salon?.name || '-'}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Tarih -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-calendar3" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Tarih</h6>
                            </div>
                            <div class="fw-bold fs-5">${reservationDate}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Saat -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-clock" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Saat</h6>
                            </div>
                            <div class="fw-bold fs-5">${data.reservation.start_time || '-'}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Randevu Kodu -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #14b8a6 0%, #0d9488 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-tag-fill" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Randevu Kodu</h6>
                            </div>
                            <div class="fw-bold fs-6">${data.reservation.code || 'Yok'}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Toplam Tutar -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-cash-stack" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Toplam Tutar</h6>
                            </div>
                            <div class="fw-bold fs-4">${formatPrice(data.total_price)} ₺</div>
                        </div>
                    </div>
                </div>
                
                <!-- Alınan Kapora -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-wallet2" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Alınan Kapora</h6>
                            </div>
                            <div class="fw-bold fs-4">${formatPrice(data.deposit_paid || 0)} ₺</div>
                        </div>
                    </div>
                </div>
                
                <!-- Kalan Tutar -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-calculator" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Kalan Tutar</h6>
                            </div>
                            <div class="fw-bold fs-4">${formatPrice(remainingAmountDetail)} ₺</div>
                        </div>
                    </div>
                </div>
                
                <!-- Oluşturulma Tarihi -->
                <div class="col-md-4 col-sm-6">
                    <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #64748b 0%, #475569 100%);">
                        <div class="card-body text-white p-3">
                            <div class="d-flex align-items-center gap-2 mb-2">
                                <i class="bi bi-calendar-check" style="font-size: 1.5rem;"></i>
                                <h6 class="mb-0 fw-bold">Oluşturulma</h6>
                            </div>
                            <div class="fw-bold">${createdDate}</div>
                            <small class="opacity-75">${createdTime}</small>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Kalemler -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header text-white" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
                            <h6 class="mb-0 fw-bold"><i class="bi bi-receipt me-2"></i>Fatura Kalemleri</h6>
                        </div>
                        <div class="card-body p-0">
                            ${items || '<div class="p-3 text-center text-muted">Kalem yok</div>'}
                        </div>
                    </div>
                </div>
            </div>`;
        
        // Kalan tutarı ve status'u sakla
        const remainingAmount = parseFloat(data.total_price) - parseFloat(data.deposit_paid);
        document.getElementById('currentRemainingAmount').value = remainingAmount || 0;
        document.getElementById('currentReservationStatus').value = data.reservation.status;
        
        // Tamamlanan veya iptal edilen randevularda işlem butonlarını gizle
        const status = data.reservation.status;
        const btnCancel = document.getElementById('btnCancelReservation');
        const btnComplete = document.getElementById('btnCompleteReservation');
        
        if (status === 'completed' || status === 'cancelled') {
            // Butonları gizle
            btnCancel.style.display = 'none';
            btnComplete.style.display = 'none';
        } else {
            // Butonları göster
            btnCancel.style.display = '';
            btnComplete.style.display = '';
        }
    })
    .catch(e => {
        console.error('Randevu detay hatası:', e);
        let errorMessage = 'Randevu bilgileri yüklenirken bir hata oluştu.';
        
        if (e.message) {
            errorMessage = e.message;
        }
        
        document.getElementById('reservationDetailContent').innerHTML = 
            '<div class="alert alert-danger">' +
            '<i class="bi bi-exclamation-triangle me-2"></i> <strong>Hata:</strong> ' + errorMessage +
            '</div>';
    });
}

// Randevuu Onayla ve Bitir
async function completeReservation() {
    const id = document.getElementById('currentReservationId').value;
    const remaining = parseFloat(document.getElementById('currentRemainingAmount').value) || 0;
    
    if (!id) return;
    
    let message;
    if (remaining > 0) {
        message = 'Kalan ödeme (' + formatPrice(remaining) + ' ₺) alındı olarak işaretlenecek ve randevu tamamlanacak.\n\nOnaylıyor musunuz?';
    } else if (remaining < 0) {
        message = 'Müşteriye ' + formatPrice(Math.abs(remaining)) + ' ₺ fazla ödeme iade edildi olarak işaretlenecek ve randevu tamamlanacak.\n\nOnaylıyor musunuz?';
    } else {
        message = 'Randevu tamamlanacak.\n\nOnaylıyor musunuz?';
    }
    
    const confirmed = await customConfirm(message);
    if (!confirmed) return;
    
    const btn = document.getElementById('btnCompleteReservation');
    if (btn) {
        btn.disabled = true;
        const loadingGif = '{{ asset("splashlogo.gif") }}';
        btn.innerHTML = '<img src="' + loadingGif + '" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">İşleniyor...';
    }
    
    const statusUrlBase = '{{ route("admin.appointments.update-status", ["id" => ":id"]) }}';
    const statusUrl = statusUrlBase.replace(':id', id);
    fetch(statusUrl, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ 
            status: 'completed',
            mark_paid: true 
        })
    })
    .then(async r => {
        const contentType = r.headers.get('content-type');
        if (!r.ok) {
            // JSON response varsa parse et, yoksa hata mesajı oluştur
            if (contentType && contentType.includes('application/json')) {
                const err = await r.json();
                throw new Error(err.message || err.error || 'HTTP ' + r.status);
            } else {
                const text = await r.text();
                throw new Error('HTTP ' + r.status + ': ' + text.substring(0, 100));
            }
        }
        // JSON response kontrolü
        if (contentType && contentType.includes('application/json')) {
            return r.json();
        } else {
            throw new Error('Beklenmeyen response formatı');
        }
    })
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal')).hide();
            showSuccessMessage('Ödeme alındı ve randevu tamamlandı!');
            setTimeout(() => location.reload(), 1500);
        } else {
            showErrorMessage(data.message || 'Hata oluştu');
            if (btn) {
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-check-circle me-1"></i>Onayla ve Bitir';
            }
        }
    })
    .catch(e => {
        console.error('Randevu tamamlama hatası:', e);
        const errorMsg = e.message || 'Randevu tamamlanırken bir hata oluştu.';
        showErrorMessage(errorMsg);
        if (btn) {
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-check-circle me-1"></i>Onayla ve Bitir';
        }
    });
}

// Randevuu İptal Et
async function cancelReservation() {
    const id = document.getElementById('currentReservationId').value;
    if (!id) return;
    
    const confirmed = await customConfirm('Bu randevuu iptal etmek istediğinize emin misiniz?\n\nBu işlem geri alınamaz!');
    if (!confirmed) return;
    
    const cancelUrlBase = '{{ route("admin.appointments.update-status", ["id" => ":id"]) }}';
    const cancelUrl = cancelUrlBase.replace(':id', id);
    fetch(cancelUrl, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ status: 'cancelled' })
    })
    .then(async r => {
        const contentType = r.headers.get('content-type');
        if (!r.ok) {
            if (contentType && contentType.includes('application/json')) {
                const err = await r.json();
                throw new Error(err.message || err.error || 'HTTP ' + r.status);
            } else {
                const text = await r.text();
                throw new Error('HTTP ' + r.status + ': ' + text.substring(0, 100));
            }
        }
        if (contentType && contentType.includes('application/json')) {
            return r.json();
        } else {
            throw new Error('Beklenmeyen response formatı');
        }
    })
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(document.getElementById('reservationDetailModal')).hide();
            showSuccessMessage('Randevu iptal edildi.');
            setTimeout(() => location.reload(), 1500);
        } else {
            showErrorMessage(data.message || 'Hata oluştu');
        }
    })
    .catch(e => {
        console.error('Randevu iptal hatası:', e);
        const errorMsg = e.message || 'Randevu iptal edilirken bir hata oluştu.';
        showErrorMessage(errorMsg);
    });
}

// Kalan tutar HTML'ini oluştur (pozitif/negatif duruma göre)
function getRemainingHtml(totalPrice, depositPaid) {
    const remaining = parseFloat(totalPrice) - parseFloat(depositPaid);
    
    if (remaining > 0) {
        // Müşteri bize borçlu
        return `<div class="d-flex justify-content-between text-danger fs-5">
            <span>Kalan (Müşteri Borcu):</span>
            <strong>${formatPrice(remaining)} ₺</strong>
        </div>`;
    } else if (remaining < 0) {
        // Biz müşteriye borçluyuz (fazla ödeme aldık)
        return `<div class="d-flex justify-content-between text-success fs-5">
            <span>Fazla Ödeme (İade Edilecek):</span>
            <strong style="color: #be185d;">${formatPrice(remaining)} ₺</strong>
        </div>
        <div class="alert alert-warning mt-2 py-2 small">
            <i class="bi bi-exclamation-triangle me-1"></i>
            Müşteriye <strong>${formatPrice(Math.abs(remaining))} ₺</strong> iade yapılması gerekiyor.
        </div>`;
    } else {
        // Tam ödeme yapılmış
        return `<div class="d-flex justify-content-between text-success fs-5">
            <span>Kalan:</span>
            <strong><i class="bi bi-check-circle me-1"></i>0.00 ₺ (Tamamlandı)</strong>
        </div>`;
    }
}

// Başarı mesajı göster
function showSuccessMessage(message) {
    showNotificationToast(message, 'success');
}

// Hata mesajı göster
function showErrorMessage(message) {
    showNotificationToast(message, 'error');
}

// Toast bildirimi göster
function showNotificationToast(message, type = 'info') {
    // Varsa eski toast'ı kaldır
    const existingToast = document.querySelector('.custom-toast');
    if (existingToast) existingToast.remove();
    
    const colors = {
        success: { bg: '#ec4899', icon: 'bi-check-circle-fill' },
        error: { bg: '#ef4444', icon: 'bi-x-circle-fill' },
        warning: { bg: '#f59e0b', icon: 'bi-exclamation-triangle-fill' },
        info: { bg: '#f472b6', icon: 'bi-info-circle-fill' }
    };
    
    const config = colors[type] || colors.info;
    
    const toast = document.createElement('div');
    toast.className = 'custom-toast';
    toast.innerHTML = `
        <div style="position: fixed; top: 20px; right: 20px; z-index: 9999999; animation: slideIn 0.3s ease;">
            <div style="background: ${config.bg}; color: white; padding: 16px 24px; border-radius: 12px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); display: flex; align-items: center; gap: 12px; min-width: 300px;">
                <i class="bi ${config.icon}" style="font-size: 24px;"></i>
                <span style="font-weight: 500;">${message}</span>
            </div>
        </div>
    `;
    
    document.body.appendChild(toast);
    
    // 3 saniye sonra kaldır
    setTimeout(() => {
        toast.style.opacity = '0';
        toast.style.transition = 'opacity 0.3s ease';
        setTimeout(() => toast.remove(), 300);
    }, 3000);
}

// SMS Bakiye Bildirimi Modal
@if(session('sms_warning'))
document.addEventListener('DOMContentLoaded', function() {
    const smsModal = new bootstrap.Modal(document.getElementById('smsBalanceModal'));
    smsModal.show();
});

function closeSmsBalanceModal() {
    const smsModal = bootstrap.Modal.getInstance(document.getElementById('smsBalanceModal'));
    if (smsModal) {
        smsModal.hide();
    }
}
@endif
</script>

@push('styles')
<style>
    /* İşlem Butonları - Modern ve Güzel Tasarım */
    .btn-action {
        min-width: 38px;
        height: 38px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: 10px;
        border: none;
        font-size: 14px;
        font-weight: 600;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        position: relative;
        overflow: hidden;
    }
    
    .btn-action::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.3);
        transform: translate(-50%, -50%);
        transition: width 0.6s, height 0.6s;
    }
    
    .btn-action:hover::before {
        width: 300px;
        height: 300px;
    }
    
    .btn-action:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }
    
    .btn-action:active {
        transform: translateY(0);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
    }
    
    .btn-action-info {
        background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
        color: white;
    }
    
    .btn-action-info:hover {
        background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
        color: white;
    }
    
    .btn-action-warning {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        color: white;
    }
    
    .btn-action-warning:hover {
        background: linear-gradient(135deg, #d97706 0%, #b45309 100%);
        color: white;
    }
    
    .btn-action-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
    }
    
    .btn-action-success:hover {
        background: linear-gradient(135deg, #059669 0%, #047857 100%);
        color: white;
    }
    
    .btn-action-danger {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: white;
    }
    
    .btn-action-danger:hover {
        background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
        color: white;
    }
    
    /* Hızlı İşlemler Modal Butonları */
    .btn-quick-action {
        padding: 16px 24px;
        border-radius: 12px;
        border: none;
        font-size: 16px;
        font-weight: 600;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        position: relative;
        overflow: hidden;
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .btn-quick-action::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.2);
        transform: translate(-50%, -50%);
        transition: width 0.6s, height 0.6s;
    }
    
    .btn-quick-action:hover::before {
        width: 400px;
        height: 400px;
    }
    
    .btn-quick-action:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    }
    
    .btn-quick-action:active {
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }
    
    .btn-quick-payment {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    }
    
    .btn-quick-payment:hover {
        background: linear-gradient(135deg, #059669 0%, #047857 100%);
    }
    
    .btn-quick-duplicate {
        background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    }
    
    .btn-quick-duplicate:hover {
        background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
    }
    
    .btn-quick-status {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    }
    
    .btn-quick-status:hover {
        background: linear-gradient(135deg, #d97706 0%, #b45309 100%);
    }
    
    .btn-quick-call {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    }
    
    .btn-quick-call:hover {
        background: linear-gradient(135deg, #059669 0%, #047857 100%);
    }
    
    .btn-quick-whatsapp {
        background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
    }
    
    .btn-quick-whatsapp:hover {
        background: linear-gradient(135deg, #128C7E 0%, #075E54 100%);
    }
    
    /* Mobil Görünüm */
    @media (max-width: 768px) {
        .btn-action {
            min-width: 36px;
            height: 36px;
            font-size: 13px;
        }
        
        .btn-action.flex-fill {
            min-width: auto;
            flex: 1;
        }
        
        .btn-quick-action {
            padding: 14px 20px;
            font-size: 15px;
        }
    }
</style>
@endpush

@push('scripts')
<script>
// Modal script yüklendikten sonra openNewReservation'ı güncelle
(function() {
    // Modal script yüklendikten sonra çalış
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initOpenNewReservation);
    } else {
        // DOM zaten yüklendi, biraz bekle (modal script'i yüklenene kadar)
        setTimeout(initOpenNewReservation, 500);
    }
    
    function initOpenNewReservation() {
        
        window.openNewReservation = function() {
            return; 
        };
    }
})();

// Bekleyen Talepler Modal JavaScript
document.addEventListener('DOMContentLoaded', function() {
    const pendingModal = document.getElementById('pendingRequestsModal');
    if (pendingModal) {
        pendingModal.addEventListener('show.bs.modal', function() {
            loadPendingRequests();
        });
    }
});

function loadPendingRequests() {
    fetch('{{ route("admin.beauty-salon.appointment-requests.index") }}', {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(async response => {
        const contentType = response.headers.get('content-type');
        if (!response.ok) {
            throw new Error('HTTP ' + response.status);
        }
        if (contentType && contentType.includes('application/json')) {
            return response.json();
        } else {
            // HTML döndüyse hata oluştu demektir
            const text = await response.text();
            throw new Error('Beklenmeyen response formatı');
        }
    })
    .then(data => {
        const tbody = document.getElementById('pendingRequestsTableBody');
        
        if (data.requests && data.requests.length > 0) {
            // Performans optimizasyonu: DocumentFragment kullan
            const fragment = document.createDocumentFragment();
            const rows = data.requests.map(request => {
                // Service HTML'i ayrı oluştur
                let serviceHtml = '<span class="text-muted">-</span>';
                if (request.service) {
                    const servicePrice = parseFloat(request.service.price).toLocaleString('tr-TR', {minimumFractionDigits: 2});
                    serviceHtml = '<span class="badge bg-primary">' + request.service.name + '</span>' +
                                  '<br><small class="text-muted">' + servicePrice + ' ₺</small>';
                }
                
                // Customer HTML'i ayrı oluştur
                const customerHtml = request.customer ? '<br><small class="text-muted">Kayıtlı Müşteri</small>' : '';
                
                // Date HTML'i ayrı oluştur
                const createdDate = new Date(request.created_at).toLocaleDateString('tr-TR');
                const createdTime = new Date(request.created_at).toLocaleTimeString('tr-TR', {hour: '2-digit', minute: '2-digit'});
                
                const row = document.createElement('tr');
                row.innerHTML = 
                    '<td>' +
                        (request.name || '') + ' ' + (request.surname || '') + customerHtml +
                    '</td>' +
                    '<td>' + (request.phone || '') + '</td>' +
                    '<td>' + serviceHtml + '</td>' +
                    '<td><small>' + createdDate + ' ' + createdTime + '</small></td>' +
                    '<td>' +
                        '<div class="btn-group" role="group">' +
                            '<button class="btn btn-sm btn-primary" onclick="showRequestDetail(' + request.id + ')">' +
                                '<i class="bi bi-eye"></i> İncele' +
                            '</button>' +
                            '<button class="btn btn-sm btn-danger" onclick="rejectAppointmentRequest(' + request.id + ')">' +
                                '<i class="bi bi-x-circle"></i> İptal Et' +
                            '</button>' +
                        '</div>' +
                    '</td>';
                return row;
            });
            
            rows.forEach(row => fragment.appendChild(row));
            tbody.innerHTML = '';
            tbody.appendChild(fragment);
        } else {
            tbody.innerHTML = '<tr><td colspan="5" class="text-center py-4 text-muted">Bekleyen randevu talebi bulunmamaktadır.</td></tr>';
        }
    })
    .catch(error => {
        console.error('Hata:', error);
        document.getElementById('pendingRequestsTableBody').innerHTML = 
            '<tr><td colspan="5" class="text-center py-4 text-danger">Talepler yüklenirken bir hata oluştu.</td></tr>';
    });
}

// Müşteri Portföyü Detay Modal
function showCustomerPortfolio(customerId) {
    // Modal içeriğini temizle
    document.getElementById('customerPortfolioContent').innerHTML = '<div class="text-center py-5"><div class="spinner-border text-primary" role="status"></div><p class="mt-3">Yükleniyor...</p></div>';
    
    // Modal'ı aç
    const modal = new bootstrap.Modal(document.getElementById('customerPortfolioModal'));
    modal.show();
    
    // Detayları yükle
    const portfolioUrlBase = '{{ route("admin.beauty-salon.appointment-requests.customer-portfolio", ["customerId" => ":customerId"]) }}';
    const portfolioUrl = portfolioUrlBase.replace(':customerId', customerId);
    
    fetch(portfolioUrl, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => {
        if (!response.ok) throw new Error('HTTP ' + response.status);
        return response.json();
    })
    .then(data => {
        // Müşteri bilgileri
        let customerInfo = `
            <div class="card shadow-sm mb-4" style="border-radius: 12px; border: none;">
                <div class="card-header" style="background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); border-radius: 12px 12px 0 0; padding: 16px;">
                    <div class="d-flex align-items-center">
                        <div class="customer-avatar me-3" style="width: 50px; height: 50px; border-radius: 50%; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 20px;">
                            ${data.customer.name ? data.customer.name.charAt(0).toUpperCase() : 'M'}
                        </div>
                        <div>
                            <h5 class="mb-0 text-white fw-bold">${data.customer.name} ${data.customer.surname || ''}</h5>
                            <small class="text-white opacity-75">
                                ${data.customer.phone ? '<i class="bi bi-telephone me-1"></i>' + data.customer.phone : ''}
                                ${data.customer.age ? '<span class="ms-2"><i class="bi bi-calendar3 me-1"></i>' + data.customer.age + ' yaş</span>' : ''}
                            </small>
                        </div>
                    </div>
                </div>
                <div class="card-body p-3">
                    <div class="row text-center">
                        <div class="col-4">
                            <div class="mb-2">
                                <small class="text-muted d-block" style="font-size: 0.75rem;">Toplam Randevu</small>
                                <strong style="font-size: 1.2rem; color: #8b5cf6;">${data.statistics.total}</strong>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="mb-2">
                                <small class="text-muted d-block" style="font-size: 0.75rem;">Tamamlanan</small>
                                <strong style="font-size: 1.2rem; color: #10b981;">${data.statistics.completed}</strong>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="mb-2">
                                <small class="text-muted d-block" style="font-size: 0.75rem;">Toplam Harcama</small>
                                <strong style="font-size: 1.2rem; color: #ec4899;">${parseFloat(data.statistics.total_spent).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2})} ₺</strong>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        // Randevu listesi
        let reservationsList = '';
        if (data.reservations && data.reservations.length > 0) {
            reservationsList = `
                <div class="card shadow-sm" style="border-radius: 12px; border: none;">
                    <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">
                        <h6 class="mb-0 text-white fw-bold" style="font-size: 0.95rem;">
                            <i class="bi bi-clock-history me-2"></i>Tüm Randevular (${data.reservations.length})
                        </h6>
                    </div>
                    <div class="card-body p-3">
                        <div style="max-height: 400px; overflow-y: auto;">
                            ${data.reservations.map(reservation => {
                                const date = new Date(reservation.date);
                                const formattedDate = date.toLocaleDateString('tr-TR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                                
                                // Performans optimizasyonu: status badge'i önceden belirle
                                let statusBadge = '';
                                if (reservation.status === 'completed') {
                                    statusBadge = '<span class="badge bg-success" style="font-size: 0.7rem;">Tamamlandı</span>';
                                } else if (reservation.status === 'confirmed') {
                                    statusBadge = '<span class="badge bg-primary" style="font-size: 0.7rem;">Onaylandı</span>';
                                } else if (reservation.status === 'cancelled') {
                                    statusBadge = '<span class="badge bg-danger" style="font-size: 0.7rem;">İptal</span>';
                                } else {
                                    statusBadge = '<span class="badge bg-secondary" style="font-size: 0.7rem;">' + reservation.status + '</span>';
                                }
                                
                                const price = parseFloat(reservation.total_price || 0).toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2});
                                
                                return `
                                    <div class="reservation-item mb-3 p-3 rounded" style="background: #f8fafc; border-left: 4px solid #ec4899;">
                                        <div class="d-flex justify-content-between align-items-start mb-2">
                                            <div style="flex: 1;">
                                                <strong class="d-block" style="font-size: 0.9rem;">${formattedDate} ${reservation.start_time}</strong>
                                                <small class="text-muted d-block mt-1" style="font-size: 0.8rem;">
                                                    ${reservation.personel_name ? '<i class="bi bi-person me-1"></i>' + reservation.personel_name : ''}
                                                    ${reservation.service_name ? '<span class="ms-2"><i class="bi bi-scissors me-1"></i>' + reservation.service_name + '</span>' : ''}
                                                    ${reservation.room_name ? '<span class="ms-2"><i class="bi bi-door-open me-1"></i>' + reservation.room_name + '</span>' : ''}
                                                </small>
                                            </div>
                                            <div class="text-end">
                                                ${statusBadge}
                                                <div class="mt-2">
                                                    <strong class="text-success" style="font-size: 0.85rem;">${price} ₺</strong>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                `;
                            }).join('')}
                        </div>
                    </div>
                </div>
            `;
        } else {
            reservationsList = `
                <div class="card shadow-sm" style="border-radius: 12px; border: none;">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-info-circle" style="font-size: 48px; color: #cbd5e1;"></i>
                        <p class="text-muted mt-3 mb-0">Henüz randevu geçmişi yok</p>
                    </div>
                </div>
            `;
        }
        
        document.getElementById('customerPortfolioContent').innerHTML = customerInfo + reservationsList;
    })
    .catch(error => {
        console.error('Hata:', error);
        document.getElementById('customerPortfolioContent').innerHTML = `
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle me-2"></i>Müşteri portföyü yüklenirken bir hata oluştu: ${error.message}
            </div>
        `;
    });
}

function showRequestDetail(requestId) {
    // Modal içeriğini temizle
    document.getElementById('requestDetailContent').innerHTML = '<div class="text-center py-5"><div class="spinner-border text-primary" role="status"></div><p class="mt-3">Yükleniyor...</p></div>';
    
    // Modal'ı aç
    const modal = new bootstrap.Modal(document.getElementById('requestDetailModal'));
    modal.show();
    
    // Detayları yükle
    const showUrlBase = '{{ route("admin.beauty-salon.appointment-requests.show", ["id" => ":id"]) }}';
    const showUrl = showUrlBase.replace(':id', requestId);
    
    fetch(showUrl, {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'text/html'
        }
    })
    .then(response => {
        if (!response.ok) throw new Error('HTTP ' + response.status);
        return response.text();
    })
    .then(html => {
        // HTML'i parse et
        const parser = new DOMParser();
        const doc = parser.parseFromString(html, 'text/html');
        const containerElement = doc.querySelector('.container-fluid');
        
        if (!containerElement) {
            document.getElementById('requestDetailContent').innerHTML = '<div class="alert alert-danger">İçerik bulunamadı!</div>';
            return;
        }
        
        // Tüm içeriği modal'a ekle (row ve tüm kartlar dahil)
        document.getElementById('requestDetailContent').innerHTML = containerElement.innerHTML;
        
        // Form submit event'ini ekle
        const form = document.querySelector('#requestDetailContent form#approveRequestForm');
        if (form) {
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                // Saat ve dakika kontrolü
                const hourSelect = document.getElementById('appointment_hour');
                const minuteSelect = document.getElementById('appointment_minute');
                const timeInput = document.getElementById('appointment_time');
                
                if (hourSelect && minuteSelect && timeInput) {
                    if (!hourSelect.value || !minuteSelect.value) {
                        alert('Lütfen saat ve dakika seçiniz.');
                        return false;
                    }
                    timeInput.value = hourSelect.value + ':' + minuteSelect.value;
                }
                
                // Form validasyonu
                if (!form.checkValidity()) {
                    form.reportValidity();
                    return false;
                }
                
                // Onayla
                approveRequest(requestId, form);
                return false;
            });
            
            // Saat/dakika seçim sistemini başlat
            setTimeout(function() {
                const hourSelect = document.getElementById('appointment_hour');
                const minuteSelect = document.getElementById('appointment_minute');
                const timeInput = document.getElementById('appointment_time');
                
                function updateTime() {
                    if (hourSelect && minuteSelect && timeInput) {
                        if (hourSelect.value && minuteSelect.value) {
                            timeInput.value = hourSelect.value + ':' + minuteSelect.value;
                        }
                    }
                }
                
                if (hourSelect) {
                    hourSelect.addEventListener('change', updateTime);
                }
                if (minuteSelect) {
                    minuteSelect.addEventListener('change', updateTime);
                }
            }, 300);
        }
    })
    .catch(error => {
        console.error('Hata:', error);
        document.getElementById('requestDetailContent').innerHTML = '<div class="alert alert-danger">Randevu talebi yüklenirken bir hata oluştu: ' + error.message + '</div>';
    });
}

function approveRequest(requestId, form) {
    const submitButton = form.querySelector('button[type="submit"]');
    const originalButtonText = submitButton ? submitButton.innerHTML : '';
    
    
    if (submitButton) {
        submitButton.disabled = true;
        submitButton.innerHTML = '<i class="bi bi-hourglass-split me-2"></i>Onaylanıyor...';
    }
    
    // FormData oluştur
    const formData = new FormData(form);
    
    // URL oluştur
    const approveUrlBase = '{{ route("admin.beauty-salon.appointment-requests.approve", ["id" => ":id"]) }}';
    const approveUrl = approveUrlBase.replace(':id', requestId);
    
    // AJAX isteği gönder
    fetch(approveUrl, {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
            'Accept': 'application/json'
        }
    })
    .then(async response => {
        const contentType = response.headers.get('content-type');
        
        if (contentType && contentType.includes('application/json')) {
            const data = await response.json();
            if (!response.ok) {
                throw new Error(data.message || 'HTTP ' + response.status);
            }
            return data;
        }
        
        if (!response.ok) {
            const text = await response.text();
            throw new Error('HTTP ' + response.status);
        }
        
        return { success: true, reload: true };
    })
    .then(data => {
        // Butonu tekrar aktif et
        if (submitButton) {
            submitButton.disabled = false;
            submitButton.innerHTML = originalButtonText;
        }
        
        // Modal'ları kapat
        const detailModal = bootstrap.Modal.getInstance(document.getElementById('requestDetailModal'));
        const pendingModal = bootstrap.Modal.getInstance(document.getElementById('pendingRequestsModal'));
        if (detailModal) detailModal.hide();
        if (pendingModal) pendingModal.hide();
        
        // Başarı mesajı
        showSuccessMessage(data.message || 'Randevu talebi başarıyla onaylandı!');
        
        // Sayfayı yenile
        setTimeout(() => window.location.reload(), 1000);
    })
    .catch(error => {
        console.error('Onaylama hatası:', error);
        
        // Butonu tekrar aktif et
        if (submitButton) {
            submitButton.disabled = false;
            submitButton.innerHTML = originalButtonText;
        }
        
        // Hata mesajı
        showErrorMessage(error.message || 'Randevu onaylanırken bir hata oluştu.');
    });
}


// Randevu Talebini İptal Et
async function rejectAppointmentRequest(requestId) {
    const confirmed = await customConfirm('Bu randevu talebini iptal etmek istediğinize emin misiniz?');
    if (!confirmed) return;
    
    const rejectUrlBase = '{{ route("admin.beauty-salon.appointment-requests.reject", ["id" => ":id"]) }}';
    const rejectUrl = rejectUrlBase.replace(':id', requestId);
    
    fetch(rejectUrl, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(async response => {
        const contentType = response.headers.get('content-type');
        if (!response.ok) {
            if (contentType && contentType.includes('application/json')) {
                const err = await response.json();
                throw new Error(err.message || err.error || 'HTTP ' + response.status);
            } else {
                const text = await response.text();
                throw new Error('HTTP ' + response.status + ': ' + text.substring(0, 100));
            }
        }
        if (contentType && contentType.includes('application/json')) {
            return response.json();
        } else {
            throw new Error('Beklenmeyen response formatı');
        }
    })
    .then(data => {
        if (data.success) {
            if (typeof showSuccessMessage === 'function') {
                showSuccessMessage('Randevu talebi başarıyla iptal edildi!');
            } else {
                alert('Randevu talebi başarıyla iptal edildi!');
            }
            
            // Modal'ları kapat
            const detailModal = bootstrap.Modal.getInstance(document.getElementById('requestDetailModal'));
            const pendingModal = bootstrap.Modal.getInstance(document.getElementById('pendingRequestsModal'));
            if (detailModal) detailModal.hide();
            if (pendingModal) pendingModal.hide();
            
            // Listeyi yenile
            setTimeout(() => {
                loadPendingRequests();
                location.reload();
            }, 1000);
        } else {
            if (typeof showErrorMessage === 'function') {
                showErrorMessage(data.message || 'Hata oluştu');
            } else {
                alert(data.message || 'Hata oluştu');
            }
        }
    })
    .catch(error => {
        console.error('Randevu talebi iptal hatası:', error);
        const errorMsg = error.message || 'Randevu talebi iptal edilirken bir hata oluştu.';
        if (typeof showErrorMessage === 'function') {
            showErrorMessage(errorMsg);
        } else {
            alert(errorMsg);
        }
    });
}

// ============================================
// HIZLI İŞLEMLER - YENİ ÖZELLİKLER
// ============================================

// Hızlı İşlemler Modal'ını Göster
function showQuickActionsModal(reservationId, totalPrice, depositPaid, status, customerPhone) {
    const modal = document.getElementById('quickActionsModal');
    const content = document.getElementById('quickActionsContent');
    
    let html = `
        <div class="d-grid gap-3">
            <button type="button" class="btn btn-quick-action btn-quick-payment" onclick="quickPayment(${reservationId}, ${totalPrice}, ${depositPaid}); bootstrap.Modal.getInstance(document.getElementById('quickActionsModal')).hide();">
                <i class="bi bi-cash-coin me-2"></i>Hızlı Ödeme Al
            </button>
            <button type="button" class="btn btn-quick-action btn-quick-duplicate" onclick="duplicateReservation(${reservationId}); bootstrap.Modal.getInstance(document.getElementById('quickActionsModal')).hide();">
                <i class="bi bi-files me-2"></i>Randevuyu Tekrarla
            </button>
            <button type="button" class="btn btn-quick-action" style="background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); color: white;" onclick="openRecurringSessionModal(${reservationId}); bootstrap.Modal.getInstance(document.getElementById('quickActionsModal')).hide();">
                <i class="bi bi-calendar-repeat me-2"></i>Tekrarlanan Seans
            </button>
            <button type="button" class="btn btn-quick-action btn-quick-status" onclick="quickStatusChange(${reservationId}, '${status}'); bootstrap.Modal.getInstance(document.getElementById('quickActionsModal')).hide();">
                <i class="bi bi-arrow-repeat me-2"></i>Durum Değiştir
            </button>
    `;
    
    if (customerPhone) {
        // Telefon numarasını temizle ve +90 ekle
        let cleanPhone = customerPhone.replace(/[\s\(\)\-]/g, '');
        
        // Eğer 0 ile başlıyorsa 0'ı kaldır
        if (cleanPhone.startsWith('0')) {
            cleanPhone = cleanPhone.substring(1);
        }
        
        // Eğer +90 ile başlamıyorsa +90 ekle
        if (!cleanPhone.startsWith('+90') && !cleanPhone.startsWith('90')) {
            cleanPhone = '90' + cleanPhone;
        } else if (cleanPhone.startsWith('90') && !cleanPhone.startsWith('+90')) {
            cleanPhone = '+' + cleanPhone;
        }
        
        html += `
            <hr class="my-3" style="border-color: #e5e7eb;">
            <button type="button" class="btn btn-quick-action btn-quick-call" onclick="window.location.href='tel:${customerPhone}';">
                <i class="bi bi-telephone me-2"></i>Ara
            </button>
            <button type="button" class="btn btn-quick-action btn-quick-whatsapp" onclick="window.open('https://wa.me/${cleanPhone}', '_blank');">
                <i class="bi bi-whatsapp me-2"></i>WhatsApp
            </button>
        `;
    }
    
    html += `</div>`;
    content.innerHTML = html;
    
    const bsModal = new bootstrap.Modal(modal);
    bsModal.show();
}

// Hızlı Randevu Oluştur
function quickCreateReservation() {
    // Yeni randevu modalını aç
    const modal = document.getElementById('newReservationModal');
    const form = document.getElementById('newReservationForm');
    const loading = document.getElementById('newReservationLoading');
    const customerSelect = document.getElementById('modal_customer_id');
    
    // Loading göster, formu gizle
    loading.style.display = 'block';
    form.style.display = 'none';
    
    // Müşterileri yükle
    fetch('{{ route("admin.customers.search") }}?q=', {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        customerSelect.innerHTML = '<option value="">Seçiniz</option>';
        if (data && data.length > 0) {
            data.forEach(customer => {
                const option = document.createElement('option');
                option.value = customer.id;
                option.textContent = customer.name + (customer.phone ? ' (' + customer.phone + ')' : '');
                customerSelect.appendChild(option);
            });
        }
        loading.style.display = 'none';
        form.style.display = 'block';
    })
    .catch(error => {
        console.error('Müşteriler yüklenemedi:', error);
        // Fallback: Sayfaya yönlendir
        window.location.href = '{{ route("admin.appointments.create") }}';
    });
    
    const bsModal = new bootstrap.Modal(modal);
    bsModal.show();
    
    // Modal kapatıldığında formu sıfırla
    modal.addEventListener('hidden.bs.modal', function() {
        form.reset();
        customerSelect.innerHTML = '<option value="">Seçiniz</option>';
        loading.style.display = 'block';
        form.style.display = 'none';
    }, { once: true });
}

// Hızlı Ödeme Alma
async function quickPayment(reservationId, totalPrice, depositPaid) {
    const remaining = parseFloat(totalPrice) - parseFloat(depositPaid || 0);
    
    if (remaining <= 0) {
        showSuccessMessage('Bu randevu için ödenecek tutar kalmamış.');
        return;
    }
    
    const paymentAmount = await showPaymentModal(remaining, totalPrice, depositPaid);
    if (!paymentAmount || paymentAmount <= 0) return;
    
    // Ödeme işlemini yap
    const url = '{{ route("admin.appointments.update-status", ["id" => ":id"]) }}'.replace(':id', reservationId);
    
    fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        },
        body: JSON.stringify({
            status: 'confirmed',
            mark_paid: true,
            payment_amount: paymentAmount
        })
    })
    .then(async response => {
        if (!response.ok) {
            const err = await response.json().catch(() => ({}));
            throw new Error(err.message || 'Ödeme alınamadı');
        }
        return response.json();
    })
    .then(data => {
        if (data.success) {
            showSuccessMessage('Ödeme başarıyla kaydedildi!');
            setTimeout(() => location.reload(), 1000);
        } else {
            showErrorMessage(data.message || 'Ödeme kaydedilemedi');
        }
    })
    .catch(error => {
        console.error('Ödeme hatası:', error);
        showErrorMessage(error.message || 'Ödeme işlemi sırasında bir hata oluştu');
    });
}

// Ödeme Modal
function showPaymentModal(remaining, totalPrice, depositPaid) {
    return new Promise((resolve) => {
        const modal = document.createElement('div');
        modal.className = 'modal fade';
        modal.id = 'quickPaymentModal';
        modal.innerHTML = `
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">
                        <h5 class="modal-title text-white fw-bold">
                            <i class="bi bi-cash-coin me-2"></i>Hızlı Ödeme Al
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body p-4">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Toplam Tutar</label>
                            <div class="form-control bg-light" style="font-size: 1.2rem; font-weight: bold;">
                                ${formatPrice(totalPrice)} ₺
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Alınan Kapora</label>
                            <div class="form-control bg-light">
                                ${formatPrice(depositPaid || 0)} ₺
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Kalan Tutar</label>
                            <div class="form-control bg-light text-danger" style="font-size: 1.1rem; font-weight: bold;">
                                ${formatPrice(remaining)} ₺
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Ödeme Tutarı <span class="text-danger">*</span></label>
                            <input type="number" id="paymentAmount" class="form-control form-control-lg" 
                                   step="0.01" min="0" max="${remaining}" value="${remaining}" 
                                   style="font-size: 1.2rem; font-weight: bold;">
                            <div class="d-flex gap-2 mt-2">
                                <button type="button" class="btn btn-sm btn-outline-primary" onclick="document.getElementById('paymentAmount').value = '${remaining}'">
                                    Tamamını Al
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="document.getElementById('paymentAmount').value = (${remaining} / 2).toFixed(2)">
                                    Yarısını Al
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                        <button type="button" class="btn btn-success" onclick="confirmQuickPayment()">
                            <i class="bi bi-check-circle me-2"></i>Ödemeyi Al
                        </button>
                    </div>
                </div>
            </div>
        `;
        
        document.body.appendChild(modal);
        const bsModal = new bootstrap.Modal(modal);
        
        window.confirmQuickPayment = function() {
            const amount = parseFloat(document.getElementById('paymentAmount').value);
            if (amount <= 0 || amount > remaining) {
                alert('Geçerli bir tutar giriniz.');
                return;
            }
            bsModal.hide();
            setTimeout(() => modal.remove(), 300);
            resolve(amount);
        };
        
        modal.addEventListener('hidden.bs.modal', function() {
            if (!window.confirmQuickPayment) {
                resolve(null);
            }
            setTimeout(() => modal.remove(), 300);
        });
        
        bsModal.show();
    });
}

// Randevuyu Tekrarla
async function duplicateReservation(reservationId) {
    const confirmed = await customConfirm('Bu randevuyu tekrar oluşturmak istediğinize emin misiniz?');
    if (!confirmed) return;
    
    // Randevu bilgilerini al
    fetch('{{ route("admin.appointments.show", ["id" => ":id"]) }}'.replace(':id', reservationId), {
        headers: {
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data && data.reservation) {
            // Yeni randevu oluştur sayfasına git, bilgileri query string ile gönder
            const params = new URLSearchParams({
                customer_id: data.reservation.customer_id || '',
                salon_id: data.reservation.salon_id || data.reservation.beauty_salon_id || '',
                personel_id: data.reservation.personel_id || '',
                service_id: data.service_id || '',
                duplicate: '1'
            });
            
            window.location.href = '{{ route("admin.appointments.create") }}?' + params.toString();
        } else {
            showErrorMessage('Randevu bilgileri alınamadı');
        }
    })
    .catch(error => {
        console.error('Hata:', error);
        showErrorMessage('Randevu bilgileri alınırken bir hata oluştu');
    });
}

// Hızlı Durum Değiştirme
async function quickStatusChange(reservationId, currentStatus) {
    const statuses = [
        { value: 'pending', label: 'Bekleyen', icon: 'bi-clock-history', color: 'warning' },
        { value: 'confirmed', label: 'Onaylandı', icon: 'bi-check-circle', color: 'info' },
        { value: 'open', label: 'Açık', icon: 'bi-clock', color: 'primary' },
        { value: 'completed', label: 'Tamamlandı', icon: 'bi-check-circle-fill', color: 'success' },
        { value: 'cancelled', label: 'İptal', icon: 'bi-x-circle', color: 'danger' }
    ];
    
    const availableStatuses = statuses.filter(s => s.value !== currentStatus);
    
    if (availableStatuses.length === 0) {
        showSuccessMessage('Değiştirilebilecek durum yok.');
        return;
    }
    
    // Durum seçim modalı
    const modal = document.createElement('div');
    modal.className = 'modal fade';
    modal.id = 'quickStatusModal';
    modal.innerHTML = `
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);">
                    <h5 class="modal-title text-white fw-bold">
                        <i class="bi bi-arrow-repeat me-2"></i>Durum Değiştir
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Mevcut Durum</label>
                        <div class="badge bg-${statuses.find(s => s.value === currentStatus)?.color || 'secondary'} p-2" style="font-size: 0.9rem;">
                            ${statuses.find(s => s.value === currentStatus)?.label || currentStatus}
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-bold">Yeni Durum Seçin</label>
                        <div class="d-grid gap-2">
                            ${availableStatuses.map(status => `
                                <button type="button" class="btn btn-outline-${status.color} text-start" onclick="selectStatus('${status.value}')">
                                    <i class="bi ${status.icon} me-2"></i>${status.label}
                                </button>
                            `).join('')}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `;
    
    document.body.appendChild(modal);
    const bsModal = new bootstrap.Modal(modal);
    
    window.selectStatus = async function(newStatus) {
        bsModal.hide();
        setTimeout(() => modal.remove(), 300);
        
        const confirmed = await customConfirm(`Randevu durumunu "${statuses.find(s => s.value === newStatus)?.label}" olarak değiştirmek istediğinize emin misiniz?`);
        if (!confirmed) return;
        
        const url = '{{ route("admin.appointments.update-status", ["id" => ":id"]) }}'.replace(':id', reservationId);
        
        fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || '',
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            },
            body: JSON.stringify({ status: newStatus })
        })
        .then(async response => {
            if (!response.ok) {
                const err = await response.json().catch(() => ({}));
                throw new Error(err.message || 'Durum değiştirilemedi');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                showSuccessMessage('Durum başarıyla değiştirildi!');
                setTimeout(() => location.reload(), 1000);
            } else {
                showErrorMessage(data.message || 'Durum değiştirilemedi');
            }
        })
        .catch(error => {
            console.error('Durum değiştirme hatası:', error);
            showErrorMessage(error.message || 'Durum değiştirilirken bir hata oluştu');
        });
    };
    
    modal.addEventListener('hidden.bs.modal', function() {
        setTimeout(() => modal.remove(), 300);
    });
    
    bsModal.show();
}

// Hızlı SMS Gönder

// Müşteri Arama (Autocomplete)
let customerSearchTimeout;
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('customerSearchInput');
    const resultsDiv = document.getElementById('customerSearchResults');
    
    if (searchInput && resultsDiv) {
        searchInput.addEventListener('input', function() {
            clearTimeout(customerSearchTimeout);
            const query = this.value.trim();
            
            if (query.length < 2) {
                resultsDiv.style.display = 'none';
                return;
            }
            
            customerSearchTimeout = setTimeout(() => {
                fetch('{{ route("admin.customers.ajax-search") }}?q=' + encodeURIComponent(query), {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(customers => {
                    if (customers.length === 0) {
                        resultsDiv.innerHTML = '<div class="p-3 text-muted text-center">Müşteri bulunamadı</div>';
                    } else {
                        resultsDiv.innerHTML = customers.map(customer => `
                            <div class="p-2 border-bottom cursor-pointer customer-search-item" 
                                 onclick="selectCustomer('${customer.name}', '${customer.phone || ''}')"
                                 style="cursor: pointer; transition: background 0.2s;"
                                 onmouseover="this.style.background='#f8f9fa'"
                                 onmouseout="this.style.background='white'">
                                <div class="d-flex align-items-center gap-2">
                                    <div class="customer-avatar" style="background: ${customer.avatar_color || '#ec4899'};">
                                        ${customer.initials || '??'}
                                    </div>
                                    <div>
                                        <div class="fw-bold">${customer.name}</div>
                                        ${customer.phone ? `<small class="text-muted">${customer.phone}</small>` : ''}
                                    </div>
                                </div>
                            </div>
                        `).join('');
                    }
                    resultsDiv.style.display = 'block';
                })
                .catch(error => {
                    console.error('Arama hatası:', error);
                    resultsDiv.style.display = 'none';
                });
            }, 300);
        });
        
        // Dışarı tıklanınca kapat
        document.addEventListener('click', function(e) {
            if (!searchInput.contains(e.target) && !resultsDiv.contains(e.target)) {
                resultsDiv.style.display = 'none';
            }
        });
    }
});

function selectCustomer(name, phone) {
    document.getElementById('customerSearchInput').value = name;
    document.getElementById('customerSearchResults').style.display = 'none';
    // Formu submit et
    document.querySelector('form[method="GET"]').submit();
}

// Excel'e Aktar
function exportAppointments() {
    const params = new URLSearchParams(window.location.search);
    params.set('export', 'excel');
    window.location.href = '{{ route("admin.appointments.index") }}?' + params.toString();
}

// Klavye Kısayolları
document.addEventListener('keydown', function(e) {
    // Ctrl+N - Yeni Randevu
    if (e.ctrlKey && e.key === 'n') {
        e.preventDefault();
        quickCreateReservation();
    }
    
    // Ctrl+F - Arama
    if (e.ctrlKey && e.key === 'f') {
        e.preventDefault();
        const searchInput = document.getElementById('customerSearchInput');
        if (searchInput) {
            searchInput.focus();
        }
    }
});

// Tekrarlanan Seans Modal'ını Aç
function openRecurringSessionModal(reservationId) {
    const modal = new bootstrap.Modal(document.getElementById('recurringSessionModal'));
    document.getElementById('recurring_reservation_id').value = reservationId;
    
    // Randevu bilgilerini al ve başlangıç tarihini ayarla
    fetch('{{ route("admin.appointments.show", ["id" => ":id"]) }}'.replace(':id', reservationId), {
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.reservation) {
            const reservation = data.reservation;
            const reservationDate = new Date(reservation.date);
            
            // Başlangıç tarihini ayarla (bugünden itibaren)
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            const startDateInput = document.getElementById('recurring_start_date');
            if (startDateInput) {
                startDateInput.min = today.toISOString().split('T')[0];
                startDateInput.value = today.toISOString().split('T')[0];
            }
            
            // Ayın gününü otomatik seç (eğer aylık seçilirse)
            const dayOfMonth = reservationDate.getDate();
            const dayOfMonthSelect = document.getElementById('day_of_month');
            if (dayOfMonthSelect) {
                dayOfMonthSelect.value = dayOfMonth;
            }
            
            // Haftanın gününü otomatik seç (eğer haftalık seçilirse)
            const dayOfWeek = reservationDate.getDay() === 0 ? 7 : reservationDate.getDay(); // Pazar = 7
            const dayOfWeekSelect = document.getElementById('day_of_week');
            if (dayOfWeekSelect) {
                dayOfWeekSelect.value = dayOfWeek;
            }
        }
    })
    .catch(error => {
        console.error('Randevu bilgileri alınamadı:', error);
    });
    
    modal.show();
}

// Tekrarlama tipi değiştiğinde
document.addEventListener('DOMContentLoaded', function() {
    const recurringTypeSelect = document.getElementById('recurring_type');
    if (recurringTypeSelect) {
        recurringTypeSelect.addEventListener('change', function() {
            const type = this.value;
            const dayOfMonthContainer = document.getElementById('day_of_month_container');
            const dayOfWeekContainer = document.getElementById('day_of_week_container');
            
            if (type === 'monthly') {
                dayOfMonthContainer.style.display = 'block';
                dayOfWeekContainer.style.display = 'none';
                document.getElementById('day_of_week').required = false;
                document.getElementById('day_of_month').required = true;
            } else if (type === 'weekly') {
                dayOfMonthContainer.style.display = 'none';
                dayOfWeekContainer.style.display = 'block';
                document.getElementById('day_of_month').required = false;
                document.getElementById('day_of_week').required = true;
            } else {
                dayOfMonthContainer.style.display = 'none';
                dayOfWeekContainer.style.display = 'none';
                document.getElementById('day_of_month').required = false;
                document.getElementById('day_of_week').required = false;
            }
        });
    }
    
    // Tekrarlanan Seans Form Submit
    const recurringForm = document.getElementById('recurringSessionForm');
    if (recurringForm) {
        recurringForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const data = {
                reservation_id: formData.get('reservation_id'),
                recurring_type: formData.get('recurring_type'),
                day_of_month: formData.get('day_of_month'),
                day_of_week: formData.get('day_of_week'),
                recurring_count: parseInt(formData.get('recurring_count')),
                start_date: formData.get('start_date'),
            };
            
            // Validasyon
            if (!data.recurring_type) {
                alert('Lütfen tekrarlama tipini seçiniz.');
                return;
            }
            
            if (data.recurring_type === 'monthly' && !data.day_of_month) {
                alert('Lütfen ayın gününü seçiniz.');
                return;
            }
            
            if (data.recurring_type === 'weekly' && !data.day_of_week) {
                alert('Lütfen haftanın gününü seçiniz.');
                return;
            }
            
            if (!data.start_date) {
                alert('Lütfen başlangıç tarihini seçiniz.');
                return;
            }
            
            // Loading göster
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Oluşturuluyor...';
            
            // API'ye gönder
            fetch('{{ route("admin.appointments.recurring.create") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    showSuccessMessage('Tekrarlanan seanslar başarıyla oluşturuldu!');
                    bootstrap.Modal.getInstance(document.getElementById('recurringSessionModal')).hide();
                    // Sayfayı yenile
                    setTimeout(() => {
                        window.location.reload();
                    }, 1000);
                } else {
                    showErrorMessage(result.message || 'Tekrarlanan seanslar oluşturulurken bir hata oluştu.');
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalText;
                }
            })
            .catch(error => {
                console.error('Hata:', error);
                showErrorMessage('Tekrarlanan seanslar oluşturulurken bir hata oluştu.');
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            });
        });
    }
});
</script>
@endpush
@endsection
