<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Yeni Randevu - Salonay</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-user-select: none;
            -webkit-tap-highlight-color: transparent;
        }
        input, textarea, select {
            -webkit-user-select: text;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f5f5f5;
            padding: 15px;
            padding-bottom: 80px;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 15px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .header h1 {
            font-size: 20px;
            font-weight: 600;
        }
        .back-btn {
            background: rgba(255,255,255,0.2);
            border: none;
            color: white;
            padding: 8px 15px;
            border-radius: 8px;
            cursor: pointer;
        }
        .card {
            background: white;
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .card-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 15px;
            color: #333;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-label {
            display: block;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 8px;
            color: #555;
        }
        .form-control, .form-select {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        .form-control:focus, .form-select:focus {
            outline: none;
            border-color: #667eea;
        }
        .btn-primary {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            margin-top: 10px;
        }
        .btn-primary:active {
            transform: scale(0.98);
        }
        .btn-secondary {
            width: 100%;
            padding: 14px;
            background: #e0e0e0;
            color: #333;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            cursor: pointer;
            margin-top: 10px;
        }
        .error-message {
            background: #fee;
            color: #c33;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 15px;
            font-size: 14px;
            display: none;
        }
        .error-message.show {
            display: block;
        }
        .row {
            display: flex;
            gap: 10px;
        }
        .col-6 {
            flex: 1;
        }
        .total-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 15px;
            margin-top: 20px;
        }
        .total-box .label {
            font-size: 14px;
            opacity: 0.9;
        }
        .total-box .amount {
            font-size: 28px;
            font-weight: bold;
            margin-top: 5px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><i class="bi bi-calendar-plus"></i> Yeni Randevu</h1>
        <button class="back-btn" onclick="window.history.back()">
            <i class="bi bi-arrow-left"></i> Geri
        </button>
    </div>

    <div class="error-message" id="errorMessage"></div>

    <form id="reservationForm" method="POST" action="{{ route('mobile.appointments.store') }}">
        @csrf
        
        <div class="card">
            <div class="card-title">Müşteri ve Salon</div>
            <div class="form-group">
                <label class="form-label">Müşteri <span style="color: red;">*</span></label>
                <select name="customer_id" id="customer_id" class="form-select" required>
                    <option value="">Müşteri Seçiniz</option>
                    @foreach($customers as $customer)
                        <option value="{{ $customer->id }}">{{ $customer->name }} @if($customer->phone)({{ $customer->phone }})@endif</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label class="form-label">Salon <span style="color: red;">*</span></label>
                <select name="salon_id" id="salon_id" class="form-select" required>
                    <option value="">Salon Seçiniz</option>
                    @foreach($salons as $salon)
                        <option value="{{ $salon->id }}">{{ $salon->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="card">
            <div class="card-title">Tarih ve Saat</div>
            <div class="form-group">
                <label class="form-label">Tarih <span style="color: red;">*</span></label>
                <input type="date" name="date" id="reservation_date" class="form-control" 
                       value="{{ date('Y-m-d') }}" min="{{ date('Y-m-d') }}" required>
            </div>
            <div class="row">
                <div class="col-6">
                    <div class="form-group">
                        <label class="form-label">Başlangıç <span style="color: red;">*</span></label>
                        <input type="time" name="start_time" id="start_time" class="form-control" required>
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label class="form-label">Bitiş <span style="color: red;">*</span></label>
                        <input type="time" name="end_time" id="end_time" class="form-control" required>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-title">Detaylar</div>
            <div class="form-group">
                <label class="form-label">Misafir Sayısı <span style="color: red;">*</span></label>
                <input type="number" name="guest_count" id="guest_count" class="form-control" 
                       value="1" min="1" required>
            </div>
            <div class="form-group">
                <label class="form-label">Durum <span style="color: red;">*</span></label>
                <select name="status" id="status" class="form-select" required>
                    <option value="open">Açık</option>
                    <option value="confirmed">Onaylandı</option>
                    <option value="completed">Tamamlandı</option>
                </select>
            </div>
        </div>

        <div class="card">
            <div class="card-title">Fiyatlandırma</div>
            <div class="form-group">
                <label class="form-label">Salon Ücreti (₺) <span style="color: red;">*</span></label>
                <input type="number" step="0.01" name="salon_price" id="salon_price" 
                       class="form-control" value="0" min="0" required>
            </div>
            <div class="form-group">
                <label class="form-label">Organizasyon Ücreti (₺)</label>
                <input type="number" step="0.01" name="organization_price" id="organization_price" 
                       class="form-control" value="0" min="0">
            </div>
            <div class="form-group">
                <label class="form-label">Ödenen Kapora (₺)</label>
                <input type="number" step="0.01" name="deposit_paid" id="deposit_paid" 
                       class="form-control" value="0" min="0">
            </div>
        </div>

        <div class="card">
            <div class="card-title">Notlar</div>
            <div class="form-group">
                <textarea name="notes" id="notes" class="form-control" rows="4" 
                          placeholder="Randevu ile ilgili notlar..."></textarea>
            </div>
        </div>

        <div class="total-box">
            <div class="label">TOPLAM TUTAR</div>
            <div class="amount" id="totalAmount">0.00 ₺</div>
        </div>

        <input type="hidden" name="total_price" id="hiddenTotalPrice" value="0">
        <input type="hidden" name="items_data" id="hiddenItemsData" value="">

        <button type="submit" class="btn-primary">Randevuu Kaydet</button>
        <button type="button" class="btn-secondary" onclick="window.history.back()">İptal</button>
    </form>

    <script>
        function calculateTotal() {
            const salonPrice = parseFloat(document.getElementById('salon_price').value) || 0;
            const orgPrice = parseFloat(document.getElementById('organization_price').value) || 0;
            const total = salonPrice + orgPrice;
            
            // Fiyat formatla (binlik ayırıcı nokta, ondalık virgül)
            function formatPrice(amount) {
                const parts = amount.toFixed(2).split('.');
                const integerPart = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                return integerPart + ',' + parts[1];
            }
            document.getElementById('totalAmount').textContent = formatPrice(total) + ' ₺';
            document.getElementById('hiddenTotalPrice').value = total;
        }

        document.getElementById('salon_price').addEventListener('input', calculateTotal);
        document.getElementById('organization_price').addEventListener('input', calculateTotal);

        document.getElementById('reservationForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const errorMsg = document.getElementById('errorMessage');
            errorMsg.classList.remove('show');
            
            const formData = new FormData(this);
            
            fetch(this.action, {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
                },
                body: formData
            })
            .then(async response => {
                const contentType = response.headers.get('content-type');
                if (contentType && contentType.includes('application/json')) {
                    return response.json();
                } else {
                    const text = await response.text();
                    throw new Error('Form hatası');
                }
            })
            .then(data => {
                if (data.success || data.redirect) {
                    if (window.NativeBridge) {
                        window.NativeBridge.postMessage('reservation_created');
                    }
                    window.location.href = data.redirect || '/admin/randevular';
                } else {
                    errorMsg.textContent = data.message || (data.errors ? Object.values(data.errors).flat().join(', ') : 'Bir hata oluştu');
                    errorMsg.classList.add('show');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                errorMsg.textContent = 'Randevu kaydedilirken bir hata oluştu. Lütfen tekrar deneyin.';
                errorMsg.classList.add('show');
            });
        });

        calculateTotal();
    </script>
</body>
</html>
