@extends('layouts.admin')

@section('title', 'Açıktaki Randevular')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="#">Randevu İşlemleri</a></li>
    <li class="breadcrumb-item active">Açıktaki Randevular</li>
@endsection

@section('content')
    <h2 class="mb-4">Açıktaki Randevular</h2>
    
    <div class="card">
        <div class="card-header border-0" style="background: linear-gradient(135deg, #f472b6 0%, #ec4899 100%);">
            <h5 class="mb-0 text-white">Randevu Listesi</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Randevu Kodu</th>
                            <th>Müşteri Adı</th>
                            <th>Tarih/Saat</th>
                            <th>Salon</th>
                            <th>Toplam Tutar</th>
                            <th>Kalan Bakiye</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($appointments as $reservation)
                            <tr>
                                <td>{{ $reservation->code }}</td>
                                <td>{{ $reservation->customer->name }}</td>
                                <td>{{ $reservation->date->format('d.m.Y') }} {{ $reservation->start_time }}</td>
                                <td>{{ $reservation->salon->name }}</td>
                                <td>{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</td>
                                <td>{{ number_format($reservation->remaining_amount, 2, ',', '.') }} ₺</td>
                                <td>
                                    <button type="button" onclick="openReservationDetailModal({{ $reservation->id }})" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </button>
                                    <a href="{{ route('admin.appointments.edit', $reservation->id) }}" class="btn btn-sm btn-warning">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center">Açık randevu bulunamadı.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-3">
                {{ $appointments->links() }}
            </div>
        </div>
    </div>
@endsection

