<!-- Yeni Randevu Popup Modal -->
<style>
#newReservationModal .modal-dialog {
    max-width: 95%;
    margin: 1.75rem auto;
}

#newReservationModal .modal-content {
    border-radius: 16px;
    border: none;
    box-shadow: 0 20px 60px rgba(0,0,0,0.3);
}

#newReservationModal .modal-header {
    background: white;
    border-radius: 16px 16px 0 0;
    padding: 1.5rem 1.75rem;
    border-bottom: 2px solid #e5e7eb;
}

#newReservationModal .modal-header .modal-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: white !important;
    text-shadow: none;
}

#newReservationModal .section-header {
    background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
    color: white;
    padding: 0.625rem 1rem;
    border-radius: 8px;
    margin-bottom: 0.75rem;
    font-weight: 600;
    font-size: 0.875rem;
    box-shadow: 0 4px 8px rgba(99, 102, 241, 0.2);
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

#newReservationModal .section-header i {
    font-size: 1rem;
}

#newReservationModal .modal-body {
    max-height: calc(100vh - 200px);
    overflow-y: auto;
    overflow-x: hidden;
}

#newReservationModal .modal-body .row {
    align-items: flex-start;
}

#newReservationModal .modal-body .col-lg-4 {
    position: sticky;
    top: 20px;
    align-self: flex-start;
    height: fit-content;
    max-height: calc(100vh - 220px);
    overflow-y: visible;
}

#newReservationModal .price-summary-card {
    background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    border-radius: 12px;
    padding: 0.75rem;
    box-shadow: 0 8px 24px rgba(245, 158, 11, 0.2);
    border: 2px solid #fbbf24;
    font-size: 0.75rem;
}

#newReservationModal .price-summary-card h5 {
    color: #92400e;
    font-weight: 700;
    font-size: 0.875rem;
    margin-bottom: 0.5rem;
    text-shadow: 0 1px 2px rgba(0,0,0,0.1);
}

#newReservationModal .price-summary-card .form-label {
    font-size: 0.7rem;
    margin-bottom: 0.2rem;
    font-weight: 600;
}

#newReservationModal .price-summary-card .form-control {
    border-radius: 6px;
    border: 2px solid #fbbf24;
    font-size: 0.7rem;
    padding: 0.3rem 0.4rem;
    height: auto;
}

#newReservationModal .price-summary-card .form-control:focus {
    border-color: #f59e0b;
    box-shadow: 0 0 0 0.15rem rgba(245, 158, 11, 0.25);
}

#newReservationModal .price-summary-card hr {
    margin: 0.4rem 0;
}

#newReservationModal .price-summary-card .d-flex.justify-content-between {
    font-size: 0.7rem;
    margin-bottom: 0.3rem;
}

#newReservationModal .price-summary-card .fs-5 {
    font-size: 0.875rem !important;
}

#newReservationModal .price-summary-card .btn {
    font-size: 0.7rem;
    padding: 0.4rem 0.6rem;
}

#newReservationModal .price-summary-card .btn-lg {
    font-size: 0.75rem;
    padding: 0.5rem 0.75rem;
}

@media (max-width: 991px) {
    /* Mobil görünümde modal düzeltmeleri */
    #newReservationModal .modal-dialog {
        margin: 0.5rem auto !important;
        max-width: 98% !important;
        max-height: 98vh !important;
    }
    
    #newReservationModal .modal-content {
        max-height: 98vh !important;
        display: flex !important;
        flex-direction: column !important;
    }
    
    #newReservationModal .modal-header {
        flex-shrink: 0 !important;
        padding: 1rem 1.25rem !important;
    }
    
    #newReservationModal .modal-header .modal-title {
        font-size: 1.25rem !important;
        color: white !important;
    }
    
    #newReservationModal .modal-body {
        flex: 1 1 auto !important;
        overflow-y: auto !important;
        overflow-x: hidden !important;
        max-height: calc(98vh - 140px) !important;
        -webkit-overflow-scrolling: touch !important;
        padding: 1rem !important;
    }
    
    #newReservationModal .modal-body .row {
        flex-direction: column !important;
    }
    
    #newReservationModal .modal-body .col-lg-4 {
        position: relative !important;
        top: 0 !important;
        max-height: none !important;
        margin-bottom: 1rem !important;
    }
    
    #newReservationModal .modal-body .col-lg-8 {
        width: 100% !important;
    }
    
    #newReservationModal .price-summary-card {
        max-height: none !important;
        overflow-y: visible !important;
        position: relative !important;
    }
    
    #newReservationModal .modal-footer {
        flex-shrink: 0 !important;
        padding: 1rem 1.25rem !important;
        flex-wrap: wrap !important;
    }
    
    #newReservationModal .modal-footer .btn {
        flex: 1 1 auto !important;
        min-width: 120px !important;
        margin: 0.25rem !important;
    }
    
    /* Form elementleri mobilde daha büyük */
    #newReservationModal .form-control,
    #newReservationModal .form-select {
        font-size: 16px !important; /* iOS zoom önleme */
        padding: 0.75rem !important;
        min-height: 44px !important;
    }
    
    #newReservationModal .form-label {
        font-size: 0.875rem !important;
        margin-bottom: 0.5rem !important;
    }
    
    #newReservationModal .section-header {
        font-size: 0.875rem !important;
        padding: 0.75rem 1rem !important;
    }
    
    /* Form elementleri kesinlikle tıklanabilir */
    #newReservationModal input,
    #newReservationModal select,
    #newReservationModal textarea,
    #newReservationModal button,
    #newReservationModal a {
        touch-action: manipulation !important; /* Mobil double-tap zoom'u engelle */
    }
    
    /* Close butonu mobilde daha büyük ve tıklanabilir */
    #newReservationModal .btn-close {
        width: 2rem !important;
        height: 2rem !important;
        opacity: 1 !important;
        z-index: 1060 !important;
        position: relative !important;
    }
}

/* Daha küçük ekranlar için ek düzeltmeler */
@media (max-width: 576px) {
    #newReservationModal .modal-dialog {
        margin: 0.25rem auto !important;
        max-width: 100% !important;
        height: 100vh !important;
        max-height: 100vh !important;
    }
    
    #newReservationModal .modal-content {
        height: 100vh !important;
        max-height: 100vh !important;
        border-radius: 0 !important;
    }
    
    #newReservationModal .modal-body {
        max-height: calc(100vh - 120px) !important;
        padding: 1rem !important;
    }
    
    #newReservationModal .modal-header {
        padding: 1rem !important;
        border-radius: 0 !important;
    }
}

.meal-item-row, .extra-item-check, .org-item-row {
    transition: all 0.3s ease;
    background: white;
    font-size: 0.8125rem;
}

.meal-item-row .form-label,
.org-item-row .form-label {
    font-size: 0.75rem;
    margin-bottom: 0.2rem;
}

.meal-item-row .form-control,
.meal-item-row .form-select,
.org-item-row .form-control {
    font-size: 0.8125rem;
    padding: 0.25rem 0.5rem;
    height: auto;
}

.extra-item-check strong {
    font-size: 0.8125rem;
}

.extra-item-check .badge {
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
}

.meal-item-card:hover, .org-item-card:hover {
    background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    border-color: #f59e0b !important;
}

.extra-item-card {
    transition: all 0.2s ease;
    background: white;
}

.extra-item-card:hover {
    background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
    border-color: #3b82f6 !important;
    box-shadow: 0 2px 8px rgba(52, 211, 153, 0.2);
}

.extra-item-card input:checked + label {
    color: #2563eb;
    font-weight: 600;
}

.extra-item-card input:checked ~ label .badge {
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%) !important;
}

.extra-manual-card {
    transition: all 0.3s ease;
    background: white;
}

.extra-manual-card:hover {
    background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
    border-color: #3b82f6 !important;
    box-shadow: 0 2px 8px rgba(52, 211, 153, 0.2);
}

/* Sol kolon genel font ayarları */
#newReservationModal .col-lg-8 {
    font-size: 0.875rem;
}

#newReservationModal .col-lg-8 .card {
    margin-bottom: 0.75rem;
}

#newReservationModal .col-lg-8 .card-body {
    padding: 0.875rem;
}

#newReservationModal .col-lg-8 .form-label {
    font-size: 0.8125rem;
    margin-bottom: 0.25rem;
    font-weight: 600;
}

#newReservationModal .col-lg-8 .form-control,
#newReservationModal .col-lg-8 .form-select {
    font-size: 0.8125rem;
    padding: 0.375rem 0.5rem;
    height: auto;
}

#newReservationModal .col-lg-8 .btn-sm {
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
}

#newReservationModal .col-lg-8 .alert {
    font-size: 0.8125rem;
    padding: 0.5rem 0.75rem;
    margin-top: 0.5rem;
}

.time-slot-select {
    min-height: auto;
}


/* Modal Efektleri - Sadece gölgelendirme ve görsel iyileştirmeler */
#newReservationModal .modal-content {
    /* Animasyon yok, sadece gölge */
}

#newReservationModal .card {
    transition: all 0.3s ease;
    border: 1px solid transparent;
}

#newReservationModal .card:hover {
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
    border-color: #e5e7eb;
}

#newReservationModal .form-control,
#newReservationModal .form-select {
    transition: all 0.3s ease;
}

#newReservationModal .form-control:focus,
#newReservationModal .form-select:focus {
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.15);
}

#newReservationModal .btn {
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

#newReservationModal .btn::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
    transform: translate(-50%, -50%);
    transition: width 0.6s, height 0.6s;
}

#newReservationModal .btn:hover::before {
    width: 300px;
    height: 300px;
}

#newReservationModal .btn:hover {
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
}

/* Loading spinner */
.spin {
    animation: spin 1s linear infinite;
    display: inline-block;
}

@keyframes spin {
    from {
        transform: rotate(0deg);
    }
    to {
        transform: rotate(360deg);
    }
}

</style>

<div class="modal fade" id="newReservationModal" tabindex="-1" aria-labelledby="newReservationModalLabel" aria-hidden="true" data-bs-backdrop="static">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="newReservationModalLabel">
                    <i class="bi bi-calendar-plus"></i> Yeni Randevu Oluştur
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="newReservationForm" method="POST" action="{{ route('admin.appointments.store') }}">
                @csrf
                <input type="hidden" name="total_price" id="hiddenTotalPrice" value="0">
                <input type="hidden" name="items_data" id="hiddenItemsData" value="">
                
                <div class="modal-body" style="padding: 1.5rem;">
                    <div class="row">
                        <!-- Sol Kolon -->
                        <div class="col-lg-8">
                            <!-- Müşteri ve Salon -->
                            <div class="section-header">
                                <i class="bi bi-person"></i> Müşteri ve Salon Bilgileri
                            </div>
                            <div class="card shadow-sm mb-3">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-2">
                                            <label class="form-label fw-bold">Müşteri <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <select name="customer_id" id="newResCustomerId" class="form-select" required style="font-size: 0.875rem;">
                                                    <option value="">  Müşteri Seçiniz  </option>
                                                    @php
                                                        $customers = \App\Models\Customer::query();
                                                        if(auth()->check() && (auth()->user()->role === 'randevucu' || auth()->user()->role === 'admin')) {
                                                            $customers->where('created_by', auth()->id());
                                                        }
                                                        $customers = $customers->orderBy('name', 'ASC')->limit(20)->get();
                                                    @endphp
                                                    @foreach($customers as $customer)
                                                        <option value="{{ $customer->id }}">
                                                            {{ $customer->name }}@if($customer->phone) ({{ $customer->phone }})@endif
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <button type="button" class="btn btn-outline-primary" onclick="window.openNewCustomerModal()" title="Yeni Müşteri Ekle">
                                                    <i class="bi bi-person-plus"></i>
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 mb-2">
                                            <label class="form-label fw-bold">Salon <span class="text-danger">*</span></label>
                                            <select name="salon_id" id="newResSalonId" class="form-select" required>
                                                @php
                                                    $salons = \App\Models\Salon::where('is_active', true);
                                                    if(auth()->check() && (auth()->user()->role === 'randevucu' || auth()->user()->role === 'admin')) {
                                                        $salons->where('created_by', auth()->id());
                                                    }
                                                    $salons = $salons->get();
                                                    $salonCount = $salons->count();
                                                    $selectedSalonId = $salonCount == 1 ? $salons->first()->id : null;
                                                @endphp
                                                @if($salonCount > 1)
                                                    <option value="">Salon Seçiniz</option>
                                                @endif
                                                @foreach($salons as $salon)
                                                    <option value="{{ $salon->id }}" {{ $selectedSalonId == $salon->id ? 'selected' : '' }}>
                                                        {{ $salon->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <!-- Düğün referansları kaldırıldı -->
                                </div>
                            </div>

                            <!-- Tarih ve Saat -->
                            <div class="section-header">
                                <i class="bi bi-calendar-event"></i> Tarih ve Saat
                            </div>
                            <div class="card shadow-sm mb-3">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4 mb-2">
                                            <label class="form-label fw-bold">Tarih <span class="text-danger">*</span></label>
                                            <input type="date" name="date" id="newResDate" class="form-control" 
                                                   value="{{ date('Y-m-d') }}" min="{{ date('Y-m-d') }}" required>
                                        </div>
                                        
                                        <div class="col-md-4 mb-2">
                                            <label class="form-label fw-bold">Başlangıç Saati <span class="text-danger">*</span></label>
                                            <select name="start_time" id="newResStartTime" class="form-select time-slot-select" required>
                                                <option value="">Başlangıç Saati Seçin</option>
                                            </select>
                                        </div>
                                        
                                        <div class="col-md-4 mb-2">
                                            <label class="form-label fw-bold">Bitiş Saati <span class="text-danger">*</span></label>
                                            <select name="end_time" id="newResEndTime" class="form-select time-slot-select" required>
                                                <option value="">Bitiş Saati Seçin</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="alert alert-info mb-0" id="newResTimeCheckResult" style="display: none;">
                                        <i class="bi bi-info-circle"></i> <span id="newResTimeCheckMessage"></span>
                                    </div>
                                </div>
                            </div>

                            <!-- Yemekler -->
                            <div class="section-header">
                                <i class="bi bi-cup-hot"></i> Yemekler
                            </div>
                            <div class="card shadow-sm mb-3">
                                <div class="card-body">
                                    <div id="newResMealsContainer">
                                        <div class="meal-item-row p-2 border rounded mb-2 meal-item-card">
                                            <div class="row align-items-end">
                                                <div class="col-md-4 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Yemek Adı</label>
                                                    <input type="text" class="form-control meal-name" 
                                                           data-meal-index="0" placeholder="Yemek adı yazın">
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Miktar</label>
                                                    <input type="number" class="form-control meal-quantity" 
                                                           value="1" min="1" data-meal-index="0" placeholder="Adet">
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Birim Fiyat</label>
                                                    <input type="number" step="0.01" class="form-control meal-price" 
                                                           value="0" min="0" data-meal-index="0" placeholder="0.00">
                                                </div>
                                                <div class="col-md-3 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Toplam</label>
                                                    <input type="text" class="form-control meal-total" 
                                                           value="0.00 ₺" readonly data-meal-index="0" style="font-weight: 600; color: #2563eb;">
                                                </div>
                                                <div class="col-md-1 mb-2">
                                                    <label class="form-label d-block">&nbsp;</label>
                                                    <button type="button" class="btn btn-sm btn-danger remove-meal-btn">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-success" id="newResAddMealBtn">
                                        <i class="bi bi-plus-circle"></i> Yemek Ekle
                                    </button>
                                </div>
                            </div>

                            <!-- Organizasyon -->
                            <div class="section-header">
                                <i class="bi bi-gift"></i> Organizasyon
                            </div>
                            <div class="card shadow-sm mb-3">
                                <div class="card-body">
                                    <div id="newResOrganizationsContainer">
                                        <div class="org-item-row p-2 border rounded mb-2 org-item-card">
                                            <div class="row align-items-end">
                                                <div class="col-md-5 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Organizasyon Adı</label>
                                                    <input type="text" class="form-control org-name" data-org-index="0" placeholder="Örn: Organizasyon Adı">
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Adet</label>
                                                    <input type="number" class="form-control org-quantity" data-org-index="0" value="1" min="1">
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Birim Fiyat</label>
                                                    <input type="number" step="0.01" class="form-control org-price" data-org-index="0" value="0" min="0" placeholder="0.00">
                                                </div>
                                                <div class="col-md-2 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Toplam</label>
                                                    <input type="text" class="form-control org-total" data-org-index="0" value="0.00 ₺" readonly style="font-weight: 600; color: #2563eb;">
                                                </div>
                                                <div class="col-md-1 mb-2">
                                                    <label class="form-label d-block">&nbsp;</label>
                                                    <button type="button" class="btn btn-sm btn-danger remove-org-btn">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-success" id="newResAddOrgBtn">
                                        <i class="bi bi-plus-circle"></i> Organizasyon Ekle
                                    </button>
                                </div>
                            </div>

                            <!-- Ekstra Hizmetler -->
                            <div class="section-header">
                                <i class="bi bi-star"></i> Ekstra Hizmetler
                            </div>
                            <div class="card shadow-sm mb-3">
                                <div class="card-body">
                                    <!-- Hazır Ekstralar (Checkbox) -->
                                    @php
                                        $extras = \App\Models\Extra::where('is_active', true)->orderBy('name')->get();
                                    @endphp
                                    @if($extras->count() > 0)
                                    <div id="newResExtrasCheckboxContainer" class="mb-3">
                                        @foreach($extras as $index => $extra)
                                        <div class="extra-item-check form-check p-2 border rounded mb-2 extra-item-card">
                                            <input class="form-check-input extra-checkbox" type="checkbox" 
                                                   value="{{ $extra->id }}" 
                                                   id="newResExtra_{{ $extra->id }}"
                                                   data-price="{{ $extra->price }}"
                                                   data-name="{{ $extra->name }}">
                                            <label class="form-check-label w-100" for="newResExtra_{{ $extra->id }}">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <strong class="d-block mb-1">{{ $extra->name }}</strong>
                                                        @if($extra->description)
                                                            <small class="text-muted">{{ $extra->description }}</small>
                                                        @endif
                                                    </div>
                                                    <span class="badge bg-primary px-3 py-2" style="font-size: 0.95rem;">{{ number_format($extra->price, 2, ',', '.') }} ₺</span>
                                                </div>
                                            </label>
                                        </div>
                                        @endforeach
                                    </div>
                                    @endif
                                    
                                    <!-- Manuel Eklenebilir Ekstralar -->
                                    <div id="newResExtrasContainer">
                                        <div class="extra-item-row p-2 border rounded mb-2 extra-manual-card">
                                            <div class="row align-items-end">
                                                <div class="col-md-6 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Ekstra Adı</label>
                                                    <input type="text" class="form-control extra-name" data-extra-index="0" placeholder="Örn: Fotoğraf Çekimi">
                                                </div>
                                                <div class="col-md-5 mb-2">
                                                    <label class="form-label fw-bold text-muted small">Fiyat (₺)</label>
                                                    <input type="number" step="0.01" class="form-control extra-price" data-extra-index="0" value="0" min="0" placeholder="0.00">
                                                </div>
                                                <div class="col-md-1 mb-2">
                                                    <label class="form-label d-block">&nbsp;</label>
                                                    <button type="button" class="btn btn-sm btn-danger remove-extra-btn">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-success" id="newResAddExtraBtn">
                                        <i class="bi bi-plus-circle"></i> Ekstra Ekle
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Sağ Kolon - Fiyatlandırma -->
                        <div class="col-lg-4">
                            <div class="price-summary-card shadow-sm">
                                <h5><i class="bi bi-calculator"></i> Fiyatlandırma</h5>
                                
                                <!-- Salon Ücreti -->
                                <div class="mb-1">
                                    <label class="form-label fw-bold">Salon Ücreti (₺) <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" id="newResSalonPrice" class="form-control" value="0" min="0" required>
                                </div>

                                <!-- Özet -->
                                <hr class="my-1">
                                <div class="mb-0 d-flex justify-content-between">
                                    <span>Salon Ücreti:</span>
                                    <strong id="newResSummarySalon">0.00 ₺</strong>
                                </div>
                                <div class="mb-0 d-flex justify-content-between">
                                    <span>Yemek Toplamı:</span>
                                    <strong id="newResSummaryMeals">0.00 ₺</strong>
                                </div>
                                <div class="mb-0 d-flex justify-content-between">
                                    <span>Organizasyon:</span>
                                    <strong id="newResSummaryOrg">0.00 ₺</strong>
                                </div>
                                <div class="mb-0 d-flex justify-content-between">
                                    <span>Ekstra Hizmetler:</span>
                                    <strong id="newResSummaryExtras">0.00 ₺</strong>
                                </div>
                                <hr class="my-1">
                                <div class="mb-1 d-flex justify-content-between">
                                    <span class="fs-5 fw-bold">TOPLAM:</span>
                                    <span class="fs-5 fw-bold text-primary" id="newResSummaryTotal">0.00 ₺</span>
                                </div>

                                <!-- Kapora -->
                                <div class="mb-1">
                                    <label class="form-label fw-bold">Ödenen Kapora (₺)</label>
                                    <input type="number" step="0.01" name="deposit_paid" id="newResDepositPaid" class="form-control" value="0" min="0">
                                </div>

                                <!-- Kalan Tutar -->
                                <div class="mb-1">
                                    <label class="form-label fw-bold">Kalan Tutar</label>
                                    <input type="text" id="newResRemainingAmount" class="form-control" value="0.00 ₺" readonly>
                                </div>

                                <!-- Butonlar -->
                                <div class="d-grid gap-1 mt-2">
                                    <button type="submit" class="btn btn-primary btn-lg">
                                        <i class="bi bi-check-circle"></i> Randevuu Kaydet
                                    </button>
                                    <button type="button" class="btn btn-success" id="newResCreateInvoiceBtn">
                                        <i class="bi bi-file-earmark-text"></i> Oluştur ve Faturala
                                    </button>
                                    <input type="hidden" name="create_invoice" id="newResCreateInvoice" value="0">
                                    
                                    <!-- Sözleşme Bilgisi -->
                                    @php
                                        $defaultContract = \App\Models\Contract::getDefaultForCompany(auth()->user()->company_id ?? null);
                                        $contractUrl = $defaultContract ? $defaultContract->public_url : '#';
                                    @endphp
                                    <div class="text-center mt-2" style="font-size: 0.625rem; color: #6b7280; line-height: 1.4;">
                                        Randevuu oluşturduğunuzda 
                                        @if($contractUrl != '#')
                                            <a href="{{ $contractUrl }}" target="_blank" style="color: #2563eb; text-decoration: underline; cursor: pointer;">Sözleşme</a>yi kabul etmiş olacaksınız.
                                        @else
                                            <span style="color: #2563eb; text-decoration: underline; cursor: pointer;">Sözleşme</span>yi kabul etmiş olacaksınız.
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
let newResMealCount = 1;
let newResOrgCount = 1;
let newResExtraCount = 1;

// Modal açıldığında
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('newReservationModal');
    if (modal) {
        // Modal açılmadan önce
        modal.addEventListener('show.bs.modal', function() {
            // Mobilde body scroll'u engelle
            if (window.innerWidth <= 991) {
                document.body.style.overflow = 'hidden';
                document.body.style.position = 'fixed';
                document.body.style.width = '100%';
            }
        });
        
        modal.addEventListener('shown.bs.modal', function() {
            // Z-index'leri garantile (mobil için)
            if (window.innerWidth <= 991) {
                const modalBackdrop = document.querySelector('.modal-backdrop');
                const modalDialog = modal.querySelector('.modal-dialog');
                const modalContent = modal.querySelector('.modal-content');
                
                // Backdrop ayarları
                if (modalBackdrop) {
                    modalBackdrop.style.zIndex = '1040';
                    modalBackdrop.style.pointerEvents = 'auto';
                }
                
                // Dialog ayarları - auto yap ki içerik tıklanabilsin
                if (modalDialog) {
                    modalDialog.style.zIndex = '1055';
                    modalDialog.style.pointerEvents = 'auto'; // Dialog ve içeriği tıklanabilir
                }
                
                // Content ayarları - içerik tıklanabilir olmalı
                if (modalContent) {
                    modalContent.style.zIndex = '1055';
                    modalContent.style.position = 'relative';
                    modalContent.style.pointerEvents = 'auto'; // İçerik tıklanabilir
                    modalContent.style.touchAction = 'pan-y'; // Mobil scroll için
                }
                
                // Modal body'yi tıklanabilir yap
                const modalBody = modal.querySelector('.modal-body');
                if (modalBody) {
                    modalBody.style.pointerEvents = 'auto';
                    modalBody.style.touchAction = 'pan-y';
                }
                
                // Header'ı tıklanabilir yap
                const modalHeader = modal.querySelector('.modal-header');
                if (modalHeader) {
                    modalHeader.style.pointerEvents = 'auto';
                }
                
                // Tüm form elementlerini tıklanabilir yap
                const formElements = modal.querySelectorAll('input, select, textarea, button, a');
                formElements.forEach(function(el) {
                    el.style.pointerEvents = 'auto';
                    el.style.touchAction = 'manipulation';
                });
            }
            
            generateNewResTimeOptions();
            calculateNewResTotal();
        });
        
        modal.addEventListener('hidden.bs.modal', function() {
            // Mobilde body scroll'u geri aç
            if (window.innerWidth <= 991) {
                document.body.style.overflow = '';
                document.body.style.position = '';
                document.body.style.width = '';
            }
            
            // Formu temizle
            document.getElementById('newReservationForm').reset();
            document.getElementById('newResMealsContainer').innerHTML = getInitialMealRow();
            document.getElementById('newResOrganizationsContainer').innerHTML = getInitialOrgRow();
            document.getElementById('newResExtrasContainer').innerHTML = getInitialExtraRow();
            newResMealCount = 1;
            newResOrgCount = 1;
            newResExtraCount = 1;
            calculateNewResTotal();
            
        });
    }
    
    
    // Yemek ekle
    const addMealBtn = document.getElementById('newResAddMealBtn');
    if (addMealBtn) {
        addMealBtn.addEventListener('click', function() {
            addNewResMealRow();
        });
    }
    
    // Organizasyon ekle
    const addOrgBtn = document.getElementById('newResAddOrgBtn');
    if (addOrgBtn) {
        addOrgBtn.addEventListener('click', function() {
            addNewResOrgRow();
        });
    }
    
    // Ekstra ekle
    const addExtraBtn = document.getElementById('newResAddExtraBtn');
    if (addExtraBtn) {
        addExtraBtn.addEventListener('click', function() {
            addNewResExtraRow();
        });
    }
    
    // Yemek sil
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-meal-btn')) {
            const mealRow = e.target.closest('.meal-item-row');
            if (mealRow) {
                mealRow.remove();
                calculateNewResTotal();
            }
        }
        
        // Organizasyon sil
        if (e.target.closest('.remove-org-btn')) {
            const orgRow = e.target.closest('.org-item-row');
            if (orgRow) {
                orgRow.remove();
                calculateNewResTotal();
            }
        }
        
        // Ekstra sil
        if (e.target.closest('.remove-extra-btn')) {
            const extraRow = e.target.closest('.extra-item-row');
            if (extraRow) {
                extraRow.remove();
                calculateNewResTotal();
            }
        }
    });
    
    // Yemek miktar değiştiğinde
    document.addEventListener('change', function(e) {
        if (e.target.classList.contains('meal-quantity')) {
            const index = e.target.dataset.mealIndex;
            updateMealTotal(index);
            calculateNewResTotal();
        }
        
        if (e.target.classList.contains('extra-checkbox')) {
            calculateNewResTotal();
        }
    });
    
    // Organizasyon input değişiklikleri
    document.addEventListener('input', function(e) {
        if (e.target.classList.contains('org-quantity') || e.target.classList.contains('org-price')) {
            const index = e.target.dataset.orgIndex;
            updateOrgTotal(index);
            calculateNewResTotal();
        }
        
        // Yemek fiyat ve miktar değişiklikleri
        if (e.target.classList.contains('meal-quantity') || e.target.classList.contains('meal-price')) {
            const index = e.target.dataset.mealIndex;
            updateMealTotal(index);
            calculateNewResTotal();
        }
        
        // Ekstra fiyat değişiklikleri
        if (e.target.classList.contains('extra-price')) {
            calculateNewResTotal();
        }
    });
    
    // Salon ücreti ve kapora
    ['newResSalonPrice', 'newResDepositPaid'].forEach(id => {
        const el = document.getElementById(id);
        if (el) {
            el.addEventListener('input', calculateNewResTotal);
        }
    });
    
    // Yemek miktar değişiklikleri için input event
    document.addEventListener('input', function(e) {
        if (e.target.classList.contains('meal-quantity')) {
            const index = e.target.dataset.mealIndex;
            updateMealTotal(index);
            calculateNewResTotal();
        }
    });
    
    // Tarih veya salon değiştiğinde saat seçeneklerini güncelle - Modal içinde çalışması için
    function setupNewResTimeListeners() {
        const newResDate = document.getElementById('newResDate');
        const newResSalonId = document.getElementById('newResSalonId');
        
        if (newResDate) {
            // Önceki listener'ı kaldır
            newResDate.removeEventListener('change', generateNewResTimeOptions);
            newResDate.removeEventListener('input', generateNewResTimeOptions);
            // Yeni listener'lar ekle
            newResDate.addEventListener('change', function() {
                console.log('📅 Yeni randevu tarihi değişti:', this.value);
                generateNewResTimeOptions();
            });
            newResDate.addEventListener('input', function() {
                if (this.value) {
                    console.log('📅 Yeni randevu tarihi input:', this.value);
                    generateNewResTimeOptions();
                }
            });
        }
        
        if (newResSalonId) {
            // Önceki listener'ı kaldır
            newResSalonId.removeEventListener('change', generateNewResTimeOptions);
            // Yeni listener ekle
            newResSalonId.addEventListener('change', function() {
                console.log('🏢 Yeni randevu salon değişti:', this.value);
                generateNewResTimeOptions();
            });
        }
        
        // Başlangıç saati değiştiğinde bitiş saatlerini güncelle
        const newResStartTime = document.getElementById('newResStartTime');
        if (newResStartTime) {
            newResStartTime.removeEventListener('change', updateNewResEndTimeOptions);
            newResStartTime.addEventListener('change', function() {
                console.log('⏰ Başlangıç saati değişti:', this.value);
                updateNewResEndTimeOptions();
                checkNewResTimeAvailability();
            });
        }
        
        const newResEndTime = document.getElementById('newResEndTime');
        if (newResEndTime) {
            newResEndTime.removeEventListener('change', checkNewResTimeAvailability);
            newResEndTime.addEventListener('change', function() {
                console.log('⏰ Bitiş saati değişti:', this.value);
                checkNewResTimeAvailability();
            });
        }
    }
    
    // İlk kurulum
    setupNewResTimeListeners();
    
    // Global event delegation (fallback)
    document.addEventListener('change', function(e) {
        if (e.target && (e.target.id === 'newResDate' || e.target.id === 'newResSalonId')) {
            console.log('🎯 Global delegation yakalandı:', e.target.id);
            setTimeout(generateNewResTimeOptions, 100);
        }
    }, true);
    
    // Faturala butonu
    const createInvoiceBtn = document.getElementById('newResCreateInvoiceBtn');
    if (createInvoiceBtn) {
        createInvoiceBtn.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Önce zorunlu alanları kontrol et - hangi kutu boşsa onun doldurulması istenir
            const customerId = document.getElementById('newResCustomerId')?.value;
            if (!customerId) {
                alert('Lütfen müşteri seçiniz.');
                document.getElementById('newResCustomerId')?.focus();
                document.getElementById('newResCustomerId')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            const salonId = document.getElementById('newResSalonId')?.value;
            if (!salonId) {
                alert('Lütfen salon seçiniz.');
                document.getElementById('newResSalonId')?.focus();
                document.getElementById('newResSalonId')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            const date = document.getElementById('newResDate')?.value;
            if (!date) {
                alert('Lütfen tarih seçiniz.');
                document.getElementById('newResDate')?.focus();
                document.getElementById('newResDate')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            const startTime = document.getElementById('newResStartTime')?.value;
            if (!startTime) {
                alert('Lütfen başlangıç saati seçiniz.');
                document.getElementById('newResStartTime')?.focus();
                document.getElementById('newResStartTime')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            const endTime = document.getElementById('newResEndTime')?.value;
            if (!endTime) {
                alert('Lütfen bitiş saati seçiniz.');
                document.getElementById('newResEndTime')?.focus();
                document.getElementById('newResEndTime')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            
            
            // Önce total price ve items data'yı set et
            const form = document.getElementById('newReservationForm');
            const salonPrice = parseFloat(document.getElementById('newResSalonPrice')?.value || 0);
            let mealTotal = 0;
            document.querySelectorAll('#newResMealsContainer .meal-item-row').forEach(row => {
                const quantity = parseFloat(row.querySelector('.meal-quantity')?.value || 0);
                const price = parseFloat(row.querySelector('.meal-price')?.value || 0);
                mealTotal += quantity * price;
            });
            let orgTotal = 0;
            document.querySelectorAll('#newResOrganizationsContainer .org-item-row').forEach(row => {
                const quantity = parseFloat(row.querySelector('.org-quantity')?.value || 0);
                const price = parseFloat(row.querySelector('.org-price')?.value || 0);
                orgTotal += quantity * price;
            });
            let extraTotal = 0;
            const checkboxContainer = document.getElementById('newResExtrasCheckboxContainer');
            if (checkboxContainer) {
                checkboxContainer.querySelectorAll('.extra-checkbox:checked').forEach(checkbox => {
                    extraTotal += parseFloat(checkbox.dataset.price || 0);
                });
            }
            document.querySelectorAll('#newResExtrasContainer .extra-item-row').forEach(row => {
                const price = parseFloat(row.querySelector('.extra-price')?.value || 0);
                extraTotal += price;
            });
            const totalPrice = salonPrice + mealTotal + orgTotal + extraTotal;
            
            if (totalPrice <= 0) {
                alert('Randevu oluşturmak için en az bir fiyat girişi yapmanız gerekmektedir.');
                return false;
            }
            
            document.getElementById('hiddenTotalPrice').value = totalPrice.toFixed(2);
            const itemsData = prepareNewResItemsData();
            document.getElementById('hiddenItemsData').value = JSON.stringify(itemsData);
            document.getElementById('newResCreateInvoice').value = '1';
            
            form.submit();
        });
    }
    
    // Form gönderimi
    const form = document.getElementById('newReservationForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            updateNewResSummary();
            
            // Zorunlu alanları kontrol et - hangi kutu boşsa onun doldurulması istenir
            const customerId = document.getElementById('newResCustomerId')?.value;
            if (!customerId) {
                alert('Lütfen müşteri seçiniz.');
                document.getElementById('newResCustomerId')?.focus();
                document.getElementById('newResCustomerId')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            const salonId = document.getElementById('newResSalonId')?.value;
            if (!salonId) {
                alert('Lütfen salon seçiniz.');
                document.getElementById('newResSalonId')?.focus();
                document.getElementById('newResSalonId')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            const date = document.getElementById('newResDate')?.value;
            if (!date) {
                alert('Lütfen tarih seçiniz.');
                document.getElementById('newResDate')?.focus();
                document.getElementById('newResDate')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            const startTime = document.getElementById('newResStartTime')?.value;
            if (!startTime) {
                alert('Lütfen başlangıç saati seçiniz.');
                document.getElementById('newResStartTime')?.focus();
                document.getElementById('newResStartTime')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            const endTime = document.getElementById('newResEndTime')?.value;
            if (!endTime) {
                alert('Lütfen bitiş saati seçiniz.');
                document.getElementById('newResEndTime')?.focus();
                document.getElementById('newResEndTime')?.scrollIntoView({ behavior: 'smooth', block: 'center' });
                return false;
            }
            
            
            
            if (!form.checkValidity()) {
                form.reportValidity();
                return false;
            }
            
            // Toplam fiyatı hesapla (summary'den değil, direkt hesapla)
            // Controller'da total_price = salon_price + meals + organizations + extras şeklinde hesaplanıyor
            // Bu yüzden total_price'a sadece salon_price'ı yazacağız, controller geri kalanını ekleyecek
            // Ancak controller koduna bakıldığında, total_price'a tüm toplamı yazıyor
            // O yüzden burada da tüm toplamı hesaplayıp yazacağız
            const salonPrice = parseFloat(document.getElementById('newResSalonPrice')?.value || 0);
            let mealTotal = 0;
            document.querySelectorAll('#newResMealsContainer .meal-item-row').forEach(row => {
                const quantity = parseFloat(row.querySelector('.meal-quantity')?.value || 0);
                const price = parseFloat(row.querySelector('.meal-price')?.value || 0);
                mealTotal += quantity * price;
            });
            let orgTotal = 0;
            document.querySelectorAll('#newResOrganizationsContainer .org-item-row').forEach(row => {
                const quantity = parseFloat(row.querySelector('.org-quantity')?.value || 0);
                const price = parseFloat(row.querySelector('.org-price')?.value || 0);
                orgTotal += quantity * price;
            });
            let extraTotal = 0;
            // Hazır ekstra checkbox'ları
            const checkboxContainer = document.getElementById('newResExtrasCheckboxContainer');
            if (checkboxContainer) {
                checkboxContainer.querySelectorAll('.extra-checkbox:checked').forEach(checkbox => {
                    extraTotal += parseFloat(checkbox.dataset.price || 0);
                });
            }
            // Manuel eklenen ekstralar
            document.querySelectorAll('#newResExtrasContainer .extra-item-row').forEach(row => {
                const price = parseFloat(row.querySelector('.extra-price')?.value || 0);
                extraTotal += price;
            });
            // Controller'da: totalPrice = reservationPrice + mealTotal + organizationTotal + extraTotal
            // reservationPrice burada salonPrice oluyor
            const totalPrice = salonPrice + mealTotal + orgTotal + extraTotal;
            
            // Fiyat kontrolü - Toplam fiyat 0'dan büyük olmalı
            if (totalPrice <= 0) {
                alert('Randevu oluşturmak için en az bir fiyat girişi yapmanız gerekmektedir. Lütfen salon ücreti, yemek, organizasyon veya ekstra fiyatlarından en az birini giriniz.');
                return false;
            }
            
            // Hidden input'lara değerleri yaz
            const hiddenTotalPrice = document.getElementById('hiddenTotalPrice');
            const hiddenItemsData = document.getElementById('hiddenItemsData');
            
            if (!hiddenTotalPrice || !hiddenItemsData) {
                alert('Form alanları bulunamadı. Sayfayı yenileyip tekrar deneyin.');
                return false;
            }
            
            hiddenTotalPrice.value = totalPrice.toFixed(2);
            
            // Items data'yı hazırla
            const itemsData = prepareNewResItemsData();
            hiddenItemsData.value = JSON.stringify(itemsData);
            
            // Değerlerin set edildiğini doğrula
            if (!hiddenTotalPrice.value || hiddenTotalPrice.value === '0') {
                alert('Toplam fiyat hesaplanamadı. Lütfen tekrar deneyin.');
                return false;
            }
            
            // Formu gönder
            form.submit();
        });
    }
});

function updateMealTotal(index) {
    const row = document.querySelector(`.meal-item-row .meal-name[data-meal-index="${index}"]`)?.closest('.meal-item-row');
    if (!row) return;
    
    const quantity = parseFloat(row.querySelector(`.meal-quantity[data-meal-index="${index}"]`)?.value || 0);
    const price = parseFloat(row.querySelector(`.meal-price[data-meal-index="${index}"]`)?.value || 0);
    const total = quantity * price;
    const totalInput = row.querySelector(`.meal-total[data-meal-index="${index}"]`);
    if (totalInput) {
        totalInput.value = formatPrice(total) + ' ₺';
    }
}

function updateOrgTotal(index) {
    const row = document.querySelector(`.org-item-row .org-name[data-org-index="${index}"]`)?.closest('.org-item-row');
    if (!row) return;
    
    const quantity = parseFloat(row.querySelector(`.org-quantity[data-org-index="${index}"]`)?.value || 0);
    const price = parseFloat(row.querySelector(`.org-price[data-org-index="${index}"]`)?.value || 0);
    const total = quantity * price;
    const totalInput = row.querySelector(`.org-total[data-org-index="${index}"]`);
    if (totalInput) {
        totalInput.value = formatPrice(total) + ' ₺';
    }
}

function getInitialMealRow() {
    return `
        <div class="meal-item-row p-2 border rounded mb-2 meal-item-card">
            <div class="row align-items-end">
                <div class="col-md-4 mb-2">
                    <label class="form-label fw-bold text-muted small">Yemek Adı</label>
                    <input type="text" class="form-control meal-name" data-meal-index="0" placeholder="Yemek adı yazın">
                </div>
                <div class="col-md-2 mb-2">
                    <label class="form-label fw-bold text-muted small">Miktar</label>
                    <input type="number" class="form-control meal-quantity" value="1" min="1" data-meal-index="0" placeholder="Adet">
                </div>
                <div class="col-md-2 mb-2">
                    <label class="form-label fw-bold text-muted small">Birim Fiyat</label>
                    <input type="number" step="0.01" class="form-control meal-price" value="0" min="0" data-meal-index="0" placeholder="0.00">
                </div>
                <div class="col-md-3 mb-2">
                    <label class="form-label fw-bold text-muted small">Toplam</label>
                    <input type="text" class="form-control meal-total" value="0.00 ₺" readonly data-meal-index="0" style="font-weight: 600; color: #2563eb;">
                </div>
                <div class="col-md-1 mb-2">
                    <label class="form-label d-block">&nbsp;</label>
                    <button type="button" class="btn btn-sm btn-danger remove-meal-btn">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    `;
}

function getInitialOrgRow() {
    return `
        <div class="org-item-row p-2 border rounded mb-2 org-item-card">
            <div class="row align-items-end">
                <div class="col-md-5 mb-2">
                    <label class="form-label fw-bold text-muted small">Organizasyon Adı</label>
                    <input type="text" class="form-control org-name" data-org-index="0" placeholder="Örn: Düğün Organizasyonu">
                </div>
                <div class="col-md-2 mb-2">
                    <label class="form-label fw-bold text-muted small">Adet</label>
                    <input type="number" class="form-control org-quantity" data-org-index="0" value="1" min="1">
                </div>
                <div class="col-md-2 mb-2">
                    <label class="form-label fw-bold text-muted small">Birim Fiyat</label>
                    <input type="number" step="0.01" class="form-control org-price" data-org-index="0" value="0" min="0" placeholder="0.00">
                </div>
                <div class="col-md-2 mb-2">
                    <label class="form-label fw-bold text-muted small">Toplam</label>
                    <input type="text" class="form-control org-total" data-org-index="0" value="0.00 ₺" readonly style="font-weight: 600; color: #2563eb;">
                </div>
                <div class="col-md-1 mb-2">
                    <label class="form-label d-block">&nbsp;</label>
                    <button type="button" class="btn btn-sm btn-danger remove-org-btn">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    `;
}

function getInitialExtraRow() {
    return `
        <div class="extra-item-row p-2 border rounded mb-2 extra-manual-card">
            <div class="row align-items-end">
                <div class="col-md-6 mb-2">
                    <label class="form-label fw-bold text-muted small">Ekstra Adı</label>
                    <input type="text" class="form-control extra-name" data-extra-index="0" placeholder="Örn: Fotoğraf Çekimi">
                </div>
                <div class="col-md-5 mb-2">
                    <label class="form-label fw-bold text-muted small">Fiyat (₺)</label>
                    <input type="number" step="0.01" class="form-control extra-price" data-extra-index="0" value="0" min="0" placeholder="0.00">
                </div>
                <div class="col-md-1 mb-2">
                    <label class="form-label d-block">&nbsp;</label>
                    <button type="button" class="btn btn-sm btn-danger remove-extra-btn">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    `;
}

function addNewResMealRow() {
    const container = document.getElementById('newResMealsContainer');
    if (!container) return;
    
    const newMeal = document.createElement('div');
    newMeal.className = 'meal-item-row p-2 border rounded mb-2 meal-item-card';
    newMeal.innerHTML = `
        <div class="row align-items-end">
            <div class="col-md-4 mb-2">
                <label class="form-label fw-bold text-muted small">Yemek Adı</label>
                <input type="text" class="form-control meal-name" data-meal-index="${newResMealCount}" placeholder="Yemek adı yazın">
            </div>
            <div class="col-md-2 mb-2">
                <label class="form-label fw-bold text-muted small">Miktar</label>
                <input type="number" class="form-control meal-quantity" value="1" min="1" data-meal-index="${newResMealCount}" placeholder="Adet">
            </div>
            <div class="col-md-2 mb-2">
                <label class="form-label fw-bold text-muted small">Birim Fiyat</label>
                <input type="number" step="0.01" class="form-control meal-price" value="0" min="0" data-meal-index="${newResMealCount}" placeholder="0.00">
            </div>
            <div class="col-md-3 mb-2">
                <label class="form-label fw-bold text-muted small">Toplam</label>
                <input type="text" class="form-control meal-total" value="0.00 ₺" readonly data-meal-index="${newResMealCount}" style="font-weight: 600; color: #2563eb;">
            </div>
            <div class="col-md-1 mb-2">
                <label class="form-label d-block">&nbsp;</label>
                <button type="button" class="btn btn-sm btn-danger remove-meal-btn">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
        </div>
    `;
    container.appendChild(newMeal);
    newResMealCount++;
}

function addNewResOrgRow() {
    const container = document.getElementById('newResOrganizationsContainer');
    if (!container) return;
    
    const newOrg = document.createElement('div');
    newOrg.className = 'org-item-row p-2 border rounded mb-2 org-item-card';
    newOrg.innerHTML = `
        <div class="row align-items-end">
            <div class="col-md-5 mb-2">
                <label class="form-label fw-bold text-muted small">Organizasyon Adı</label>
                <input type="text" class="form-control org-name" data-org-index="${newResOrgCount}" placeholder="Örn: Organizasyon Adı">
            </div>
            <div class="col-md-2 mb-2">
                <label class="form-label fw-bold text-muted small">Adet</label>
                <input type="number" class="form-control org-quantity" data-org-index="${newResOrgCount}" value="1" min="1">
            </div>
            <div class="col-md-2 mb-2">
                <label class="form-label fw-bold text-muted small">Birim Fiyat</label>
                <input type="number" step="0.01" class="form-control org-price" data-org-index="${newResOrgCount}" value="0" min="0" placeholder="0.00">
            </div>
            <div class="col-md-2 mb-2">
                <label class="form-label fw-bold text-muted small">Toplam</label>
                <input type="text" class="form-control org-total" data-org-index="${newResOrgCount}" value="0.00 ₺" readonly style="font-weight: 600; color: #2563eb;">
            </div>
            <div class="col-md-1 mb-2">
                <label class="form-label d-block">&nbsp;</label>
                <button type="button" class="btn btn-sm btn-danger remove-org-btn">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
        </div>
    `;
    container.appendChild(newOrg);
    newResOrgCount++;
}

function addNewResExtraRow() {
    const container = document.getElementById('newResExtrasContainer');
    if (!container) return;
    
    const newExtra = document.createElement('div');
    newExtra.className = 'extra-item-row p-2 border rounded mb-2 extra-manual-card';
    newExtra.innerHTML = `
        <div class="row align-items-end">
            <div class="col-md-6 mb-2">
                <label class="form-label fw-bold text-muted small">Ekstra Adı</label>
                <input type="text" class="form-control extra-name" data-extra-index="${newResExtraCount}" placeholder="Örn: Fotoğraf Çekimi">
            </div>
            <div class="col-md-5 mb-2">
                <label class="form-label fw-bold text-muted small">Fiyat (₺)</label>
                <input type="number" step="0.01" class="form-control extra-price" data-extra-index="${newResExtraCount}" value="0" min="0" placeholder="0.00">
            </div>
            <div class="col-md-1 mb-2">
                <label class="form-label d-block">&nbsp;</label>
                <button type="button" class="btn btn-sm btn-danger remove-extra-btn">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
        </div>
    `;
    container.appendChild(newExtra);
    newResExtraCount++;
}

function calculateNewResTotal() {
    // Salon ücreti
    const salonPrice = parseFloat(document.getElementById('newResSalonPrice')?.value || 0);
    
    // Yemek toplamı
    let mealTotal = 0;
    document.querySelectorAll('#newResMealsContainer .meal-item-row').forEach(row => {
        const quantity = parseFloat(row.querySelector('.meal-quantity')?.value || 0);
        const price = parseFloat(row.querySelector('.meal-price')?.value || 0);
        mealTotal += quantity * price;
    });
    
    // Organizasyon toplamı (çoklu organizasyon)
    let orgTotal = 0;
    document.querySelectorAll('#newResOrganizationsContainer .org-item-row').forEach(row => {
        const quantity = parseFloat(row.querySelector('.org-quantity')?.value || 0);
        const price = parseFloat(row.querySelector('.org-price')?.value || 0);
        orgTotal += quantity * price;
    });
    
    // Ekstra hizmetler (hazır checkbox'lar)
    let extraTotal = 0;
    const checkboxContainer = document.getElementById('newResExtrasCheckboxContainer');
    if (checkboxContainer) {
        checkboxContainer.querySelectorAll('.extra-checkbox:checked').forEach(checkbox => {
            extraTotal += parseFloat(checkbox.dataset.price || 0);
        });
    }
    
    // Manuel eklenen ekstralar
    document.querySelectorAll('#newResExtrasContainer .extra-item-row').forEach(row => {
        const price = parseFloat(row.querySelector('.extra-price')?.value || 0);
        extraTotal += price;
    });
    
    // Toplam
    const total = salonPrice + mealTotal + orgTotal + extraTotal;
    
    // Kapora
    const depositPaid = parseFloat(document.getElementById('newResDepositPaid')?.value || 0);
    const remaining = total - depositPaid;
    
    // Fiyat formatla (binlik ayırıcı nokta, ondalık virgül)
    function formatPrice(amount) {
        const parts = amount.toFixed(2).split('.');
        const integerPart = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        return integerPart + ',' + parts[1];
    }
    
    // Güncelle
    if (document.getElementById('newResSummarySalon')) {
        document.getElementById('newResSummarySalon').textContent = formatPrice(salonPrice) + ' ₺';
    }
    if (document.getElementById('newResSummaryMeals')) {
        document.getElementById('newResSummaryMeals').textContent = formatPrice(mealTotal) + ' ₺';
    }
    if (document.getElementById('newResSummaryOrg')) {
        document.getElementById('newResSummaryOrg').textContent = formatPrice(orgTotal) + ' ₺';
    }
    if (document.getElementById('newResSummaryExtras')) {
        document.getElementById('newResSummaryExtras').textContent = formatPrice(extraTotal) + ' ₺';
    }
    if (document.getElementById('newResSummaryTotal')) {
        document.getElementById('newResSummaryTotal').textContent = formatPrice(total) + ' ₺';
    }
    if (document.getElementById('newResRemainingAmount')) {
        document.getElementById('newResRemainingAmount').value = formatPrice(remaining) + ' ₺';
    }
}

function updateNewResSummary() {
    calculateNewResTotal();
}

function prepareNewResItemsData() {
    const itemsData = {};
    
    // Yemekler
    const meals = [];
    document.querySelectorAll('#newResMealsContainer .meal-item-row').forEach(row => {
        const nameInput = row.querySelector('.meal-name');
        const name = nameInput?.value?.trim();
        const quantity = parseInt(row.querySelector('.meal-quantity')?.value || 1);
        const price = parseFloat(row.querySelector('.meal-price')?.value || 0);
        if (name && quantity > 0 && price > 0) {
            meals.push({ name, quantity, price });
        }
    });
    if (meals.length > 0) itemsData.meals = meals;
    
    // Organizasyonlar (çoklu)
    const organizations = [];
    document.querySelectorAll('#newResOrganizationsContainer .org-item-row').forEach(row => {
        const name = row.querySelector('.org-name')?.value?.trim();
        const quantity = parseInt(row.querySelector('.org-quantity')?.value || 1);
        const price = parseFloat(row.querySelector('.org-price')?.value || 0);
        if (name && price > 0) {
            organizations.push({
                name: name,
                quantity: quantity,
                price: price
            });
        }
    });
    if (organizations.length > 0) {
        itemsData.organizations = organizations;
    }
    
    // Ekstralar (hazır checkbox'lar)
    const extras = [];
    const checkboxContainer = document.getElementById('newResExtrasCheckboxContainer');
    if (checkboxContainer) {
        checkboxContainer.querySelectorAll('.extra-checkbox:checked').forEach(checkbox => {
            const name = checkbox.dataset.name;
            const price = parseFloat(checkbox.dataset.price || 0);
            if (name && price > 0) {
                extras.push({ name, price });
            }
        });
    }
    
    // Manuel eklenen ekstralar
    document.querySelectorAll('#newResExtrasContainer .extra-item-row').forEach(row => {
        const name = row.querySelector('.extra-name')?.value?.trim();
        const price = parseFloat(row.querySelector('.extra-price')?.value || 0);
        if (name && price > 0) {
            extras.push({ name, price });
        }
    });
    
    if (extras.length > 0) itemsData.extras = extras;
    
    
    
    return itemsData;
}

// Saat seçeneklerini oluştur
function generateNewResTimeOptions() {
    const date = document.getElementById('newResDate')?.value;
    const salonId = document.getElementById('newResSalonId')?.value;
    const startSelect = document.getElementById('newResStartTime');
    const endSelect = document.getElementById('newResEndTime');
    
    if (!startSelect || !endSelect) return;
    
    if (!date || !salonId) {
        startSelect.innerHTML = '<option value="">Önce tarih ve salon seçin</option>';
        endSelect.innerHTML = '<option value="">Önce başlangıç saati seçin</option>';
        return;
    }
    
    // Tüm saatleri oluştur (8:00 - 23:30, 30 dakika aralıklarla)
    startSelect.innerHTML = '<option value="">Başlangıç Saati Seçin</option>';
    endSelect.innerHTML = '<option value="">Bitiş Saati Seçin</option>';
    
    for (let h = 8; h < 24; h++) {
        for (let m = 0; m < 60; m += 30) {
            const time = String(h).padStart(2, '0') + ':' + String(m).padStart(2, '0');
            startSelect.add(new Option(time, time));
            endSelect.add(new Option(time, time));
        }
    }
    
    // Dolu saatleri kontrol et
    checkNewResBookedSlots(date, salonId);
}

function updateNewResEndTimeOptions() {
    const startSelect = document.getElementById('newResStartTime');
    const endSelect = document.getElementById('newResEndTime');
    const startTime = startSelect?.value;
    
    if (!startSelect || !endSelect || !startTime) return;
    
    // Bitiş saatlerini başlangıç saatinden sonrakileri etkinleştir
    Array.from(endSelect.options).forEach((opt, idx) => {
        if (idx === 0) return; // İlk seçenek (placeholder)
        opt.disabled = opt.value <= startTime;
    });
}

function checkNewResBookedSlots(date, salonId) {
    if (!date || !salonId) return;
    
    fetch('{{ route("admin.reservations.check-times") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ date, salon_id: salonId })
    })
    .then(r => r.json())
    .then(data => {
        const bookedSlots = data.booked_slots || [];
        const startSelect = document.getElementById('newResStartTime');
        const endSelect = document.getElementById('newResEndTime');
        
        [startSelect, endSelect].forEach(select => {
            Array.from(select.options).forEach(opt => {
                if (opt.value && bookedSlots.includes(opt.value)) {
                    opt.disabled = true;
                    opt.style.color = '#dc3545';
                    if (!opt.textContent.includes('(Dolu)')) {
                        opt.textContent = opt.value + ' (Dolu)';
                    }
                } else if (opt.value) {
                    opt.disabled = false;
                    opt.style.color = '';
                    opt.textContent = opt.textContent.replace(' (Dolu)', '');
                }
            });
        });
    })
    .catch(err => console.error('Saat kontrolü hatası:', err));
}

function checkNewResTimeAvailability() {
    const date = document.getElementById('newResDate')?.value;
    const salonId = document.getElementById('newResSalonId')?.value;
    const startTime = document.getElementById('newResStartTime')?.value;
    const endTime = document.getElementById('newResEndTime')?.value;
    const resultDiv = document.getElementById('newResTimeCheckResult');
    const messageSpan = document.getElementById('newResTimeCheckMessage');
    
    if (!date || !salonId || !startTime || !endTime || !resultDiv || !messageSpan) {
        if (resultDiv) resultDiv.style.display = 'none';
        return;
    }
    
    fetch('{{ route("admin.reservations.check-times") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ date, salon_id: salonId })
    })
    .then(r => r.json())
    .then(data => {
        const bookedSlots = data.booked_slots || [];
        let hasConflict = false;
        
        // Seçilen saat aralığında çakışma var mı kontrol et
        bookedSlots.forEach(slot => {
            if (slot >= startTime && slot < endTime) {
                hasConflict = true;
            }
        });
        
        if (hasConflict) {
            resultDiv.className = 'alert alert-warning mb-0';
            messageSpan.textContent = '⚠️ Seçilen saat aralığında başka bir randevu var!';
            resultDiv.style.display = 'block';
        } else {
            resultDiv.className = 'alert alert-success mb-0';
            messageSpan.textContent = '✅ Seçilen saat aralığı müsait!';
            resultDiv.style.display = 'block';
        }
    })
    .catch(err => {
        console.error('Saat kontrolü hatası:', err);
        resultDiv.style.display = 'none';
    });
}

// Global fonksiyon - Modal'ı aç
window.openNewReservationModal = function(selectedDate = null) {
    // Eğer tarih verilmişse, input'a set et
    if (selectedDate) {
        const dateInput = document.getElementById('newResDate');
        if (dateInput) {
            dateInput.value = selectedDate;
            dateInput.setAttribute('value', selectedDate);
            // Tarih bugünden önceyse min attribute'unu kaldır
            const today = new Date().toISOString().split('T')[0];
            if (selectedDate < today) {
                dateInput.removeAttribute('min');
            } else {
                dateInput.setAttribute('min', today);
            }
        }
    }
    
    const modalElement = document.getElementById('newReservationModal');
    if (!modalElement) {
        console.error('❌ newReservationModal bulunamadı');
        return;
    }
    
    const modal = new bootstrap.Modal(modalElement);
    modal.show();
    
    // Modal açıldığında event listener'ları yeniden kur ve saat seçeneklerini güncelle
    modalElement.addEventListener('shown.bs.modal', function onModalShown() {
        console.log('📦 Yeni randevu modal\'ı açıldı');
        // Event listener'ları yeniden kur
        setTimeout(() => {
            setupNewResTimeListeners();
            // Tarih varsa saat seçeneklerini güncelle
            if (selectedDate) {
                generateNewResTimeOptions();
            }
        }, 200);
        // Event listener'ı bir kez çalıştıktan sonra kaldır
        modalElement.removeEventListener('shown.bs.modal', onModalShown);
    }, { once: true });
};
</script>
@push('scripts')
<script>
// Modal script yüklendikten sonra global fonksiyonu tanımla
if (typeof window.openNewReservationModal === 'function') {
    // Zaten tanımlı, bir şey yapma
} else {
    // Biraz bekle ve tekrar kontrol et
    setTimeout(function() {
        if (typeof window.openNewReservationModal === 'function') {
            console.log('openNewReservationModal yüklendi');
        }
    }, 100);
}
</script>
@endpush
