@extends('layouts.admin')

@section('title', 'Fiyat Listesi')
@section('page-title', 'Fiyat Listesi')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Fiyat Listesi</h4>
                <a href="{{ route('admin.beauty-salon.services.create') }}" class="btn btn-primary">
                    <i class="bi bi-plus-circle me-2"></i>Yeni Hizmet Ekle
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if($services->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Hizmet Adı</th>
                                        <th>Açıklama</th>
                                        <th>Fiyat</th>
                                        <th>Süre</th>
                                        <th>Durum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($services as $service)
                                        <tr>
                                            <td><strong>{{ $service->name }}</strong></td>
                                            <td>{{ $service->description ?? '-' }}</td>
                                            <td><strong>{{ number_format($service->price, 2, ',', '.') }} ₺</strong></td>
                                            <td>{{ $service->duration ? $service->duration . ' dk' : '-' }}</td>
                                            <td>
                                                @if($service->is_active)
                                                    <span class="badge bg-success">Aktif</span>
                                                @else
                                                    <span class="badge bg-danger">Pasif</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-box-seam" style="font-size: 48px; color: #ccc;"></i>
                            <p class="text-muted mt-3">Henüz hizmet eklenmemiş.</p>
                            <a href="{{ route('admin.beauty-salon.services.create') }}" class="btn btn-primary">
                                <i class="bi bi-plus-circle me-2"></i>İlk Hizmeti Ekle
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

