@extends('layouts.admin')

@section('title', 'Profil Düzenle')
@section('page-title', 'Profil Düzenle')

@section('content')
<div class="container-fluid">
    @if($isFirstLogin ?? false || (empty($user->salon_name) || empty($user->salon_slug)))
        <div class="alert alert-warning alert-dismissible fade show" role="alert" style="background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%); border: 2px solid #f59e0b;">
            <h5 class="alert-heading"><i class="bi bi-exclamation-triangle-fill me-2" style="color: #f59e0b;"></i>Hoş Geldiniz! Salon Bilgilerinizi Tamamlayın</h5>
            <p class="mb-0"><strong>Sistemi kullanmaya başlamak için lütfen aşağıdaki salon bilgilerinizi doldurun.</strong></p>
            <p class="mb-0 mt-2"><small>Bu bilgiler zorunludur ve sistemin düzgün çalışması için gereklidir.</small></p>
        </div>
    @endif
    
    @if(session('warning'))
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            {{ session('warning') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    
    <div class="row">
        <div class="col-12">
            <div class="card" style="border-radius: 16px; border: none; box-shadow: 0 4px 20px rgba(0,0,0,0.08);">
                <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; padding: 24px;">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 text-white fw-bold">
                            <i class="bi bi-building me-2"></i>Salon Profil Bilgileri
                        </h5>
                    </div>
                </div>
                <div class="card-body" style="padding: 32px;">
                    <form action="{{ route('admin.beauty-salon.profile.update') }}" method="POST" enctype="multipart/form-data" id="profileForm">
                        @csrf
                        @method('PUT')
                        
                        <!-- Banner ve Profil Fotoğrafı (Üst Üste) -->
                        <div class="row mb-5">
                            <div class="col-md-12">
                                <label class="form-label mb-3">
                                    <i class="bi bi-image me-2"></i>Salon Banner'ı ve Profil Fotoğrafı
                                </label>
                                
                                <!-- Banner Container -->
                                <div class="banner-image-container-wrapper" style="position: relative; margin-bottom: 100px;">
                                    <div class="banner-image-container" style="position: relative; width: 100%; height: 300px; border-radius: 16px; overflow: hidden; border: 2px dashed #e5e7eb;">
                                        @if($user->salon_banner_image)
                                            <img src="{{ Storage::url($user->salon_banner_image) }}" alt="Banner" id="bannerImagePreview" style="width: 100%; height: 100%; object-fit: cover;">
                                        @else
                                            <div id="bannerImagePreview" style="width: 100%; height: 100%; background: linear-gradient(135deg, {{ $user->avatar_color }} 0%, {{ $user->avatar_color }}dd 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 24px; font-weight: bold;">
                                                <i class="bi bi-image me-2"></i>Banner Yükleyin
                                            </div>
                                        @endif
                                        
                                        <!-- Banner Overlay -->
                                        <div class="banner-image-overlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); display: flex; align-items: center; justify-content: center; opacity: 0; transition: all 0.3s; cursor: pointer;">
                                            <label for="salon_banner_image" class="btn btn-light">
                                                <i class="bi bi-camera-fill me-2"></i>{{ $user->salon_banner_image ? 'Banner Değiştir' : 'Banner Yükle' }}
                                            </label>
                                        </div>
                                    </div>
                                    
                                    <!-- Profil Fotoğrafı Banner Üzerinde -->
                                    <div style="position: absolute; bottom: -90px; left: 50%; transform: translateX(-50%); z-index: 10;">
                                        <div class="profile-image-container" style="position: relative;">
                                            @if($user->salon_profile_image)
                                                <img src="{{ Storage::url($user->salon_profile_image) }}" alt="Profil Fotoğrafı" id="profileImagePreview" class="profile-image-preview" style="width: 180px; height: 180px; border-radius: 50%; object-fit: cover; border: 6px solid white; box-shadow: 0 8px 24px rgba(0,0,0,0.2);">
                                            @else
                                                <div class="profile-image-placeholder" style="width: 180px; height: 180px; border-radius: 50%; background: {{ $user->avatar_color }}; display: flex; align-items: center; justify-content: center; font-size: 64px; color: white; font-weight: bold; border: 6px solid white; box-shadow: 0 8px 24px rgba(0,0,0,0.2);">
                                                    {{ $user->initials }}
                                                </div>
                                            @endif
                                            <div class="profile-image-overlay">
                                                <label for="salon_profile_image" class="btn btn-light btn-sm">
                                                    <i class="bi bi-camera-fill me-2"></i>Değiştir
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Input Fields -->
                                <label for="salon_banner_image" class="visually-hidden">Salon Banner Görseli</label>
                                <input type="file" class="d-none" id="salon_banner_image" name="salon_banner_image" accept="image/jpeg,image/png,image/jpg,image/gif,image/webp" autocomplete="off" onchange="previewBannerImage(this)">
                                <label for="salon_profile_image" class="visually-hidden">Salon Profil Fotoğrafı</label>
                                <input type="file" class="d-none" id="salon_profile_image" name="salon_profile_image" accept="image/jpeg,image/png,image/jpg,image/gif,image/webp" autocomplete="off" onchange="previewImage(this)">
                                
                                <!-- Info Texts -->
                                <div class="row mt-4">
                                    <div class="col-md-6">
                                        <small class="text-muted d-block">
                                            <i class="bi bi-info-circle me-1"></i><strong>Banner:</strong> Maksimum 10 MB. Önerilen boyut: 1920x600px
                                        </small>
                                    </div>
                                    <div class="col-md-6">
                                        <small class="text-muted d-block">
                                            <i class="bi bi-info-circle me-1"></i><strong>Profil Fotoğrafı:</strong> Maksimum 5 MB. Desteklenen formatlar: JPG, PNG, GIF, WEBP
                                        </small>
                                    </div>
                                </div>
                                
                                @error('salon_banner_image')
                                    <div class="text-danger small mt-2">{{ $message }}</div>
                                @enderror
                                @error('salon_profile_image')
                                    <div class="text-danger small mt-2">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="section-divider"></div>
                        
                        <h5 class="section-title mb-4">
                            <i class="bi bi-person-circle me-2"></i>Kişisel Bilgiler
                        </h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="name" class="form-label">Ad Soyad <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" value="{{ old('name', $user->name) }}" autocomplete="name" required>
                                @error('name')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label">E-posta <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" id="email" name="email" value="{{ old('email', $user->email) }}" autocomplete="email" required>
                                @error('email')
                                    <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="phone" class="form-label">Telefon <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="tel" class="form-control" id="phone" name="phone" value="{{ old('phone', $user->phone) }}" autocomplete="tel" required>
                                <button type="button" class="btn btn-outline-primary" id="sendPhoneOtpBtn" onclick="sendPhoneOtp()">
                                    <i class="bi bi-send me-1"></i>OTP Kodu Gönder
                                </button>
                            </div>
                            <small class="text-muted d-block mt-2" id="phoneOtpStatus"></small>
                            <div class="mt-2" id="phoneOtpField" style="display: none;">
                                <label for="phone_otp" class="form-label">Doğrulama Kodu <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="phone_otp" name="phone_otp" placeholder="6 haneli kod" maxlength="6" pattern="[0-9]{6}">
                                @error('phone_otp')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            @error('phone')
                                <div class="text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="section-divider"></div>
                        
                        <h5 class="section-title mb-4">
                            <i class="bi bi-building me-2"></i>Salon Bilgileri
                        </h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="salon_name" class="form-label">
                                    <i class="bi bi-shop me-1"></i>Salon Adı <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control" id="salon_name" name="salon_name" value="{{ old('salon_name', $user->salon_name) }}" autocomplete="organization" required placeholder="Örn: Güzellik Salonu">
                                @error('salon_name')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="salon_short_name" class="form-label">
                                    <i class="bi bi-link-45deg me-1"></i>Salon Kısa Adı <span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control" id="salon_short_name" name="salon_short_name" value="{{ old('salon_short_name', $user->salon_short_name) }}" autocomplete="off" required maxlength="50" placeholder="Örn: guzellik-salonu">
                                <small class="text-muted d-block mt-2">
                                    <i class="bi bi-globe me-1"></i>Profil URL'niz: <strong>{{ url('/salon') }}/<span id="slug-preview">{{ $user->salon_slug }}</span></strong>
                                    @if($user->short_url)
                                        <br><i class="bi bi-link-45deg me-1"></i>Kısa URL: <strong>{{ url('/') }}/<span id="short-url-display">{{ $user->short_url }}</span></strong>
                                    @endif
                                </small>
                                @error('salon_short_name')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="short_url" class="form-label">
                                    <i class="bi bi-link-45deg me-1"></i>Kısa URL (Opsiyonel)
                                </label>
                                <input type="text" class="form-control" id="short_url" name="short_url" value="{{ old('short_url', $user->short_url) }}" autocomplete="off" maxlength="50" placeholder="Örn: salon123">
                                <small class="text-muted d-block mt-2">
                                    <i class="bi bi-info-circle me-1"></i>Kısa URL ile salonunuza erişim: <strong>{{ url('/') }}/<span id="short-url-preview">{{ $user->short_url ?? 'otomatik-oluşturulacak' }}</span></strong>
                                    <br><span class="text-info"><i class="bi bi-arrow-right me-1"></i>Kısa URL otomatik olarak salon sayfanıza yönlendirir</span>
                                    @if($user->short_url)
                                        <br><span class="text-success"><i class="bi bi-check-circle me-1"></i>Mevcut kısa URL: {{ $user->short_url }}</span>
                                    @else
                                        <br><span class="text-info"><i class="bi bi-info-circle me-1"></i>Boş bırakırsanız otomatik oluşturulur</span>
                                    @endif
                                </small>
                                @error('short_url')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="salon_phone" class="form-label">
                                    <i class="bi bi-telephone me-1"></i>Salon Telefon <span class="text-danger">*</span>
                                </label>
                                <input type="tel" class="form-control" id="salon_phone" name="salon_phone" value="{{ old('salon_phone', $user->salon_phone) }}" autocomplete="tel-national" required placeholder="05XX XXX XX XX">
                                @error('salon_phone')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="salon_theme" class="form-label">
                                    <i class="bi bi-palette me-1"></i>Tema <span class="text-danger">*</span>
                                </label>
                                <select class="form-select" id="salon_theme" name="salon_theme" required>
                                    <option value="theme1" selected>🎨 Tema 1 - Aktif</option>
                                    <option value="theme2" disabled>🏛️ Tema 2 - Yakında</option>
                                    <option value="theme3" disabled>✨ Tema 3 - Yakında</option>
                                    <option value="theme4" disabled>🌈 Tema 4 - Yakında</option>
                                    <option value="theme5" disabled>💎 Tema 5 - Yakında</option>
                                </select>
                                <small class="text-muted d-block mt-2">
                                    Şu an tüm salonlar Tema 1 kullanıyor. Diğer temalar yakında tekrar açılacak.
                                </small>
                                @error('salon_theme')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="salon_color" class="form-label">
                                    <i class="bi bi-palette2 me-1"></i>Renk Paleti <span class="text-danger">*</span>
                                </label>
                                <div class="color-palette-selector-modern">
                                    <div class="row g-3">
                                        <div class="col-6 col-md-4">
                                            <label class="color-option-modern {{ old('salon_color', $user->salon_color ?? 'pink') === 'pink' ? 'active' : '' }}" data-color="pink">
                                                <input type="radio" name="salon_color" value="pink" {{ old('salon_color', $user->salon_color ?? 'pink') === 'pink' ? 'checked' : '' }}>
                                                <div class="color-card">
                                                    <div class="color-preview" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);"></div>
                                                    <div class="color-info">
                                                        <span class="color-name">Pembe</span>
                                                        <i class="bi bi-check-circle-fill check-icon"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                        <div class="col-6 col-md-4">
                                            <label class="color-option-modern {{ old('salon_color', $user->salon_color ?? 'pink') === 'blue' ? 'active' : '' }}" data-color="blue">
                                                <input type="radio" name="salon_color" value="blue" {{ old('salon_color', $user->salon_color ?? 'pink') === 'blue' ? 'checked' : '' }}>
                                                <div class="color-card">
                                                    <div class="color-preview" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%);"></div>
                                                    <div class="color-info">
                                                        <span class="color-name">Mavi</span>
                                                        <i class="bi bi-check-circle-fill check-icon"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                        <div class="col-6 col-md-4">
                                            <label class="color-option-modern {{ old('salon_color', $user->salon_color ?? 'pink') === 'purple' ? 'active' : '' }}" data-color="purple">
                                                <input type="radio" name="salon_color" value="purple" {{ old('salon_color', $user->salon_color ?? 'pink') === 'purple' ? 'checked' : '' }}>
                                                <div class="color-card">
                                                    <div class="color-preview" style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);"></div>
                                                    <div class="color-info">
                                                        <span class="color-name">Mor</span>
                                                        <i class="bi bi-check-circle-fill check-icon"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                        <div class="col-6 col-md-4">
                                            <label class="color-option-modern {{ old('salon_color', $user->salon_color ?? 'pink') === 'orange' ? 'active' : '' }}" data-color="orange">
                                                <input type="radio" name="salon_color" value="orange" {{ old('salon_color', $user->salon_color ?? 'pink') === 'orange' ? 'checked' : '' }}>
                                                <div class="color-card">
                                                    <div class="color-preview" style="background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);"></div>
                                                    <div class="color-info">
                                                        <span class="color-name">Turuncu</span>
                                                        <i class="bi bi-check-circle-fill check-icon"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                        <div class="col-6 col-md-4">
                                            <label class="color-option-modern {{ old('salon_color', $user->salon_color ?? 'pink') === 'green' ? 'active' : '' }}" data-color="green">
                                                <input type="radio" name="salon_color" value="green" {{ old('salon_color', $user->salon_color ?? 'pink') === 'green' ? 'checked' : '' }}>
                                                <div class="color-card">
                                                    <div class="color-preview" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);"></div>
                                                    <div class="color-info">
                                                        <span class="color-name">Yeşil</span>
                                                        <i class="bi bi-check-circle-fill check-icon"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                @error('salon_color')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="salon_city" class="form-label fw-bold">
                                    <i class="bi bi-geo-alt me-2"></i>İl <span class="text-danger">*</span>
                                </label>
                                <select class="form-select" id="salon_city" name="salon_city" required>
                                    <option value="">İl Seçin</option>
                                    @php
                                        $cities = [
                                            'Adana', 'Adıyaman', 'Afyonkarahisar', 'Ağrı', 'Aksaray', 'Amasya', 'Ankara', 'Antalya',
                                            'Ardahan', 'Artvin', 'Aydın', 'Balıkesir', 'Bartın', 'Batman', 'Bayburt', 'Bilecik',
                                            'Bingöl', 'Bitlis', 'Bolu', 'Burdur', 'Bursa', 'Çanakkale', 'Çankırı', 'Çorum',
                                            'Denizli', 'Diyarbakır', 'Düzce', 'Edirne', 'Elazığ', 'Erzincan', 'Erzurum', 'Eskişehir',
                                            'Gaziantep', 'Giresun', 'Gümüşhane', 'Hakkari', 'Hatay', 'Iğdır', 'Isparta', 'İstanbul',
                                            'İzmir', 'Kahramanmaraş', 'Karabük', 'Karaman', 'Kars', 'Kastamonu', 'Kayseri', 'Kilis',
                                            'Kırıkkale', 'Kırklareli', 'Kırşehir', 'Kocaeli', 'Konya', 'Kütahya', 'Malatya', 'Manisa',
                                            'Mardin', 'Mersin', 'Muğla', 'Muş', 'Nevşehir', 'Niğde', 'Ordu', 'Osmaniye',
                                            'Rize', 'Sakarya', 'Samsun', 'Siirt', 'Sinop', 'Sivas', 'Şanlıurfa', 'Şırnak',
                                            'Tekirdağ', 'Tokat', 'Trabzon', 'Tunceli', 'Uşak', 'Van', 'Yalova', 'Yozgat', 'Zonguldak'
                                        ];
                                    @endphp
                                    @foreach($cities as $city)
                                        <option value="{{ $city }}" {{ old('salon_city', $user->salon_city) == $city ? 'selected' : '' }}>{{ $city }}</option>
                                    @endforeach
                                </select>
                                @error('salon_city')
                                    <div class="text-danger small mt-2">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="salon_district" class="form-label fw-bold">
                                    <i class="bi bi-geo-alt-fill me-2"></i>İlçe <span class="text-danger">*</span>
                                </label>
                                <select class="form-select" id="salon_district" name="salon_district" required disabled>
                                    <option value="">Önce il seçin</option>
                                </select>
                                @error('salon_district')
                                    <div class="text-danger small mt-2">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="salon_address" class="form-label fw-bold">
                                <i class="bi bi-geo-alt me-2"></i>Salon Adresi <span class="text-danger">*</span>
                            </label>
                            <textarea class="form-control" id="salon_address" name="salon_address" rows="3" autocomplete="street-address" required placeholder="Örn: Atatürk Caddesi No:123">{{ old('salon_address', $user->salon_address) }}</textarea>
                            @error('salon_address')
                                <div class="text-danger small mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-4">
                            <label for="salon_description" class="form-label fw-bold">
                                <i class="bi bi-card-text me-2"></i>Salon Açıklaması
                            </label>
                            <textarea class="form-control" id="salon_description" name="salon_description" rows="4" autocomplete="off" placeholder="Salonunuz hakkında bilgi verin...">{{ old('salon_description', $user->salon_description) }}</textarea>
                        </div>

                        @php
                            $workingDays = [
                                'monday' => 'Pazartesi',
                                'tuesday' => 'Salı',
                                'wednesday' => 'Çarşamba',
                                'thursday' => 'Perşembe',
                                'friday' => 'Cuma',
                                'saturday' => 'Cumartesi',
                                'sunday' => 'Pazar',
                            ];
                            $workingHours = old('working_hours', $user->salon_working_hours ?? []);
                        @endphp

                        <div class="mb-4">
                            <label class="form-label fw-bold">
                                <i class="bi bi-clock-history me-2"></i>Çalışma Gün ve Saatleri <span class="text-danger">*</span>
                            </label>
                            <small class="text-muted d-block mb-2">Açık olduğunuz günleri ve saat aralıklarını buradan yönetin.</small>
                            <div class="row g-2">
                                @foreach($workingDays as $dayKey => $dayLabel)
                                    @php
                                        $dayData = $workingHours[$dayKey] ?? [];
                                        $isOpen = array_key_exists('is_open', $dayData) ? (bool) $dayData['is_open'] : ($dayKey !== 'sunday');
                                        $openTime = $dayData['open_time'] ?? '09:00';
                                        $closeTime = $dayData['close_time'] ?? '18:00';
                                    @endphp
                                    <div class="col-12">
                                        <div class="working-hours-row border rounded p-2 d-flex flex-wrap align-items-center gap-2">
                                            <div class="form-check form-switch m-0 me-2">
                                                <input class="form-check-input js-working-day-toggle" type="checkbox" role="switch" id="working_{{ $dayKey }}" name="working_hours[{{ $dayKey }}][is_open]" value="1" {{ $isOpen ? 'checked' : '' }}>
                                                <label class="form-check-label fw-semibold" for="working_{{ $dayKey }}">{{ $dayLabel }}</label>
                                            </div>
                                            <div class="d-flex align-items-center gap-2 ms-md-auto">
                                                <input type="time" class="form-control form-control-sm js-working-day-time" style="max-width: 130px;" name="working_hours[{{ $dayKey }}][open_time]" value="{{ $openTime }}" {{ $isOpen ? '' : 'disabled' }}>
                                                <span>-</span>
                                                <input type="time" class="form-control form-control-sm js-working-day-time" style="max-width: 130px;" name="working_hours[{{ $dayKey }}][close_time]" value="{{ $closeTime }}" {{ $isOpen ? '' : 'disabled' }}>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            @error('working_hours')
                                <div class="text-danger small mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <!-- Salon Görsel Galerisi -->
                        <div class="mb-4">
                            <label class="form-label fw-bold">
                                <i class="bi bi-images me-2"></i>Salon Görselleri
                            </label>
                            <div class="gallery-upload-container">
                                <div class="gallery-grid" id="galleryGrid">
                                    @if($user->salon_gallery && is_array($user->salon_gallery))
                                        @foreach($user->salon_gallery as $index => $imagePath)
                                            <div class="gallery-item" data-image-path="{{ $imagePath }}">
                                                <img src="{{ Storage::url($imagePath) }}" alt="Salon Görseli" class="gallery-image">
                                                <button type="button" class="gallery-remove-btn" onclick="removeGalleryImage(this, '{{ $imagePath }}')">
                                                    <i class="bi bi-x-circle-fill"></i>
                                                </button>
                                                <input type="hidden" name="remove_gallery_images[]" value="{{ $imagePath }}" class="remove-image-input" style="display: none;">
                                            </div>
                                        @endforeach
                                    @endif
                                    
                                    <!-- Yükleme Kutusu -->
                                    <div class="gallery-upload-box" id="galleryUploadBox">
                                        <label for="salon_gallery" class="gallery-upload-label">
                                            <i class="bi bi-plus-circle-fill"></i>
                                            <span>Görsel Ekle</span>
                                        </label>
                                        <input type="file" id="salon_gallery" name="salon_gallery[]" accept="image/jpeg,image/png,image/jpg,image/gif,image/webp" multiple onchange="handleGalleryUpload(this)">
                                    </div>
                                </div>
                                <small class="text-muted d-block mt-2">
                                    <i class="bi bi-info-circle me-1"></i>Maksimum 10 görsel yükleyebilirsiniz. Her görsel maksimum 5 MB olabilir.
                                </small>
                            </div>
                        </div>
                            <small class="text-muted d-block mt-2">
                                <i class="bi bi-info-circle me-1"></i>Bu açıklama müşterilerin salon sayfanızda göreceği bilgidir.
                            </small>
                            @error('salon_description')
                                <div class="text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <!-- Personeller, Hizmetler ve Odalar -->
                        <div class="section-divider"></div>
                        
                        <h5 class="section-title mb-4" style="padding-left: 20px;">
                            <i class="bi bi-people me-2"></i>Personeller, Hizmetler ve Odalar
                        </h5>
                        
                        <div class="row g-3" style="padding: 0 20px;">
                            <!-- Personeller -->
                            <div class="col-md-4">
                                <div class="card border-0 shadow-sm h-100" style="border-radius: 12px;">
                                    <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">
                                        <h6 class="mb-0 text-white fw-bold" style="font-size: 0.9rem;">
                                            <i class="bi bi-people me-2"></i>Personeller ({{ $personelCount }})
                                        </h6>
                                    </div>
                                    <div class="card-body" style="padding: 12px;">
                                        @if($personels->count() > 0)
                                            <div class="list-group list-group-flush">
                                                @foreach($personels as $personel)
                                                    <div class="list-group-item px-2 py-2 border-0 border-bottom" style="font-size: 0.85rem;">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <strong class="d-block">{{ $personel->name }}</strong>
                                                                @if($personel->services->count() > 0)
                                                                    <small class="text-muted">
                                                                        <i class="bi bi-scissors me-1"></i>{{ $personel->services->count() }} hizmet
                                                                    </small>
                                                                @endif
                                                            </div>
                                                            @if($personel->is_active)
                                                                <span class="badge bg-success">Aktif</span>
                                                            @else
                                                                <span class="badge bg-secondary">Pasif</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                            @if($personelCount > 10)
                                                <div class="mt-3 text-center">
                                                    <a href="{{ route('admin.beauty-salon.personel.index') }}" class="btn btn-sm btn-outline-primary">
                                                        Tümünü Gör ({{ $personelCount }})
                                                    </a>
                                                </div>
                                            @else
                                                <div class="mt-3 text-center">
                                                    <a href="{{ route('admin.beauty-salon.personel.index') }}" class="btn btn-sm btn-outline-primary">
                                                        <i class="bi bi-plus-circle me-1"></i>Personel Ekle
                                                    </a>
                                                </div>
                                            @endif
                                        @else
                                            <div class="text-center py-4">
                                                <i class="bi bi-person-x" style="font-size: 48px; color: #cbd5e1;"></i>
                                                <p class="text-muted mt-2 mb-0">Henüz personel eklenmemiş</p>
                                                <a href="{{ route('admin.beauty-salon.personel.create') }}" class="btn btn-sm btn-primary mt-3">
                                                    <i class="bi bi-plus-circle me-1"></i>İlk Personeli Ekle
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Hizmetler -->
                            <div class="col-md-4">
                                <div class="card border-0 shadow-sm h-100" style="border-radius: 12px;">
                                    <div class="card-header" style="background: linear-gradient(135deg, #8b5cf6 0%, #6d28d9 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">
                                        <h6 class="mb-0 text-white fw-bold" style="font-size: 0.9rem;">
                                            <i class="bi bi-scissors me-2"></i>Hizmetler ({{ $serviceCount }})
                                        </h6>
                                    </div>
                                    <div class="card-body" style="padding: 12px;">
                                        @if($services->count() > 0)
                                            <div class="list-group list-group-flush">
                                                @foreach($services as $service)
                                                    <div class="list-group-item px-2 py-2 border-0 border-bottom" style="font-size: 0.85rem;">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <strong class="d-block">{{ $service->name }}</strong>
                                                                <small class="text-success fw-bold">{{ number_format($service->price, 2, ',', '.') }} ₺</small>
                                                                @if($service->duration)
                                                                    <small class="text-muted ms-2">
                                                                        <i class="bi bi-clock me-1"></i>{{ $service->duration }} dk
                                                                    </small>
                                                                @endif
                                                            </div>
                                                            @if($service->is_active)
                                                                <span class="badge bg-success">Aktif</span>
                                                            @else
                                                                <span class="badge bg-secondary">Pasif</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                            @if($serviceCount > 10)
                                                <div class="mt-3 text-center">
                                                    <a href="{{ route('admin.beauty-salon.services.index') }}" class="btn btn-sm btn-outline-primary">
                                                        Tümünü Gör ({{ $serviceCount }})
                                                    </a>
                                                </div>
                                            @else
                                                <div class="mt-3 text-center">
                                                    <a href="{{ route('admin.beauty-salon.services.index') }}" class="btn btn-sm btn-outline-primary">
                                                        <i class="bi bi-plus-circle me-1"></i>Hizmet Ekle
                                                    </a>
                                                </div>
                                            @endif
                                        @else
                                            <div class="text-center py-4">
                                                <i class="bi bi-scissors" style="font-size: 48px; color: #cbd5e1;"></i>
                                                <p class="text-muted mt-2 mb-0">Henüz hizmet eklenmemiş</p>
                                                <a href="{{ route('admin.beauty-salon.services.create') }}" class="btn btn-sm btn-primary mt-3">
                                                    <i class="bi bi-plus-circle me-1"></i>İlk Hizmeti Ekle
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Odalar -->
                            <div class="col-md-4">
                                <div class="card border-0 shadow-sm h-100" style="border-radius: 12px;">
                                    <div class="card-header" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 12px 12px 0 0; padding: 12px 16px;">
                                        <h6 class="mb-0 text-white fw-bold" style="font-size: 0.9rem;">
                                            <i class="bi bi-door-open me-2"></i>Odalar ({{ $roomCount }})
                                        </h6>
                                    </div>
                                    <div class="card-body" style="padding: 12px;">
                                        @if($rooms->count() > 0)
                                            <div class="list-group list-group-flush">
                                                @foreach($rooms as $room)
                                                    <div class="list-group-item px-2 py-2 border-0 border-bottom" style="font-size: 0.85rem;">
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <div>
                                                                <strong class="d-block">{{ $room->name }}</strong>
                                                                @if($room->capacity)
                                                                    <small class="text-muted">
                                                                        <i class="bi bi-people me-1"></i>Kapasite: {{ $room->capacity }}
                                                                    </small>
                                                                @endif
                                                            </div>
                                                            @if($room->is_active ?? true)
                                                                <span class="badge bg-success">Aktif</span>
                                                            @else
                                                                <span class="badge bg-secondary">Pasif</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                            @if($roomCount > 10)
                                                <div class="mt-3 text-center">
                                                    <a href="{{ route('admin.beauty-salon.rooms.index') }}" class="btn btn-sm btn-outline-primary">
                                                        Tümünü Gör ({{ $roomCount }})
                                                    </a>
                                                </div>
                                            @else
                                                <div class="mt-3 text-center">
                                                    <a href="{{ route('admin.beauty-salon.rooms.index') }}" class="btn btn-sm btn-outline-primary">
                                                        <i class="bi bi-plus-circle me-1"></i>Oda Ekle
                                                    </a>
                                                </div>
                                            @endif
                                        @else
                                            <div class="text-center py-4">
                                                <i class="bi bi-door-open" style="font-size: 48px; color: #cbd5e1;"></i>
                                                <p class="text-muted mt-2 mb-0">Henüz oda eklenmemiş</p>
                                                <a href="{{ route('admin.beauty-salon.rooms.create') }}" class="btn btn-sm btn-primary mt-3">
                                                    <i class="bi bi-plus-circle me-1"></i>İlk Odayı Ekle
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-3 pt-3 border-top" style="padding: 20px;">
                            <div class="d-flex flex-wrap gap-3">
                                <button type="submit" class="btn btn-lg px-5" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; border: none; border-radius: 12px; font-weight: 600; box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);">
                                    <i class="bi bi-check-circle me-2"></i>{{ ($isFirstLogin ?? false) || (empty($user->salon_name) || empty($user->salon_slug)) ? 'Kaydet ve Devam Et' : 'Güncelle' }}
                                </button>
                                @if(!($isFirstLogin ?? false) && !empty($user->salon_name) && !empty($user->salon_slug))
                                <a href="{{ route('admin.dashboard') }}" class="btn btn-lg btn-light px-4" style="border-radius: 12px; font-weight: 500;">
                                    <i class="bi bi-arrow-left me-2"></i>Geri
                                </a>
                                @endif
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    /* Banner ve Profil Fotoğrafı Container */
    .banner-image-container-wrapper {
        margin-bottom: 20px;
    }
    
    .banner-image-container {
        margin-bottom: 0;
    }
    
    .banner-image-container:hover .banner-image-overlay {
        opacity: 1;
    }
    
    .banner-image-container-wrapper:hover .profile-image-overlay {
        opacity: 1;
    }

    /* Profil Fotoğrafı */
    .profile-image-container {
        position: relative;
        display: inline-block;
    }

    .profile-image-preview,
    .profile-image-placeholder {
        width: 180px;
        height: 180px;
        border-radius: 50%;
        object-fit: cover;
        border: 6px solid white;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2);
        transition: all 0.3s;
    }

    .profile-image-placeholder {
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 64px;
        color: white;
        font-weight: bold;
        margin: 0 auto;
    }

    .profile-image-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        border-radius: 50%;
        background: rgba(0, 0, 0, 0.5);
        display: flex;
        align-items: center;
        justify-content: center;
        opacity: 0;
        transition: all 0.3s;
        cursor: pointer;
    }

    .profile-image-container:hover .profile-image-overlay {
        opacity: 1;
    }
    
    .banner-image-container:hover .profile-image-overlay {
        opacity: 1;
    }

    /* Form Stilleri */
    .form-label {
        color: #374151;
        font-weight: 600;
        margin-bottom: 8px;
    }

    .form-control,
    .form-select {
        border-radius: 10px;
        border: 2px solid #e5e7eb;
        padding: 12px 16px;
        transition: all 0.2s;
    }

    .form-control:focus,
    .form-select:focus {
        border-color: #ec4899;
        box-shadow: 0 0 0 3px rgba(236, 72, 153, 0.1);
    }

    .section-divider {
        height: 2px;
        background: linear-gradient(90deg, transparent, #e5e7eb, transparent);
        margin: 32px 0;
    }

    .section-title {
        color: #1f2937;
        font-weight: 700;
        display: flex;
        align-items: center;
    }

    /* Salon Görsel Galerisi */
    .gallery-upload-container {
        margin-top: 16px;
    }

    .gallery-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
        gap: 16px;
        margin-bottom: 16px;
    }

    .gallery-item {
        position: relative;
        aspect-ratio: 1;
        border-radius: 16px;
        overflow: hidden;
        border: 3px solid #e5e7eb;
        background: #f9fafb;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }

    .gallery-item:hover {
        transform: translateY(-6px) scale(1.02);
        box-shadow: 0 12px 32px rgba(0, 0, 0, 0.15);
        border-color: #ec4899;
    }

    .gallery-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
        transition: transform 0.3s;
    }

    .gallery-item:hover .gallery-image {
        transform: scale(1.1);
    }

    .gallery-remove-btn {
        position: absolute;
        top: 10px;
        right: 10px;
        background: rgba(239, 68, 68, 0.95);
        color: white;
        border: none;
        border-radius: 50%;
        width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: all 0.3s ease;
        opacity: 0;
        transform: scale(0.8);
        box-shadow: 0 4px 12px rgba(239, 68, 68, 0.4);
        z-index: 10;
    }

    .gallery-item:hover .gallery-remove-btn {
        opacity: 1;
        transform: scale(1);
    }

    .gallery-remove-btn:hover {
        background: rgba(220, 38, 38, 1);
        transform: scale(1.15);
        box-shadow: 0 6px 16px rgba(220, 38, 38, 0.5);
    }

    .gallery-remove-btn i {
        font-size: 20px;
    }

    .gallery-upload-box {
        aspect-ratio: 1;
        border: 3px dashed #d1d5db;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, #f9fafb 0%, #f3f4f6 100%);
        transition: all 0.3s ease;
        cursor: pointer;
        position: relative;
        overflow: hidden;
    }

    .gallery-upload-box::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(236, 72, 153, 0.05) 0%, rgba(244, 114, 182, 0.05) 100%);
        opacity: 0;
        transition: opacity 0.3s;
    }

    .gallery-upload-box:hover {
        border-color: #ec4899;
        background: linear-gradient(135deg, rgba(236, 72, 153, 0.08) 0%, rgba(244, 114, 182, 0.08) 100%);
        transform: translateY(-4px);
        box-shadow: 0 8px 24px rgba(236, 72, 153, 0.15);
    }

    .gallery-upload-box:hover::before {
        opacity: 1;
    }

    .gallery-upload-label {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 10px;
        cursor: pointer;
        width: 100%;
        height: 100%;
        color: #6b7280;
        transition: all 0.3s;
        position: relative;
        z-index: 1;
    }

    .gallery-upload-box:hover .gallery-upload-label {
        color: #ec4899;
    }

    .gallery-upload-label i {
        font-size: 40px;
        transition: transform 0.3s;
    }

    .gallery-upload-box:hover .gallery-upload-label i {
        transform: scale(1.1) rotate(90deg);
    }

    .gallery-upload-label span {
        font-weight: 700;
        font-size: 15px;
        letter-spacing: 0.5px;
    }

    #salon_gallery {
        display: none;
    }

    @media (max-width: 768px) {
        .gallery-grid {
            grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
            gap: 12px;
        }
    }

    /* Modern Renk Paleti Seçici - Premium */
    .color-palette-selector-modern {
        padding: 28px;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.98) 0%, rgba(248, 250, 252, 0.98) 100%);
        backdrop-filter: blur(20px) saturate(180%);
        -webkit-backdrop-filter: blur(20px) saturate(180%);
        border-radius: 24px;
        border: 2px solid rgba(236, 72, 153, 0.15);
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08), 0 0 0 1px rgba(236, 72, 153, 0.08), inset 0 1px 0 rgba(255, 255, 255, 0.9);
        position: relative;
        overflow: hidden;
    }

    .color-palette-selector-modern::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, #ec4899, #be185d, #f472b6, #ec4899);
        background-size: 200% 100%;
        animation: gradientShift 3s ease infinite;
        opacity: 0.6;
    }

    @keyframes gradientShift {
        0%, 100% { background-position: 0% 50%; }
        50% { background-position: 100% 50%; }
    }

    .color-option-modern {
        cursor: pointer;
        display: block;
        position: relative;
    }

    .color-option-modern input[type="radio"] {
        position: absolute;
        opacity: 0;
        pointer-events: none;
        width: 0;
        height: 0;
    }

    .color-card {
        background: white;
        border-radius: 18px;
        overflow: hidden;
        border: 3px solid #e5e7eb;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        position: relative;
        transform-style: preserve-3d;
    }

    .color-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, transparent 100%);
        opacity: 0;
        transition: opacity 0.3s;
        z-index: 1;
    }

    .color-preview {
        width: 100%;
        height: 120px;
        position: relative;
        overflow: hidden;
    }

    .color-preview::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, transparent 50%);
    }

    .color-info {
        padding: 14px 18px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: linear-gradient(180deg, rgba(255,255,255,0.95) 0%, rgba(249,250,251,0.95) 100%);
        position: relative;
        z-index: 2;
        border-top: 1px solid rgba(0, 0, 0, 0.05);
    }

    .color-name {
        font-weight: 700;
        font-size: 1rem;
        color: #374151;
        transition: all 0.3s;
        letter-spacing: 0.5px;
    }

    .check-icon {
        font-size: 1.4rem;
        color: #10b981;
        opacity: 0;
        transform: scale(0) rotate(-180deg);
        transition: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        filter: drop-shadow(0 2px 4px rgba(236, 72, 153, 0.3));
    }

    /* Hover Effects */
    .color-option-modern:hover .color-card {
        transform: translateY(-6px) scale(1.02);
        box-shadow: 0 12px 32px rgba(0, 0, 0, 0.15);
        border-color: #d1d5db;
    }

    .color-option-modern:hover .color-card::before {
        opacity: 1;
    }

    .color-option-modern:hover .color-name {
        color: #ec4899;
    }

    /* Active State */
    .color-option-modern.active .color-card {
        border-color: #ec4899;
        box-shadow: 0 12px 36px rgba(236, 72, 153, 0.3), 0 0 0 5px rgba(236, 72, 153, 0.15), inset 0 0 20px rgba(236, 72, 153, 0.05);
        transform: translateY(-6px) scale(1.03);
        animation: colorCardPulse 2s ease-in-out infinite;
    }

    @keyframes colorCardPulse {
        0%, 100% {
            box-shadow: 0 12px 36px rgba(236, 72, 153, 0.3), 0 0 0 5px rgba(236, 72, 153, 0.15);
        }
        50% {
            box-shadow: 0 12px 36px rgba(236, 72, 153, 0.4), 0 0 0 6px rgba(236, 72, 153, 0.2);
        }
    }

    .color-option-modern.active .check-icon {
        opacity: 1;
        transform: scale(1) rotate(0deg);
        animation: checkBounce 0.5s ease;
    }

    @keyframes checkBounce {
        0% { transform: scale(0) rotate(-180deg); }
        50% { transform: scale(1.2) rotate(10deg); }
        100% { transform: scale(1) rotate(0deg); }
    }

    .color-option-modern.active .color-name {
        color: #ec4899;
        font-weight: 700;
    }

    /* Pink Active */
    .color-option-modern[data-color="pink"].active .color-card {
        border-color: #ec4899;
        box-shadow: 0 8px 24px rgba(236, 72, 153, 0.25), 0 0 0 4px rgba(236, 72, 153, 0.1);
    }

    /* Blue Active */
    .color-option-modern[data-color="blue"].active .color-card {
        border-color: #3b82f6;
        box-shadow: 0 8px 24px rgba(59, 130, 246, 0.25), 0 0 0 4px rgba(59, 130, 246, 0.1);
    }

    .color-option-modern[data-color="blue"].active .color-name,
    .color-option-modern[data-color="blue"]:hover .color-name {
        color: #3b82f6;
    }

    .color-option-modern[data-color="blue"].active .check-icon {
        color: #3b82f6;
    }

    /* Purple Active */
    .color-option-modern[data-color="purple"].active .color-card {
        border-color: #8b5cf6;
        box-shadow: 0 8px 24px rgba(139, 92, 246, 0.25), 0 0 0 4px rgba(139, 92, 246, 0.1);
    }

    .color-option-modern[data-color="purple"].active .color-name,
    .color-option-modern[data-color="purple"]:hover .color-name {
        color: #8b5cf6;
    }

    .color-option-modern[data-color="purple"].active .check-icon {
        color: #8b5cf6;
    }

    /* Orange Active */
    .color-option-modern[data-color="orange"].active .color-card {
        border-color: #f97316;
        box-shadow: 0 8px 24px rgba(249, 115, 22, 0.25), 0 0 0 4px rgba(249, 115, 22, 0.1);
    }

    .color-option-modern[data-color="orange"].active .color-name,
    .color-option-modern[data-color="orange"]:hover .color-name {
        color: #f97316;
    }

    .color-option-modern[data-color="orange"].active .check-icon {
        color: #f97316;
    }

    /* Green Active */
    .color-option-modern[data-color="green"].active .color-card {
        border-color: #10b981;
        box-shadow: 0 8px 24px rgba(236, 72, 153, 0.25), 0 0 0 4px rgba(236, 72, 153, 0.1);
    }

    .color-option-modern[data-color="green"].active .color-name,
    .color-option-modern[data-color="green"]:hover .color-name {
        color: #10b981;
    }

    .color-option-modern[data-color="green"].active .check-icon {
        color: #10b981;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .color-palette-selector-modern {
            padding: 16px;
        }

        .color-preview {
            height: 80px;
        }

        .color-info {
            padding: 10px 12px;
        }
    }

</style>
@endpush

@push('scripts')
<script>
    function previewBannerImage(input) {
        if (input.files && input.files[0]) {
            const file = input.files[0];
            const maxSize = 10 * 1024 * 1024; // 10MB
            const allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/gif', 'image/webp'];
            
            // Dosya boyutu kontrolü
            if (file.size > maxSize) {
                alert('Dosya boyutu çok büyük! Maksimum 10 MB olmalıdır.');
                input.value = '';
                return;
            }
            
            // Dosya tipi kontrolü
            if (!allowedTypes.includes(file.type)) {
                alert('Desteklenmeyen dosya formatı! Sadece JPG, PNG, GIF ve WEBP formatları desteklenir.');
                input.value = '';
                return;
            }
            
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.getElementById('bannerImagePreview');
                if (preview) {
                    // Eğer div ise img'e çevir, img ise src'yi güncelle
                    if (preview.tagName === 'DIV') {
                        const img = document.createElement('img');
                        img.src = e.target.result;
                        img.alt = 'Banner';
                        img.id = 'bannerImagePreview';
                        img.style.width = '100%';
                        img.style.height = '100%';
                        img.style.objectFit = 'cover';
                        preview.parentNode.replaceChild(img, preview);
                    } else {
                        preview.src = e.target.result;
                    }
                }
            };
            reader.readAsDataURL(file);
        }
    }

    function previewImage(input) {
        if (input.files && input.files[0]) {
            const file = input.files[0];
            const maxSize = 5 * 1024 * 1024; // 5MB
            const allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/gif', 'image/webp'];
            
            // Dosya boyutu kontrolü
            if (file.size > maxSize) {
                alert('Dosya boyutu çok büyük! Maksimum 5 MB olmalıdır.');
                input.value = '';
                return;
            }
            
            // Dosya tipi kontrolü
            if (!allowedTypes.includes(file.type)) {
                alert('Desteklenmeyen dosya formatı! Sadece JPG, PNG, GIF ve WEBP formatları desteklenir.');
                input.value = '';
                return;
            }
            
            const reader = new FileReader();
            reader.onload = function(e) {
                let preview = document.getElementById('profileImagePreview');
                const placeholder = document.querySelector('.profile-image-placeholder');
                
                if (preview) {
                    preview.src = e.target.result;
                } else if (placeholder) {
                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.alt = 'Profil Fotoğrafı';
                    img.id = 'profileImagePreview';
                    img.className = 'profile-image-preview';
                    img.style.width = '180px';
                    img.style.height = '180px';
                    img.style.borderRadius = '50%';
                    img.style.objectFit = 'cover';
                    img.style.border = '6px solid white';
                    img.style.boxShadow = '0 8px 24px rgba(0,0,0,0.2)';
                    placeholder.parentNode.replaceChild(img, placeholder);
                }
            };
            reader.onerror = function() {
                alert('Dosya okunurken bir hata oluştu. Lütfen başka bir dosya seçin.');
                input.value = '';
            };
            reader.readAsDataURL(file);
        }
    }
    
    // Renk Paleti Seçimi
    document.addEventListener('DOMContentLoaded', function() {
        const colorOptions = document.querySelectorAll('.color-option-modern');
        
        colorOptions.forEach(option => {
            const radio = option.querySelector('input[type="radio"]');
            
            // Label'a tıklandığında
            option.addEventListener('click', function(e) {
                e.preventDefault();
                
                // Tüm active class'ları kaldır
                colorOptions.forEach(opt => {
                    opt.classList.remove('active');
                });
                
                // Seçilen option'a active class ekle
                option.classList.add('active');
                
                // Radio button'ı seç
                if (radio) {
                    radio.checked = true;
                    radio.dispatchEvent(new Event('change', { bubbles: true }));
                }
            });
            
            // Radio button değiştiğinde
            if (radio) {
                radio.addEventListener('change', function() {
                    if (this.checked) {
                        // Tüm active class'ları kaldır
                        colorOptions.forEach(opt => {
                            opt.classList.remove('active');
                        });
                        // Seçilen option'a active class ekle
                        option.classList.add('active');
                    }
                });
            }
        });
        
        // Sayfa yüklendiğinde seçili olanı işaretle
        const checkedRadio = document.querySelector('input[name="salon_color"]:checked');
        if (checkedRadio) {
            const checkedOption = checkedRadio.closest('.color-option-modern');
            if (checkedOption) {
                checkedOption.classList.add('active');
            }
        }
    });
    
    // Form submit kontrolü
    const profileForm = document.getElementById('profileForm');
    if (profileForm) {
        profileForm.addEventListener('submit', function(e) {
            const fileInput = document.getElementById('salon_profile_image');
            if (fileInput && fileInput.files && fileInput.files[0]) {
                const file = fileInput.files[0];
                const maxSize = 5 * 1024 * 1024; // 5MB
                const allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/gif', 'image/webp'];
                
                if (file.size > maxSize) {
                    e.preventDefault();
                    alert('Dosya boyutu çok büyük! Maksimum 5 MB olmalıdır.');
                    return false;
                }
                
                if (!allowedTypes.includes(file.type)) {
                    e.preventDefault();
                    alert('Desteklenmeyen dosya formatı! Sadece JPG, PNG, GIF ve WEBP formatları desteklenir.');
                    return false;
                }
            }
        });
    }
    
    // Slug önizleme
    document.getElementById('salon_short_name').addEventListener('input', function() {
        const value = this.value.toLowerCase()
            .replace(/ğ/g, 'g')
            .replace(/ü/g, 'u')
            .replace(/ş/g, 's')
            .replace(/ı/g, 'i')
            .replace(/ö/g, 'o')
            .replace(/ç/g, 'c')
            .replace(/[^a-z0-9\s-]/g, '')
            .replace(/\s+/g, '-')
            .replace(/-+/g, '-')
            .trim();
        document.getElementById('slug-preview').textContent = value || 'salon-adi';
    });

    // OTP Gönderme Fonksiyonu
    function sendPhoneOtp() {
        const phone = document.getElementById('phone').value.trim();
        if (!phone) {
            alert('Lütfen telefon numarasını giriniz.');
            return;
        }

        const btn = document.getElementById('sendPhoneOtpBtn');
        const status = document.getElementById('phoneOtpStatus');
        const otpField = document.getElementById('phoneOtpField');

        if (!btn || !status) return;

        btn.disabled = true;
        btn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Gönderiliyor...';
        status.textContent = '';
        status.style.color = '';

        fetch('{{ route("admin.beauty-salon.profile.send-phone-otp") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json'
            },
            body: JSON.stringify({ new_phone: phone })
        })
        .then(response => response.json())
        .then(data => {
            if (!btn || !status) return;

            if (data.success) {
                status.textContent = '✓ Doğrulama kodu gönderildi. Lütfen telefonunuza gelen kodu giriniz.';
                status.style.color = '#10b981';
                if (otpField) {
                    otpField.style.display = 'block';
                    document.getElementById('phone_otp').focus();
                }
                btn.innerHTML = '<i class="bi bi-check-circle me-1"></i>Kod Gönderildi';
            } else {
                status.textContent = '✗ ' + (data.message || 'Kod gönderilemedi.');
                status.style.color = '#dc3545';
                btn.disabled = false;
                btn.innerHTML = '<i class="bi bi-send me-1"></i>OTP Kodu Gönder';
            }
        })
        .catch(error => {
            console.error('OTP gönderme hatası:', error);
            if (!btn || !status) return;

            status.textContent = '✗ Bir hata oluştu. Lütfen tekrar deneyin.';
            status.style.color = '#dc3545';
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-send me-1"></i>OTP Kodu Gönder';
        });
    }

    // Telefon numarası değiştiğinde OTP alanını sıfırla
    document.getElementById('phone').addEventListener('input', function() {
        const otpField = document.getElementById('phoneOtpField');
        const otpInput = document.getElementById('phone_otp');
        const status = document.getElementById('phoneOtpStatus');
        const btn = document.getElementById('sendPhoneOtpBtn');
        
        if (otpField) {
            otpField.style.display = 'none';
        }
        if (otpInput) {
            otpInput.value = '';
        }
        if (status) {
            status.textContent = '';
        }
        if (btn) {
            btn.disabled = false;
            btn.innerHTML = '<i class="bi bi-send me-1"></i>OTP Kodu Gönder';
        }
    });
    
    // İl/İlçe Seçimi (tüm ilçeler yerelde - API bağımlılığı yok)
    const salonCitySelect = document.getElementById('salon_city');
    const salonDistrictSelect = document.getElementById('salon_district');
    const currentCity = '{{ old('salon_city', $user->salon_city ?? '') }}';
    const currentDistrict = '{{ old('salon_district', $user->salon_district ?? '') }}';
    const allDistricts = @json(\App\Helpers\DistrictHelper::getAllDistricts());
    
    if (salonCitySelect && salonDistrictSelect) {
        function loadDistrictsForCity(selectedCity) {
            if (selectedCity) {
                salonDistrictSelect.disabled = false;
                salonDistrictSelect.innerHTML = '<option value="">İlçe Seçin</option>';
                const cityDistricts = allDistricts[selectedCity] || [];
                cityDistricts.forEach(district => {
                    const option = document.createElement('option');
                    option.value = district;
                    option.textContent = district;
                    if (currentDistrict && district === currentDistrict) {
                        option.selected = true;
                    }
                    salonDistrictSelect.appendChild(option);
                });
                if (cityDistricts.length === 0) {
                    salonDistrictSelect.innerHTML = '<option value="">Bu il için ilçe bulunamadı</option>';
                }
            } else {
                salonDistrictSelect.disabled = true;
                salonDistrictSelect.innerHTML = '<option value="">Önce il seçin</option>';
            }
        }
        salonCitySelect.addEventListener('change', function() {
            loadDistrictsForCity(this.value);
        });
        
        // Sayfa yüklendiğinde mevcut il için ilçeleri yükle
        if (currentCity) {
            salonCitySelect.dispatchEvent(new Event('change'));
        }
        
        // İl/İlçe seçildiğinde localStorage'a kaydet (ana sayfadaki seçim için)
        salonCitySelect.addEventListener('change', function() {
            const selectedCity = this.value;
            if (selectedCity) {
                localStorage.setItem('selectedCity', selectedCity);
            } else {
                localStorage.removeItem('selectedCity');
            }
        });
        
        salonDistrictSelect.addEventListener('change', function() {
            const selectedDistrict = this.value;
            if (selectedDistrict) {
                localStorage.setItem('selectedDistrict', selectedDistrict);
            } else {
                localStorage.removeItem('selectedDistrict');
            }
        });
    }

    // Çalışma saatleri: kapalı günlerde saat alanlarını pasif yap
    document.querySelectorAll('.js-working-day-toggle').forEach((toggle) => {
        const row = toggle.closest('.working-hours-row');
        if (!row) return;
        const timeInputs = row.querySelectorAll('.js-working-day-time');
        const refreshState = () => {
            timeInputs.forEach((input) => {
                input.disabled = !toggle.checked;
            });
        };
        toggle.addEventListener('change', refreshState);
        refreshState();
    });
</script>
@endpush

@endsection

