@extends('layouts.admin')

@section('title', 'Yeni Şube')
@section('page-title', 'Yeni Şube')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-building me-2"></i>Yeni Şube Ekle
                </h2>
                <a href="{{ route('admin.beauty-salon.branches.index') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-2"></i>Geri
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white fw-bold">
                        <i class="bi bi-building me-2"></i>Şube Bilgileri
                    </h5>
                </div>
                <div class="card-body p-4">
                    <form action="{{ route('admin.beauty-salon.branches.store') }}" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Şube Adı <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" required>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Telefon</label>
                                <input type="text" name="phone" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Şube Yöneticisi</label>
                                <select name="branch_manager_id" class="form-select">
                                    <option value="">Yönetici Seçin</option>
                                    @foreach($staff as $person)
                                        <option value="{{ $person->id }}">{{ $person->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Adres</label>
                            <textarea name="address" class="form-control" rows="3"></textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">İl</label>
                                <input type="text" name="city" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">İlçe</label>
                                <input type="text" name="district" class="form-control">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Gelir Paylaşım Yüzdesi (%)</label>
                                <input type="number" name="revenue_share_percentage" class="form-control" step="0.01" min="0" max="100" value="0">
                                <small class="text-muted">Şube gelirinin yüzde kaçı şubeye kalacak (0-100)</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Yetkiler</label>
                                <div class="form-check mt-2">
                                    <input class="form-check-input" type="checkbox" name="can_create_campaigns" id="can_create_campaigns" value="1">
                                    <label class="form-check-label" for="can_create_campaigns">
                                        Şube özel kampanya oluşturabilir
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex gap-2 mt-4">
                            <button type="submit" class="btn btn-primary flex-fill" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                                <i class="bi bi-check-circle me-2"></i>Kaydet
                            </button>
                            <a href="{{ route('admin.beauty-salon.branches.index') }}" class="btn btn-secondary">
                                İptal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

