@extends('layouts.admin')

@section('title', 'Şube Yönetimi')
@section('page-title', 'Şube Yönetimi')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-building me-2"></i>Şube Yönetimi
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.branches.create') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Şube
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row g-4">
        @forelse($branches as $branch)
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-sm h-100" style="border: none; border-radius: 16px; transition: all 0.3s;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 24px rgba(0,0,0,0.15)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.1)'">
                    <div class="card-header" style="background: linear-gradient(135deg, {{ $branch->status === 'active' ? '#10b981' : ($branch->status === 'suspended' ? '#ef4444' : '#6b7280') }} 0%, {{ $branch->status === 'active' ? '#047857' : ($branch->status === 'suspended' ? '#dc2626' : '#4b5563') }} 100%); border-radius: 16px 16px 0 0;">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-white fw-bold">{{ $branch->name }}</h5>
                            @if($branch->status === 'active')
                                <span class="badge bg-white text-success">Aktif</span>
                            @elseif($branch->status === 'suspended')
                                <span class="badge bg-white text-danger">Askıya Alındı</span>
                            @else
                                <span class="badge bg-white text-secondary">Pasif</span>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">
                        @if($branch->branchManager)
                            <div class="mb-3">
                                <span class="text-muted small">Yönetici:</span>
                                <div class="fw-bold">{{ $branch->branchManager->name }}</div>
                            </div>
                        @endif
                        
                        @if($branch->phone)
                            <div class="mb-3">
                                <span class="text-muted small"><i class="bi bi-telephone me-1"></i>Telefon:</span>
                                <div>{{ $branch->phone }}</div>
                            </div>
                        @endif

                        @if($branch->address)
                            <div class="mb-3">
                                <span class="text-muted small"><i class="bi bi-geo-alt me-1"></i>Adres:</span>
                                <div>{{ $branch->address }}</div>
                                @if($branch->city || $branch->district)
                                    <div class="text-muted small">{{ $branch->city }}{{ $branch->district ? ', ' . $branch->district : '' }}</div>
                                @endif
                            </div>
                        @endif

                        <div class="mb-3">
                            <span class="text-muted small">Gelir Paylaşımı:</span>
                            <div class="fw-bold text-primary">{{ number_format($branch->revenue_share_percentage, 2, ',', '.') }}%</div>
                        </div>

                        <div class="d-flex gap-2 mt-3">
                            <a href="{{ route('admin.beauty-salon.branches.show', $branch->id) }}" class="btn btn-sm btn-info flex-fill">
                                <i class="bi bi-eye"></i> Detay
                            </a>
                            <a href="{{ route('admin.beauty-salon.branches.edit', $branch->id) }}" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="{{ route('admin.beauty-salon.branches.destroy', $branch->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu şubeyi silmek istediğinize emin misiniz?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="card shadow-sm text-center py-5" style="border: none; border-radius: 16px;">
                    <i class="bi bi-building" style="font-size: 64px; color: #ccc;"></i>
                    <h5 class="mt-3 text-muted">Henüz şube oluşturulmamış</h5>
                    <p class="text-muted">İlk şubenizi oluşturun ve çok şubeli yapıya geçin.</p>
                    <a href="{{ route('admin.beauty-salon.branches.create') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Şubeyi Oluştur
                    </a>
                </div>
            </div>
        @endforelse
    </div>
</div>
@endsection

