@extends('layouts.admin')

@section('title', 'Şube Detayı')
@section('page-title', 'Şube Detayı: ' . $branch->name)

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-building me-2"></i>{{ $branch->name }}
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.branches.edit', $branch->id) }}" class="btn btn-warning">
                        <i class="bi bi-pencil me-2"></i>Düzenle
                    </a>
                    <a href="{{ route('admin.beauty-salon.branches.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-4">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white fw-bold">
                        <i class="bi bi-info-circle me-2"></i>Şube Bilgileri
                    </h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <span class="text-muted small">Durum:</span>
                        <div>
                            @if($branch->status === 'active')
                                <span class="badge bg-success">Aktif</span>
                            @elseif($branch->status === 'suspended')
                                <span class="badge bg-danger">Askıya Alındı</span>
                            @else
                                <span class="badge bg-secondary">Pasif</span>
                            @endif
                        </div>
                    </div>

                    @if($branch->branchManager)
                        <div class="mb-3">
                            <span class="text-muted small">Yönetici:</span>
                            <div class="fw-bold">{{ $branch->branchManager->name }}</div>
                        </div>
                    @endif

                    @if($branch->phone)
                        <div class="mb-3">
                            <span class="text-muted small">Telefon:</span>
                            <div><a href="tel:{{ $branch->phone }}">{{ $branch->phone }}</a></div>
                        </div>
                    @endif

                    @if($branch->address)
                        <div class="mb-3">
                            <span class="text-muted small">Adres:</span>
                            <div>{{ $branch->address }}</div>
                            @if($branch->city || $branch->district)
                                <div class="text-muted small">{{ $branch->city }}{{ $branch->district ? ', ' . $branch->district : '' }}</div>
                            @endif
                        </div>
                    @endif

                    <div class="mb-3">
                        <span class="text-muted small">Gelir Paylaşımı:</span>
                        <div class="fw-bold text-primary">{{ number_format($branch->revenue_share_percentage, 2, ',', '.') }}%</div>
                    </div>

                    <div class="mb-3">
                        <span class="text-muted small">Kampanya Oluşturma:</span>
                        <div>
                            @if($branch->can_create_campaigns)
                                <span class="badge bg-success">Evet</span>
                            @else
                                <span class="badge bg-secondary">Hayır</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white fw-bold">
                        <i class="bi bi-people me-2"></i>Şube Personeli
                        <span class="badge bg-white text-success ms-2">{{ $branch->staff->count() }}</span>
                    </h5>
                </div>
                <div class="card-body">
                    @if($branch->staff->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Personel</th>
                                        <th>Rol</th>
                                        <th>Durum</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branch->staff as $staffMember)
                                        <tr>
                                            <td>{{ $staffMember->staff->name ?? 'Personel' }}</td>
                                            <td>
                                                @if($staffMember->role === 'manager')
                                                    <span class="badge bg-primary">Yönetici</span>
                                                @elseif($staffMember->role === 'admin')
                                                    <span class="badge bg-danger">Admin</span>
                                                @else
                                                    <span class="badge bg-info">Personel</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($staffMember->is_active)
                                                    <span class="badge bg-success">Aktif</span>
                                                @else
                                                    <span class="badge bg-secondary">Pasif</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-people" style="font-size: 48px; color: #ccc;"></i>
                            <p class="text-muted mt-3">Bu şubeye henüz personel atanmamış.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

