@extends('layouts.admin')

@section('title', 'Yeni Kampanya Oluştur')
@section('page-title', 'Yeni Kampanya')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-plus-circle me-2"></i>Yeni Kampanya Oluştur
                </h2>
                <a href="{{ route('admin.beauty-salon.campaigns.index') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-2"></i>Geri
                </a>
            </div>
        </div>
    </div>

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-info-circle me-2"></i>Kampanya Bilgileri
            </h5>
        </div>
        <div class="card-body p-4">
            <form action="{{ route('admin.beauty-salon.campaigns.store') }}" method="POST">
                @csrf
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="name" class="form-label fw-bold">Kampanya Adı <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" placeholder="Örn: Yılbaşı İndirimi" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="type" class="form-label fw-bold">Kampanya Türü <span class="text-danger">*</span></label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">Seçiniz</option>
                            <option value="time_based" {{ old('type') == 'time_based' ? 'selected' : '' }}>Zaman Bazlı</option>
                            <option value="visit_based" {{ old('type') == 'visit_based' ? 'selected' : '' }}>Ziyaret Bazlı</option>
                            <option value="spend_based" {{ old('type') == 'spend_based' ? 'selected' : '' }}>Harcama Bazlı</option>
                            <option value="segment_based" {{ old('type') == 'segment_based' ? 'selected' : '' }}>Segment Bazlı</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12">
                        <label for="description" class="form-label fw-bold">Açıklama</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" placeholder="Kampanya hakkında açıklama...">{{ old('description') }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="start_date" class="form-label fw-bold">Başlangıç Tarihi <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('start_date') is-invalid @enderror" id="start_date" name="start_date" value="{{ old('start_date') }}" required>
                        @error('start_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="end_date" class="form-label fw-bold">Bitiş Tarihi</label>
                        <input type="date" class="form-control @error('end_date') is-invalid @enderror" id="end_date" name="end_date" value="{{ old('end_date') }}">
                        @error('end_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="discount_percentage" class="form-label fw-bold">İndirim Yüzdesi (%)</label>
                        <input type="number" step="0.01" class="form-control @error('discount_percentage') is-invalid @enderror" id="discount_percentage" name="discount_percentage" value="{{ old('discount_percentage') }}" placeholder="Örn: 20" min="0" max="100">
                        @error('discount_percentage')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="discount_amount" class="form-label fw-bold">İndirim Tutarı (₺)</label>
                        <input type="number" step="0.01" class="form-control @error('discount_amount') is-invalid @enderror" id="discount_amount" name="discount_amount" value="{{ old('discount_amount') }}" placeholder="Örn: 50" min="0">
                        @error('discount_amount')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="budget" class="form-label fw-bold">Bütçe (₺)</label>
                        <input type="number" step="0.01" class="form-control @error('budget') is-invalid @enderror" id="budget" name="budget" value="{{ old('budget') }}" placeholder="Örn: 5000" min="0">
                        @error('budget')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="max_redemptions" class="form-label fw-bold">Maksimum Kullanım</label>
                        <input type="number" class="form-control @error('max_redemptions') is-invalid @enderror" id="max_redemptions" name="max_redemptions" value="{{ old('max_redemptions') }}" placeholder="Örn: 100" min="1">
                        @error('max_redemptions')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6">
                        <label for="status" class="form-label fw-bold">Durum <span class="text-danger">*</span></label>
                        <select class="form-select @error('status') is-invalid @enderror" id="status" name="status" required>
                            <option value="draft" {{ old('status') == 'draft' ? 'selected' : '' }}>Taslak</option>
                            <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>Aktif</option>
                            <option value="paused" {{ old('status') == 'paused' ? 'selected' : '' }}>Duraklatıldı</option>
                        </select>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12 mt-4">
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                                <i class="bi bi-check-circle me-2"></i>Kampanya Oluştur
                            </button>
                            <a href="{{ route('admin.beauty-salon.campaigns.index') }}" class="btn btn-secondary">
                                <i class="bi bi-x-circle me-2"></i>İptal
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
