@extends('layouts.admin')

@section('title', 'Kampanyalar')
@section('page-title', 'Kampanyalar')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-megaphone-fill me-2"></i>Kampanyalar
                </h2>
                <a href="{{ route('admin.beauty-salon.campaigns.create') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                    <i class="bi bi-plus-circle me-2"></i>Yeni Kampanya Oluştur
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Kampanya Listesi
            </h5>
        </div>
        <div class="card-body">
            @if($campaigns->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Kampanya Adı</th>
                                <th>Türü</th>
                                <th>Durum</th>
                                <th>Başlangıç</th>
                                <th>Bitiş</th>
                                <th>Kullanım</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($campaigns as $campaign)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $campaign->name }}</div>
                                        @if($campaign->description)
                                            <small class="text-muted">{{ Str::limit($campaign->description, 50) }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($campaign->type === 'time_based')
                                            <span class="badge bg-info">Zaman Bazlı</span>
                                        @elseif($campaign->type === 'visit_based')
                                            <span class="badge bg-success">Ziyaret Bazlı</span>
                                        @elseif($campaign->type === 'spend_based')
                                            <span class="badge bg-warning text-dark">Harcama Bazlı</span>
                                        @else
                                            <span class="badge bg-primary">Segment Bazlı</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($campaign->status === 'active')
                                            <span class="badge bg-success">Aktif</span>
                                        @elseif($campaign->status === 'paused')
                                            <span class="badge bg-warning text-dark">Duraklatıldı</span>
                                        @elseif($campaign->status === 'completed')
                                            <span class="badge bg-info">Tamamlandı</span>
                                        @elseif($campaign->status === 'cancelled')
                                            <span class="badge bg-danger">İptal</span>
                                        @else
                                            <span class="badge bg-secondary">Taslak</span>
                                        @endif
                                    </td>
                                    <td>{{ $campaign->start_date ? \Carbon\Carbon::parse($campaign->start_date)->format('d.m.Y') : '-' }}</td>
                                    <td>{{ $campaign->end_date ? \Carbon\Carbon::parse($campaign->end_date)->format('d.m.Y') : '-' }}</td>
                                    <td>
                                        @if($campaign->max_redemptions)
                                            {{ $campaign->redemptions_count }} / {{ $campaign->max_redemptions }}
                                        @else
                                            {{ $campaign->redemptions_count }}
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex gap-1">
                                            <a href="{{ route('admin.beauty-salon.campaigns.show', $campaign->id) }}" class="btn btn-sm btn-info">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.beauty-salon.campaigns.edit', $campaign->id) }}" class="btn btn-sm btn-warning">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <form action="{{ route('admin.beauty-salon.campaigns.destroy', $campaign->id) }}" method="POST" class="d-inline-block" onsubmit="return confirm('Bu kampanyayı silmek istediğinizden emin misiniz?');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $campaigns->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-megaphone" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz kampanya oluşturulmamış.</p>
                    <a href="{{ route('admin.beauty-salon.campaigns.create') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Kampanyayı Oluştur
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
