@extends('layouts.admin')

@section('title', 'Tavsiye Et, 1 Ay Kazan')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Tavsiye Et</li>
@endsection

@section('content')
    <h2 class="mb-4">Tavsiye Et, 1 Ay Kazan</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-people"></i> Referans Kampanyası</h5>
        </div>
        <div class="card-body">
            <div class="alert alert-success">
                <h5><i class="bi bi-gift"></i> Kampanya Detayları</h5>
                <p class="mb-0">Arkadaşlarınızı tavsiye edin, 1 ay ücretsiz kazanın!</p>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-12">
                    <div class="card border-primary">
                        <div class="card-body">
                            <h5 class="card-title">Referans Linkiniz</h5>
                            <div class="input-group input-group-lg">
                                <input type="text" class="form-control" value="{{ url('/?ref=' . Auth::id()) }}" readonly>
                                <button class="btn btn-primary" onclick="copyReferralLink()">
                                    <i class="bi bi-clipboard"></i> Kopyala
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <i class="bi bi-person-plus" style="font-size: 36px; color: #007bff;"></i>
                            <h4 class="mt-3">0</h4>
                            <p class="text-muted">Tavsiye Edilen</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <i class="bi bi-check-circle" style="font-size: 36px; color: #28a745;"></i>
                            <h4 class="mt-3">0</h4>
                            <p class="text-muted">Kayıt Olan</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <i class="bi bi-calendar-check" style="font-size: 36px; color: #ffc107;"></i>
                            <h4 class="mt-3">0</h4>
                            <p class="text-muted">Kazanılan Ay</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
function copyReferralLink() {
    const input = document.querySelector('input[readonly]');
    input.select();
    document.execCommand('copy');
    alert('Referans linki kopyalandı!');
}
</script>
@endpush

