@extends('layouts.admin')

@section('title', '1000 SMS Kazan')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">1000 SMS Kazan</li>
@endsection

@section('content')
    <h2 class="mb-4">1000 SMS Kazan</h2>
    
    <div class="card shadow-sm">
        <div class="card-header bg-success text-white">
            <h5 class="mb-0"><i class="bi bi-gift"></i> Kampanya Detayları</h5>
        </div>
        <div class="card-body">
            <div class="alert alert-info">
                <h5><i class="bi bi-info-circle"></i> Kampanya Bilgileri</h5>
                <p class="mb-0">Bu kampanya ile 1000 SMS kazanabilirsiniz. Detaylar için lütfen destek ekibimizle iletişime geçin.</p>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="card border-success">
                        <div class="card-body text-center">
                            <i class="bi bi-chat-dots-fill" style="font-size: 48px; color: #28a745;"></i>
                            <h3 class="mt-3">1000 SMS</h3>
                            <p class="text-muted">Kampanya hediyesi</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5>Kampanya Şartları</h5>
                            <ul>
                                <li>Yeni üyelikler için geçerlidir</li>
                                <li>Minimum 3 ay üyelik gereklidir</li>
                                <li>Kampanya kodu ile başvuru yapılmalıdır</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

