@extends('layouts.admin')

@section('title', 'Müşteri Değer Analizi (CLV)')
@section('page-title', 'Müşteri Değer Analizi (CLV)')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-graph-up-arrow me-2"></i>Müşteri Değer Analizi (CLV)
                </h2>
                <div class="d-flex gap-2">
                    <form action="{{ route('admin.beauty-salon.clv.calculate') }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-success">
                            <i class="bi bi-calculator me-2"></i>CLV Hesapla
                        </button>
                    </form>
                    <a href="{{ route('admin.beauty-salon.clv.segments') }}" class="btn btn-info">
                        <i class="bi bi-diagram-3 me-2"></i>Segmentler
                    </a>
                    <a href="{{ route('admin.beauty-salon.clv.offers') }}" class="btn btn-warning">
                        <i class="bi bi-gift me-2"></i>Teklifler
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- CLV Açıklaması -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow-sm" style="border: none; border-radius: 16px; background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);">
                <div class="card-body p-4">
                    <div class="d-flex align-items-start">
                        <div class="me-3">
                            <i class="bi bi-info-circle-fill" style="font-size: 32px; color: #06b6d4;"></i>
                        </div>
                        <div class="flex-grow-1">
                            <h4 class="fw-bold mb-3" style="color: #0c4a6e;">
                                <i class="bi bi-question-circle me-2"></i>CLV (Customer Lifetime Value) Nedir?
                            </h4>
                            <p class="mb-3" style="color: #075985; line-height: 1.8;">
                                <strong>Müşteri Yaşam Boyu Değeri (CLV)</strong>, bir müşterinin salonunuzla olan tüm ilişkisi boyunca size getireceği toplam geliri tahmin eden bir metrikdir. Bu değer, müşterilerinizin ne kadar değerli olduğunu anlamanıza ve pazarlama stratejilerinizi buna göre şekillendirmenize yardımcı olur.
                            </p>
                            
                            <div class="row g-3 mb-3">
                                <div class="col-md-6">
                                    <div class="d-flex align-items-start">
                                        <i class="bi bi-check-circle-fill text-success me-2 mt-1" style="font-size: 18px;"></i>
                                        <div>
                                            <strong style="color: #0c4a6e;">Nasıl Hesaplanır?</strong>
                                            <p class="mb-0 small" style="color: #075985;">
                                                CLV = Ortalama Sipariş Değeri × Satın Alma Sıklığı × Müşteri Yaşam Süresi
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-start">
                                        <i class="bi bi-lightbulb-fill text-warning me-2 mt-1" style="font-size: 18px;"></i>
                                        <div>
                                            <strong style="color: #0c4a6e;">Neden Önemli?</strong>
                                            <p class="mb-0 small" style="color: #075985;">
                                                Yüksek CLV'li müşterilere özel kampanyalar yaparak gelirinizi artırabilir, düşük CLV'li müşterileri kaybetme riskini önceden tespit edebilirsiniz.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="alert alert-info mb-0" style="background: rgba(255, 255, 255, 0.7); border-left: 4px solid #06b6d4;">
                                <div class="d-flex align-items-start">
                                    <i class="bi bi-graph-up-arrow me-2 mt-1" style="font-size: 20px; color: #06b6d4;"></i>
                                    <div>
                                        <strong>İpuçları:</strong>
                                        <ul class="mb-0 small" style="color: #075985;">
                                            <li>Yüksek CLV skorlu müşterilerinize VIP hizmetler ve özel indirimler sunun</li>
                                            <li>Churn riski yüksek müşterileri tespit edip onlara özel teklifler gönderin</li>
                                            <li>Segmentlere göre müşterilerinizi gruplayarak hedefli pazarlama yapın</li>
                                            <li>CLV skorlarını düzenli olarak hesaplayarak müşteri değerlerini takip edin</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- İstatistikler -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px;">
                <div class="card-body">
                    <h3 class="fw-bold text-primary">{{ $totalCustomers }}</h3>
                    <p class="text-muted mb-0">Toplam Müşteri</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px;">
                <div class="card-body">
                    <h3 class="fw-bold text-success">{{ $vipCustomers }}</h3>
                    <p class="text-muted mb-0">VIP Müşteri</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px;">
                <div class="card-body">
                    <h3 class="fw-bold text-danger">{{ $highRiskCustomers }}</h3>
                    <p class="text-muted mb-0">Yüksek Risk</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px;">
                <div class="card-body">
                    <h3 class="fw-bold text-info">{{ $segments->count() }}</h3>
                    <p class="text-muted mb-0">Aktif Segment</p>
                </div>
            </div>
        </div>
    </div>

    <!-- CLV Skorları Listesi -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white fw-bold">
                        <i class="bi bi-list-ul me-2"></i>Müşteri CLV Skorları
                    </h5>
                </div>
                <div class="card-body">
                    @if($clvScores->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th>Müşteri</th>
                                        <th>Segment</th>
                                        <th>CLV Skoru</th>
                                        <th>Toplam Harcama</th>
                                        <th>Ziyaret</th>
                                        <th>Churn Riski</th>
                                        <th>VIP</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($clvScores as $score)
                                        <tr>
                                            <td>
                                                <div class="fw-bold">{{ $score->customer->name ?? 'Müşteri' }}</div>
                                                <small class="text-muted">{{ $score->customer->phone ?? '-' }}</small>
                                            </td>
                                            <td>
                                                @if($score->segment)
                                                    <span class="badge bg-primary">{{ $score->segment->name }}</span>
                                                @else
                                                    <span class="badge bg-secondary">Segment Yok</span>
                                                @endif
                                            </td>
                                            <td>
                                                <span class="fw-bold text-primary">{{ number_format($score->clv_score, 2, ',', '.') }} ₺</span>
                                            </td>
                                            <td>{{ number_format($score->total_spend, 2, ',', '.') }} ₺</td>
                                            <td>{{ $score->total_visits }}</td>
                                            <td>
                                                @if($score->churn_risk_level === 'critical')
                                                    <span class="badge bg-danger">Kritik</span>
                                                @elseif($score->churn_risk_level === 'high')
                                                    <span class="badge bg-warning text-dark">Yüksek</span>
                                                @elseif($score->churn_risk_level === 'medium')
                                                    <span class="badge bg-info">Orta</span>
                                                @else
                                                    <span class="badge bg-success">Düşük</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($score->is_vip)
                                                    <span class="badge bg-warning text-dark">VIP</span>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $clvScores->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-graph-up-arrow" style="font-size: 48px; color: #ccc;"></i>
                            <p class="text-muted mt-3">Henüz CLV skoru hesaplanmamış.</p>
                            <form action="{{ route('admin.beauty-salon.clv.calculate') }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                                    <i class="bi bi-calculator me-2"></i>CLV Hesapla
                                </button>
                            </form>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

