@extends('layouts.admin')

@section('title', 'Kişiselleştirilmiş Teklifler')
@section('page-title', 'Kişiselleştirilmiş Teklifler')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-gift me-2"></i>Kişiselleştirilmiş Teklifler
                </h2>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createOfferModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Teklif Oluştur
                    </button>
                    <a href="{{ route('admin.beauty-salon.clv.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Teklif Listesi
            </h5>
        </div>
        <div class="card-body">
            @if($offers->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Müşteri</th>
                                <th>Segment</th>
                                <th>Teklif Türü</th>
                                <th>İndirim</th>
                                <th>Durum</th>
                                <th>Geçerlilik</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($offers as $offer)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $offer->customer->name ?? 'Müşteri' }}</div>
                                        @if($offer->customer && $offer->customer->phone)
                                            <small class="text-muted">{{ $offer->customer->phone }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($offer->segment)
                                            <span class="badge bg-primary">{{ $offer->segment->name }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($offer->offer_type === 'discount')
                                            <span class="badge bg-success">İndirim</span>
                                        @elseif($offer->offer_type === 'free_service')
                                            <span class="badge bg-info">Ücretsiz Hizmet</span>
                                        @elseif($offer->offer_type === 'package')
                                            <span class="badge bg-warning text-dark">Paket</span>
                                        @else
                                            <span class="badge bg-secondary">{{ $offer->offer_type }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($offer->discount_type === 'percentage')
                                            %{{ number_format($offer->discount_value, 0) }}
                                        @elseif($offer->discount_type === 'fixed')
                                            {{ number_format($offer->discount_value, 2, ',', '.') }} ₺
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($offer->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-danger">Pasif</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($offer->valid_until)
                                            @if($offer->valid_until->isPast())
                                                <span class="badge bg-danger">Süresi Dolmuş</span>
                                            @else
                                                {{ $offer->valid_until->format('d.m.Y') }}
                                            @endif
                                        @else
                                            <span class="text-muted">Sınırsız</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#offerDetailModal{{ $offer->id }}">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                    </td>
                                </tr>

                                <!-- Offer Detail Modal -->
                                <div class="modal fade" id="offerDetailModal{{ $offer->id }}" tabindex="-1" aria-labelledby="offerDetailModalLabel{{ $offer->id }}" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="offerDetailModalLabel{{ $offer->id }}">Teklif Detayı</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p><strong>Müşteri:</strong> {{ $offer->customer->name ?? 'Müşteri' }}</p>
                                                @if($offer->segment)
                                                    <p><strong>Segment:</strong> {{ $offer->segment->name }}</p>
                                                @endif
                                                <p><strong>Teklif Türü:</strong>
                                                    @if($offer->offer_type === 'discount')
                                                        İndirim
                                                    @elseif($offer->offer_type === 'free_service')
                                                        Ücretsiz Hizmet
                                                    @elseif($offer->offer_type === 'package')
                                                        Paket
                                                    @else
                                                        {{ $offer->offer_type }}
                                                    @endif
                                                </p>
                                                @if($offer->discount_type)
                                                    <p><strong>İndirim:</strong>
                                                        @if($offer->discount_type === 'percentage')
                                                            %{{ number_format($offer->discount_value, 0) }}
                                                        @elseif($offer->discount_type === 'fixed')
                                                            {{ number_format($offer->discount_value, 2, ',', '.') }} ₺
                                                        @endif
                                                    </p>
                                                @endif
                                                @if($offer->description)
                                                    <p><strong>Açıklama:</strong> {{ $offer->description }}</p>
                                                @endif
                                                <p><strong>Durum:</strong>
                                                    @if($offer->is_active)
                                                        <span class="badge bg-success">Aktif</span>
                                                    @else
                                                        <span class="badge bg-danger">Pasif</span>
                                                    @endif
                                                </p>
                                                @if($offer->valid_until)
                                                    <p><strong>Geçerlilik:</strong>
                                                        @if($offer->valid_until->isPast())
                                                            <span class="badge bg-danger">Süresi Dolmuş ({{ $offer->valid_until->format('d.m.Y') }})</span>
                                                        @else
                                                            {{ $offer->valid_until->format('d.m.Y') }}
                                                        @endif
                                                    </p>
                                                @endif
                                                <p><strong>Oluşturulma:</strong> {{ $offer->created_at->format('d.m.Y H:i') }}</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $offers->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-gift" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz kişiselleştirilmiş teklif oluşturulmamış.</p>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createOfferModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Teklifi Oluştur
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Create Offer Modal -->
<div class="modal fade" id="createOfferModal" tabindex="-1" aria-labelledby="createOfferModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" style="max-width: 800px;">
        <div class="modal-content" style="border: none; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; padding: 20px 24px;">
                <h5 class="modal-title text-white fw-bold mb-0" id="createOfferModalLabel">
                    <i class="bi bi-gift me-2"></i>Yeni Teklif Oluştur
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="opacity: 1;"></button>
            </div>
            <form action="#" method="POST" id="createOfferForm">
                @csrf
                <div class="modal-body" style="padding: 24px; max-height: 70vh; overflow-y: auto;">
                    <div class="alert alert-info mb-4" style="border-radius: 12px; border: none; background: #e0f2fe;">
                        <i class="bi bi-lightbulb me-2"></i><strong>Kişiselleştirilmiş Teklif Nedir?</strong><br>
                        <small>Müşterilerinize CLV değerlerine ve segmentlerine göre özel teklifler sunabilirsiniz. Bu sayede müşteri memnuniyetini ve geliri artırabilirsiniz.</small>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="customer_id" class="form-label">Müşteri</label>
                            <select class="form-select" id="customer_id" name="customer_id" required>
                                <option value="">Seçiniz</option>
                                <!-- Müşteriler buraya dinamik olarak yüklenecek -->
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="segment_id" class="form-label">Segment</label>
                            <select class="form-select" id="segment_id" name="segment_id">
                                <option value="">Seçiniz (Opsiyonel)</option>
                                @foreach($segments as $segment)
                                    <option value="{{ $segment->id }}">{{ $segment->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="offer_type" class="form-label">Teklif Türü</label>
                            <select class="form-select" id="offer_type" name="offer_type" required>
                                <option value="">Seçiniz</option>
                                <option value="discount">İndirim</option>
                                <option value="free_service">Ücretsiz Hizmet</option>
                                <option value="package">Paket</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="discount_type" class="form-label">İndirim Türü</label>
                            <select class="form-select" id="discount_type" name="discount_type">
                                <option value="">Seçiniz</option>
                                <option value="percentage">Yüzde (%)</option>
                                <option value="fixed">Sabit Tutar (₺)</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="discount_value" class="form-label">İndirim Değeri</label>
                            <input type="number" step="0.01" class="form-control" id="discount_value" name="discount_value" placeholder="Örn: 10 veya 50">
                        </div>
                        <div class="col-md-6">
                            <label for="valid_until" class="form-label">Geçerlilik Tarihi</label>
                            <input type="date" class="form-control" id="valid_until" name="valid_until">
                        </div>
                        <div class="col-12">
                            <label for="description" class="form-label">Açıklama</label>
                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="Teklif açıklaması..."></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 16px 24px; background: #f9fafb; border-radius: 0 0 16px 16px;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">
                        <i class="bi bi-x-circle me-2"></i>İptal
                    </button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 8px; padding: 10px 24px; font-weight: 600;">
                        <i class="bi bi-check-circle me-2"></i>Teklif Oluştur
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Form submit handler - şimdilik sadece alert göster
    document.getElementById('createOfferForm')?.addEventListener('submit', function(e) {
        e.preventDefault();
        // Form submit handler - şimdilik sadece alert göster
        // TODO: Backend endpoint'i eklendiğinde buraya AJAX request eklenebilir
        alert('Teklif oluşturma özelliği geliştiriliyor. Yakında eklenecektir.');
    });
</script>
@endpush
@endsection

