@extends('layouts.admin')

@section('title', 'Müşteri Segmentleri')
@section('page-title', 'Müşteri Segmentleri')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-diagram-3 me-2"></i>Müşteri Segmentleri
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.clv.segments.create') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Segment Oluştur
                    </a>
                    <a href="{{ route('admin.beauty-salon.clv.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Segment Listesi
            </h5>
        </div>
        <div class="card-body">
            @if($segments->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Segment Adı</th>
                                <th>Müşteri Sayısı</th>
                                <th>Kriterler</th>
                                <th>Durum</th>
                                <th>Oluşturulma</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($segments as $segment)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $segment->name }}</div>
                                        @if($segment->description)
                                            <small class="text-muted">{{ $segment->description }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-primary">{{ $segment->clv_scores_count ?? 0 }} Müşteri</span>
                                    </td>
                                    <td>
                                        <div class="small">
                                            @if($segment->min_clv || $segment->max_clv)
                                                <span class="badge bg-info me-1">CLV: {{ $segment->min_clv ? number_format($segment->min_clv, 0) . '₺+' : '' }} {{ $segment->max_clv ? '-' . number_format($segment->max_clv, 0) . '₺' : '' }}</span>
                                            @endif
                                            @if($segment->min_visits || $segment->max_visits)
                                                <span class="badge bg-success me-1">Ziyaret: {{ $segment->min_visits ?? 0 }}{{ $segment->max_visits ? '-' . $segment->max_visits : '+' }}</span>
                                            @endif
                                            @if($segment->days_since_last_visit)
                                                <span class="badge bg-warning text-dark">Son: {{ $segment->days_since_last_visit }} gün+</span>
                                            @endif
                                            @if(!$segment->min_clv && !$segment->max_clv && !$segment->min_visits && !$segment->max_visits && !$segment->days_since_last_visit)
                                                <span class="text-muted">Kriter yok</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        @if($segment->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-danger">Pasif</span>
                                        @endif
                                    </td>
                                    <td>{{ $segment->created_at->format('d.m.Y H:i') }}</td>
                                    <td>
                                        <div class="d-flex gap-1">
                                            <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#segmentDetailModal{{ $segment->id }}">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <a href="{{ route('admin.beauty-salon.clv.segments.edit', $segment->id) }}" class="btn btn-sm btn-warning">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <form action="{{ route('admin.beauty-salon.clv.segments.destroy', $segment->id) }}" method="POST" class="d-inline-block" onsubmit="return confirm('Bu segmenti silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>

                                <!-- Segment Detail Modal -->
                                <div class="modal fade" id="segmentDetailModal{{ $segment->id }}" tabindex="-1" aria-labelledby="segmentDetailModalLabel{{ $segment->id }}" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="segmentDetailModalLabel{{ $segment->id }}">Segment Detayı</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p><strong>Segment Adı:</strong> {{ $segment->name }}</p>
                                                @if($segment->description)
                                                    <p><strong>Açıklama:</strong> {{ $segment->description }}</p>
                                                @endif
                                                
                                                <hr>
                                                <h6 class="fw-bold mb-3">Segment Kriterleri:</h6>
                                                <div class="mb-3">
                                                    @if($segment->min_clv || $segment->max_clv)
                                                        <p class="mb-2">
                                                            <strong>CLV Değeri:</strong>
                                                            @if($segment->min_clv && $segment->max_clv)
                                                                {{ number_format($segment->min_clv, 2, ',', '.') }} ₺ - {{ number_format($segment->max_clv, 2, ',', '.') }} ₺
                                                            @elseif($segment->min_clv)
                                                                {{ number_format($segment->min_clv, 2, ',', '.') }} ₺ ve üzeri
                                                            @elseif($segment->max_clv)
                                                                {{ number_format($segment->max_clv, 2, ',', '.') }} ₺ ve altı
                                                            @endif
                                                        </p>
                                                    @endif
                                                    
                                                    @if($segment->min_visits || $segment->max_visits)
                                                        <p class="mb-2">
                                                            <strong>Ziyaret Sayısı:</strong>
                                                            @if($segment->min_visits && $segment->max_visits)
                                                                {{ $segment->min_visits }} - {{ $segment->max_visits }} ziyaret
                                                            @elseif($segment->min_visits)
                                                                {{ $segment->min_visits }} ve üzeri ziyaret
                                                            @elseif($segment->max_visits)
                                                                {{ $segment->max_visits }} ve altı ziyaret
                                                            @endif
                                                        </p>
                                                    @endif
                                                    
                                                    @if($segment->days_since_last_visit)
                                                        <p class="mb-2">
                                                            <strong>Son Ziyaret:</strong> {{ $segment->days_since_last_visit }} gün ve daha fazla süredir gelmeyenler
                                                        </p>
                                                    @endif
                                                    
                                                    @if(!$segment->min_clv && !$segment->max_clv && !$segment->min_visits && !$segment->max_visits && !$segment->days_since_last_visit)
                                                        <p class="text-muted mb-0">Henüz kriter belirlenmemiş.</p>
                                                    @endif
                                                </div>
                                                
                                                <hr>
                                                <p><strong>Müşteri Sayısı:</strong> <span class="badge bg-primary">{{ $segment->clv_scores_count ?? 0 }}</span></p>
                                                <p><strong>Durum:</strong>
                                                    @if($segment->is_active)
                                                        <span class="badge bg-success">Aktif</span>
                                                    @else
                                                        <span class="badge bg-danger">Pasif</span>
                                                    @endif
                                                </p>
                                                <p><strong>Oluşturulma:</strong> {{ $segment->created_at->format('d.m.Y H:i') }}</p>
                                                <p><strong>Güncelleme:</strong> {{ $segment->updated_at->format('d.m.Y H:i') }}</p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-diagram-3" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz segment oluşturulmamış.</p>
                    <p class="text-muted mb-4">Müşterilerinizi gruplandırmak için segment oluşturun.</p>
                    <a href="{{ route('admin.beauty-salon.clv.segments.create') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Segmenti Oluştur
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

