@extends('layouts.admin')

@section('title', 'Yeni Segment Oluştur')
@section('page-title', 'Yeni Segment Oluştur')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-plus-circle me-2"></i>Yeni Segment Oluştur
                </h2>
                <a href="{{ route('admin.beauty-salon.clv.segments') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-2"></i>Geri
                </a>
            </div>
        </div>
    </div>

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-info-circle me-2"></i>Segment Bilgileri
            </h5>
        </div>
        <div class="card-body p-4">
            <div class="alert alert-info mb-4">
                <i class="bi bi-lightbulb me-2"></i><strong>Segment Nedir?</strong><br>
                Segment, müşterilerinizi belirli kriterlere göre gruplandırmak için kullanılır. Örneğin: "Yüksek Harcama Yapanlar", "Sık Gelen Müşteriler", "Uzun Süredir Gelmeyenler" gibi. Segment oluşturduktan sonra bu müşterilere özel kampanyalar ve teklifler yapabilirsiniz.
            </div>

            <form action="{{ route('admin.beauty-salon.clv.segments.store') }}" method="POST">
                @csrf
                <div class="row g-3">
                    <div class="col-md-12">
                        <label for="name" class="form-label fw-bold">Segment Adı <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" placeholder="Örn: VIP Müşteriler, Sık Gelenler" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Müşterilerinizi nasıl gruplandırmak istediğinizi açıklayan bir isim verin.</small>
                    </div>

                    <div class="col-md-12">
                        <label for="description" class="form-label fw-bold">Açıklama</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" placeholder="Bu segment hakkında açıklama yazın...">{{ old('description') }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        <hr class="my-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">
                            <i class="bi bi-funnel me-2"></i>Segment Kriterleri
                        </h6>
                        <p class="text-muted small mb-4">Müşterilerin bu segmente dahil olması için gereken kriterleri belirleyin. Tüm kriterler opsiyoneldir, istediğiniz kadarını kullanabilirsiniz.</p>
                    </div>

                    <div class="col-md-6">
                        <label for="min_clv" class="form-label fw-bold">Minimum CLV Değeri (₺)</label>
                        <input type="number" step="0.01" class="form-control @error('min_clv') is-invalid @enderror" id="min_clv" name="min_clv" value="{{ old('min_clv') }}" placeholder="Örn: 1000">
                        @error('min_clv')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Bu değerin üzerinde CLV'ye sahip müşteriler dahil edilir.</small>
                    </div>

                    <div class="col-md-6">
                        <label for="max_clv" class="form-label fw-bold">Maksimum CLV Değeri (₺)</label>
                        <input type="number" step="0.01" class="form-control @error('max_clv') is-invalid @enderror" id="max_clv" name="max_clv" value="{{ old('max_clv') }}" placeholder="Örn: 5000">
                        @error('max_clv')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Bu değerin altında CLV'ye sahip müşteriler dahil edilir.</small>
                    </div>

                    <div class="col-md-6">
                        <label for="min_visits" class="form-label fw-bold">Minimum Ziyaret Sayısı</label>
                        <input type="number" class="form-control @error('min_visits') is-invalid @enderror" id="min_visits" name="min_visits" value="{{ old('min_visits') }}" placeholder="Örn: 5" min="0">
                        @error('min_visits')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Bu sayının üzerinde ziyareti olan müşteriler dahil edilir.</small>
                    </div>

                    <div class="col-md-6">
                        <label for="max_visits" class="form-label fw-bold">Maksimum Ziyaret Sayısı</label>
                        <input type="number" class="form-control @error('max_visits') is-invalid @enderror" id="max_visits" name="max_visits" value="{{ old('max_visits') }}" placeholder="Örn: 20" min="0">
                        @error('max_visits')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Bu sayının altında ziyareti olan müşteriler dahil edilir.</small>
                    </div>

                    <div class="col-md-12">
                        <label for="days_since_last_visit" class="form-label fw-bold">Son Ziyaretten Beri Geçen Gün</label>
                        <input type="number" class="form-control @error('days_since_last_visit') is-invalid @enderror" id="days_since_last_visit" name="days_since_last_visit" value="{{ old('days_since_last_visit') }}" placeholder="Örn: 30" min="0">
                        @error('days_since_last_visit')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Bu süreden fazla gelmeyen müşterileri belirlemek için kullanın. Örn: 30 gün = son 30 günde gelmeyenler.</small>
                    </div>


                    <div class="col-12 mt-4">
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                                <i class="bi bi-check-circle me-2"></i>Segment Oluştur
                            </button>
                            <a href="{{ route('admin.beauty-salon.clv.segments') }}" class="btn btn-secondary">
                                <i class="bi bi-x-circle me-2"></i>İptal
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

