@extends('layouts.admin')

@section('title', 'Segment Düzenle')
@section('page-title', 'Segment Düzenle')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-pencil me-2"></i>Segment Düzenle
                </h2>
                <a href="{{ route('admin.beauty-salon.clv.segments') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-2"></i>Geri
                </a>
            </div>
        </div>
    </div>

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-info-circle me-2"></i>Segment Bilgileri
            </h5>
        </div>
        <div class="card-body p-4">
            <form action="{{ route('admin.beauty-salon.clv.segments.update', $segment->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row g-3">
                    <div class="col-md-12">
                        <label for="name" class="form-label fw-bold">Segment Adı <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $segment->name) }}" placeholder="Örn: VIP Müşteriler, Sık Gelenler" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-12">
                        <label for="description" class="form-label fw-bold">Açıklama</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" placeholder="Bu segment hakkında açıklama yazın...">{{ old('description', $segment->description) }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        <hr class="my-4">
                        <h6 class="fw-bold mb-3" style="color: #ec4899;">
                            <i class="bi bi-funnel me-2"></i>Segment Kriterleri
                        </h6>
                    </div>

                    <div class="col-md-6">
                        <label for="min_clv" class="form-label fw-bold">Minimum CLV Değeri (₺)</label>
                        <input type="number" step="0.01" class="form-control @error('min_clv') is-invalid @enderror" id="min_clv" name="min_clv" value="{{ old('min_clv', $segment->min_clv) }}" placeholder="Örn: 1000">
                        @error('min_clv')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6">
                        <label for="max_clv" class="form-label fw-bold">Maksimum CLV Değeri (₺)</label>
                        <input type="number" step="0.01" class="form-control @error('max_clv') is-invalid @enderror" id="max_clv" name="max_clv" value="{{ old('max_clv', $segment->max_clv) }}" placeholder="Örn: 5000">
                        @error('max_clv')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6">
                        <label for="min_visits" class="form-label fw-bold">Minimum Ziyaret Sayısı</label>
                        <input type="number" class="form-control @error('min_visits') is-invalid @enderror" id="min_visits" name="min_visits" value="{{ old('min_visits', $segment->min_visits) }}" placeholder="Örn: 5" min="0">
                        @error('min_visits')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6">
                        <label for="max_visits" class="form-label fw-bold">Maksimum Ziyaret Sayısı</label>
                        <input type="number" class="form-control @error('max_visits') is-invalid @enderror" id="max_visits" name="max_visits" value="{{ old('max_visits', $segment->max_visits) }}" placeholder="Örn: 20" min="0">
                        @error('max_visits')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-12">
                        <label for="days_since_last_visit" class="form-label fw-bold">Son Ziyaretten Beri Geçen Gün</label>
                        <input type="number" class="form-control @error('days_since_last_visit') is-invalid @enderror" id="days_since_last_visit" name="days_since_last_visit" value="{{ old('days_since_last_visit', $segment->days_since_last_visit) }}" placeholder="Örn: 30" min="0">
                        @error('days_since_last_visit')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $segment->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label fw-bold" for="is_active">Aktif</label>
                        </div>
                    </div>

                    <div class="col-12 mt-4">
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                                <i class="bi bi-check-circle me-2"></i>Değişiklikleri Kaydet
                            </button>
                            <a href="{{ route('admin.beauty-salon.clv.segments') }}" class="btn btn-secondary">
                                <i class="bi bi-x-circle me-2"></i>İptal
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

