@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-0" style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);">
                    <h4 class="mb-0 text-white">Sözleşme - Randevu #{{ $reservation->id }}</h4>
                </div>
                <div class="card-body">
                    <div class="mb-4">
                        <h5>Müşteri Bilgileri</h5>
                        <p><strong>Adı:</strong> {{ $reservation->customer->name }}</p>
                        @if($reservation->customer->phone)
                            <p><strong>Telefon:</strong> {{ $reservation->customer->phone }}</p>
                        @endif
                        @if($reservation->customer->email)
                            <p><strong>E-posta:</strong> {{ $reservation->customer->email }}</p>
                        @endif
                    </div>
                    
                    <div class="mb-4">
                        <h5>Randevu Bilgileri</h5>
                        <p><strong>Tarih:</strong> {{ $reservation->date->format('d.m.Y') }}</p>
                        <p><strong>Saat:</strong> {{ $reservation->start_time }} - {{ $reservation->end_time }}</p>
                        <p><strong>Salon:</strong> {{ $reservation->salon->name }}</p>
                        <p><strong>Misafir Sayısı:</strong> {{ $reservation->guest_count }} kişi</p>
                        <p><strong>Toplam Tutar:</strong> {{ number_format($reservation->total_price, 2, ',', '.') }} ₺</p>
                        <p><strong>Alınan Kapora:</strong> {{ number_format($reservation->deposit_paid, 2, ',', '.') }} ₺</p>
                        <p><strong>Kalan Ödeme:</strong> {{ number_format($reservation->remaining_amount, 2, ',', '.') }} ₺</p>
                    </div>
                    
                    <div class="mb-4">
                        <h5>Sözleşme Metni</h5>
                        <div class="border p-4" style="background: #f8f9fa; border-radius: 5px;">
                            {!! nl2br(e($contract->content)) !!}
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <a href="{{ route('admin.appointments.show', $reservation->id) }}" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Geri Dön
                        </a>
                        <button onclick="window.print()" class="btn btn-primary">
                            <i class="bi bi-printer"></i> Yazdır
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
