@extends('layouts.admin')

@section('title', 'Müşteri Rehberi')
@section('page-title', 'Müşteri Rehberi')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="fw-bold mb-0" style="color: #ec4899;">
                <i class="bi bi-book me-2"></i>Müşteri Rehberi
            </h2>
            <p class="text-muted mt-2">Müşterilerinize toplu mesaj gönderin ve kampanyalarınızı duyurun.</p>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            @if(session('failed_customers') && count(session('failed_customers')) > 0)
                <br><small>Başarısız: {{ implode(', ', session('failed_customers')) }}</small>
            @endif
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Sol Panel - Müşteri Listesi -->
        <div class="col-md-4 mb-4">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white fw-bold">
                        <i class="bi bi-people me-2"></i>Müşteriler ({{ $customers->total() }})
                    </h5>
                </div>
                <div class="card-body p-0" style="max-height: 600px; overflow-y: auto;">
                    <div class="p-3 border-bottom">
                        <input type="text" class="form-control" id="customerSearch" placeholder="Müşteri ara...">
                    </div>
                    <div class="p-2">
                        <div class="form-check mb-2">
                            <input class="form-check-input" type="checkbox" id="selectAllCustomers">
                            <label class="form-check-label fw-bold" for="selectAllCustomers">Tümünü Seç</label>
                        </div>
                    </div>
                    <form id="customerForm">
                        @foreach($customers as $customer)
                            <div class="customer-item p-3 border-bottom" data-name="{{ strtolower($customer->name) }}" data-phone="{{ $customer->phone ?? '' }}">
                                <div class="form-check">
                                    <input class="form-check-input customer-checkbox" type="checkbox" name="customer_ids[]" value="{{ $customer->id }}" id="customer_{{ $customer->id }}">
                                    <label class="form-check-label w-100" for="customer_{{ $customer->id }}">
                                        <div class="fw-bold">{{ $customer->name }}</div>
                                        @if($customer->phone)
                                            <small class="text-muted">{{ $customer->phone }}</small>
                                        @else
                                            <small class="text-danger">Telefon yok</small>
                                        @endif
                                    </label>
                                </div>
                            </div>
                        @endforeach
                    </form>
                    <div class="p-3">
                        {{ $customers->links() }}
                    </div>
                </div>
            </div>
        </div>

        <!-- Sağ Panel - Mesaj Gönderme -->
        <div class="col-md-8">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white fw-bold">
                        <i class="bi bi-send me-2"></i>Mesaj Gönder
                    </h5>
                </div>
                <div class="card-body p-4">
                    <form action="{{ route('admin.beauty-salon.customer-directory.send-message') }}" method="POST" id="messageForm">
                        @csrf
                        
                        <!-- Seçili müşteri ID'leri buraya eklenecek -->
                        <div id="selectedCustomersInputs"></div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Mesaj Türü</label>
                            <select class="form-select" name="message_type" id="messageType" required>
                                <option value="template">Şablon Kullan</option>
                                <option value="custom">Özel Mesaj</option>
                            </select>
                        </div>

                        <div class="mb-3" id="templateSection">
                            <label class="form-label fw-bold">Mesaj Şablonu</label>
                            <select class="form-select" name="template_key" id="templateKey">
                                @foreach($templates as $key => $template)
                                    @if($key !== 'custom')
                                        <option value="{{ $key }}" data-template="{{ $template['template'] }}">{{ $template['name'] }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Mesaj İçeriği <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="message_content" id="messageContent" rows="6" required placeholder="Mesajınızı buraya yazın..."></textarea>
                            <small class="text-muted">
                                Kullanılabilir değişkenler: {customer_name}, {discount}, {service_name}, {date}, {time}
                            </small>
                        </div>

                        <div class="row mb-3" id="templateVariables" style="display: none;">
                            <div class="col-md-6">
                                <label class="form-label">İndirim Yüzdesi</label>
                                <input type="text" class="form-control" id="discountVar" placeholder="10">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Hizmet Adı</label>
                                <input type="text" class="form-control" id="serviceNameVar" placeholder="Saç Kesimi">
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Gönderim Yöntemi <span class="text-danger">*</span></label>
                            <select class="form-select" name="send_method" required>
                                <option value="whatsapp">WhatsApp</option>
                                <option value="sms">SMS</option>
                            </select>
                        </div>

                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Bilgi:</strong> Seçili müşterilere mesaj gönderilecektir. Telefon numarası olmayan müşteriler atlanacaktır.
                        </div>

                        <button type="submit" class="btn btn-primary w-100" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                            <i class="bi bi-send me-2"></i>Mesaj Gönder
                        </button>
                    </form>
                </div>
            </div>

            <!-- Gönderilen Mesajlar -->
            <div class="card shadow-sm mt-4" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white fw-bold">
                        <i class="bi bi-clock-history me-2"></i>Gönderilen Mesajlar
                    </h5>
                </div>
                <div class="card-body">
                    @forelse($sentMessages as $message)
                        <div class="border-bottom pb-3 mb-3">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div>
                                    <strong>{{ $message->message_content }}</strong>
                                    @if($message->template_key)
                                        <span class="badge bg-info ms-2">{{ $templates[$message->template_key]['name'] ?? $message->template_key }}</span>
                                    @endif
                                </div>
                                <span class="badge bg-{{ $message->send_method === 'whatsapp' ? 'success' : 'primary' }}">
                                    {{ $message->send_method === 'whatsapp' ? 'WhatsApp' : 'SMS' }}
                                </span>
                            </div>
                            <div class="text-muted small">
                                <i class="bi bi-check-circle text-success"></i> {{ $message->total_sent }} gönderildi
                                @if($message->total_failed > 0)
                                    <i class="bi bi-x-circle text-danger ms-2"></i> {{ $message->total_failed }} başarısız
                                @endif
                                <span class="ms-2">{{ $message->sent_at ? $message->sent_at->format('d.m.Y H:i') : '-' }}</span>
                            </div>
                        </div>
                    @empty
                        <p class="text-muted text-center py-3">Henüz mesaj gönderilmemiş.</p>
                    @endforelse
                    {{ $sentMessages->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Müşteri arama
    const searchInput = document.getElementById('customerSearch');
    const customerItems = document.querySelectorAll('.customer-item');
    
    searchInput.addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase();
        customerItems.forEach(item => {
            const name = item.dataset.name;
            const phone = item.dataset.phone;
            if (name.includes(searchTerm) || phone.includes(searchTerm)) {
                item.style.display = 'block';
            } else {
                item.style.display = 'none';
            }
        });
    });

    // Tümünü seç
    const selectAll = document.getElementById('selectAllCustomers');
    const checkboxes = document.querySelectorAll('.customer-checkbox');
    
    selectAll.addEventListener('change', function() {
        checkboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
    });

    // Şablon değiştirme
    const templateKey = document.getElementById('templateKey');
    const messageContent = document.getElementById('messageContent');
    const templateVariables = document.getElementById('templateVariables');
    
    templateKey.addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        const template = selectedOption.dataset.template;
        if (template) {
            messageContent.value = template;
            templateVariables.style.display = 'block';
        }
    });

    // Mesaj türü değiştirme
    const messageType = document.getElementById('messageType');
    const templateSection = document.getElementById('templateSection');
    
    messageType.addEventListener('change', function() {
        if (this.value === 'template') {
            templateSection.style.display = 'block';
            templateKey.dispatchEvent(new Event('change'));
        } else {
            templateSection.style.display = 'none';
            messageContent.value = '';
            templateVariables.style.display = 'none';
        }
    });

    // Seçili müşteri ID'lerini form'a ekle
    function updateSelectedCustomers() {
        const checkedCustomers = document.querySelectorAll('.customer-checkbox:checked');
        const selectedInputs = document.getElementById('selectedCustomersInputs');
        selectedInputs.innerHTML = '';
        
        checkedCustomers.forEach(checkbox => {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'customer_ids[]';
            input.value = checkbox.value;
            selectedInputs.appendChild(input);
        });
    }

    // Checkbox değişikliklerini dinle
    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateSelectedCustomers);
    });
    selectAll.addEventListener('change', updateSelectedCustomers);

    // Form gönderimi kontrolü
    const messageForm = document.getElementById('messageForm');
    messageForm.addEventListener('submit', function(e) {
        const checkedCustomers = document.querySelectorAll('.customer-checkbox:checked');
        if (checkedCustomers.length === 0) {
            e.preventDefault();
            alert('Lütfen en az bir müşteri seçin.');
            return false;
        }
        // Seçili müşteri ID'lerini güncelle
        updateSelectedCustomers();
    });
});
</script>
@endsection

