@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold" style="color: #ec4899;">
            <i class="bi bi-person-circle"></i> Müşteri Detayı: {{ $customer->name }}
        </h2>
        <div class="d-flex gap-2">
            @if($totalRemaining > 0)
            <button type="button" class="btn btn-success" onclick="openCustomerPaymentModal()" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); border: none; box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);">
                <i class="bi bi-cash-coin"></i> Ödeme Yap ({{ number_format($totalRemaining, 2, ',', '.') }} ₺)
            </button>
            @endif
            <a href="{{ route('admin.customers.edit', $customer->id) }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3);">
                <i class="bi bi-pencil"></i> Düzenle
            </a>
            <a href="{{ route('admin.customers.index') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Geri Dön
            </a>
        </div>
    </div>

    <div class="row g-4">
        <!-- Left Column: Customer Info & Stats -->
        <div class="col-lg-4">
            <!-- Customer Info Card -->
            <div class="card shadow-sm mb-4" style="border: none; border-radius: 16px; overflow: hidden;">
                <div class="card-body text-center" style="padding: 2rem;">
                    <div class="customer-avatar mx-auto mb-3" style="width: 120px; height: 120px; border-radius: 50%; background: linear-gradient(135deg, {{ $customer->avatar_color ?? '#ec4899' }} 0%, {{ $customer->avatar_color ?? '#be185d' }} 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: 700; font-size: 42px; box-shadow: 0 8px 24px rgba(0,0,0,0.15); position: relative; overflow: hidden;">
                        <div style="position: relative; z-index: 1;">
                            {{ $customer->initials ?? strtoupper(substr($customer->name, 0, 2)) }}
                        </div>
                    </div>
                    <h4 class="card-title mb-4 fw-bold" style="color: #111827; font-size: 1.5rem;">{{ $customer->name }}</h4>
                    
                    <div class="text-start" style="border-top: 1px solid #e5e7eb; padding-top: 1.5rem;">
                        <div class="mb-3 d-flex justify-content-between align-items-center">
                            <span class="text-muted fw-semibold">
                                <i class="bi bi-telephone me-2" style="color: #ec4899;"></i>Telefon
                            </span>
                            <a href="tel:{{ $customer->phone }}" class="text-decoration-none fw-semibold" style="color: #ec4899;">
                                {{ $customer->phone ?? '-' }}
                            </a>
                        </div>
                        
                        @if($customer->email)
                        <div class="mb-3 d-flex justify-content-between align-items-center">
                            <span class="text-muted fw-semibold">
                                <i class="bi bi-envelope me-2" style="color: #ec4899;"></i>E-posta
                            </span>
                            <a href="mailto:{{ $customer->email }}" class="text-decoration-none fw-semibold" style="color: #ec4899;">
                                {{ $customer->email }}
                            </a>
                        </div>
                        @endif
                        
                        <div class="mb-3 d-flex justify-content-between align-items-center">
                            <span class="text-muted fw-semibold">
                                <i class="bi bi-wallet2 me-2" style="color: #ec4899;"></i>Bakiye
                            </span>
                            <span>
                                @if($customer->balance > 0)
                                    <span class="badge" style="background: #fef3c7; color: #92400e; padding: 6px 12px; font-size: 13px;">{{ number_format($customer->balance, 2, ',', '.') }} ₺</span>
                                @elseif($customer->balance < 0)
                                    <span class="badge" style="background: #fce7f3; color: #ec4899; padding: 6px 12px; font-size: 13px;">{{ number_format(abs($customer->balance), 2, ',', '.') }} ₺</span>
                                @else
                                    <span class="badge" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; padding: 6px 12px; font-size: 13px;">0,00 ₺</span>
                                @endif
                            </span>
                        </div>
                        
                        
                        
                        @if($customer->birth_date)
                        <div class="mb-3 d-flex justify-content-between align-items-center">
                            <span class="text-muted fw-semibold">
                                <i class="bi bi-calendar3 me-2" style="color: #ec4899;"></i>Doğum Tarihi
                            </span>
                            <span class="fw-semibold" style="color: #111827;">{{ $customer->birth_date->format('d.m.Y') }}</span>
                        </div>
                        @endif
                        
                        @if($customer->address)
                        <div class="mb-3">
                            <div class="text-muted fw-semibold mb-2">
                                <i class="bi bi-geo-alt me-2" style="color: #ec4899;"></i>Adres
                            </div>
                            <div class="fw-semibold" style="color: #111827; text-align: right;">{{ $customer->address }}</div>
                        </div>
                        @endif
                        
                        @if($customer->notes)
                        <div class="mb-3">
                            <div class="text-muted fw-semibold mb-2">
                                <i class="bi bi-sticky me-2" style="color: #ec4899;"></i>Notlar
                            </div>
                            <div class="fw-semibold" style="color: #111827; text-align: right;">{{ $customer->notes }}</div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Statistics Card -->
            <div class="card shadow-sm mb-4" style="border: none; border-radius: 16px; background: linear-gradient(135deg, rgba(236, 72, 153, 0.05) 0%, rgba(190, 24, 93, 0.02) 100%);">
                <div class="card-body">
                    <h5 class="card-title fw-bold mb-3" style="color: #111827;">
                        <i class="bi bi-bar-chart me-2" style="color: #ec4899;"></i>İstatistikler
                    </h5>
                    <div class="row g-3">
                        <div class="col-6">
                            <div style="background: white; padding: 1rem; border-radius: 12px; border: 1px solid #e5e7eb;">
                                <div class="text-muted small fw-semibold mb-1" style="text-transform: uppercase; letter-spacing: 0.5px;">Toplam Randevu</div>
                                <div class="h4 mb-0 fw-bold" style="color: #ec4899;">{{ $totalAppointments }}</div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div style="background: white; padding: 1rem; border-radius: 12px; border: 1px solid #e5e7eb;">
                                <div class="text-muted small fw-semibold mb-1" style="text-transform: uppercase; letter-spacing: 0.5px;">Toplam Tutar</div>
                                <div class="h5 mb-0 fw-bold" style="color: #ec4899;">{{ number_format($totalAmount, 0, ',', '.') }} ₺</div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div style="background: white; padding: 1rem; border-radius: 12px; border: 1px solid #e5e7eb;">
                                <div class="text-muted small fw-semibold mb-1" style="text-transform: uppercase; letter-spacing: 0.5px;">Ödenen</div>
                                <div class="h5 mb-0 fw-bold" style="color: #10b981;">{{ number_format($totalPaid, 0, ',', '.') }} ₺</div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div style="background: white; padding: 1rem; border-radius: 12px; border: 1px solid #e5e7eb;">
                                <div class="text-muted small fw-semibold mb-1" style="text-transform: uppercase; letter-spacing: 0.5px;">Kalan</div>
                                <div class="h5 mb-0 fw-bold" style="color: {{ $totalRemaining > 0 ? '#f59e0b' : '#ec4899' }};">{{ number_format($totalRemaining, 0, ',', '.') }} ₺</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pending Balances Card -->
            @php
                $appointmentsWithBalance = $customer->appointments->filter(function($r) {
                    return $r->remaining_amount > 0 && $r->status != 'cancelled';
                });
            @endphp
            @if($appointmentsWithBalance->count() > 0)
            <div class="card shadow-sm" style="border: none; border-radius: 16px; border-left: 4px solid #f59e0b;">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0 fw-bold" style="color: #111827;">
                            <i class="bi bi-exclamation-circle me-2" style="color: #f59e0b;"></i>Kalan Bakiyeler
                        </h5>
                        <span class="badge" style="background: #fef3c7; color: #92400e; padding: 6px 12px;">{{ $appointmentsWithBalance->count() }}</span>
                    </div>
                    <div class="list-group" style="border: none;">
                        @foreach($appointmentsWithBalance as $reservation)
                            <div class="list-group-item d-flex justify-content-between align-items-start mb-2" style="border: 1px solid #e5e7eb; border-radius: 12px; padding: 1rem;">
                                <div class="flex-grow-1">
                                    <div class="fw-bold mb-1" style="color: #111827;">
                                        {{ $reservation->date->format('d.m.Y') }}
                                    </div>
                                    <div class="small text-muted mb-1">
                                        <i class="bi bi-building me-1"></i>{{ $reservation->salon->name ?? '-' }}
                                    </div>
                                    <div class="small text-muted">
                                        <i class="bi bi-clock me-1"></i>{{ $reservation->start_time }} - {{ $reservation->end_time }}
                                    </div>
                                </div>
                                <span class="badge" style="background: #fef3c7; color: #92400e; padding: 8px 14px; font-size: 14px; white-space: nowrap;">
                                    {{ number_format($reservation->remaining_amount, 2, ',', '.') }} ₺
                                </span>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endif
            
        </div>

        <!-- Right Column: Appointments & Transactions -->
        <div class="col-lg-8">
            <!-- Appointments Card -->
            <div class="card shadow-sm mb-4" style="border: none; border-radius: 16px;">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0 fw-bold" style="color: #111827;">
                            <i class="bi bi-calendar-check me-2" style="color: #ec4899;"></i>Randevular
                        </h5>
                        <span class="badge" style="background: #f9fafb; color: #6b7280; padding: 6px 12px;">{{ $customer->appointments->count() }} randevu</span>
                    </div>
                    <hr>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th style="font-weight: 600; color: #111827;">Tarih</th>
                                    <th style="font-weight: 600; color: #111827;">Salon</th>
                                    <th style="font-weight: 600; color: #111827;">Hizmet</th>
                                    <th style="font-weight: 600; color: #111827;">Tutar</th>
                                    <th style="font-weight: 600; color: #111827;">Ödenen</th>
                                    <th style="font-weight: 600; color: #111827;">Durum</th>
                                    <th style="font-weight: 600; color: #111827;">İşlem</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($customer->appointments as $reservation)
                                    <tr style="border-bottom: 1px solid #f3f4f6;">
                                        <td class="fw-semibold" style="color: #111827;">{{ $reservation->date->format('d.m.Y') }}</td>
                                        <td style="color: #6b7280;">{{ $reservation->salon->name ?? '-' }}</td>
                                        <td style="color: #6b7280;">
                                            @if($reservation->appointmentRequest && $reservation->appointmentRequest->service)
                                                <span class="badge" style="background: #fce7f3; color: #ec4899; padding: 4px 10px;">
                                                    {{ $reservation->appointmentRequest->service->name }}
                                                </span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td class="fw-semibold" style="color: #111827;">{{ number_format($reservation->total_price, 2, ',', '.') }} ₺</td>
                                        <td style="color: #10b981;">{{ number_format($reservation->deposit_paid, 2, ',', '.') }} ₺</td>
                                        <td>
                                            @if($reservation->status == 'confirmed')
                                                <span class="badge" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; padding: 6px 12px;">Onaylandı</span>
                                            @elseif($reservation->status == 'open')
                                                <span class="badge" style="background: #fef3c7; color: #92400e; padding: 6px 12px;">Açık</span>
                                            @elseif($reservation->status == 'cancelled')
                                                <span class="badge" style="background: #fee2e2; color: #991b1b; padding: 6px 12px;">İptal</span>
                                            @else
                                                <span class="badge" style="background: #dbeafe; color: #1e40af; padding: 6px 12px;">Tamamlandı</span>
                                            @endif
                                        </td>
                                        <td>
                                            <button type="button" onclick="if(typeof window.showReservationDetail === 'function') { window.showReservationDetail({{ $reservation->id }}); } else { window.location.href='{{ route('admin.appointments.show', $reservation->id) }}'; }" class="btn btn-sm" style="background: #f9fafb; color: #6b7280; border: 1px solid #e5e7eb; padding: 6px 12px;">
                                                <i class="bi bi-eye"></i> Görüntüle
                                            </button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center py-5">
                                            <div class="text-muted">
                                                <i class="bi bi-calendar-x" style="font-size: 3rem; opacity: 0.3;"></i>
                                                <p class="mt-3 mb-0">Henüz randevu yok.</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Transactions Card -->
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0 fw-bold" style="color: #111827;">
                            <i class="bi bi-receipt me-2" style="color: #ec4899;"></i>Hesap Bordosu
                        </h5>
                        <div class="d-flex gap-2">
                            @php
                                $totalIncome = $transactions->where('type', 'income')->sum('amount');
                                $totalExpense = $transactions->where('type', 'expense')->sum('amount');
                            @endphp
                            <span class="badge" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; padding: 6px 12px;">
                                +{{ number_format($totalIncome, 0, ',', '.') }} ₺
                            </span>
                            @if($totalExpense > 0)
                            <span class="badge" style="background: #fee2e2; color: #991b1b; padding: 6px 12px;">
                                -{{ number_format($totalExpense, 0, ',', '.') }} ₺
                            </span>
                            @endif
                        </div>
                    </div>
                    <hr>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th style="font-weight: 600; color: #111827;">Tarih</th>
                                    <th style="font-weight: 600; color: #111827;">Açıklama</th>
                                    <th style="font-weight: 600; color: #111827;">Tür</th>
                                    <th style="font-weight: 600; color: #111827;">Tutar</th>
                                    <th style="font-weight: 600; color: #111827;">Kalan Borç</th>
                                    <th style="font-weight: 600; color: #111827;">Randevu</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transactions as $transaction)
                                    <tr style="border-bottom: 1px solid #f3f4f6;">
                                        <td style="color: #6b7280;">{{ $transaction->date ? \Carbon\Carbon::parse($transaction->date)->format('d.m.Y') : ($transaction->created_at ? $transaction->created_at->format('d.m.Y') : '-') }}</td>
                                        <td style="color: #111827; font-weight: 500;">{{ $transaction->description ?? '-' }}</td>
                                        <td>
                                            @if($transaction->type == 'income')
                                                <span class="badge" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); color: white; padding: 6px 12px;">
                                                    <i class="bi bi-arrow-down-circle me-1"></i>Tahsilat
                                                </span>
                                            @elseif($transaction->type == 'expense')
                                                <span class="badge" style="background: #fee2e2; color: #991b1b; padding: 6px 12px;">
                                                    <i class="bi bi-arrow-up-circle me-1"></i>Gider
                                                </span>
                                            @else
                                                <span class="badge" style="background: #dbeafe; color: #1e40af; padding: 6px 12px;">{{ ucfirst($transaction->type) }}</span>
                                            @endif
                                        </td>
                                        <td class="fw-bold" style="color: {{ $transaction->type == 'income' ? '#ec4899' : '#ef4444' }}; font-size: 1.1rem;">
                                            {{ $transaction->type === 'income' ? '+' : '-' }}{{ number_format($transaction->amount, 2, ',', '.') }} ₺
                                        </td>
                                        <td>
                                            @if($transaction->type == 'income' && isset($transaction->remaining_debt_after))
                                                <div>
                                                    <span class="badge" style="background: #fef3c7; color: #92400e; padding: 6px 12px;">
                                                        <i class="bi bi-cash-coin me-1"></i>{{ number_format($transaction->remaining_debt_after, 2, ',', '.') }} ₺
                                                    </span>
                                                    <div class="small text-muted mt-1" style="font-size: 0.75rem;">
                                                        <i class="bi bi-info-circle me-1"></i>Bu ödemeden sonra kalan borç
                                                    </div>
                                                </div>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($transaction->reservation)
                                                <button type="button" onclick="if(typeof window.showReservationDetail === 'function') { window.showReservationDetail({{ $transaction->reservation_id }}); } else { window.location.href='{{ route('admin.appointments.show', $transaction->reservation_id) }}'; }" class="btn btn-sm" style="background: #f9fafb; color: #ec4899; border: 1px solid #e5e7eb; padding: 6px 12px;">
                                                    <i class="bi bi-calendar-check me-1"></i>Görüntüle
                                                </button>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-5">
                                            <div class="text-muted">
                                                <i class="bi bi-inbox" style="font-size: 3rem; opacity: 0.3;"></i>
                                                <p class="mt-3 mb-0">Henüz işlem kaydı bulunmamaktadır.</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Customer Payment Modal -->
<div class="modal fade" id="customerPaymentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content" style="border-radius: 16px; border: none;">
            <div class="modal-header" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); border-radius: 16px 16px 0 0; border: none;">
                <h5 class="modal-title text-white fw-bold">
                    <i class="bi bi-cash-coin me-2"></i>Müşteriye Ödeme Ekle
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.accounting.cashbox.income.store') }}" method="POST">
                @csrf
                <input type="hidden" name="customer_id" value="{{ $customer->id }}">
                <div class="modal-body" style="padding: 2rem;">
                    <div class="alert" style="background: #dbeafe; border: none; border-radius: 12px; padding: 1rem;">
                        <strong style="color: #1e40af;">Müşteri:</strong> <span style="color: #111827;">{{ $customer->name }}</span><br>
                        <strong style="color: #1e40af;">Kalan Bakiye:</strong> <span style="color: #111827;">{{ number_format($totalRemaining, 2, ',', '.') }} ₺</span>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-semibold" style="color: #111827;">Ödeme Tutarı <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="number" name="amount" id="customerPaymentAmount" class="form-control" step="0.01" min="0" value="{{ $totalRemaining > 0 ? $totalRemaining : 0 }}" required style="border-radius: 8px; border: 1px solid #e5e7eb; padding: 12px;">
                            <span class="input-group-text" style="border-radius: 0 8px 8px 0; border: 1px solid #e5e7eb; background: #f9fafb;">₺</span>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-semibold" style="color: #111827;">Tarih <span class="text-danger">*</span></label>
                        <input type="date" name="date" class="form-control" value="{{ date('Y-m-d') }}" required style="border-radius: 8px; border: 1px solid #e5e7eb; padding: 12px;">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-semibold" style="color: #111827;">Açıklama</label>
                        <input type="text" name="description" class="form-control" value="Müşteri Ödemesi - {{ $customer->name }}" style="border-radius: 8px; border: 1px solid #e5e7eb; padding: 12px;">
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 1.5rem;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">İptal</button>
                    <button type="submit" class="btn btn-success" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); border: none; border-radius: 8px; padding: 10px 20px; box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);">
                        <i class="bi bi-check-circle me-2"></i>Ödemeyi Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function openCustomerPaymentModal() {
    const modal = new bootstrap.Modal(document.getElementById('customerPaymentModal'));
    modal.show();
}

function copyReferralCode(code) {
    navigator.clipboard.writeText(code).then(function() {
        // Başarılı mesajı göster
        const btn = event.target.closest('button');
        const originalHTML = btn.innerHTML;
        btn.innerHTML = '<i class="bi bi-check"></i>';
        btn.classList.remove('btn-outline-secondary');
        btn.classList.add('btn-success');
        
        setTimeout(function() {
            btn.innerHTML = originalHTML;
            btn.classList.remove('btn-success');
            btn.classList.add('btn-outline-secondary');
        }, 2000);
    }).catch(function(err) {
        console.error('Kopyalama hatası:', err);
        alert('Kod kopyalanamadı. Lütfen manuel olarak kopyalayın: ' + code);
    });
}

</script>
@endpush
