@extends('layouts.admin')

@section('title', 'Dashboard - Admin Panel')
@section('page-title', 'Dashboard')

@push('styles')
<style>
    /* Mobil görünümde header padding düzeltmesi */
    @media (max-width: 1024px) {
        body {
            padding-top: 108px !important;
        }
        
        .main-content {
            padding-top: 20px !important;
        }
    }
    /* Dashboard Specific Styles */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    @keyframes fadeIn {
        from {
            opacity: 0;
        }
        to {
            opacity: 1;
        }
    }
    
    @keyframes slideInRight {
        from {
            opacity: 0;
            transform: translateX(30px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
}

@keyframes pulse {
    0%, 100% {
            opacity: 1;
    }
    50% {
            opacity: 0.7;
    }
}

    @keyframes shimmer {
    0% {
            background-position: -1000px 0;
    }
    100% {
            background-position: 1000px 0;
        }
    }
    
    .greeting-card {
    background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        color: white;
        border-radius: 0.75rem;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 10px 30px rgba(236, 72, 153, 0.3);
    position: relative;
    overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .greeting-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 15px 40px rgba(236, 72, 153, 0.4);
    }
    
    @media (max-width: 767.98px) {
        .greeting-card {
            padding: 1.25rem;
            margin-bottom: 1rem;
        }
    }
    
    .greeting-card::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 200%;
    height: 200%;
        background: linear-gradient(45deg, transparent, rgba(255,255,255,0.1), transparent);
        transform: rotate(45deg);
        animation: shimmer 3s infinite;
        pointer-events: none;
        z-index: 0;
    }
    
    .greeting-text {
        font-size: 1.375rem;
        font-weight: 600;
        margin-bottom: 0.375rem;
    position: relative;
    z-index: 1;
    }
    
    .greeting-name {
        font-size: 1rem;
        opacity: 0.9;
    position: relative;
        z-index: 1;
        margin-bottom: 0;
    }
    
    @media (max-width: 767.98px) {
        .greeting-text {
            font-size: 1.25rem;
            margin-bottom: 0.25rem;
        }
        
        .greeting-name {
            font-size: 0.9375rem;
        }
    }
    
    .stats-grid {
        display: grid !important;
        grid-template-columns: repeat(4, 1fr) !important;
        gap: 1rem !important;
        margin-bottom: 1.5rem !important;
        width: 100% !important;
        box-sizing: border-box !important;
        padding: 0 !important;
    }
    
    @media (min-width: 1400px) {
        .stats-grid {
            gap: 1.25rem !important;
        }
    }
    
    @media (max-width: 1199.98px) and (min-width: 992px) {
        .stats-grid {
            grid-template-columns: repeat(3, 1fr) !important;
            gap: 1rem !important;
        }
    }
    
    @media (max-width: 991.98px) and (min-width: 768px) {
        .stats-grid {
            grid-template-columns: repeat(2, 1fr) !important;
            gap: 1rem !important;
        }
    }
    
    @media (max-width: 767.98px) {
        .stats-grid {
            grid-template-columns: repeat(2, 1fr) !important;
            gap: 0.75rem !important;
            margin-bottom: 1rem !important;
        }
    }
    
    @media (max-width: 575.98px) {
        .stats-grid {
            grid-template-columns: 1fr !important;
            gap: 0.75rem !important;
            margin-bottom: 1rem !important;
        }
        
        .greeting-card {
            padding: 1.5rem;
        }
        
        .greeting-text {
            font-size: 1.25rem;
        }
        
        .greeting-name {
            font-size: 1rem;
        }
        
        .stat-card {
            width: 100% !important;
            max-width: 100% !important;
            margin: 0 !important;
        }
    }
    
    .stat-card {
        background: white;
        border-radius: 0.625rem;
        padding: 1.25rem;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid var(--border-color);
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
        width: 100% !important;
        max-width: 100% !important;
        min-width: 0 !important;
        box-sizing: border-box !important;
        display: flex !important;
        flex-direction: column !important;
        margin: 0 !important;
        float: none !important;
    cursor: pointer;
    }
    
    .stat-card:hover {
        transform: translateY(-5px) scale(1.02);
        box-shadow: 0 12px 30px rgba(236, 72, 153, 0.2);
        border-color: #ec4899;
        z-index: 10;
    }
    
    .stat-card:hover .stat-icon {
    transform: scale(1.15) rotate(5deg);
    }
    
    .stat-card:hover .stat-value {
        color: #ec4899;
    }
    
    @media (max-width: 767.98px) {
        .stat-card {
            padding: 1rem;
        }
    }
    
    @media (max-width: 575.98px) {
        .stat-card {
            padding: 0.875rem;
        }
    }
    
    .stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(180deg, #ec4899, #be185d);
        transform: scaleY(0);
        transition: transform 0.3s ease;
    }
    
    @media (min-width: 768px) {
        .stat-card:hover {
    transform: translateY(-5px) scale(1.02);
            box-shadow: 0 8px 25px rgba(236, 72, 153, 0.15);
        }
    }
    
    .stat-card:hover::before {
        transform: scaleY(1);
        width: 5px;
    }
    
    
    .stat-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
        margin-bottom: 0.75rem;
    }
    
    .stat-title {
        font-size: 0.875rem;
        color: var(--text-secondary);
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.5px;
}

.stat-icon {
    width: 48px;
    height: 48px;
        border-radius: 0.625rem;
    display: flex;
    align-items: center;
    justify-content: center;
        font-size: 1.5rem;
    flex-shrink: 0;
        transition: transform 0.3s ease;
    }
    
    @media (max-width: 767.98px) {
        .stat-icon {
            width: 44px;
            height: 44px;
            font-size: 1.35rem;
        }
    }
    
    .stat-card:hover .stat-icon {
        transform: scale(1.1) rotate(5deg);
    }
    
    .stat-value {
        font-size: 1.875rem;
        font-weight: 700;
        color: var(--text-primary);
        margin-bottom: 0.25rem;
        line-height: 1.1;
    }
    
    @media (max-width: 767.98px) {
        .stat-value {
            font-size: 1.5rem;
            margin-bottom: 0.125rem;
        }
    }
    
    @media (max-width: 575.98px) {
.stat-value {
            font-size: 1.375rem;
}
}

    .stat-change {
        font-size: 0.8125rem;
    display: flex;
        align-items: center;
        gap: 0.375rem;
        font-weight: 500;
        margin-top: 0.25rem;
        transition: all 0.3s ease;
    }
    
    .stat-card:hover .stat-change {
        transform: translateX(5px);
    }
    
    /* Premium Feature Cards */
    .premium-feature-card {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 1.5rem 1rem;
        background: white;
        border-radius: 12px;
        text-decoration: none;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        border: 2px solid transparent;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        height: 100%;
        min-height: 140px;
    }
    
    .premium-feature-card:hover {
        transform: translateY(-8px) scale(1.02);
        box-shadow: 0 12px 30px rgba(236, 72, 153, 0.25);
        border-color: #ec4899;
        text-decoration: none;
    }
    
    .premium-feature-card.active {
        border-color: #ec4899;
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    }
    
    .premium-feature-icon {
        width: 64px;
        height: 64px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 0.75rem;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }
    
    .premium-feature-card:hover .premium-feature-icon {
        transform: scale(1.15) rotate(5deg);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
    }
    
    .premium-feature-icon i {
        font-size: 28px;
    }
    
    .premium-feature-title {
        font-size: 0.875rem;
        font-weight: 600;
        color: #1e293b;
        text-align: center;
        line-height: 1.3;
        transition: color 0.3s ease;
    }
    
    .premium-feature-card:hover .premium-feature-title {
        color: #ec4899;
    }
    
    @media (max-width: 767.98px) {
        .premium-feature-card {
            padding: 1.25rem 0.75rem;
            min-height: 120px;
        }
        
        .premium-feature-icon {
            width: 56px;
            height: 56px;
        }
        
        .premium-feature-icon i {
            font-size: 24px;
        }
        
        .premium-feature-title {
            font-size: 0.8125rem;
        }
    }
    
    .stat-change-table {
        width: 100%;
        font-size: 0.75rem;
        margin-top: 0.5rem;
        border-collapse: collapse;
    }
    
    .stat-change-table {
        transition: all 0.3s ease;
    }
    
    .stat-card:hover .stat-change-table {
        transform: translateX(3px);
    }
    
    .stat-change-table td {
        padding: 0.375rem 0.25rem;
        border-bottom: 1px solid #f1f5f9;
    transition: all 0.3s ease;
    }
    
    .stat-change-table td:first-child {
        color: var(--text-secondary);
        font-weight: 500;
        width: 60%;
    }
    
    .stat-change-table td:last-child {
        text-align: right;
    font-weight: 600;
        width: 40%;
    }
    
    .stat-change-table tr:hover td {
        background: #fce7f3;
        color: #ec4899;
    }
    
    .stat-change-table tr:last-child td {
        border-bottom: none;
    }
    
    .stat-card:hover .stat-change-table td:last-child {
        transform: scale(1.05);
        font-weight: 700;
    }
    
    @media (max-width: 767.98px) {
        .stat-change {
            font-size: 0.75rem;
            gap: 0.25rem;
        }
    }
    
    .stat-change.positive {
        color: var(--success-color);
    }
    
    .stat-change.negative {
        color: var(--danger-color);
    }
    
    .stat-change.neutral {
        color: var(--text-secondary);
    }
    
    .progress-bar-container {
        margin-top: 0.625rem;
        height: 4px;
        background: #e5e7eb;
        border-radius: 2px;
    overflow: hidden;
    }
    
    .progress-bar {
        height: 100%;
        background: linear-gradient(90deg, #ec4899, #f472b6);
        border-radius: 3px;
        transition: width 0.5s ease-out;
    }
    
    .stat-card:hover .progress-bar {
        background: linear-gradient(90deg, #ec4899, #f472b6);
        box-shadow: 0 0 10px rgba(236, 72, 153, 0.4);
    }
    
    /* Mini Widgets */
    .mini-widget {
        background: white;
        border-radius: 0.625rem;
        padding: 1rem;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid var(--border-color);
        transition: all 0.3s ease;
        margin-bottom: 0.75rem;
    cursor: pointer;
}

    .mini-widget:last-child {
        margin-bottom: 0;
    }
    
    .mini-widget:hover {
        transform: translateY(-3px) translateX(5px);
        box-shadow: 0 8px 20px rgba(236, 72, 153, 0.15);
        border-left: 4px solid #ec4899;
        background: linear-gradient(135deg, #fce7f3 0%, #ffffff 100%);
    }
    
    .mini-widget:hover i {
        transform: scale(1.2);
        color: #ec4899 !important;
    }
    
    .mini-widget i {
    transition: all 0.3s ease;
    }
    
    @media (max-width: 767.98px) {
        .mini-widget {
            padding: 0.875rem;
            margin-bottom: 0.625rem;
        }
    }
    
    /* Chart Container */
    .chart-container {
        position: relative;
        height: 300px;
        margin-bottom: 0;
    transition: all 0.3s ease;
}

    .card:hover .chart-container {
        transform: scale(1.01);
    }
    
    @media (max-width: 767.98px) {
        .chart-container {
            height: 250px;
        }
    }
    
    @media (max-width: 575.98px) {
        .chart-container {
            height: 220px;
        }
    }
    
    /* Table Styles */
    .data-table {
        width: 100%;
    }
    
    .data-table thead {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    }
    
    .data-table th {
        font-weight: 600;
        font-size: 0.8125rem;
        color: var(--text-secondary);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        padding: 0.875rem 1rem;
        border-bottom: 2px solid var(--border-color);
    }
    
    .data-table td {
        padding: 0.875rem 1rem;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle;
    }
    
    @media (max-width: 991.98px) {
        .data-table {
            font-size: 0.875rem;
        }
        
        .data-table th,
        .data-table td {
            padding: 0.75rem 0.5rem;
            font-size: 0.8125rem;
        }
        
        .data-table th:nth-child(3),
        .data-table td:nth-child(3),
        .data-table th:nth-child(4),
        .data-table td:nth-child(4) {
            display: none;
        }
    }
    
    @media (max-width: 767.98px) {
        .data-table th,
        .data-table td {
            padding: 0.625rem 0.375rem;
            font-size: 0.75rem;
        }
        
        .data-table .btn-sm {
            padding: 0.25rem 0.5rem;
            font-size: 0.7rem;
        }
    }
    
    @media (max-width: 575.98px) {
        .data-table th,
        .data-table td {
            padding: 0.5rem 0.25rem;
            font-size: 0.7rem;
        }
        
        .data-table th:nth-child(5),
        .data-table td:nth-child(5) {
            display: none;
        }
    }
    
    .data-table tbody tr {
        transition: all 0.2s ease;
        animation: fadeIn 0.5s ease-out;
        animation-fill-mode: both;
    }
    
    
    @media (max-width: 767.98px) {
        .data-table th,
        .data-table td {
            padding: 0.75rem 0.5rem;
            font-size: 0.875rem;
        }
    }
    
    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 2rem 1rem;
        color: var(--text-secondary);
    }
    
    .empty-state i {
        font-size: 2.5rem;
        color: var(--border-color);
        margin-bottom: 0.75rem;
        transition: all 0.3s ease;
    }
    
    .empty-state:hover i {
        transform: scale(1.2) rotate(10deg);
    color: #ec4899;
    }
    
    @media (max-width: 767.98px) {
.empty-state {
            padding: 1.5rem 0.75rem;
}

.empty-state i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
    }
    
    .section-title {
        font-size: 1.25rem;
        font-weight: 700;
        color: var(--text-primary);
        margin-bottom: 1rem;
        margin-top: 0;
    display: flex;
    align-items: center;
        gap: 0.5rem;
        padding-top: 0.5rem;
    transition: all 0.3s ease;
}

    .section-title:hover {
        color: #ec4899;
        transform: translateX(5px);
    }
    
    .section-title:hover i {
        transform: scale(1.2) rotate(5deg);
    }
    
    .section-title i {
        transition: all 0.3s ease;
    }
    
    @media (max-width: 767.98px) {
        .section-title {
            font-size: 1.125rem;
            margin-bottom: 0.875rem;
        }
    }
    
    .section-title i {
        color: var(--primary-color);
        font-size: 1.5rem;
    }
    
    @media (max-width: 767.98px) {
        .section-title {
            font-size: 1.125rem;
            margin-bottom: 0.875rem;
        }
        
        .section-title i {
            font-size: 1.35rem;
        }
    }
    
    /* Trend Indicator */
    .trend-indicator {
        display: inline-flex;
        align-items: center;
        gap: 0.25rem;
        padding: 0.25rem 0.5rem;
        border-radius: 0.375rem;
        font-size: 0.75rem;
        font-weight: 600;
    }
    
    .trend-up {
        background: #fce7f3;
        color: #ec4899;
    }
    
    .trend-down {
        background: #fee2e2;
        color: #991b1b;
    }
    
    .trend-neutral {
        background: #f3f4f6;
        color: #6b7280;
    }
    
    /* Top Customer Card */
    .top-customer-card {
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border-radius: 0.625rem;
        padding: 0.875rem;
        margin-bottom: 0.625rem;
        border-left: 3px solid #ec4899;
        transition: all 0.3s ease;
        cursor: pointer;
    }
    
    .top-customer-card:last-child {
        margin-bottom: 0;
    }
    
    .top-customer-card:hover {
        transform: translateX(8px) translateY(-2px);
        box-shadow: 0 6px 20px rgba(236, 72, 153, 0.2);
        border-left-width: 5px;
        background: linear-gradient(135deg, #fce7f3 0%, #ffffff 100%);
    }
    
    .top-customer-card:hover .bg-primary {
        transform: scale(1.1);
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3);
    }
    
    .top-customer-card .bg-primary {
        transition: all 0.3s ease;
    }
    
    @media (max-width: 767.98px) {
        .top-customer-card {
            padding: 0.75rem;
            margin-bottom: 0.5rem;
        }
    }
    
    @keyframes fadeInRight {
        from {
    opacity: 0;
            transform: translateX(-20px);
}
        to {
    opacity: 1;
            transform: translateX(0);
        }
    }
    
    /* Quick Action Buttons */
    .quick-action-btn {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        color: white;
        border: none;
        padding: 0.75rem 1.5rem;
        border-radius: 0.5rem;
        font-weight: 600;
    transition: all 0.3s ease;
        display: inline-flex;
    align-items: center;
        gap: 0.5rem;
    text-decoration: none;
        box-shadow: 0 4px 12px rgba(236, 72, 153, 0.3);
        cursor: pointer;
        position: relative;
        z-index: 10;
        pointer-events: auto;
    }
    
    .quick-action-btn:hover {
        transform: translateY(-3px) scale(1.05);
        box-shadow: 0 8px 25px rgba(236, 72, 153, 0.5);
        color: white;
    }
    
    .quick-action-btn:hover i {
        transform: scale(1.2) rotate(10deg);
    }
    
    .quick-action-btn i {
    transition: all 0.3s ease;
}

    /* Revenue Comparison Card */
    .revenue-comparison {
        background: white;
        border: 1px solid var(--border-color);
        border-radius: 0.75rem;
        padding: 1.5rem;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        height: 100%;
    display: flex;
    flex-direction: column;
    position: relative;
    overflow: hidden;
}

    .revenue-comparison::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
        height: 4px;
        background: linear-gradient(90deg, #ec4899 0%, #be185d 100%);
    transition: all 0.3s ease;
}

    .revenue-comparison:hover::before {
        height: 6px;
        box-shadow: 0 2px 10px rgba(236, 72, 153, 0.4);
    }
    
    @media (max-width: 767.98px) {
        .revenue-comparison {
            padding: 1.25rem;
            margin-bottom: 1rem;
        }
    }
    
    .revenue-comparison::before {
    content: '';
    position: absolute;
        top: -50%;
        right: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        animation: pulse 3s infinite;
    }
    
    /* Mobile Optimizations */
    @media (max-width: 767.98px) {
        .stat-value {
            font-size: 1.75rem;
        }
        
        .stat-icon {
    width: 48px;
    height: 48px;
            font-size: 1.5rem;
        }
        
        .section-title {
            font-size: 1.25rem;
        }
        
        .chart-container {
            height: 250px;
        }
        
        .row {
            margin-left: 0;
            margin-right: 0;
        }
        
        .row > [class*="col-"] {
            padding-left: 0.75rem;
            padding-right: 0.75rem;
            margin-bottom: 1rem;
        }
    }
    
    @media (max-width: 575.98px) {
        .stat-value {
            font-size: 1.5rem;
        }
        
        .stat-card {
            padding: 1rem;
        }
        
        .chart-container {
            height: 220px;
        }
        
        .row > [class*="col-"] {
            padding-left: 0.5rem;
            padding-right: 0.5rem;
        }
        
        #greetingActions,
        .greeting-card .d-flex {
            flex-direction: column !important;
            position: relative !important;
            z-index: 10 !important;
            pointer-events: auto !important;
        }
        
        .greeting-card .quick-action-btn {
            width: 100% !important;
            justify-content: center !important;
            position: relative !important;
            z-index: 10 !important;
            pointer-events: auto !important;
            touch-action: manipulation !important;
        }
    }
    
    /* Force proper layout */
    .content-wrapper {
        width: 100% !important;
        max-width: 100% !important;
        box-sizing: border-box !important;
        overflow-x: hidden !important;
        padding: 1.5rem !important;
    }
    
    @media (max-width: 991.98px) {
        .content-wrapper {
            padding: 1rem !important;
        }
    }
    
    @media (max-width: 575.98px) {
        .content-wrapper {
            padding: 0.75rem !important;
        }
    }
    
    /* Main container fixes */
    .main-content,
    #dashboardContent {
        width: 100% !important;
        max-width: 100% !important;
        margin: 0 auto !important;
        padding: 0 !important;
    }
    
    .content-wrapper > * {
        width: 100% !important;
        max-width: 100% !important;
        box-sizing: border-box !important;
    }
    
    /* Force grid items to be proper */
    .stats-grid > * {
        width: 100% !important;
        max-width: 100% !important;
        min-width: 0 !important;
        box-sizing: border-box !important;
        margin: 0 !important;
        float: none !important;
    }
    
    /* Row and column fixes */
    .dashboard-row,
    .dashboard-row.row,
    .row {
        display: flex !important;
        flex-wrap: wrap !important;
        margin-left: -0.75rem !important;
        margin-right: -0.75rem !important;
        margin-bottom: 1rem !important;
        width: 100% !important;
        box-sizing: border-box !important;
    }
    
    .dashboard-row [class*="col-"],
    .row [class*="col-"] {
        position: relative !important;
        padding-left: 0.75rem !important;
        padding-right: 0.75rem !important;
        box-sizing: border-box !important;
        flex: 0 0 auto !important;
        width: 100% !important;
        max-width: 100% !important;
        margin-bottom: 1rem !important;
    }
    
    @media (max-width: 767.98px) {
        .dashboard-row,
        .row {
            margin-left: -0.5rem !important;
            margin-right: -0.5rem !important;
            margin-bottom: 0.75rem !important;
        }
        
        .dashboard-row [class*="col-"],
        .row [class*="col-"] {
            padding-left: 0.5rem !important;
            padding-right: 0.5rem !important;
            margin-bottom: 0.75rem !important;
        }
    }
    
    @media (max-width: 575.98px) {
        .dashboard-row,
        .row {
            margin-left: -0.25rem !important;
            margin-right: -0.25rem !important;
        }
        
        .dashboard-row [class*="col-"],
        .row [class*="col-"] {
            padding-left: 0.25rem !important;
            padding-right: 0.25rem !important;
        }
    }
    
    @media (min-width: 992px) {
        .dashboard-row .col-lg-6,
        .row .col-lg-6,
        .col-lg-6 {
            flex: 0 0 calc(50% - 1.5rem) !important;
            max-width: calc(50% - 1.5rem) !important;
            width: calc(50% - 1.5rem) !important;
        }
        
        .dashboard-row .col-lg-8,
        .row .col-lg-8,
        .col-lg-8 {
            flex: 0 0 calc(66.666667% - 1.5rem) !important;
            max-width: calc(66.666667% - 1.5rem) !important;
            width: calc(66.666667% - 1.5rem) !important;
        }
        
        .dashboard-row .col-lg-4,
        .row .col-lg-4,
        .col-lg-4 {
            flex: 0 0 calc(33.333333% - 1.5rem) !important;
            max-width: calc(33.333333% - 1.5rem) !important;
            width: calc(33.333333% - 1.5rem) !important;
        }
    }
    
    @media (max-width: 991.98px) {
        .dashboard-row .col-lg-6,
        .dashboard-row .col-lg-8,
        .dashboard-row .col-lg-4,
        .row .col-lg-6,
        .row .col-lg-8,
        .row .col-lg-4,
        .col-lg-6,
        .col-lg-8,
        .col-lg-4 {
            flex: 0 0 100% !important;
            max-width: 100% !important;
        width: 100% !important;
            margin-bottom: 1rem !important;
        }
    }
    
    /* Loading Animation */
    .loading-skeleton {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: shimmer 1.5s infinite;
        border-radius: 0.5rem;
        height: 20px;
        margin-bottom: 0.5rem;
    }
    
    /* Counter Animation */
    .counter {
        font-variant-numeric: tabular-nums;
    }
    
    /* Status Badge Styles */
    .status-badge {
        display: inline-block;
        padding: 0.375rem 0.75rem;
        border-radius: 0.375rem;
        font-size: 0.75rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .status-badge.status-pending {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        color: #92400e;
    }
    
    .status-badge.status-confirmed {
        background: linear-gradient(135deg, #dbeafe 0%, #93c5fd 100%);
        color: #1e40af;
    }
    
    .status-badge.status-completed {
        background: linear-gradient(135deg, #d1fae5 0%, #6ee7b7 100%);
        color: #065f46;
    }
    
    .status-badge.status-cancelled {
        background: linear-gradient(135deg, #fee2e2 0%, #fca5a5 100%);
        color: #991b1b;
    }
    
    .status-badge.status-open {
        background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
        color: #92400e;
    }
    
    .data-table tbody tr {
        cursor: pointer;
        transition: all 0.2s ease;
    }
    
    .data-table tbody tr:hover {
        background-color: #f8f9fa;
        transform: translateX(2px);
    }
</style>
@endpush

@section('content')
@php
    $now = \Carbon\Carbon::now()->setTimezone('Europe/Istanbul');
    $hour = $now->hour;
    
    if ($hour >= 5 && $hour < 12) {
        $greeting = 'Günaydın';
    } elseif ($hour >= 12 && $hour < 17) {
        $greeting = 'İyi Öğleden Sonralar';
    } elseif ($hour >= 17 && $hour < 21) {
        $greeting = 'İyi Akşamlar';
    } else {
        $greeting = 'İyi Geceler';
    }
    
    $user = auth()->user();
    
    // Hesaplamalar
    $todayCount = $stats['today_count'] ?? 0;
    $monthCount = $stats['month_count'] ?? 0;
    $totalAppointments = $stats['total_appointments'] ?? 0;
    $openCount = $stats['open_count'] ?? 0;
    $confirmedCount = $stats['confirmed_count'] ?? 0;
    $completedCount = $stats['completed_count'] ?? 0;
    $cancelledCount = $stats['cancelled_count'] ?? 0;
    
    // Gelir hesaplamaları
    $monthlyRevenueAmount = $monthlyRevenue ?? 0;
    $lastMonthRevenueAmount = $lastMonthRevenue ?? 0;
    $revenueChange = $lastMonthRevenueAmount > 0 
        ? (($monthlyRevenueAmount - $lastMonthRevenueAmount) / $lastMonthRevenueAmount) * 100 
        : 0;
    
    // Randevu değişimi
    $lastMonthAppointmentsCount = $lastMonthAppointments ?? 0;
    $reservationChange = $lastMonthAppointmentsCount > 0 
        ? (($monthCount - $lastMonthAppointmentsCount) / $lastMonthAppointmentsCount) * 100 
        : 0;
    
    // Ortalama hesaplamaları
    $avgReservation = $monthCount > 0 ? ($monthlyRevenueAmount / $monthCount) : 0;
    $weeklyAvg = $weeklyAppointments ?? 0;
    
    // Tamamlanma oranı
    $completionRate = $totalAppointments > 0 
        ? ($completedCount / $totalAppointments) * 100 
        : 0;
    
    // İptal oranı
    $cancellationRate = $totalAppointments > 0 
        ? ($cancelledCount / $totalAppointments) * 100 
        : 0;
    
    // Günlük ortalama
    $dailyAverage = $monthCount > 0 ? ($monthCount / $now->day) : 0;
    
    // Kasa net kar
    $netProfit = ($cashIncome ?? 0) - ($cashExpense ?? 0);
@endphp

<!-- Greeting Card -->
<div class="greeting-card">
    <div class="greeting-text">
        {{ $greeting }}, {{ explode(' ', $user->name)[0] }}! 👋
    </div>
    <div class="greeting-name">
        <i class="bi bi-calendar3 me-2"></i>
        {{ $now->locale('tr')->isoFormat('D MMMM YYYY, dddd') }}
    </div>
    <div class="mt-2 d-flex gap-2 flex-wrap" id="greetingActions" style="position: relative; z-index: 10;">
        <!-- Yeni Randevu butonu kaldırıldı -->
        <a href="#" onclick="event.preventDefault(); openNewCustomerModalFromDashboard();" class="quick-action-btn" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); font-size: 0.875rem; padding: 0.625rem 1.25rem;">
            <i class="bi bi-person-plus"></i>
            Yeni Müşteri
        </a>
    </div>
</div>

<!-- Today's Stats -->
<div class="section-title">
    <i class="bi bi-calendar-day"></i>
    Bugünün Özeti
</div>

<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Bugünkü Randevular</span>
            <div class="stat-icon" style="background: #fce7f3; color: #be185d;">
                <i class="bi bi-calendar-check"></i>
            </div>
        </div>
        <div class="stat-value">{{ $todayCount }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Durum</td>
                <td class="text-success">Bugün</td>
            </tr>
            <tr>
                <td>Günlük Ortalama</td>
                <td>{{ number_format($dailyAverage, 1) }}</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ min(100, ($todayCount / max(1, $dailyAverage)) * 100) }}%"></div>
        </div>
    </div>
    
    @if(!auth()->user()->isPersonel())
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Bugünkü Gelir</span>
            <div class="stat-icon" style="background: #fce7f3; color: #ec4899;">
                <i class="bi bi-cash-stack"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($todayIncome ?? 0, 0, ',', '.') }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Toplam</td>
                <td class="text-success">{{ number_format($todayIncome ?? 0, 2, ',', '.') }} ₺</td>
            </tr>
            <tr>
                <td>Günlük Hedef</td>
                <td>{{ $monthlyRevenueAmount > 0 ? number_format($monthlyRevenueAmount / $now->day, 2, ',', '.') : '0,00' }} ₺</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ $monthlyRevenueAmount > 0 ? min(100, (($todayIncome ?? 0) / ($monthlyRevenueAmount / $now->day)) * 100) : 0 }}%; background: linear-gradient(90deg, #ec4899, #be185d);"></div>
        </div>
    </div>
    @endif
    
    @if(!auth()->user()->isPersonel())
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Bugünkü Gider</span>
            <div class="stat-icon" style="background: #fee2e2; color: #991b1b;">
                <i class="bi bi-arrow-down-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($todayExpense ?? 0, 0, ',', '.') }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Toplam</td>
                <td class="text-danger">{{ number_format($todayExpense ?? 0, 2, ',', '.') }} ₺</td>
            </tr>
            <tr>
                <td>Kategori</td>
                <td>Günlük Gider</td>
            </tr>
        </table>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Kasa Bakiyesi</span>
            <div class="stat-icon" style="background: #fef3c7; color: #92400e;">
                <i class="bi bi-wallet2"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($cashBalance ?? 0, 0, ',', '.') }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Net Kar</td>
                <td class="{{ $netProfit >= 0 ? 'text-success' : 'text-danger' }}">{{ number_format($netProfit, 2, ',', '.') }} ₺</td>
            </tr>
            <tr>
                <td>Toplam Gelir</td>
                <td>{{ number_format($cashIncome ?? 0, 2, ',', '.') }} ₺</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ ($cashIncome ?? 0) > 0 ? min(100, (($cashBalance ?? 0) / ($cashIncome ?? 1)) * 100) : 0 }}%; background: linear-gradient(90deg, #f59e0b, #d97706);"></div>
        </div>
    </div>
    @endif
</div>

<!-- Monthly Stats & Performance -->
<div class="section-title">
    <i class="bi bi-graph-up-arrow"></i>
    Aylık Performans ve İstatistikler
</div>

<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Bu Ay Randevu</span>
            <div class="stat-icon" style="background: #e0e7ff; color: #3730a3;">
                <i class="bi bi-calendar3"></i>
            </div>
        </div>
        <div class="stat-value">{{ $monthCount }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Geçen Ay</td>
                <td>{{ $lastMonthAppointmentsCount }}</td>
            </tr>
            <tr>
                <td>Değişim</td>
                <td class="{{ $reservationChange >= 0 ? 'text-success' : 'text-danger' }}">{{ number_format(abs($reservationChange), 1) }}%</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ $lastMonthAppointmentsCount > 0 ? min(100, ($monthCount / $lastMonthAppointmentsCount) * 100) : 0 }}%"></div>
        </div>
    </div>
    
    @if(!auth()->user()->isPersonel())
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Aylık Gelir</span>
            <div class="stat-icon" style="background: linear-gradient(135deg, #ec4899, #be185d); color: white;">
                <i class="bi bi-graph-up"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($monthlyRevenueAmount, 0, ',', '.') }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Geçen Ay</td>
                <td>{{ number_format($lastMonthRevenueAmount, 0, ',', '.') }} ₺</td>
            </tr>
            <tr>
                <td>Değişim</td>
                <td class="{{ $revenueChange >= 0 ? 'text-success' : 'text-danger' }}">{{ number_format(abs($revenueChange), 1) }}%</td>
            </tr>
            <tr>
                <td>Ortalama</td>
                <td>@if(!auth()->user()->isPersonel()){{ number_format($avgReservation, 2, ',', '.') }} ₺/randevu@else-@endif</td>
            </tr>
        </table>
    </div>
    @endif
    
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Bekleyen Ödeme</span>
            <div class="stat-icon" style="background: #fee2e2; color: #991b1b;">
                <i class="bi bi-clock-history"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($pendingPayments ?? 0, 0, ',', '.') }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Tutar</td>
                <td class="text-danger">{{ number_format($pendingPayments ?? 0, 2, ',', '.') }} ₺</td>
            </tr>
            <tr>
                <td>Oran</td>
                <td>{{ $monthlyRevenueAmount > 0 ? number_format((($pendingPayments ?? 0) / $monthlyRevenueAmount) * 100, 1) : 0 }}%</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ $monthlyRevenueAmount > 0 ? min(100, (($pendingPayments ?? 0) / $monthlyRevenueAmount) * 100) : 0 }}%; background: linear-gradient(90deg, #ef4444, #dc2626);"></div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Toplam Müşteri</span>
            <div class="stat-icon" style="background: #fce7f3; color: #ec4899;">
                <i class="bi bi-people"></i>
            </div>
        </div>
        <div class="stat-value">{{ $totalCustomers ?? 0 }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Durum</td>
                <td class="text-success">Aktif</td>
            </tr>
            <tr>
                <td>Randevu/Müşteri</td>
                <td>{{ $totalCustomers > 0 ? number_format($totalAppointments / $totalCustomers, 1) : 0 }}</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ $totalAppointments > 0 ? min(100, (($totalCustomers ?? 0) / max(1, $totalAppointments)) * 100) : 0 }}%; background: linear-gradient(90deg, #f472b6, #ec4899);"></div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Tamamlanma Oranı</span>
            <div class="stat-icon" style="background: #fce7f3; color: #ec4899;">
                <i class="bi bi-check-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($completionRate, 1) }}%</div>
        <table class="stat-change-table">
            <tr>
                <td>Tamamlanan</td>
                <td class="text-success">{{ $completedCount }}</td>
            </tr>
            <tr>
                <td>Toplam</td>
                <td>{{ $totalAppointments }}</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ $completionRate }}%; background: linear-gradient(90deg, #ec4899, #be185d);"></div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">İptal Oranı</span>
            <div class="stat-icon" style="background: #fee2e2; color: #991b1b;">
                <i class="bi bi-x-circle"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($cancellationRate, 1) }}%</div>
        <table class="stat-change-table">
            <tr>
                <td>İptal Edilen</td>
                <td class="text-danger">{{ $cancelledCount }}</td>
            </tr>
            <tr>
                <td>Toplam</td>
                <td>{{ $totalAppointments }}</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ $cancellationRate }}%; background: linear-gradient(90deg, #ef4444, #dc2626);"></div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Haftalık Randevu</span>
            <div class="stat-icon" style="background: #fef3c7; color: #92400e;">
                <i class="bi bi-calendar-week"></i>
            </div>
        </div>
        <div class="stat-value">{{ $weeklyAppointments ?? 0 }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Periyot</td>
                <td>Bu Hafta</td>
            </tr>
            <tr>
                <td>Haftalık Ortalama</td>
                <td>{{ $monthCount > 0 ? number_format($monthCount / 4, 1) : 0 }}</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ $monthCount > 0 ? min(100, (($weeklyAppointments ?? 0) / ($monthCount / 4)) * 100) : 0 }}%; background: linear-gradient(90deg, #f59e0b, #d97706);"></div>
        </div>
    </div>
    
    <div class="stat-card">
        <div class="stat-header">
            <span class="stat-title">Günlük Ortalama</span>
            <div class="stat-icon" style="background: #e0e7ff; color: #3730a3;">
                <i class="bi bi-graph-up"></i>
            </div>
        </div>
        <div class="stat-value">{{ number_format($dailyAverage, 1) }}</div>
        <table class="stat-change-table">
            <tr>
                <td>Birim</td>
                <td>Randevu/gün</td>
            </tr>
            <tr>
                <td>Bu Ay Toplam</td>
                <td>{{ $monthCount }}</td>
            </tr>
        </table>
        <div class="progress-bar-container">
            <div class="progress-bar" style="width: {{ min(100, ($dailyAverage / 10) * 100) }}%"></div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row dashboard-row">
    <div class="col-12 col-lg-8">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-graph-up me-2"></i>
                Son 7 Günün Randevu Tablosu
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="weeklyTrendChart"></canvas>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-12 col-lg-4">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-pie-chart me-2"></i>
                Randevu Durumu Dağılımı
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="statusChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Revenue Comparison & Monthly Chart -->
@if(!auth()->user()->isPersonel())
<div class="row dashboard-row">
    <div class="col-12 col-lg-6">
        <div class="revenue-comparison">
            <div class="d-flex align-items-center mb-3">
                <div class="bg-success bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 48px; height: 48px;">
                    <i class="bi bi-cash-coin text-success" style="font-size: 1.5rem;"></i>
                </div>
                <div>
                    <h5 class="mb-0" style="font-size: 1rem; font-weight: 600;">Aylık Gelir Karşılaştırması</h5>
                    <small class="text-muted">Bu ay ve geçen ay karşılaştırması</small>
                </div>
            </div>
            <div class="mt-3">
                <div class="d-flex justify-content-between align-items-center mb-3 p-3 rounded" style="background: linear-gradient(135deg, #fdf2f8 0%, #fce7f3 100%); border-left: 3px solid #ec4899;">
                    <div>
                        <div class="text-muted small mb-1">Bu Ay</div>
                        <div class="h4 mb-0 text-success fw-bold">{{ number_format($monthlyRevenueAmount, 0, ',', '.') }} ₺</div>
                    </div>
                    <i class="bi bi-calendar-month text-success" style="font-size: 2rem; opacity: 0.3;"></i>
                </div>
                <div class="d-flex justify-content-between align-items-center mb-3 p-3 rounded" style="background: #f9fafb;">
                    <div>
                        <div class="text-muted small mb-1">Geçen Ay</div>
                        <div class="h5 mb-0 fw-bold">{{ number_format($lastMonthRevenueAmount, 0, ',', '.') }} ₺</div>
                    </div>
                    <i class="bi bi-calendar3 text-muted" style="font-size: 1.5rem; opacity: 0.3;"></i>
                </div>
                @if($revenueChange != 0)
                <div class="mt-3 p-3 rounded d-flex align-items-center justify-content-between" style="background: {{ $revenueChange >= 0 ? '#fdf2f8' : '#fef2f2' }}; border-left: 3px solid {{ $revenueChange >= 0 ? '#ec4899' : '#ef4444' }};">
                    <div>
                        <div class="text-muted small mb-1">Değişim Oranı</div>
                        <div class="h6 mb-0 fw-bold text-{{ $revenueChange >= 0 ? 'success' : 'danger' }}">
                            <i class="bi bi-arrow-{{ $revenueChange >= 0 ? 'up' : 'down' }}"></i>
                            {{ number_format(abs($revenueChange), 1) }}% {{ $revenueChange >= 0 ? 'artış' : 'azalış' }}
                        </div>
                    </div>
                    <div class="text-{{ $revenueChange >= 0 ? 'success' : 'danger' }}" style="font-size: 2rem;">
                        <i class="bi bi-graph-up-arrow"></i>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-12 col-lg-6">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-bar-chart me-2"></i>
                Son 30 Gün Gelir Tablosu
            </div>
            <div class="card-body">
                <div class="chart-container" style="height: 250px;">
                    <canvas id="revenueChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

<!-- Top Customers -->
@if(isset($topCustomers) && $topCustomers->count() > 0)
<div class="row dashboard-row">
    <div class="col-12 col-lg-6">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-trophy me-2"></i>
                En Çok Randevu Yapan Müşteriler
            </div>
            <div class="card-body">
                @foreach($topCustomers->take(5) as $index => $item)
                <div class="top-customer-card">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center gap-3">
                            <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px; font-weight: bold;">
                                {{ $index + 1 }}
                            </div>
                            <div>
                                <strong>{{ $item['customer']->name ?? 'Misafir' }}</strong>
                                <br>
                                <small class="text-muted">{{ $item['customer']->phone ?? '-' }}</small>
                            </div>
                        </div>
                        <div class="text-end">
                            <div class="text-primary fw-bold">{{ $item['reservation_count'] }} randevu</div>
                            @if(!auth()->user()->isPersonel())
                            <small class="text-muted">{{ number_format($item['total_spent'] ?? 0, 2, ',', '.') }} ₺</small>
                            @endif
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    
    <div class="col-12 col-lg-6">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-info-circle me-2"></i>
                Sistem Özeti
            </div>
            <div class="card-body">
                <div class="mini-widget mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <span><i class="bi bi-calendar-check me-2 text-primary"></i>Toplam Randevu</span>
                        <strong class="text-primary">{{ number_format($totalAppointments, 0, ',', '.') }}</strong>
                    </div>
                </div>
                @if(!auth()->user()->isPersonel())
                <div class="mini-widget mb-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <span><i class="bi bi-cash-coin me-2 text-success"></i>Toplam Gelir</span>
                        <strong class="text-success">{{ number_format($totalRevenue ?? 0, 0, ',', '.') }} ₺</strong>
                    </div>
                </div>
                <div class="mini-widget">
                    <div class="d-flex justify-content-between align-items-center">
                        <span><i class="bi bi-calculator me-2 text-info"></i>Ortalama Tutar</span>
                        <strong class="text-info">{{ number_format($averageReservationAmount ?? 0, 2, ',', '.') }} ₺</strong>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endif

<!-- Recent Appointments -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2">
        <div class="d-flex align-items-center">
            <i class="bi bi-clock-history me-2 text-primary"></i>
            <span class="fw-bold">Son Randevular</span>
            <span class="badge bg-primary ms-2">{{ $recent_appointments->count() ?? 0 }}</span>
        </div>
        <a href="{{ route('admin.appointments.index') }}" class="btn btn-sm btn-outline-primary">
            <i class="bi bi-arrow-right me-1"></i>Tümünü Gör
        </a>
    </div>
    <div class="card-body p-0">
        @if(isset($recent_appointments) && $recent_appointments->count() > 0)
        <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
            <table class="table data-table mb-0 table-hover">
                <thead>
                    <tr>
                        <th>Tarih</th>
                        <th>Müşteri</th>
                        @if(Auth::check() && Auth::user()->role === 'güzellik_salonu')
                        <th>Hizmet</th>
                        <th>Personel</th>
                        <th>Oda</th>
                        @else
                        <th>Salon</th>
                        @endif
                        <th>Tutar</th>
                        <th>Durum</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recent_appointments->take(10) as $reservation)
                    <tr onclick="if(typeof window.showReservationDetail === 'function') { window.showReservationDetail({{ $reservation->id }}); } else { window.location.href='{{ route('admin.appointments.show', $reservation->id) }}'; }" style="cursor: pointer;">
                        <td>
                            <strong>{{ \Carbon\Carbon::parse($reservation->date ?? $reservation->created_at)->locale('tr')->translatedFormat('d M Y') }}</strong>
                            @if($reservation->start_time)
                            <br>
                            <small class="text-muted"><i class="bi bi-clock me-1"></i>{{ \Carbon\Carbon::parse($reservation->start_time)->format('H:i') }}</small>
                            @endif
                        </td>
                        <td>
                            <strong>{{ $reservation->customer->name ?? 'Misafir' }}</strong>
                            @if($reservation->customer && $reservation->customer->phone)
                            <br>
                            <small class="text-muted"><i class="bi bi-telephone me-1"></i>{{ $reservation->customer->phone }}</small>
                            @endif
                        </td>
                        @if(Auth::check() && Auth::user()->role === 'güzellik_salonu')
                        <td>
                            {{ $reservation->appointmentRequest && $reservation->appointmentRequest->service ? $reservation->appointmentRequest->service->name : '-' }}
                        </td>
                        <td>{{ $reservation->personel->name ?? '-' }}</td>
                        <td>{{ $reservation->room->name ?? '-' }}</td>
                        @else
                        <td>{{ $reservation->salon->name ?? '-' }}</td>
                        @endif
                        <td><strong>{{ number_format($reservation->total_price ?? 0, 2, ',', '.') }} ₺</strong></td>
                        <td>
                            <span class="status-badge status-{{ $reservation->status ?? 'pending' }}">
                                @if(($reservation->status ?? 'pending') == 'pending') Beklemede
                                @elseif(($reservation->status ?? 'pending') == 'confirmed') Onaylandı
                                @elseif(($reservation->status ?? 'pending') == 'completed') Tamamlandı
                                @elseif(($reservation->status ?? 'pending') == 'cancelled') İptal
                                @elseif(($reservation->status ?? 'pending') == 'open') Açık
                                @else {{ ucfirst($reservation->status ?? 'Bilinmiyor') }}
                                @endif
                            </span>
                        </td>
                        <td onclick="event.stopPropagation();">
                            <a href="{{ route('admin.appointments.show', $reservation->id) }}" class="btn btn-sm btn-outline-primary" onclick="event.preventDefault(); if(typeof window.showReservationDetail === 'function') { window.showReservationDetail({{ $reservation->id }}); } else { window.location.href='{{ route('admin.appointments.show', $reservation->id) }}'; }">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="empty-state">
            <i class="bi bi-calendar-x"></i>
            <p>Henüz randevu bulunmamaktadır.</p>
            <!-- Yeni Randevu butonu kaldırıldı -->
        </div>
        @endif
    </div>
</div>

<!-- Upcoming Appointments -->
@if(isset($upcomingAppointments) && $upcomingAppointments->count() > 0)
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center flex-wrap gap-2">
        <div class="d-flex align-items-center">
            <i class="bi bi-calendar-event me-2 text-info"></i>
            <span class="fw-bold">Yaklaşan Randevular</span>
            <span class="badge bg-info ms-2">{{ $upcomingAppointments->count() }}</span>
        </div>
        <a href="{{ route('admin.appointments.index') }}" class="btn btn-sm btn-outline-info">
            <i class="bi bi-arrow-right me-1"></i>Tümünü Gör
        </a>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
            <table class="table data-table mb-0 table-hover">
                <thead>
                    <tr>
                        <th>Tarih</th>
                        <th>Saat</th>
                        <th>Müşteri</th>
                        @if(Auth::check() && Auth::user()->role === 'güzellik_salonu')
                        <th>Hizmet</th>
                        <th>Personel</th>
                        <th>Oda</th>
                        @else
                        <th>Salon</th>
                        @endif
                        <th>Tutar</th>
                        <th>Durum</th>
                        <th>İşlemler</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($upcomingAppointments->take(10) as $reservation)
                    <tr onclick="if(typeof window.showReservationDetail === 'function') { window.showReservationDetail({{ $reservation->id }}); } else { window.location.href='{{ route('admin.appointments.show', $reservation->id) }}'; }" style="cursor: pointer;">
                        <td>
                            <strong>{{ \Carbon\Carbon::parse($reservation->date)->locale('tr')->translatedFormat('d M Y') }}</strong>
                            <br>
                            <small class="text-muted">{{ \Carbon\Carbon::parse($reservation->date)->locale('tr')->translatedFormat('l') }}</small>
                        </td>
                        <td>
                            @if($reservation->start_time)
                            <strong>{{ \Carbon\Carbon::parse($reservation->start_time)->format('H:i') }}</strong>
                            @else
                            <span>-</span>
                            @endif
                        </td>
                        <td>
                            <strong>{{ $reservation->customer->name ?? 'Misafir' }}</strong>
                            @if($reservation->customer && $reservation->customer->phone)
                            <br>
                            <small class="text-muted">{{ $reservation->customer->phone }}</small>
                            @endif
                        </td>
                        @if(Auth::check() && Auth::user()->role === 'güzellik_salonu')
                        <td>
                            {{ $reservation->appointmentRequest && $reservation->appointmentRequest->service ? $reservation->appointmentRequest->service->name : '-' }}
                        </td>
                        <td>{{ $reservation->personel->name ?? '-' }}</td>
                        <td>{{ $reservation->room->name ?? '-' }}</td>
                        @else
                        <td>{{ $reservation->salon->name ?? '-' }}</td>
                        @endif
                        <td><strong>{{ number_format($reservation->total_price ?? 0, 2, ',', '.') }} ₺</strong></td>
                        <td>
                            <span class="status-badge status-{{ $reservation->status ?? 'pending' }}">
                                @if(($reservation->status ?? 'pending') == 'pending') Beklemede
                                @elseif(($reservation->status ?? 'pending') == 'confirmed') Onaylandı
                                @elseif(($reservation->status ?? 'pending') == 'completed') Tamamlandı
                                @elseif(($reservation->status ?? 'pending') == 'cancelled') İptal
                                @else {{ ucfirst($reservation->status ?? 'Bilinmiyor') }}
                                @endif
                            </span>
                        </td>
                        <td onclick="event.stopPropagation();">
                            <a href="{{ route('admin.appointments.show', $reservation->id) }}" class="btn btn-sm btn-outline-primary" onclick="event.preventDefault(); if(typeof window.showReservationDetail === 'function') { window.showReservationDetail({{ $reservation->id }}); } else { window.location.href='{{ route('admin.appointments.show', $reservation->id) }}'; }">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endif

<!-- Modals -->
{{-- Yeni randevu modal'ı kaldırıldı - artık sayfa yönlendirmesi kullanılıyor --}}
@include('partials.modals')

<!-- Kayıt Bilgisi Modal -->
<div class="modal fade" id="registrationInfoModal" tabindex="-1" aria-labelledby="registrationInfoModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="registrationInfoModalLabel">
                    <i class="bi bi-info-circle"></i> Hoş Geldiniz! Kayıt Bilgilerinizi Tamamlayın
                </h5>
            </div>
            <form id="registrationInfoForm" method="POST" action="{{ route('register.update-info') }}">
                @csrf
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="bi bi-lightbulb"></i> Hesabınız başarıyla oluşturuldu. Lütfen aşağıdaki bilgileri tamamlayın.
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Salon İsmi <span class="text-danger">*</span></label>
                            <input type="text" name="salon_name" id="salon_name" class="form-control" placeholder="Örn: Güzellik Salonu, Kuaför" value="{{ Auth::check() && Auth::user() ? (Auth::user()->salon_name ?? '') : '' }}" required>
                            <small class="text-muted">Salon adınız (sistemde otomatik salon oluşturulacak)</small>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Salon Kısa Adı <span class="text-danger">*</span></label>
                            <input type="text" name="salon_short_name" id="salon_short_name" class="form-control" placeholder="Örn: guzellik-salonu" value="{{ Auth::check() && Auth::user() ? (Auth::user()->salon_short_name ?? '') : '' }}" required>
                            <small class="text-muted">URL'de görünecek kısa ad (örn: guzellik-salonu)</small>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Salon Telefonu <span class="text-danger">*</span></label>
                            <input type="text" name="salon_phone" id="salon_phone" class="form-control" placeholder="05XX XXX XX XX" value="{{ Auth::check() && Auth::user() ? (Auth::user()->salon_phone ?? '') : '' }}" required>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Salon Adresi <span class="text-danger">*</span></label>
                            <input type="text" name="salon_address" id="salon_address" class="form-control" placeholder="Salon adresiniz" value="{{ Auth::check() && Auth::user() ? (Auth::user()->salon_address ?? '') : '' }}" required>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">İl <span class="text-danger">*</span></label>
                            <select name="salon_city" id="salon_city" class="form-select" required>
                                <option value="">İl Seçin</option>
                                @php
                                    $cities = [
                                        'Adana', 'Adıyaman', 'Afyonkarahisar', 'Ağrı', 'Aksaray', 'Amasya', 'Ankara', 'Antalya',
                                        'Ardahan', 'Artvin', 'Aydın', 'Balıkesir', 'Bartın', 'Batman', 'Bayburt', 'Bilecik',
                                        'Bingöl', 'Bitlis', 'Bolu', 'Burdur', 'Bursa', 'Çanakkale', 'Çankırı', 'Çorum',
                                        'Denizli', 'Diyarbakır', 'Düzce', 'Edirne', 'Elazığ', 'Erzincan', 'Erzurum', 'Eskişehir',
                                        'Gaziantep', 'Giresun', 'Gümüşhane', 'Hakkari', 'Hatay', 'Iğdır', 'Isparta', 'İstanbul',
                                        'İzmir', 'Kahramanmaraş', 'Karabük', 'Karaman', 'Kars', 'Kastamonu', 'Kayseri', 'Kilis',
                                        'Kırıkkale', 'Kırklareli', 'Kırşehir', 'Kocaeli', 'Konya', 'Kütahya', 'Malatya', 'Manisa',
                                        'Mardin', 'Mersin', 'Muğla', 'Muş', 'Nevşehir', 'Niğde', 'Ordu', 'Osmaniye',
                                        'Rize', 'Sakarya', 'Samsun', 'Siirt', 'Sinop', 'Sivas', 'Şanlıurfa', 'Şırnak',
                                        'Tekirdağ', 'Tokat', 'Trabzon', 'Tunceli', 'Uşak', 'Van', 'Yalova', 'Yozgat', 'Zonguldak'
                                    ];
                                @endphp
                                @foreach($cities as $city)
                                    <option value="{{ $city }}" {{ (Auth::user()->salon_city ?? '') === $city ? 'selected' : '' }}>{{ $city }}</option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">İlçe <span class="text-danger">*</span></label>
                            <select name="salon_district" id="salon_district" class="form-select" required disabled>
                                <option value="">Önce il seçin</option>
                            </select>
                        </div>
                    </div>

                    @php
                        $workingDays = [
                            'monday' => 'Pazartesi',
                            'tuesday' => 'Salı',
                            'wednesday' => 'Çarşamba',
                            'thursday' => 'Perşembe',
                            'friday' => 'Cuma',
                            'saturday' => 'Cumartesi',
                            'sunday' => 'Pazar',
                        ];
                        $defaultWorkingHours = Auth::check() && Auth::user()
                            ? (Auth::user()->salon_working_hours ?? [])
                            : [];
                        $workingHours = old('working_hours', $defaultWorkingHours);
                    @endphp

                    <div class="mb-2">
                        <label class="form-label fw-bold">Çalışma Gün ve Saatleri <span class="text-danger">*</span></label>
                        <small class="d-block text-muted mb-2">Salonun açık olduğu günleri seçip saat aralığı girin.</small>
                    </div>
                    <div class="row g-2">
                        @foreach($workingDays as $dayKey => $dayLabel)
                            @php
                                $dayData = $workingHours[$dayKey] ?? [];
                                $isOpen = array_key_exists('is_open', $dayData) ? (bool) $dayData['is_open'] : ($dayKey !== 'sunday');
                                $openTime = $dayData['open_time'] ?? '09:00';
                                $closeTime = $dayData['close_time'] ?? '18:00';
                            @endphp
                            <div class="col-12">
                                <div class="border rounded p-2 d-flex flex-wrap align-items-center gap-2">
                                    <div class="form-check form-switch m-0 me-2">
                                        <input class="form-check-input js-working-day-toggle" type="checkbox" role="switch" id="registration_working_{{ $dayKey }}" name="working_hours[{{ $dayKey }}][is_open]" value="1" {{ $isOpen ? 'checked' : '' }}>
                                        <label class="form-check-label fw-semibold" for="registration_working_{{ $dayKey }}">{{ $dayLabel }}</label>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 ms-md-auto">
                                        <input type="time" class="form-control form-control-sm js-working-day-time" style="max-width: 130px;" name="working_hours[{{ $dayKey }}][open_time]" value="{{ $openTime }}" {{ $isOpen ? '' : 'disabled' }}>
                                        <span>-</span>
                                        <input type="time" class="form-control form-control-sm js-working-day-time" style="max-width: 130px;" name="working_hours[{{ $dayKey }}][close_time]" value="{{ $closeTime }}" {{ $isOpen ? '' : 'disabled' }}>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    @error('working_hours')
                        <div class="text-danger small mt-2">{{ $message }}</div>
                    @enderror
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-check-circle"></i> Kaydet ve Devam Et
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
    // No counter animation - direct display
    // Counters are displayed directly without animation
    
    // Weekly Trend Chart
    const weeklyCtx = document.getElementById('weeklyTrendChart');
    if (weeklyCtx) {
        const weeklyData = @json($last7Days ?? []);
        const labels = weeklyData.map(item => item.date || '');
        const counts = weeklyData.map(item => item.count || 0);
        
        new Chart(weeklyCtx, {
            type: 'line',
                data: {
                labels: labels,
                    datasets: [{
                        label: 'Randevu Sayısı',
                    data: counts,
                    borderColor: '#ec4899',
                    backgroundColor: 'rgba(236, 72, 153, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointRadius: 6,
                    pointHoverRadius: 8,
                    pointBackgroundColor: '#ec4899',
                    pointBorderColor: '#ffffff',
                    pointBorderWidth: 3
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                        display: true,
                        position: 'top',
                        },
                        tooltip: {
                        backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            padding: 12,
                            titleFont: {
                            size: 14,
                            weight: 'bold'
                            },
                            bodyFont: {
                            size: 13
                        }
                        }
                    },
                    scales: {
                    y: {
                        beginAtZero: true,
                            ticks: {
                            stepSize: 1
                            },
                            grid: {
                            color: 'rgba(0, 0, 0, 0.05)'
                        }
                    },
                    x: {
                            grid: {
                            display: false
                            }
                        }
                },
                animation: {
                    duration: 0,
                    animateRotate: false,
                    animateScale: false
                    }
                }
            });
    }
    
    // Status Distribution Chart
    const statusCtx = document.getElementById('statusChart');
    if (statusCtx) {
        const stats = @json($stats ?? []);
        const statusMap = {
            'open': 'Açık',
            'confirmed': 'Onaylandı',
            'completed': 'Tamamlandı',
            'cancelled': 'İptal',
            'pending': 'Beklemede'
        };
        
        const labels = [];
        const data = [];
        const colors = ['#8b5cf6', '#f472b6', '#ec4899', '#ef4444', '#f59e0b'];
        
        if (stats.open_count) {
            labels.push(statusMap.open || 'Açık');
            data.push(stats.open_count);
        }
        if (stats.confirmed_count) {
            labels.push(statusMap.confirmed || 'Onaylandı');
            data.push(stats.confirmed_count);
        }
        if (stats.completed_count) {
            labels.push(statusMap.completed || 'Tamamlandı');
            data.push(stats.completed_count);
        }
        if (stats.cancelled_count) {
            labels.push(statusMap.cancelled || 'İptal');
            data.push(stats.cancelled_count);
        }
        
        if (labels.length > 0) {
            new Chart(statusCtx, {
                type: 'doughnut',
                data: {
                    labels: labels,
                    datasets: [{
                        data: data,
                        backgroundColor: colors.slice(0, labels.length),
                        borderWidth: 3,
                        borderColor: '#ffffff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 15,
                                font: {
                                size: 12
                                }
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            padding: 12
                        }
                    },
                    animation: {
                        animateRotate: false,
                        animateScale: false,
                        duration: 0
                    }
                }
            });
        }
    }
    
    // Revenue Chart
    const revenueCtx = document.getElementById('revenueChart');
    if (revenueCtx) {
        const revenueData = @json($last30DaysRevenue ?? []);
        const labels = revenueData.map(item => item.date || '');
        const revenues = revenueData.map(item => parseFloat(item.revenue || 0));
        
        new Chart(revenueCtx, {
            type: 'bar',
                data: {
                labels: labels,
                    datasets: [{
                        label: 'Gelir (₺)',
                    data: revenues,
                    backgroundColor: 'rgba(236, 72, 153, 0.8)',
                    borderColor: '#ec4899',
                    borderWidth: 2,
                    borderRadius: 6
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                        backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            padding: 12,
                            callbacks: {
                                label: function(context) {
                                return 'Gelir: ' + context.parsed.y.toLocaleString('tr-TR', {minimumFractionDigits: 2, maximumFractionDigits: 2}) + ' ₺';
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                callback: function(value) {
                                    return value.toLocaleString('tr-TR') + ' ₺';
                                }
                            },
                            grid: {
                            color: 'rgba(0, 0, 0, 0.05)'
                        }
                    },
                    x: {
                        grid: {
                            display: false
                            }
                        }
                    },
                    animation: {
                    duration: 0,
                    animateRotate: false,
                    animateScale: false
                    }
                }
            });
    }
    
    // Salon Kayıt Modal - Salon kaydı tamamlanana kadar zorunlu, her sayfa yüklemesinde göster
    @if(($showSetupWizard ?? false) && Auth::check() && Auth::user()->role === 'güzellik_salonu')
    document.addEventListener('DOMContentLoaded', function() {
        const registrationModal = new bootstrap.Modal(document.getElementById('registrationInfoModal'), {
            backdrop: 'static',
            keyboard: false
        });
        registrationModal.show();
    });
    @endif
    
    // İl seçildiğinde ilçeleri yükle (tüm ilçeler yerelde - API bağımlılığı yok)
    const dashboardCitySelect = document.getElementById('salon_city');
    const dashboardDistrictSelect = document.getElementById('salon_district');
    const allDistricts = @json(\App\Helpers\DistrictHelper::getAllDistricts());
    
    if (dashboardCitySelect && dashboardDistrictSelect) {
        function loadDistrictsForCity(selectedCity) {
            if (selectedCity) {
                dashboardDistrictSelect.disabled = false;
                dashboardDistrictSelect.innerHTML = '<option value="">İlçe Seçin</option>';
                const cityDistricts = allDistricts[selectedCity] || [];
                cityDistricts.forEach(district => {
                    const option = document.createElement('option');
                    option.value = district;
                    option.textContent = district;
                    dashboardDistrictSelect.appendChild(option);
                });
                if (cityDistricts.length === 0) {
                    dashboardDistrictSelect.innerHTML = '<option value="">Bu il için ilçe bulunamadı</option>';
                }
            } else {
                dashboardDistrictSelect.disabled = true;
                dashboardDistrictSelect.innerHTML = '<option value="">Önce il seçin</option>';
            }
        }
        dashboardCitySelect.addEventListener('change', function() {
            loadDistrictsForCity(this.value);
        });
        // Sayfa yüklendiğinde mevcut il varsa ilçeleri yükle
        const currentCity = dashboardCitySelect.value;
        const currentDistrict = '{{ addslashes(Auth::user()->salon_district ?? '') }}';
        if (currentCity) {
            loadDistrictsForCity(currentCity);
            if (currentDistrict) {
                dashboardDistrictSelect.value = currentDistrict;
            }
        }
    }

    // Kayıt modalı çalışma saatleri input yönetimi
    document.querySelectorAll('#registrationInfoModal .js-working-day-toggle').forEach((toggle) => {
        const row = toggle.closest('.border');
        if (!row) return;
        const timeInputs = row.querySelectorAll('.js-working-day-time');
        const refreshState = () => {
            timeInputs.forEach((input) => {
                input.disabled = !toggle.checked;
            });
        };
        toggle.addEventListener('change', refreshState);
        refreshState();
    });
    
    // Kayıt bilgisi form submit
    document.getElementById('registrationInfoForm')?.addEventListener('submit', function(e) {
        e.preventDefault();
        const form = this;
        const formData = new FormData(form);
        const submitBtn = form.querySelector('button[type="submit"]');
        
        // Loading state
        if (submitBtn) {
            submitBtn.disabled = true;
            const originalText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<img src="{{ asset('splashlogo.gif') }}" alt="Yükleniyor" style="width: 20px; height: 20px; display: inline-block; margin-right: 8px;">Kaydediliyor...';
            
            fetch(form.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || formData.get('_token'),
                    'Accept': 'application/json'
                }
            })
            .then(response => {
                return response.json().then(data => {
                    if (!response.ok) {
                        // Validation hatalarını göster
                        if (data.errors) {
                            let errorMessages = [];
                            for (let field in data.errors) {
                                errorMessages.push(data.errors[field][0]);
                            }
                            alert(errorMessages.join('\n'));
                        } else {
                            throw new Error(data.message || 'Bir hata oluştu');
                        }
                    }
                    return data;
                });
            })
            .then(data => {
                if (data.success) {
                    const modal = bootstrap.Modal.getInstance(document.getElementById('registrationInfoModal'));
                    if (modal) modal.hide();
                    location.reload();
                } else {
                    alert(data.message || 'Bir hata oluştu');
                    if (submitBtn) {
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = originalText;
                    }
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert(error.message || 'Bir hata oluştu');
                alert(error.message || 'Bir hata oluştu. Lütfen tekrar deneyin.');
                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalText;
                }
            });
        }
    });
    
    
    window.openNewReservationModalFromDashboard = function() {
        return; 
    };
    
    // Dashboard'dan yeni müşteri modal açma fonksiyonu
    window.openNewCustomerModalFromDashboard = function() {
        console.log('openNewCustomerModalFromDashboard called');
        // Önce modal'ın yüklenip yüklenmediğini kontrol et
        if (typeof window.openNewCustomerModal === 'function') {
            window.openNewCustomerModal();
        } else {
            // Modal henüz yüklenmemişse, biraz bekle ve tekrar dene
            let attempts = 0;
            const maxAttempts = 10;
            const checkInterval = setInterval(function() {
                attempts++;
                if (typeof window.openNewCustomerModal === 'function') {
                    clearInterval(checkInterval);
                    window.openNewCustomerModal();
                } else if (attempts >= maxAttempts) {
                    clearInterval(checkInterval);
                    // Fallback: Müşteriler sayfasına yönlendir
                    window.location.href = '{{ route('admin.customers.create') }}';
                }
            }, 100);
        }
    };
    
</script>
@endpush
