@extends('layouts.admin')

@section('title', 'Sık Sorulan Sorular')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item active">Yardım - SSS</li>
@endsection

@section('content')
<style>
    /* Mobil görünümde header padding düzeltmesi */
    @media (max-width: 1024px) {
        body {
            padding-top: 108px !important;
        }
        
        .main-content {
            padding-top: 20px !important;
        }
        
        .help-hero {
            padding: 30px 20px !important;
        }
        
        .help-hero h1 {
            font-size: 28px !important;
        }
        
        .help-hero p {
            font-size: 16px !important;
        }
        
        .quick-links {
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)) !important;
            gap: 15px !important;
        }
        
        .help-card {
            padding: 20px !important;
        }
        
        .faq-category-title {
            font-size: 20px !important;
        }
        
        .accordion-button {
            padding: 16px 20px !important;
            font-size: 15px !important;
        }
    }
    
    .help-hero {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border-radius: 24px;
        padding: 50px 40px;
        color: white;
        margin-bottom: 35px;
        box-shadow: 0 12px 40px rgba(236, 72, 153, 0.35);
        position: relative;
        overflow: hidden;
    }
    
    .help-hero::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        animation: pulse 8s ease-in-out infinite;
    }
    
    @keyframes pulse {
        0%, 100% { transform: scale(1); opacity: 0.5; }
        50% { transform: scale(1.1); opacity: 0.8; }
    }
    
    .help-hero h1 {
        font-size: 42px;
        font-weight: 800;
        margin-bottom: 12px;
        position: relative;
        z-index: 1;
        text-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    
    .help-hero p {
        font-size: 20px;
        opacity: 0.95;
        margin: 0;
        position: relative;
        z-index: 1;
        font-weight: 400;
    }
    
    .faq-category {
        margin-bottom: 35px;
    }
    
    .faq-category-title {
        font-size: 26px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 24px;
        display: flex;
        align-items: center;
        gap: 14px;
        padding-bottom: 14px;
        border-bottom: 3px solid #e2e8f0;
        position: relative;
    }
    
    .faq-category-title::after {
        content: '';
        position: absolute;
        bottom: -3px;
        left: 0;
        width: 60px;
        height: 3px;
        background: linear-gradient(90deg, #ec4899 0%, #be185d 100%);
        border-radius: 3px;
    }
    
    .faq-category-title i {
        font-size: 32px;
        color: #ec4899;
        background: linear-gradient(135deg, #fce7f3 0%, #fdf2f8 100%);
        padding: 10px;
        border-radius: 12px;
    }
    
    .accordion-item {
        border: none;
        margin-bottom: 16px;
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 3px 12px rgba(0,0,0,0.08);
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        background: white;
    }
    
    .accordion-item:hover {
        box-shadow: 0 6px 24px rgba(0,0,0,0.12);
        transform: translateY(-3px);
    }
    
    .accordion-button {
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border: none;
        padding: 22px 28px;
        font-weight: 600;
        font-size: 17px;
        color: #0f172a;
        box-shadow: none;
        position: relative;
        transition: all 0.3s ease;
    }
    
    .accordion-button::after {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23ec4899'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");
        width: 1.25rem;
        height: 1.25rem;
        transition: transform 0.3s ease;
    }
    
    .accordion-button:not(.collapsed) {
        background: linear-gradient(135deg, #fce7f3 0%, #fdf2f8 100%);
        color: #ec4899;
        box-shadow: none;
        border-bottom: 1px solid #fbcfe8;
    }
    
    .accordion-button:not(.collapsed)::after {
        transform: rotate(180deg);
    }
    
    .accordion-button:focus {
        box-shadow: 0 0 0 4px rgba(236, 72, 153, 0.15);
        border-color: transparent;
    }
    
    .accordion-body {
        padding: 28px;
        background: white;
        color: #475569;
        line-height: 1.85;
        font-size: 15.5px;
    }
    
    .accordion-body strong {
        color: #0f172a;
        font-weight: 600;
    }
    
    .accordion-body ul, .accordion-body ol {
        margin: 16px 0;
        padding-left: 28px;
    }
    
    .accordion-body li {
        margin-bottom: 10px;
    }
    
    .accordion-body p {
        margin-bottom: 12px;
    }
    
    .help-card {
        background: white;
        border-radius: 20px;
        padding: 35px;
        box-shadow: 0 4px 24px rgba(0,0,0,0.08);
        margin-bottom: 35px;
        border: 1px solid #f1f5f9;
        transition: all 0.3s ease;
    }
    
    .help-card:hover {
        box-shadow: 0 8px 32px rgba(0,0,0,0.12);
    }
    
    .quick-links {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
        gap: 24px;
        margin-top: 35px;
        margin-bottom: 40px;
    }
    
    .quick-link-card {
        background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
        border: 2px solid #e2e8f0;
        border-radius: 16px;
        padding: 28px;
        text-align: center;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        cursor: pointer;
        text-decoration: none;
        color: inherit;
        position: relative;
        overflow: hidden;
    }
    
    .quick-link-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(236, 72, 153, 0.1), transparent);
        transition: left 0.5s ease;
    }
    
    .quick-link-card:hover::before {
        left: 100%;
    }
    
    .quick-link-card:hover {
        transform: translateY(-6px);
        border-color: #ec4899;
        box-shadow: 0 12px 32px rgba(236, 72, 153, 0.2);
        text-decoration: none;
        color: inherit;
        background: linear-gradient(135deg, #ffffff 0%, #fdf2f8 100%);
    }
    
    .quick-link-card i {
        font-size: 42px;
        color: #ec4899;
        margin-bottom: 16px;
        display: block;
        transition: transform 0.3s ease;
    }
    
    .quick-link-card:hover i {
        transform: scale(1.1);
    }
    
    .quick-link-card h5 {
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 10px;
        font-size: 18px;
    }
    
    .quick-link-card p {
        color: #64748b;
        font-size: 14.5px;
        margin: 0;
        line-height: 1.6;
    }
    
    .search-box {
        position: relative;
        margin-bottom: 35px;
    }
    
    .search-box input {
        padding: 18px 24px 18px 56px;
        border-radius: 16px;
        border: 2px solid #e2e8f0;
        font-size: 16px;
        width: 100%;
        transition: all 0.3s ease;
        background: white;
        box-shadow: 0 2px 8px rgba(0,0,0,0.04);
    }
    
    .search-box input:focus {
        border-color: #ec4899;
        box-shadow: 0 0 0 4px rgba(236, 72, 153, 0.12), 0 4px 16px rgba(0,0,0,0.08);
        outline: none;
    }
    
    .search-box i {
        position: absolute;
        left: 22px;
        top: 50%;
        transform: translateY(-50%);
        color: #64748b;
        font-size: 22px;
        transition: color 0.3s ease;
    }
    
    .search-box input:focus + i,
    .search-box:has(input:focus) i {
        color: #ec4899;
    }
    
    .accordion-button i {
        margin-right: 10px;
        font-size: 18px;
    }
    
    /* No results message */
    #noResultsMessage {
        margin-top: 30px;
        border-radius: 12px;
        padding: 20px;
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border: 2px solid #e2e8f0;
    }
</style>

<div class="container-fluid">
    <!-- Hero Section -->
    <div class="help-hero">
        <h1><i class="bi bi-question-circle me-3"></i>Yardım Merkezi</h1>
        <p>Sık sorulan sorular ve kullanım kılavuzu</p>
    </div>
    
    <!-- Arama Kutusu -->
    <div class="search-box">
        <i class="bi bi-search"></i>
        <input type="text" id="faqSearch" placeholder="Sorunuzu arayın..." autocomplete="off">
    </div>
    
    <!-- Hızlı Erişim -->
    <div class="quick-links">
        <a href="#randevular" class="quick-link-card">
            <i class="bi bi-calendar-check"></i>
            <h5>Randevular</h5>
            <p>Randevu oluşturma ve yönetimi</p>
        </a>
        <a href="#musteriler" class="quick-link-card">
            <i class="bi bi-people"></i>
            <h5>Müşteriler</h5>
            <p>Müşteri ekleme ve düzenleme</p>
        </a>
        <a href="#muhasebe" class="quick-link-card">
            <i class="bi bi-cash-stack"></i>
            <h5>Muhasebe</h5>
            <p>Gelir-gider ve kasa işlemleri</p>
        </a>
        <a href="#personel" class="quick-link-card">
            <i class="bi bi-people-fill"></i>
            <h5>Personel</h5>
            <p>Personel yönetimi ve yetkilendirme</p>
        </a>
        <a href="#hizmetler" class="quick-link-card">
            <i class="bi bi-scissors"></i>
            <h5>Hizmetler</h5>
            <p>Hizmet ve oda yönetimi</p>
        </a>
        <a href="#takvim" class="quick-link-card">
            <i class="bi bi-calendar3"></i>
            <h5>Takvim</h5>
            <p>Takvim görünümleri ve kullanımı</p>
        </a>
        <a href="#sms" class="quick-link-card">
            <i class="bi bi-chat-dots"></i>
            <h5>SMS</h5>
            <p>SMS gönderimi ve ayarları</p>
        </a>
        <a href="{{ route('admin.help.support') }}" class="quick-link-card">
            <i class="bi bi-headset"></i>
            <h5>Destek Talebi</h5>
            <p>Yardıma mı ihtiyacınız var?</p>
        </a>
    </div>
    
    <!-- Randevular -->
    <div class="help-card" id="randevular">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-calendar-check"></i>
                <span>Randevu İşlemleri</span>
            </div>
            
            <div class="accordion" id="faqAppointments">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                            <i class="bi bi-plus-circle"></i> Randevu nasıl oluşturulur?
                        </button>
                    </h2>
                    <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAppointments">
                        <div class="accordion-body">
                            <strong>Randevu oluşturmanın birkaç yolu vardır:</strong>
                            <ul>
                                <li><strong>Takvimden:</strong> Randevu Takvimi sayfasından istediğiniz tarihe tıklayarak yeni randevu oluşturabilirsiniz.</li>
                                <li><strong>Randevu Listesi:</strong> Randevu İşlemleri menüsünden "Tüm Randevular" sayfasına gidin ve "Yeni Randevu" butonuna tıklayın.</li>
                                <li><strong>Hızlı Erişim:</strong> Takvim sayfasının altındaki "Yeni Randevu" butonunu kullanabilirsiniz.</li>
                            </ul>
                            <p class="mt-3"><strong>Randevu oluştururken:</strong></p>
                            <ul>
                                <li>Müşteri seçimi yapın (yoksa yeni müşteri ekleyebilirsiniz)</li>
                                <li>Salon seçin</li>
                                <li>Tarih ve saat aralığını belirleyin</li>
                                <li>Yemekler, ekstralar ve organizasyon ücretlerini ekleyin</li>
                                <li>Randevu ücreti ve kapora bilgilerini girin</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                            <i class="bi bi-x-circle"></i> Randevu nasıl iptal edilir?
                        </button>
                    </h2>
                    <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAppointments">
                        <div class="accordion-body">
                            Randevu iptal etmek için:
                            <ol>
                                <li>Randevu detay sayfasına gidin</li>
                                <li>Durum alanından "İptal" seçeneğini seçin</li>
                                <li>Değişiklikleri kaydedin</li>
                            </ol>
                            <p class="mt-3"><strong>Not:</strong> İptal edilen randevular takvimde görünmez ve istatistiklerde "İptal" kategorisinde gösterilir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                            <i class="bi bi-check-circle"></i> Randevu nasıl onaylanır?
                        </button>
                    </h2>
                    <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAppointments">
                        <div class="accordion-body">
                            Randevu onaylamak için:
                            <ol>
                                <li>Randevu detay sayfasına gidin</li>
                                <li>Durum alanından "Onaylandı" seçeneğini seçin</li>
                                <li>Değişiklikleri kaydedin</li>
                            </ol>
                            <p class="mt-3">Onaylanan randevular takvimde yeşil renkte görünür ve istatistiklerde "Onaylanan" kategorisinde gösterilir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4">
                            <i class="bi bi-receipt"></i> Fatura nasıl oluşturulur?
                        </button>
                    </h2>
                    <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqAppointments">
                        <div class="accordion-body">
                            Yeni randevu oluştururken "Onayla ve Faturalandır" butonuna tıkladığınızda:
                            <ul>
                                <li>Fatura önizlemesi gösterilir</li>
                                <li>Fatura PDF olarak oluşturulur ve storage'a kaydedilir</li>
                                <li>Her salon için özel sözleşme PDF'i oluşturulur</li>
                                <li>WhatsApp/SMS gönderimi için mesaj hazırlanır</li>
                            </ul>
                            <p class="mt-3">Faturalar "Faturalar" menüsünden görüntülenebilir ve PDF olarak indirilebilir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq5">
                            <i class="bi bi-clock"></i> Takvimde saat seçimi nasıl yapılır?
                        </button>
                    </h2>
                    <div id="faq5" class="accordion-collapse collapse" data-bs-parent="#faqAppointments">
                        <div class="accordion-body">
                            Randevu oluştururken:
                            <ul>
                                <li><strong>Başlangıç Saati:</strong> Randevunun başlayacağı saati seçin</li>
                                <li><strong>Bitiş Saati:</strong> Randevunun biteceği saati seçin</li>
                            </ul>
                            <p class="mt-3"><strong>Önemli:</strong> Sistem, seçtiğiniz tarih ve saatte daha önce randevu olup olmadığını kontrol eder. Dolu saatler seçilemez.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Müşteriler -->
    <div class="help-card" id="musteriler">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-people"></i>
                <span>Müşteri Yönetimi</span>
            </div>
            
            <div class="accordion" id="faqCustomers">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq6">
                            <i class="bi bi-person-plus"></i> Yeni müşteri nasıl eklenir?
                        </button>
                    </h2>
                    <div id="faq6" class="accordion-collapse collapse" data-bs-parent="#faqCustomers">
                        <div class="accordion-body">
                            Yeni müşteri eklemenin yolları:
                            <ul>
                                <li><strong>Müşteriler Sayfası:</strong> Müşteriler menüsünden "Yeni Müşteri" butonuna tıklayın</li>
                                <li><strong>Randevu Oluştururken:</strong> Yeni randevu modalında "Yeni Müşteri Ekle" butonunu kullanın</li>
                            </ul>
                            <p class="mt-3"><strong>Müşteri bilgileri:</strong></p>
                            <ul>
                                <li>İsim (zorunlu)</li>
                                <li>Telefon (opsiyonel)</li>
                                <li>E-posta (opsiyonel)</li>
                                <li>Adres (opsiyonel)</li>
                                <li>Notlar (opsiyonel)</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq7">
                            <i class="bi bi-search"></i> Müşteri nasıl aranır?
                        </button>
                    </h2>
                    <div id="faq7" class="accordion-collapse collapse" data-bs-parent="#faqCustomers">
                        <div class="accordion-body">
                            Müşteri arama yöntemleri:
                            <ul>
                                <li><strong>Randevu Oluştururken:</strong> Müşteri seçim alanına isim veya telefon numarası yazarak arama yapabilirsiniz</li>
                                <li><strong>Müşteriler Sayfası:</strong> Sayfanın üst kısmındaki arama kutusunu kullanabilirsiniz</li>
                                <li><strong>Header Arama:</strong> Üst menüdeki global arama kutusunu kullanabilirsiniz</li>
                            </ul>
                            <p class="mt-3">Arama, müşteri ismi ve telefon numarasına göre yapılır.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq8">
                            <i class="bi bi-wallet2"></i> Müşteri bakiyesi nedir?
                        </button>
                    </h2>
                    <div id="faq8" class="accordion-collapse collapse" data-bs-parent="#faqCustomers">
                        <div class="accordion-body">
                            Müşteri bakiyesi, müşterinin size olan borç/alacak durumunu gösterir:
                            <ul>
                                <li><strong>Pozitif Bakiye:</strong> Müşteri size borçludur</li>
                                <li><strong>Negatif Bakiye:</strong> Müşteriye borçlusunuz</li>
                                <li><strong>Sıfır Bakiye:</strong> Hesap kapalı</li>
                            </ul>
                            <p class="mt-3"><strong>Bakiye nasıl değişir?</strong></p>
                            <ul>
                                <li><strong>Gelir Eklendiğinde:</strong> Müşteri bakiyesinden borç düşer (negatif olabilir)</li>
                                <li><strong>Gider Eklendiğinde:</strong> Müşteri bakiyesine borç eklenir</li>
                                <li><strong>Randevu Oluşturulduğunda:</strong> Randevu ücreti bakiyeye eklenir</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Muhasebe -->
    <div class="help-card" id="muhasebe">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-cash-stack"></i>
                <span>Muhasebe ve Kasa İşlemleri</span>
            </div>
            
            <div class="accordion" id="faqAccounting">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq9">
                            <i class="bi bi-plus-circle"></i> Gelir nasıl eklenir?
                        </button>
                    </h2>
                    <div id="faq9" class="accordion-collapse collapse" data-bs-parent="#faqAccounting">
                        <div class="accordion-body">
                            Gelir eklemek için:
                            <ol>
                                <li>Muhasebe menüsünden "Kasa" sayfasına gidin</li>
                                <li>"Gelir Ekle" butonuna tıklayın</li>
                                <li>Formu doldurun:
                                    <ul>
                                        <li>Tutar (zorunlu)</li>
                                        <li>Tarih (zorunlu)</li>
                                        <li>Müşteri (opsiyonel)</li>
                                        <li>Randevu (opsiyonel)</li>
                                        <li>Açıklama (opsiyonel)</li>
                                    </ul>
                                </li>
                                <li>"Kaydet" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Önemli:</strong> Gelir eklendiğinde müşteri bakiyesinden borç düşer. Eğer fazla gelir eklenirse müşteri bakiyesi negatife düşer (müşteriye borçlu olursunuz).</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq10">
                            <i class="bi bi-dash-circle"></i> Gider nasıl eklenir?
                        </button>
                    </h2>
                    <div id="faq10" class="accordion-collapse collapse" data-bs-parent="#faqAccounting">
                        <div class="accordion-body">
                            Gider eklemek için:
                            <ol>
                                <li>Muhasebe menüsünden "Kasa" sayfasına gidin</li>
                                <li>"Gider Ekle" butonuna tıklayın</li>
                                <li>Formu doldurun (gelir ekleme ile aynı alanlar)</li>
                                <li>"Kaydet" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Önemli:</strong> Gider eklendiğinde müşteri seçildiyse, müşteri bakiyesine borç olarak eklenir. Bu, müşteriye ekstra bir şey eklediğinizde kullanılır.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq11">
                            <i class="bi bi-pencil"></i> İşlem nasıl düzenlenir?
                        </button>
                    </h2>
                    <div id="faq11" class="accordion-collapse collapse" data-bs-parent="#faqAccounting">
                        <div class="accordion-body">
                            İşlem düzenlemek için:
                            <ol>
                                <li>Kasa sayfasındaki işlem listesinde düzenlemek istediğiniz işlemin yanındaki "Düzenle" butonuna tıklayın</li>
                                <li>Açılan modal'da:
                                    <ul>
                                        <li>Tutarı değiştirebilirsiniz</li>
                                        <li>Tarihi değiştirebilirsiniz</li>
                                        <li>Müşteriyi değiştirebilirsiniz</li>
                                        <li>Açıklamayı değiştirebilirsiniz</li>
                                    </ul>
                                </li>
                                <li>"Güncelle" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Not:</strong> İşlem düzenlendiğinde bakiyeler otomatik olarak güncellenir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq12">
                            <i class="bi bi-trash"></i> İşlem nasıl silinir?
                        </button>
                    </h2>
                    <div id="faq12" class="accordion-collapse collapse" data-bs-parent="#faqAccounting">
                        <div class="accordion-body">
                            İşlem silmek için:
                            <ol>
                                <li>Kasa sayfasındaki işlem listesinde silmek istediğiniz işlemin yanındaki "Sil" butonuna tıklayın</li>
                                <li>Onay mesajını kabul edin</li>
                            </ol>
                            <p class="mt-3"><strong>Önemli:</strong> İşlem silindiğinde bakiyeler otomatik olarak geri alınır. Bu işlem geri alınamaz, dikkatli olun.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Genel Sorular -->
    <div class="help-card">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-info-circle"></i>
                <span>Genel Sorular</span>
            </div>
            
            <div class="accordion" id="faqGeneral">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq13">
                            <i class="bi bi-shield-check"></i> Verilerim güvende mi?
                        </button>
                    </h2>
                    <div id="faq13" class="accordion-collapse collapse" data-bs-parent="#faqGeneral">
                        <div class="accordion-body">
                            <p>Evet, tüm verileriniz güvendedir. Sistem şu güvenlik önlemlerini kullanır:</p>
                            <ul>
                                <li>Kullanıcı bazlı veri izolasyonu (randevucu ve admin rolleri sadece kendi verilerini görür)</li>
                                <li>Güvenli veritabanı bağlantıları</li>
                                <li>Düzenli yedekleme</li>
                                <li>Şifreli veri saklama</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq14">
                            <i class="bi bi-phone"></i> Destek nasıl alabilirim?
                        </button>
                    </h2>
                    <div id="faq14" class="accordion-collapse collapse" data-bs-parent="#faqGeneral">
                        <div class="accordion-body">
                            Destek almak için:
                            <ul>
                                <li><strong>Yardım Menüsü:</strong> "Yardım > Destek Talebi" sayfasından destek talebi oluşturabilirsiniz</li>
                                <li><strong>E-posta:</strong> Destek ekibimize e-posta gönderebilirsiniz</li>
                                <li><strong>Telefon:</strong> Müşteri hizmetleri hattımızı arayabilirsiniz</li>
                            </ul>
                            <p class="mt-3">Destek talebiniz en kısa sürede yanıtlanacaktır.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq15">
                            <i class="bi bi-box-seam"></i> Paket ve ödeme işlemleri nasıl yapılır?
                        </button>
                    </h2>
                    <div id="faq15" class="accordion-collapse collapse" data-bs-parent="#faqGeneral">
                        <div class="accordion-body">
                            <p><strong>Ücretsiz Deneme:</strong> Yeni kayıt olan her kullanıcı 14 gün ücretsiz deneme hakkına sahiptir. Bu süre içinde tüm özellikleri kullanabilirsiniz. Kupon kodunuz varsa paket seçim ekranından kodu girerek ek süre veya SMS hakkı kazanabilirsiniz.</p>
                            <p class="mt-3"><strong>Paket Seçimi:</strong> Deneme süresi bitmeden veya bittikten sonra paket seçim ekranından uygun paketi seçebilirsiniz:</p>
                            <ul>
                                <li><strong>Aylık Paket:</strong> 1 aylık abonelik (500 TL)</li>
                                <li><strong>3 Aylık Paket:</strong> 3 aylık abonelik (1.500 TL) - Popüler seçim</li>
                                <li><strong>Yıllık Paket:</strong> 12 aylık abonelik (5.000 TL) - En iyi değer, 2 ay ücretsiz</li>
                            </ul>
                            <p class="mt-3"><strong>Ödeme Yöntemleri:</strong></p>
                            <ul>
                                <li>Kredi/Banka kartı ile PayTR üzerinden ödeme</li>
                                <li>Havale/EFT ile manuel ödeme</li>
                            </ul>
                            <p class="mt-3"><strong>Önemli:</strong> Paket satın alınmadığı sürece sistemde işlem yapamazsınız. Paket seçim ekranı otomatik olarak açılacaktır.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Personel Yönetimi -->
    <div class="help-card" id="personel">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-people-fill"></i>
                <span>Personel Yönetimi</span>
            </div>
            
            <div class="accordion" id="faqStaff">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq16">
                            <i class="bi bi-person-plus"></i> Personel nasıl eklenir?
                        </button>
                    </h2>
                    <div id="faq16" class="accordion-collapse collapse" data-bs-parent="#faqStaff">
                        <div class="accordion-body">
                            Personel eklemek için:
                            <ol>
                                <li>Ayarlar menüsünden "Personeller" sayfasına gidin</li>
                                <li>"Yeni Personel Ekle" butonuna tıklayın</li>
                                <li>Formu doldurun:
                                    <ul>
                                        <li>İsim (zorunlu)</li>
                                        <li>E-posta (zorunlu, benzersiz olmalı)</li>
                                        <li>Telefon (opsiyonel)</li>
                                        <li>Şifre (zorunlu)</li>
                                        <li>Salon Admini (opsiyonel - işaretlenirse personel admin yetkisine sahip olur)</li>
                                    </ul>
                                </li>
                                <li>"Kaydet" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Not:</strong> Personel eklendikten sonra kendi şifresi ile giriş yapabilir ve sadece kendi randevularını görebilir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq17">
                            <i class="bi bi-shield-check"></i> Salon Admini nedir?
                        </button>
                    </h2>
                    <div id="faq17" class="accordion-collapse collapse" data-bs-parent="#faqStaff">
                        <div class="accordion-body">
                            <p>Salon Admini, normal personelden daha fazla yetkiye sahip bir personeldir. Salon Admini:</p>
                            <ul>
                                <li>Tüm randevuları görebilir (sadece kendi randevularını değil)</li>
                                <li>Randevu oluşturabilir, düzenleyebilir ve silebilir</li>
                                <li>Müşteri ekleyebilir ve düzenleyebilir</li>
                                <li>Kasa işlemleri yapabilir</li>
                                <li>Raporları görüntüleyebilir</li>
                            </ul>
                            <p class="mt-3"><strong>Normal Personel:</strong> Sadece kendi randevularını görebilir ve düzenleyebilir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq18">
                            <i class="bi bi-pencil"></i> Personel bilgileri nasıl düzenlenir?
                        </button>
                    </h2>
                    <div id="faq18" class="accordion-collapse collapse" data-bs-parent="#faqStaff">
                        <div class="accordion-body">
                            Personel bilgilerini düzenlemek için:
                            <ol>
                                <li>Personeller sayfasından düzenlemek istediğiniz personelin yanındaki "Düzenle" butonuna tıklayın</li>
                                <li>Açılan formda bilgileri güncelleyin</li>
                                <li>"Güncelle" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Not:</strong> E-posta adresi değiştirilemez. E-posta değiştirmek için personeli silip yeniden eklemeniz gerekir.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Hizmet ve Oda Yönetimi -->
    <div class="help-card" id="hizmetler">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-scissors"></i>
                <span>Hizmet ve Oda Yönetimi</span>
            </div>
            
            <div class="accordion" id="faqServices">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq19">
                            <i class="bi bi-plus-circle"></i> Hizmet nasıl eklenir?
                        </button>
                    </h2>
                    <div id="faq19" class="accordion-collapse collapse" data-bs-parent="#faqServices">
                        <div class="accordion-body">
                            Hizmet eklemek için:
                            <ol>
                                <li>Header menüsünden "Hizmetler" sayfasına gidin</li>
                                <li>"Yeni Hizmet Ekle" butonuna tıklayın</li>
                                <li>Formu doldurun:
                                    <ul>
                                        <li>Hizmet Adı (zorunlu)</li>
                                        <li>Açıklama (opsiyonel)</li>
                                        <li>Fiyat (zorunlu)</li>
                                        <li>Süre (dakika cinsinden, zorunlu)</li>
                                        <li>Kategori (opsiyonel)</li>
                                        <li>Personel Ataması (opsiyonel - hangi personeller bu hizmeti verebilir)</li>
                                    </ul>
                                </li>
                                <li>"Kaydet" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Not:</strong> Hizmet eklendikten sonra randevu oluştururken bu hizmeti seçebilirsiniz.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq20">
                            <i class="bi bi-door-open"></i> Oda nasıl eklenir?
                        </button>
                    </h2>
                    <div id="faq20" class="accordion-collapse collapse" data-bs-parent="#faqServices">
                        <div class="accordion-body">
                            Oda eklemek için:
                            <ol>
                                <li>Header menüsünden "Odalar" sayfasına gidin</li>
                                <li>"Yeni Oda Ekle" butonuna tıklayın</li>
                                <li>Formu doldurun:
                                    <ul>
                                        <li>Oda Adı (zorunlu)</li>
                                        <li>Açıklama (opsiyonel)</li>
                                        <li>Kapasite (opsiyonel - kaç kişi alabilir)</li>
                                        <li>Renk (opsiyonel - takvimde görünecek renk)</li>
                                    </ul>
                                </li>
                                <li>"Kaydet" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Not:</strong> Odalar randevu oluştururken seçilebilir ve takvimde farklı renklerle gösterilir.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Takvim ve Görünümler -->
    <div class="help-card" id="takvim">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-calendar3"></i>
                <span>Takvim ve Görünümler</span>
            </div>
            
            <div class="accordion" id="faqCalendar">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq21">
                            <i class="bi bi-calendar-day"></i> Takvim görünümleri nasıl değiştirilir?
                        </button>
                    </h2>
                    <div id="faq21" class="accordion-collapse collapse" data-bs-parent="#faqCalendar">
                        <div class="accordion-body">
                            <p>Takvim sayfasında üst kısımdaki görünüm butonlarını kullanarak görünümü değiştirebilirsiniz:</p>
                            <ul>
                                <li><strong>Günlük Görünüm:</strong> Sadece seçilen günün randevularını gösterir</li>
                                <li><strong>Haftalık Görünüm:</strong> Seçilen haftanın tüm günlerini gösterir</li>
                                <li><strong>Aylık Görünüm:</strong> Seçilen ayın tüm günlerini gösterir</li>
                            </ul>
                            <p class="mt-3"><strong>Navigasyon:</strong> Takvim üzerindeki ok butonları ile tarihler arasında geçiş yapabilirsiniz. "Bugün" butonuna tıklayarak bugünün tarihine dönebilirsiniz.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq22">
                            <i class="bi bi-people"></i> Personel takvimleri nasıl görüntülenir?
                        </button>
                    </h2>
                    <div id="faq22" class="accordion-collapse collapse" data-bs-parent="#faqCalendar">
                        <div class="accordion-body">
                            <p>Takvim sayfasında her personel için ayrı bir takvim kartı gösterilir. Bu sayede:</p>
                            <ul>
                                <li>Her personelin randevularını ayrı ayrı görebilirsiniz</li>
                                <li>Personel bazında müsaitlik kontrolü yapabilirsiniz</li>
                                <li>Personel sayısına göre takvim genişliği otomatik ayarlanır (1 personel = %100, 2 personel = %50 her biri)</li>
                            </ul>
                            <p class="mt-3"><strong>Mobil Görünüm:</strong> Mobil cihazlarda takvimler yatay kaydırma ile görüntülenir.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- SMS ve Bildirimler -->
    <div class="help-card" id="sms">
        <div class="faq-category">
            <div class="faq-category-title">
                <i class="bi bi-chat-dots"></i>
                <span>SMS ve Bildirimler</span>
            </div>
            
            <div class="accordion" id="faqSms">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq23">
                            <i class="bi bi-send"></i> SMS nasıl gönderilir?
                        </button>
                    </h2>
                    <div id="faq23" class="accordion-collapse collapse" data-bs-parent="#faqSms">
                        <div class="accordion-body">
                            <p><strong>Otomatik SMS:</strong> Randevu oluşturulduğunda, onaylandığında veya iptal edildiğinde otomatik olarak SMS gönderilir (SMS ayarlarından aktif edilmişse).</p>
                            <p class="mt-3"><strong>Manuel SMS:</strong></p>
                            <ol>
                                <li>Randevu detay sayfasından "SMS Gönder" butonuna tıklayın</li>
                                <li>Mesaj içeriğini düzenleyin (isteğe bağlı)</li>
                                <li>"Gönder" butonuna tıklayın</li>
                            </ol>
                            <p class="mt-3"><strong>Önemli:</strong> SMS gönderebilmek için SMS paketi satın almanız ve SMS Ayarları sayfasından API bilgilerinizi girmeniz gerekir.</p>
                        </div>
                    </div>
                </div>
                
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq24">
                            <i class="bi bi-gear"></i> SMS ayarları nasıl yapılır?
                        </button>
                    </h2>
                    <div id="faq24" class="accordion-collapse collapse" data-bs-parent="#faqSms">
                        <div class="accordion-body">
                            SMS ayarlarını yapmak için:
                            <ol>
                                <li>Ayarlar menüsünden "SMS Ayarları" sayfasına gidin</li>
                                <li>SMS sağlayıcınızın API bilgilerini girin:
                                    <ul>
                                        <li>API URL</li>
                                        <li>API Kullanıcı Adı</li>
                                        <li>API Şifresi</li>
                                        <li>Gönderen Numarası</li>
                                    </ul>
                                </li>
                                <li>Otomatik SMS gönderimini aktif/pasif edin</li>
                                <li>Ayarları kaydedin</li>
                            </ol>
                            <p class="mt-3"><strong>Not:</strong> SMS paketi satın almak için "SMS Paketleri" sayfasından paket seçebilirsiniz.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Arama fonksiyonu
    const searchInput = document.getElementById('faqSearch');
    
    if (searchInput) {
        searchInput.addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase().trim();
            const accordionItems = document.querySelectorAll('.accordion-item');
            const helpCards = document.querySelectorAll('.help-card');
            
            if (searchTerm === '') {
                // Arama boşsa tüm öğeleri göster
                accordionItems.forEach(item => {
                    item.style.display = '';
                });
                helpCards.forEach(card => {
                    card.style.display = '';
                });
                const noResultsMessage = document.getElementById('noResultsMessage');
                if (noResultsMessage) {
                    noResultsMessage.remove();
                }
                return;
            }
            
            let hasResults = false;
            
            accordionItems.forEach(item => {
                const question = item.querySelector('.accordion-button')?.textContent.toLowerCase() || '';
                const answer = item.querySelector('.accordion-body')?.textContent.toLowerCase() || '';
                
                if (question.includes(searchTerm) || answer.includes(searchTerm)) {
                    item.style.display = '';
                    hasResults = true;
                } else {
                    item.style.display = 'none';
                }
            });
            
            // Eğer kategori içinde sonuç varsa kategoriyi göster, yoksa gizle
            helpCards.forEach(card => {
                const visibleItems = card.querySelectorAll('.accordion-item[style=""]');
                const allItems = card.querySelectorAll('.accordion-item');
                
                if (visibleItems.length > 0 || searchTerm === '') {
                    card.style.display = '';
                } else {
                    card.style.display = 'none';
                }
            });
            
            // Sonuç yoksa mesaj göster
            let noResultsMessage = document.getElementById('noResultsMessage');
            if (!hasResults && searchTerm !== '') {
                if (!noResultsMessage) {
                    noResultsMessage = document.createElement('div');
                    noResultsMessage.id = 'noResultsMessage';
                    noResultsMessage.className = 'alert alert-info';
                    noResultsMessage.innerHTML = '<i class="bi bi-info-circle me-2"></i>Aradığınız kriterlere uygun sonuç bulunamadı.';
                    const container = document.querySelector('.container-fluid');
                    if (container) {
                        const helpCards = container.querySelectorAll('.help-card');
                        if (helpCards.length > 0) {
                            container.insertBefore(noResultsMessage, helpCards[0]);
                        } else {
                            container.appendChild(noResultsMessage);
                        }
                    }
                }
            } else {
                if (noResultsMessage) {
                    noResultsMessage.remove();
                }
            }
        });
        
        // Enter tuşu ile arama
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });
    }
    
    // Smooth scroll for quick links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});
</script>
@endpush
@endsection
