@extends('layouts.admin')

@section('title', 'Destek Talebi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Anasayfa</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.help.faq') }}">Yardım</a></li>
    <li class="breadcrumb-item active">Destek Talebi</li>
@endsection

@section('content')
<style>
    /* Mobil görünüm */
    @media (max-width: 768px) {
        .support-hero {
            padding: 30px 20px !important;
        }
        
        .support-hero h1 {
            font-size: 28px !important;
        }
        
        .support-hero p {
            font-size: 16px !important;
        }
        
        .support-card {
            padding: 25px 20px !important;
        }
        
        .contact-cards {
            grid-template-columns: 1fr !important;
            gap: 15px !important;
        }
        
        .info-box {
            margin-top: 20px !important;
        }
    }
    
    .support-hero {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border-radius: 24px;
        padding: 50px 40px;
        color: white;
        margin-bottom: 35px;
        box-shadow: 0 12px 40px rgba(236, 72, 153, 0.35);
        position: relative;
        overflow: hidden;
    }
    
    .support-hero::before {
        content: '';
        position: absolute;
        top: -50%;
        right: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        animation: pulse 8s ease-in-out infinite;
    }
    
    @keyframes pulse {
        0%, 100% { transform: scale(1); opacity: 0.5; }
        50% { transform: scale(1.1); opacity: 0.8; }
    }
    
    .support-hero h1 {
        font-size: 42px;
        font-weight: 800;
        margin-bottom: 12px;
        position: relative;
        z-index: 1;
        text-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    
    .support-hero p {
        font-size: 20px;
        opacity: 0.95;
        margin: 0;
        position: relative;
        z-index: 1;
        font-weight: 400;
    }
    
    .support-card {
        background: white;
        border-radius: 20px;
        padding: 45px;
        box-shadow: 0 4px 24px rgba(0,0,0,0.08);
        margin-bottom: 30px;
        border: 1px solid #f1f5f9;
        transition: all 0.3s ease;
    }
    
    .support-card:hover {
        box-shadow: 0 8px 32px rgba(0,0,0,0.12);
    }
    
    .support-card h3 {
        color: #0f172a;
        font-weight: 700;
        font-size: 26px;
        margin-bottom: 32px;
        display: flex;
        align-items: center;
        gap: 12px;
    }
    
    .support-card h3 i {
        color: #ec4899;
        font-size: 32px;
        background: linear-gradient(135deg, #fce7f3 0%, #fdf2f8 100%);
        padding: 10px;
        border-radius: 12px;
    }
    
    .form-label {
        font-weight: 600;
        color: #0f172a;
        margin-bottom: 10px;
        font-size: 15.5px;
        display: block;
    }
    
    .form-control, .form-select {
        border-radius: 14px;
        border: 2px solid #e2e8f0;
        padding: 16px 20px;
        font-size: 15.5px;
        transition: all 0.3s ease;
        background: white;
        width: 100%;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: #ec4899;
        box-shadow: 0 0 0 4px rgba(236, 72, 153, 0.12);
        outline: none;
    }
    
    .form-control::placeholder {
        color: #94a3b8;
    }
    
    textarea.form-control {
        min-height: 180px;
        resize: vertical;
        line-height: 1.6;
    }
    
    .form-control:disabled, .form-select:disabled {
        background-color: #f8fafc;
        cursor: not-allowed;
    }
    
    .btn-submit {
        background: linear-gradient(135deg, #ec4899 0%, #be185d 100%);
        border: none;
        padding: 16px 36px;
        font-weight: 600;
        font-size: 16.5px;
        border-radius: 14px;
        color: white;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        box-shadow: 0 4px 16px rgba(236, 72, 153, 0.3);
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }
    
    .btn-submit:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 24px rgba(236, 72, 153, 0.4);
        background: linear-gradient(135deg, #f43f5e 0%, #ec4899 100%);
    }
    
    .btn-submit:active {
        transform: translateY(-1px);
    }
    
    .btn-outline-secondary {
        padding: 16px 36px;
        border-radius: 14px;
        font-weight: 600;
        font-size: 16.5px;
        border: 2px solid #e2e8f0;
        color: #64748b;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }
    
    .btn-outline-secondary:hover {
        background: #f8fafc;
        border-color: #cbd5e1;
        color: #475569;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    }
    
    .info-box {
        background: linear-gradient(135deg, #f8fafc 0%, #ffffff 100%);
        border: 2px solid #e2e8f0;
        border-radius: 16px;
        padding: 28px;
        margin-top: 30px;
        box-shadow: 0 2px 12px rgba(0,0,0,0.04);
    }
    
    .info-box h5 {
        color: #0f172a;
        font-weight: 700;
        margin-bottom: 20px;
        display: flex;
        align-items: center;
        gap: 12px;
        font-size: 18px;
    }
    
    .info-box h5 i {
        color: #ec4899;
        font-size: 24px;
    }
    
    .info-box ul {
        margin: 0;
        padding-left: 28px;
        color: #475569;
        list-style-type: disc;
    }
    
    .info-box li {
        margin-bottom: 12px;
        line-height: 1.7;
        font-size: 14.5px;
    }
    
    .contact-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
        gap: 20px;
        margin-top: 30px;
    }
    
    .contact-card {
        background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
        border: 2px solid #e2e8f0;
        border-radius: 16px;
        padding: 28px;
        text-align: center;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }
    
    .contact-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(236, 72, 153, 0.1), transparent);
        transition: left 0.5s ease;
    }
    
    .contact-card:hover::before {
        left: 100%;
    }
    
    .contact-card:hover {
        transform: translateY(-6px);
        border-color: #ec4899;
        box-shadow: 0 12px 32px rgba(236, 72, 153, 0.2);
        background: linear-gradient(135deg, #ffffff 0%, #fdf2f8 100%);
    }
    
    .contact-card i {
        font-size: 42px;
        color: #ec4899;
        margin-bottom: 16px;
        display: block;
        transition: transform 0.3s ease;
    }
    
    .contact-card:hover i {
        transform: scale(1.1);
    }
    
    .contact-card h5 {
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 10px;
        font-size: 18px;
    }
    
    .contact-card p {
        color: #64748b;
        font-size: 14.5px;
        margin: 0;
        line-height: 1.6;
    }
    
    .required-field {
        color: #dc2626;
        font-weight: 700;
        margin-left: 2px;
    }
    
    small.text-muted {
        display: block;
        margin-top: 8px;
        font-size: 13.5px;
        color: #64748b;
        line-height: 1.5;
    }
    
    .alert {
        border-radius: 14px;
        border: none;
        padding: 16px 20px;
        margin-bottom: 24px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.06);
    }
    
    .alert-success {
        background: linear-gradient(135deg, #d1fae5 0%, #ecfdf5 100%);
        color: #065f46;
        border-left: 4px solid #10b981;
    }
    
    .alert-danger {
        background: linear-gradient(135deg, #fee2e2 0%, #fef2f2 100%);
        color: #991b1b;
        border-left: 4px solid #ef4444;
    }
    
    .alert ul {
        margin: 8px 0 0 0;
        padding-left: 24px;
    }
    
    .mb-4 {
        margin-bottom: 28px;
    }
    
    .gap-3 {
        gap: 16px;
    }
</style>

<div class="container-fluid">
    <!-- Hero Section -->
    <div class="support-hero">
        <h1><i class="bi bi-headset me-3"></i>Destek Merkezi</h1>
        <p>Size yardımcı olmaktan mutluluk duyarız</p>
    </div>
    
    <div class="row">
        <div class="col-lg-8">
            <div class="support-card">
                <h3>
                    <i class="bi bi-envelope-paper"></i>
                    Destek Talebi Oluştur
                </h3>
                
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-circle me-2"></i>
                        <strong>Lütfen aşağıdaki hataları düzeltin:</strong>
                        <ul class="mb-0 mt-2">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                <form method="POST" action="{{ route('admin.help.submit') }}">
                    @csrf
                    
                    <div class="mb-4">
                        <label class="form-label">
                            Konu <span class="required-field">*</span>
                        </label>
                        <input type="text" name="subject" class="form-control" placeholder="Örn: Randevu oluşturma sorunu" value="{{ old('subject') }}" required>
                        <small class="text-muted">Sorununuzu kısaca özetleyin</small>
                    </div>
                    
                    <div class="mb-4">
                        <label class="form-label">
                            Kategori
                        </label>
                        <select name="category" class="form-select">
                            <option value="">Kategori Seçiniz</option>
                            <option value="technical" {{ old('category') == 'technical' ? 'selected' : '' }}>Teknik Sorun</option>
                            <option value="billing" {{ old('category') == 'billing' ? 'selected' : '' }}>Faturalama</option>
                            <option value="feature" {{ old('category') == 'feature' ? 'selected' : '' }}>Özellik İsteği</option>
                            <option value="other" {{ old('category') == 'other' ? 'selected' : '' }}>Diğer</option>
                        </select>
                        <small class="text-muted">Talebinizi kategorize etmek için seçin (opsiyonel)</small>
                    </div>
                    
                    <div class="mb-4">
                        <label class="form-label">
                            Mesaj <span class="required-field">*</span>
                        </label>
                        <textarea name="message" class="form-control" rows="10" placeholder="Sorununuzu veya isteğinizi detaylı olarak açıklayın..." required>{{ old('message') }}</textarea>
                        <small class="text-muted">Mümkün olduğunca detaylı bilgi verin, böylece size daha hızlı yardımcı olabiliriz</small>
                    </div>
                    
                    <div class="d-flex gap-3 flex-wrap">
                        <button type="submit" class="btn btn-submit">
                            <i class="bi bi-send"></i>
                            Gönder
                        </button>
                        <a href="{{ route('admin.help.faq') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left"></i>
                            SSS'ye Dön
                        </a>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="info-box">
                <h5>
                    <i class="bi bi-info-circle"></i>
                    Bilgilendirme
                </h5>
                <ul>
                    <li>Destek talebiniz en geç 24 saat içinde yanıtlanacaktır</li>
                    <li>Teknik sorunlar için ekran görüntüsü eklemeniz yardımcı olur</li>
                    <li>Acil durumlar için telefon desteğimizi kullanabilirsiniz</li>
                    <li>SSS sayfasını kontrol ederek hızlı çözüm bulabilirsiniz</li>
                </ul>
            </div>
            
            <div class="contact-cards">
                <div class="contact-card">
                    <i class="bi bi-envelope"></i>
                    <h5>E-posta</h5>
                    <p>destek@salonay.com</p>
                </div>
                
                <div class="contact-card">
                    <i class="bi bi-telephone"></i>
                    <h5>Telefon</h5>
                    <p>0850 811 08 20</p>
                </div>
                
                <div class="contact-card">
                    <i class="bi bi-clock"></i>
                    <h5>Çalışma Saatleri</h5>
                    <p>Pazartesi - Cuma<br>09:00 - 18:00</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
