@extends('layouts.admin')

@section('title', 'Kart Sahipleri')
@section('page-title', 'Kart Sahipleri')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-people me-2"></i>Kart Sahipleri
                </h2>
                <a href="{{ route('admin.beauty-salon.loyalty.index') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-2"></i>Geri
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Müşteri Listesi
            </h5>
        </div>
        <div class="card-body">
            @if(isset($customerLoyalties) && $customerLoyalties->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Müşteri</th>
                                <th>Seviye</th>
                                <th>Toplam Puan</th>
                                <th>Kullanılabilir Puan</th>
                                <th>Toplam Ziyaret</th>
                                <th>Toplam Harcama</th>
                                <th>Son Ziyaret</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($customerLoyalties as $loyalty)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $loyalty->customer->name ?? 'Müşteri' }}</div>
                                        @if($loyalty->customer && $loyalty->customer->phone)
                                            <small class="text-muted">{{ $loyalty->customer->phone }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        @if($loyalty->loyaltyTier)
                                            <span class="badge bg-primary">{{ $loyalty->loyaltyTier->name }}</span>
                                        @else
                                            <span class="badge bg-secondary">Seviye Yok</span>
                                        @endif
                                    </td>
                                    <td class="fw-bold text-primary">{{ number_format($loyalty->total_points, 0, ',', '.') }}</td>
                                    <td class="fw-bold text-success">{{ number_format($loyalty->points_available, 0, ',', '.') }}</td>
                                    <td>{{ $loyalty->total_visits }}</td>
                                    <td>{{ number_format($loyalty->total_spend, 2, ',', '.') }} ₺</td>
                                    <td>
                                        @if($loyalty->last_visit_at)
                                            {{ $loyalty->last_visit_at->format('d.m.Y') }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#customerDetailModal{{ $loyalty->id }}">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                    </td>
                                </tr>

                                <!-- Customer Detail Modal -->
                                <div class="modal fade" id="customerDetailModal{{ $loyalty->id }}" tabindex="-1" aria-labelledby="customerDetailModalLabel{{ $loyalty->id }}" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="customerDetailModalLabel{{ $loyalty->id }}">Müşteri Sadakat Detayı</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p><strong>Müşteri:</strong> {{ $loyalty->customer->name ?? 'Müşteri' }}</p>
                                                @if($loyalty->loyaltyTier)
                                                    <p><strong>Seviye:</strong> {{ $loyalty->loyaltyTier->name }} (Seviye {{ $loyalty->loyaltyTier->level }})</p>
                                                @endif
                                                <p><strong>Toplam Puan:</strong> {{ number_format($loyalty->total_points, 0, ',', '.') }}</p>
                                                <p><strong>Kullanılabilir Puan:</strong> {{ number_format($loyalty->points_available, 0, ',', '.') }}</p>
                                                <p><strong>Kullanılan Puan:</strong> {{ number_format($loyalty->points_used, 0, ',', '.') }}</p>
                                                <p><strong>Toplam Ziyaret:</strong> {{ $loyalty->total_visits }}</p>
                                                <p><strong>Toplam Harcama:</strong> {{ number_format($loyalty->total_spend, 2, ',', '.') }} ₺</p>
                                                @if($loyalty->last_visit_at)
                                                    <p><strong>Son Ziyaret:</strong> {{ $loyalty->last_visit_at->format('d.m.Y H:i') }}</p>
                                                @endif
                                                @if($loyalty->tier_upgraded_at)
                                                    <p><strong>Seviye Yükseltme:</strong> {{ $loyalty->tier_upgraded_at->format('d.m.Y H:i') }}</p>
                                                @endif
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $customerLoyalties->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-people" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz sadakat müşterisi bulunmamaktadır.</p>
                    <p class="text-muted">Müşteriler randevu aldığında otomatik olarak sadakat programına dahil olacaktır.</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection

