@extends('layouts.admin')

@section('title', 'Kart Programı')
@section('page-title', 'Kart Programı')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-credit-card me-2"></i>Kart Programı
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.loyalty.tiers') }}" class="btn btn-outline-primary">
                        <i class="bi bi-award me-2"></i>Seviyeler
                    </a>
                    <a href="{{ route('admin.beauty-salon.loyalty.rewards') }}" class="btn btn-outline-success">
                        <i class="bi bi-gift me-2"></i>Ödüller
                    </a>
                    <a href="{{ route('admin.beauty-salon.loyalty.customers') }}" class="btn btn-outline-info">
                        <i class="bi bi-people me-2"></i>Müşteriler
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- İstatistikler -->
    <div class="row g-4 mb-4">
        <div class="col-md-4">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px; background: linear-gradient(135deg, #10b981 0%, #047857 100%); color: white;">
                <div class="card-body">
                    <i class="bi bi-people-fill" style="font-size: 32px; opacity: 0.9;"></i>
                    <h3 class="mb-0 mt-2">{{ $totalCustomers }}</h3>
                    <p class="mb-0">Toplam Kart Sahibi</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px; background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); color: white;">
                <div class="card-body">
                    <i class="bi bi-star-fill" style="font-size: 32px; opacity: 0.9;"></i>
                    <h3 class="mb-0 mt-2">{{ number_format($totalPoints, 0, ',', '.') }}</h3>
                    <p class="mb-0">Toplam Puan</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm text-center" style="border: none; border-radius: 16px; background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white;">
                <div class="card-body">
                    <i class="bi bi-award-fill" style="font-size: 32px; opacity: 0.9;"></i>
                    <h3 class="mb-0 mt-2">{{ $activeTiers }}</h3>
                    <p class="mb-0">Aktif Seviye</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!-- Sadakat Seviyeleri -->
        <div class="col-md-6">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); border-radius: 16px 16px 0 0;">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 text-white fw-bold">
                            <i class="bi bi-award me-2"></i>Kart Seviyeleri
                        </h5>
                        <a href="{{ route('admin.beauty-salon.loyalty.tiers') }}" class="btn btn-sm btn-light">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if($tiers->count() > 0)
                        <div class="list-group list-group-flush">
                            @foreach($tiers->take(5) as $tier)
                                <div class="list-group-item border-0 px-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <div class="fw-bold">{{ $tier->name }}</div>
                                            <small class="text-muted">Seviye {{ $tier->level }}</small>
                                        </div>
                                        @if($tier->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-danger">Pasif</span>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted text-center py-3 mb-0">Henüz seviye oluşturulmamış.</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Ödüller -->
        <div class="col-md-6">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0;">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 text-white fw-bold">
                            <i class="bi bi-gift me-2"></i>Ödüller
                        </h5>
                        <a href="{{ route('admin.beauty-salon.loyalty.rewards') }}" class="btn btn-sm btn-light">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if($rewards->count() > 0)
                        <div class="list-group list-group-flush">
                            @foreach($rewards->take(5) as $reward)
                                <div class="list-group-item border-0 px-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <div class="fw-bold">{{ $reward->name }}</div>
                                            <small class="text-muted">{{ number_format($reward->points_required, 0) }} puan</small>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted text-center py-3 mb-0">Henüz ödül tanımlanmamış.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Müşteri Sadakat Listesi -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 text-white fw-bold">
                            <i class="bi bi-list-ul me-2"></i>Kart Sahipleri
                        </h5>
                        <a href="{{ route('admin.beauty-salon.loyalty.customers') }}" class="btn btn-sm btn-light">
                            <i class="bi bi-arrow-right"></i>Tümünü Gör
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if($customerLoyalties->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th>Müşteri</th>
                                        <th>Seviye</th>
                                        <th>Toplam Puan</th>
                                        <th>Kullanılabilir Puan</th>
                                        <th>Toplam Ziyaret</th>
                                        <th>Toplam Harcama</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($customerLoyalties as $loyalty)
                                        <tr>
                                            <td>
                                                <div class="fw-bold">{{ $loyalty->customer->name ?? 'Müşteri' }}</div>
                                                @if($loyalty->customer && $loyalty->customer->phone)
                                                    <small class="text-muted">{{ $loyalty->customer->phone }}</small>
                                                @endif
                                            </td>
                                            <td>
                                                @if($loyalty->loyaltyTier)
                                                    <span class="badge bg-primary">{{ $loyalty->loyaltyTier->name }}</span>
                                                @else
                                                    <span class="badge bg-secondary">Seviye Yok</span>
                                                @endif
                                            </td>
                                            <td class="fw-bold text-primary">{{ number_format($loyalty->total_points, 0, ',', '.') }}</td>
                                            <td class="fw-bold text-success">{{ number_format($loyalty->points_available, 0, ',', '.') }}</td>
                                            <td>{{ $loyalty->total_visits }}</td>
                                            <td>{{ number_format($loyalty->total_spend, 2, ',', '.') }} ₺</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $customerLoyalties->links() }}
                        </div>
                    @else
                        <p class="text-muted text-center py-4">Henüz kart sahibi müşteri bulunmamaktadır.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
