@extends('layouts.admin')

@section('title', 'Kart Ödülleri')
@section('page-title', 'Kart Ödülleri')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-gift me-2"></i>Kart Ödülleri
                </h2>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createRewardModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Ödül Oluştur
                    </button>
                    <a href="{{ route('admin.beauty-salon.loyalty.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Ödül Listesi
            </h5>
        </div>
        <div class="card-body">
            @if(isset($rewards) && $rewards->count() > 0)
                <div class="row g-4">
                    @foreach($rewards as $reward)
                        <div class="col-md-6 col-lg-4">
                            <div class="card shadow-sm h-100" style="border: none; border-radius: 16px; border-left: 4px solid #10b981;">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <div>
                                            <h5 class="fw-bold mb-1">{{ $reward->name }}</h5>
                                            <span class="badge bg-primary">{{ number_format($reward->points_required, 0) }} Puan</span>
                                        </div>
                                        @if($reward->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-danger">Pasif</span>
                                        @endif
                                    </div>
                                    
                                    @if($reward->description)
                                        <p class="text-muted small mb-3">{{ Str::limit($reward->description, 100) }}</p>
                                    @endif

                                    <div class="mb-3">
                                        <p class="mb-1 small"><i class="bi bi-tag me-1"></i>Ödül Türü: <strong>{{ ucfirst($reward->reward_type ?? 'İndirim') }}</strong></p>
                                        @if($reward->reward_value)
                                            <p class="mb-1 small"><i class="bi bi-cash-coin me-1"></i>Değer: <strong>{{ number_format($reward->reward_value, 2, ',', '.') }} ₺</strong></p>
                                        @endif
                                    </div>

                                    <div class="d-flex gap-2">
                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#rewardDetailModal{{ $reward->id }}">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="editReward({{ $reward->id }})">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <form action="#" method="POST" class="d-inline-block" onsubmit="return confirm('Bu ödülü silmek istediğinizden emin misiniz?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-gift" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz ödül oluşturulmamış.</p>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createRewardModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Ödülü Oluştur
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Create Reward Modal -->
<div class="modal fade" id="createRewardModal" tabindex="-1" aria-labelledby="createRewardModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" style="max-width: 800px;">
        <div class="modal-content" style="border: none; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; padding: 20px 24px;">
                <h5 class="modal-title text-white fw-bold mb-0" id="createRewardModalLabel">
                    <i class="bi bi-gift me-2"></i>Yeni Ödül Oluştur
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="opacity: 1;"></button>
            </div>
            <form action="{{ route('admin.beauty-salon.loyalty.rewards.store') }}" method="POST" id="createRewardForm">
                @csrf
                <div class="modal-body" style="padding: 24px; max-height: 70vh; overflow-y: auto;">
                    <div class="alert alert-info mb-4" style="border-radius: 12px; border: none; background: #e0f2fe;">
                        <i class="bi bi-lightbulb me-2"></i><strong>Ödül Nedir?</strong><br>
                        <small>Müşterileriniz puanlarını biriktirip ödüller alabilir. Örneğin: 100 puan = %10 indirim, 500 puan = ücretsiz saç kesimi.</small>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="name" class="form-label fw-bold">Ödül Adı <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" placeholder="Örn: %10 İndirim" required>
                        </div>
                        <div class="col-md-6">
                            <label for="points_required" class="form-label fw-bold">Gerekli Puan <span class="text-danger">*</span></label>
                            <input type="number" step="0.01" class="form-control" id="points_required" name="points_required" placeholder="Örn: 100" min="0" required>
                        </div>
                        <div class="col-md-6">
                            <label for="reward_type" class="form-label fw-bold">Ödül Türü</label>
                            <select class="form-select" id="reward_type" name="reward_type">
                                <option value="discount">İndirim</option>
                                <option value="free_service">Ücretsiz Hizmet</option>
                                <option value="points">Puan</option>
                                <option value="cash">Nakit</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="reward_value" class="form-label fw-bold">Ödül Değeri (₺)</label>
                            <input type="number" step="0.01" class="form-control" id="reward_value" name="reward_value" placeholder="Örn: 50" min="0">
                        </div>
                        <div class="col-12">
                            <label for="description" class="form-label fw-bold">Açıklama</label>
                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="Ödül hakkında açıklama..."></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 16px 24px; background: #f9fafb; border-radius: 0 0 16px 16px;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">
                        <i class="bi bi-x-circle me-2"></i>İptal
                    </button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 8px; padding: 10px 24px; font-weight: 600;">
                        <i class="bi bi-check-circle me-2"></i>Ödül Oluştur
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function editReward(id) {
        alert('Ödül düzenleme özelliği geliştiriliyor. Yakında eklenecektir.');
    }
</script>
@endpush
@endsection

