@extends('layouts.admin')

@section('title', 'Kart Seviyeleri')
@section('page-title', 'Kart Seviyeleri')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-award me-2"></i>Kart Seviyeleri
                </h2>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createTierModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Seviye Oluştur
                    </button>
                    <a href="{{ route('admin.beauty-salon.loyalty.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card shadow-sm" style="border: none; border-radius: 16px;">
        <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
            <h5 class="mb-0 text-white fw-bold">
                <i class="bi bi-list-ul me-2"></i>Seviye Listesi
            </h5>
        </div>
        <div class="card-body">
            @if(isset($tiers) && $tiers->count() > 0)
                <div class="row g-4">
                    @foreach($tiers as $tier)
                        <div class="col-md-6 col-lg-4">
                            <div class="card shadow-sm h-100" style="border: none; border-radius: 16px; border-left: 4px solid #ec4899;">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <div>
                                            <h5 class="fw-bold mb-1">{{ $tier->name }}</h5>
                                            <span class="badge bg-primary">Seviye {{ $tier->level }}</span>
                                        </div>
                                        @if($tier->is_active)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-danger">Pasif</span>
                                        @endif
                                    </div>
                                    
                                    <div class="mb-3">
                                        @if($tier->min_visits)
                                            <p class="mb-1 small"><i class="bi bi-calendar-check me-1"></i>Minimum Ziyaret: <strong>{{ $tier->min_visits }}</strong></p>
                                        @endif
                                        @if($tier->min_spend)
                                            <p class="mb-1 small"><i class="bi bi-cash-coin me-1"></i>Minimum Harcama: <strong>{{ number_format($tier->min_spend, 2, ',', '.') }} ₺</strong></p>
                                        @endif
                                        @if($tier->points_per_visit)
                                            <p class="mb-1 small"><i class="bi bi-star me-1"></i>Ziyaret Başına Puan: <strong>{{ number_format($tier->points_per_visit, 0) }}</strong></p>
                                        @endif
                                        @if($tier->discount_percentage)
                                            <p class="mb-1 small"><i class="bi bi-percent me-1"></i>İndirim: <strong>%{{ number_format($tier->discount_percentage, 0) }}</strong></p>
                                        @endif
                                    </div>

                                    <div class="d-flex gap-2">
                                        <button type="button" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#tierDetailModal{{ $tier->id }}">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-warning" onclick="editTier({{ $tier->id }})">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <form action="#" method="POST" class="d-inline-block" onsubmit="return confirm('Bu seviyeyi silmek istediğinizden emin misiniz?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-award" style="font-size: 48px; color: #ccc;"></i>
                    <p class="text-muted mt-3">Henüz sadakat seviyesi oluşturulmamış.</p>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createTierModal" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Seviyeyi Oluştur
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Create Tier Modal -->
<div class="modal fade" id="createTierModal" tabindex="-1" aria-labelledby="createTierModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" style="max-width: 800px;">
        <div class="modal-content" style="border: none; border-radius: 16px; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; padding: 20px 24px;">
                <h5 class="modal-title text-white fw-bold mb-0" id="createTierModalLabel">
                    <i class="bi bi-award me-2"></i>Yeni Seviye Oluştur
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close" style="opacity: 1;"></button>
            </div>
            <form action="{{ route('admin.beauty-salon.loyalty.tiers.store') }}" method="POST" id="createTierForm">
                @csrf
                <div class="modal-body" style="padding: 24px; max-height: 70vh; overflow-y: auto;">
                    <div class="alert alert-info mb-4" style="border-radius: 12px; border: none; background: #e0f2fe;">
                        <i class="bi bi-lightbulb me-2"></i><strong>Seviye Nedir?</strong><br>
                        <small>Sadakat seviyeleri müşterilerinizi gruplandırır. Örneğin: Bronz (5 ziyaret), Gümüş (10 ziyaret), Altın (20 ziyaret). Her seviyede farklı avantajlar sunabilirsiniz.</small>
                    </div>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="name" class="form-label fw-bold">Seviye Adı <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" placeholder="Örn: Bronz, Gümüş, Altın" required>
                        </div>
                        <div class="col-md-6">
                            <label for="level" class="form-label fw-bold">Seviye Numarası <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="level" name="level" placeholder="1, 2, 3..." min="1" required>
                        </div>
                        <div class="col-md-6">
                            <label for="min_visits" class="form-label fw-bold">Minimum Ziyaret</label>
                            <input type="number" class="form-control" id="min_visits" name="min_visits" placeholder="Örn: 5" min="0">
                        </div>
                        <div class="col-md-6">
                            <label for="min_spend" class="form-label fw-bold">Minimum Harcama (₺)</label>
                            <input type="number" step="0.01" class="form-control" id="min_spend" name="min_spend" placeholder="Örn: 1000" min="0">
                        </div>
                        <div class="col-md-6">
                            <label for="points_per_visit" class="form-label fw-bold">Ziyaret Başına Puan</label>
                            <input type="number" step="0.01" class="form-control" id="points_per_visit" name="points_per_visit" placeholder="Örn: 10" min="0">
                        </div>
                        <div class="col-md-6">
                            <label for="discount_percentage" class="form-label fw-bold">İndirim Yüzdesi (%)</label>
                            <input type="number" step="0.01" class="form-control" id="discount_percentage" name="discount_percentage" placeholder="Örn: 10" min="0" max="100">
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 16px 24px; background: #f9fafb; border-radius: 0 0 16px 16px;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">
                        <i class="bi bi-x-circle me-2"></i>İptal
                    </button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 8px; padding: 10px 24px; font-weight: 600;">
                        <i class="bi bi-check-circle me-2"></i>Seviye Oluştur
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    function editTier(id) {
        alert('Seviye düzenleme özelliği geliştiriliyor. Yakında eklenecektir.');
    }
</script>
@endpush
@endsection

