@extends('layouts.admin')

@section('title', 'Üye Müşteriler')
@section('page-title', 'Üye Müşteriler')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-people me-2"></i>Üye Müşteriler
                </h2>
                <a href="{{ route('admin.beauty-salon.memberships.index') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-2"></i>Geri
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white">
                        <i class="bi bi-list-ul me-2"></i>Tüm Üyelikler
                        <span class="badge bg-white text-primary ms-2">{{ $memberships->total() }}</span>
                    </h5>
                </div>
                <div class="card-body">
                    @if($memberships->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover align-middle">
                                <thead class="table-light">
                                    <tr>
                                        <th>Müşteri</th>
                                        <th>Paket</th>
                                        <th>Durum</th>
                                        <th>Başlangıç</th>
                                        <th>Bitiş</th>
                                        <th>Kalan Hizmet</th>
                                        <th>Kalan Tutar</th>
                                        <th>İşlemler</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($memberships as $membership)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar-circle me-2" style="width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold;">
                                                        {{ substr($membership->customer->name ?? 'M', 0, 1) }}
                                                    </div>
                                                    <div>
                                                        <div class="fw-bold">{{ $membership->customer->name ?? 'Müşteri' }}</div>
                                                        <small class="text-muted">{{ $membership->customer->phone ?? '-' }}</small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="badge bg-primary">{{ $membership->membershipPackage->name ?? 'Paket' }}</span>
                                            </td>
                                            <td>
                                                @if($membership->status === 'active')
                                                    <span class="badge bg-success">Aktif</span>
                                                @elseif($membership->status === 'paused')
                                                    <span class="badge bg-warning text-dark">Donduruldu</span>
                                                @elseif($membership->status === 'cancelled')
                                                    <span class="badge bg-danger">İptal</span>
                                                @else
                                                    <span class="badge bg-secondary">Süresi Doldu</span>
                                                @endif
                                            </td>
                                            <td>{{ $membership->start_date->format('d.m.Y') }}</td>
                                            <td>{{ $membership->end_date->format('d.m.Y') }}</td>
                                            <td>
                                                @if($membership->services_remaining > 0)
                                                    <span class="badge bg-success">{{ $membership->services_remaining }}</span>
                                                @else
                                                    <span class="badge bg-warning text-dark">0</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($membership->amount_remaining > 0)
                                                    <span class="badge bg-info">{{ number_format($membership->amount_remaining, 2, ',', '.') }} ₺</span>
                                                @else
                                                    <span class="badge bg-secondary">0,00 ₺</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('admin.customers.show', $membership->customer_id) }}" class="btn btn-sm btn-info" title="Müşteri Detayı">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $memberships->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-people" style="font-size: 48px; color: #ccc;"></i>
                            <p class="text-muted mt-3">Henüz üyelik bulunmuyor.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

