@extends('layouts.admin')

@section('title', 'Üyelik Sistemi')
@section('page-title', 'Üyelik Sistemi')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-card-checklist me-2"></i>Üyelik Sistemi
                </h2>
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.beauty-salon.memberships.packages') }}" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-box-seam me-2"></i>Paket Yönetimi
                    </a>
                    <a href="{{ route('admin.beauty-salon.memberships.customers') }}" class="btn btn-info">
                        <i class="bi bi-people me-2"></i>Üye Müşteriler
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row g-4">
        <!-- Aktif Paketler -->
        <div class="col-lg-6">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #10b981 0%, #047857 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white">
                        <i class="bi bi-box-seam me-2"></i>Aktif Paketler
                        <span class="badge bg-white text-success ms-2">{{ $packages->count() }}</span>
                    </h5>
                </div>
                <div class="card-body">
                    @if($packages->count() > 0)
                        <div class="list-group list-group-flush">
                            @foreach($packages as $package)
                                <div class="list-group-item border-0 px-0 py-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <h6 class="fw-bold mb-1">{{ $package->name }}</h6>
                                            <p class="text-muted small mb-1">{{ $package->description ?? 'Açıklama yok' }}</p>
                                            <div class="d-flex gap-3">
                                                <span class="badge bg-primary">{{ number_format($package->price, 2, ',', '.') }} ₺</span>
                                                <span class="badge bg-info">
                                                    @if($package->period === 'monthly') Aylık
                                                    @elseif($package->period === 'quarterly') Üç Aylık
                                                    @else Yıllık
                                                    @endif
                                                </span>
                                                @if($package->service_limit)
                                                    <span class="badge bg-warning text-dark">{{ $package->service_limit }} hizmet</span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-box-seam" style="font-size: 48px; color: #ccc;"></i>
                            <p class="text-muted mt-3">Henüz aktif paket bulunmuyor.</p>
                            <a href="{{ route('admin.beauty-salon.memberships.packages') }}" class="btn btn-primary">
                                <i class="bi bi-plus-circle me-2"></i>Paket Oluştur
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Aktif Üyelikler -->
        <div class="col-lg-6">
            <div class="card shadow-sm" style="border: none; border-radius: 16px;">
                <div class="card-header" style="background: linear-gradient(135deg, #3b82f6 0%, #1e40af 100%); border-radius: 16px 16px 0 0;">
                    <h5 class="mb-0 text-white">
                        <i class="bi bi-people me-2"></i>Aktif Üyelikler
                        <span class="badge bg-white text-primary ms-2">{{ $activeMemberships->total() }}</span>
                    </h5>
                </div>
                <div class="card-body">
                    @if($activeMemberships->count() > 0)
                        <div class="list-group list-group-flush">
                            @foreach($activeMemberships as $membership)
                                <div class="list-group-item border-0 px-0 py-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <h6 class="fw-bold mb-1">{{ $membership->customer->name ?? 'Müşteri' }}</h6>
                                            <p class="text-muted small mb-1">{{ $membership->membershipPackage->name ?? 'Paket' }}</p>
                                            <div class="d-flex gap-2">
                                                @if($membership->services_remaining > 0)
                                                    <span class="badge bg-success">{{ $membership->services_remaining }} hizmet kaldı</span>
                                                @else
                                                    <span class="badge bg-warning text-dark">Hizmet hakkı bitti</span>
                                                @endif
                                                <span class="badge bg-info">{{ $membership->end_date->format('d.m.Y') }}'a kadar</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="mt-3">
                            {{ $activeMemberships->links() }}
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="bi bi-people" style="font-size: 48px; color: #ccc;"></i>
                            <p class="text-muted mt-3">Henüz aktif üyelik bulunmuyor.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

