@extends('layouts.admin')

@section('title', 'Üyelik Paketleri')
@section('page-title', 'Üyelik Paketleri')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="fw-bold mb-0" style="color: #ec4899;">
                    <i class="bi bi-box-seam me-2"></i>Üyelik Paketleri
                </h2>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-primary" onclick="openCreateModal()" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>Yeni Paket
                    </button>
                    <a href="{{ route('admin.beauty-salon.memberships.index') }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-left me-2"></i>Geri
                    </a>
                </div>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row g-4">
        @forelse($packages as $package)
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-sm h-100" style="border: none; border-radius: 16px; transition: all 0.3s;" onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 24px rgba(0,0,0,0.15)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 8px rgba(0,0,0,0.1)'">
                    <div class="card-header" style="background: linear-gradient(135deg, {{ $package->is_active ? '#10b981' : '#6b7280' }} 0%, {{ $package->is_active ? '#047857' : '#4b5563' }} 100%); border-radius: 16px 16px 0 0;">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-white fw-bold">{{ $package->name }}</h5>
                            @if($package->is_active)
                                <span class="badge bg-white text-success">Aktif</span>
                            @else
                                <span class="badge bg-white text-secondary">Pasif</span>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="text-center mb-3">
                            <h3 class="fw-bold mb-0" style="color: #ec4899;">{{ number_format($package->price, 2, ',', '.') }} ₺</h3>
                            <p class="text-muted small mb-0">
                                @if($package->period === 'monthly') Aylık
                                @elseif($package->period === 'quarterly') Üç Aylık
                                @else Yıllık
                                @endif
                            </p>
                        </div>
                        
                        @if($package->description)
                            <p class="text-muted small mb-3">{{ Str::limit($package->description, 100) }}</p>
                        @endif

                        <div class="mb-3">
                            @if($package->service_limit)
                                <div class="d-flex justify-content-between mb-2">
                                    <span class="text-muted">Hizmet Limiti:</span>
                                    <strong>{{ $package->service_limit }}</strong>
                                </div>
                            @endif
                            @if($package->amount_limit)
                                <div class="d-flex justify-content-between mb-2">
                                    <span class="text-muted">Tutar Limiti:</span>
                                    <strong>{{ number_format($package->amount_limit, 2, ',', '.') }} ₺</strong>
                                </div>
                            @endif
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted">Devir Hakkı:</span>
                                <strong>{{ $package->allow_rollover ? 'Var' : 'Yok' }}</strong>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="text-muted">Öncelikli Randevu:</span>
                                <strong>{{ $package->priority_booking ? 'Var' : 'Yok' }}</strong>
                            </div>
                        </div>

                        <div class="d-flex gap-2 mt-3">
                            <button type="button" class="btn btn-sm btn-warning flex-fill" onclick="editPackage({{ $package->id }})">
                                <i class="bi bi-pencil"></i> Düzenle
                            </button>
                            <form action="{{ route('admin.beauty-salon.memberships.packages.destroy', $package->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Bu paketi silmek istediğinize emin misiniz?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="card shadow-sm text-center py-5" style="border: none; border-radius: 16px;">
                    <i class="bi bi-box-seam" style="font-size: 64px; color: #ccc;"></i>
                    <h5 class="mt-3 text-muted">Henüz paket oluşturulmamış</h5>
                    <p class="text-muted">İlk üyelik paketinizi oluşturun ve müşterilerinize sunun.</p>
                    <button type="button" class="btn btn-primary" onclick="openCreateModal()" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none;">
                        <i class="bi bi-plus-circle me-2"></i>İlk Paketi Oluştur
                    </button>
                </div>
            </div>
        @endforelse
    </div>
</div>

<!-- Create/Edit Package Modal -->
<div class="modal fade" id="packageModal" tabindex="-1">
    <div class="modal-dialog modal-lg" style="max-width: 900px;">
        <div class="modal-content" style="border-radius: 16px; border: none; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
            <div class="modal-header" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border-radius: 16px 16px 0 0; padding: 20px 24px;">
                <h5 class="modal-title text-white fw-bold mb-0" id="packageModalTitle">
                    <i class="bi bi-box-seam me-2"></i>Yeni Paket
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" style="opacity: 1;"></button>
            </div>
            <form id="packageForm" method="POST">
                @csrf
                <div id="packageFormMethod"></div>
                <div class="modal-body" style="padding: 24px; max-height: 70vh; overflow-y: auto;">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Paket Adı <span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-bold">Açıklama</label>
                        <textarea name="description" class="form-control" rows="3"></textarea>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Dönem <span class="text-danger">*</span></label>
                            <select name="period" class="form-select" required>
                                <option value="monthly">Aylık</option>
                                <option value="quarterly">Üç Aylık</option>
                                <option value="yearly">Yıllık</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Fiyat (₺) <span class="text-danger">*</span></label>
                            <input type="number" name="price" class="form-control" step="0.01" min="0" required>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Hizmet Limiti</label>
                            <input type="number" name="service_limit" class="form-control" min="0" placeholder="Sınırsız için boş bırakın">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-bold">Tutar Limiti (₺)</label>
                            <input type="number" name="amount_limit" class="form-control" step="0.01" min="0" placeholder="Sınırsız için boş bırakın">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="allow_rollover" id="allow_rollover" value="1">
                                <label class="form-check-label" for="allow_rollover">
                                    Devir Hakkı (Kullanılmayan haklar sonraki aya devredilir)
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="priority_booking" id="priority_booking" value="1">
                                <label class="form-check-label" for="priority_booking">
                                    Öncelikli Randevu
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Devir Yüzdesi (%)</label>
                        <input type="number" name="rollover_percentage" class="form-control" min="0" max="100" value="100">
                        <small class="text-muted">Kullanılmayan hakların yüzde kaçı devredilir (0-100)</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Dahil Edilen Hizmetler</label>
                        <select name="included_services[]" class="form-select" multiple size="5">
                            @foreach($services as $service)
                                <option value="{{ $service->id }}">{{ $service->name }} ({{ number_format($service->price, 2, ',', '.') }} ₺)</option>
                            @endforeach
                        </select>
                        <small class="text-muted">Sadece bu hizmetler pakete dahildir (Ctrl/Cmd ile çoklu seçim)</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Hariç Tutulan Hizmetler</label>
                        <select name="excluded_services[]" class="form-select" multiple size="5">
                            @foreach($services as $service)
                                <option value="{{ $service->id }}">{{ $service->name }} ({{ number_format($service->price, 2, ',', '.') }} ₺)</option>
                            @endforeach
                        </select>
                        <small class="text-muted">Bu hizmetler pakete dahil değildir</small>
                    </div>

                </div>
                <div class="modal-footer" style="border-top: 1px solid #e5e7eb; padding: 16px 24px; background: #f9fafb; border-radius: 0 0 16px 16px;">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">
                        <i class="bi bi-x-circle me-2"></i>İptal
                    </button>
                    <button type="submit" class="btn btn-primary" style="background: linear-gradient(135deg, #ec4899 0%, #be185d 100%); border: none; border-radius: 8px; padding: 10px 24px; font-weight: 600;">
                        <i class="bi bi-check-circle me-2"></i>Kaydet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function openCreateModal() {
    document.getElementById('packageModalTitle').innerHTML = '<i class="bi bi-box-seam me-2"></i>Yeni Paket';
    document.getElementById('packageForm').action = '{{ route("admin.beauty-salon.memberships.packages.store") }}';
    document.getElementById('packageFormMethod').innerHTML = '';
    document.getElementById('packageForm').reset();
    new bootstrap.Modal(document.getElementById('packageModal')).show();
}

function editPackage(id) {
    // Bu fonksiyon AJAX ile paket bilgilerini yükleyip modal'ı dolduracak
    fetch(`{{ url('/guzellik-salonu/uyelik/paketler') }}/${id}`, {
        headers: {
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
        .then(response => response.json())
        .then(data => {
            document.getElementById('packageModalTitle').innerHTML = '<i class="bi bi-pencil me-2"></i>Paket Düzenle';
            document.getElementById('packageForm').action = `{{ url('/guzellik-salonu/uyelik/paketler') }}/${id}`;
            document.getElementById('packageFormMethod').innerHTML = '@method("PUT")';
            
            document.querySelector('input[name="name"]').value = data.name || '';
            document.querySelector('textarea[name="description"]').value = data.description || '';
            document.querySelector('select[name="period"]').value = data.period || 'monthly';
            document.querySelector('input[name="price"]').value = data.price || '';
            document.querySelector('input[name="service_limit"]').value = data.service_limit || '';
            document.querySelector('input[name="amount_limit"]').value = data.amount_limit || '';
            document.querySelector('input[name="allow_rollover"]').checked = data.allow_rollover || false;
            document.querySelector('input[name="priority_booking"]').checked = data.priority_booking || false;
            document.querySelector('input[name="rollover_percentage"]').value = data.rollover_percentage || 100;
            
            new bootstrap.Modal(document.getElementById('packageModal')).show();
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Paket bilgileri yüklenemedi.');
        });
}
</script>
@endpush

